/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Traceable;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.processor.DelegateAsyncProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FinallyProcessor
extends DelegateAsyncProcessor
implements Traceable,
IdAware,
RouteIdAware {
    private static final Logger LOG = LoggerFactory.getLogger(FinallyProcessor.class);
    private String id;
    private String routeId;

    public FinallyProcessor(Processor processor) {
        super(processor);
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        Exception exception = exchange.getException();
        exchange.setException(null);
        if (exception != null) {
            exchange.setProperty("CamelExceptionCaught", (Object)exception);
        }
        if (exchange.getProperty("CamelFailureEndpoint") == null) {
            exchange.setProperty("CamelFailureEndpoint", exchange.getProperty("CamelToEndpoint"));
        }
        return this.processor.process(exchange, (AsyncCallback)new FinallyAsyncCallback(exchange, callback, exception));
    }

    public String toString() {
        return this.id;
    }

    public String getTraceLabel() {
        return "finally";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    private final class FinallyAsyncCallback
    implements AsyncCallback {
        private final Exchange exchange;
        private final AsyncCallback callback;
        private final Exception exception;

        FinallyAsyncCallback(Exchange exchange, AsyncCallback callback, Exception exception) {
            this.exchange = exchange;
            this.callback = callback;
            this.exception = exception;
        }

        public void done(boolean doneSync) {
            try {
                if (this.exception == null) {
                    this.exchange.removeProperty("CamelFailureEndpoint");
                } else {
                    this.exchange.setException((Throwable)this.exception);
                    this.exchange.setProperty("CamelExceptionCaught", (Object)this.exception);
                }
                if (!doneSync) {
                    ExchangeHelper.prepareOutToIn((Exchange)this.exchange);
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Processing complete for exchangeId: {} >>> {}", (Object)this.exchange.getExchangeId(), (Object)this.exchange);
                    }
                }
            }
            finally {
                this.callback.done(doneSync);
            }
        }

        public String toString() {
            return "FinallyAsyncCallback";
        }
    }
}

