/*
 * Decompiled with CFR 0.152.
 */
package pureconfig;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValue;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import pureconfig.ConfigObjectSource;
import pureconfig.ConfigReader;
import pureconfig.ConfigSource$;
import pureconfig.ConfigWriter;
import pureconfig.Derivation;
import pureconfig.error.ConfigReaderException;
import pureconfig.error.ConfigReaderFailures;
import scala.Function1;
import scala.Function2;
import scala.collection.Traversable;
import scala.collection.Traversable$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.reflect.ClassTag;
import scala.util.Either;

public final class package$ {
    public static package$ MODULE$;

    static {
        new package$();
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfig(Derivation<ConfigReader<Config>> reader) {
        return ConfigSource$.MODULE$.default().load(reader);
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfig(String namespace, Derivation<ConfigReader<Config>> reader) {
        return ConfigSource$.MODULE$.default().at(namespace).load(reader);
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfig(Path path, Derivation<ConfigReader<Config>> reader) {
        return ConfigSource$.MODULE$.default(ConfigSource$.MODULE$.file(path)).load(reader);
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfig(Path path, String namespace, Derivation<ConfigReader<Config>> reader) {
        return ConfigSource$.MODULE$.default(ConfigSource$.MODULE$.file(path)).at(namespace).load(reader);
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfig(Config conf, Derivation<ConfigReader<Config>> reader) {
        return ConfigSource$.MODULE$.fromConfig(conf).load(reader);
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfig(Config conf, String namespace, Derivation<ConfigReader<Config>> reader) {
        return ConfigSource$.MODULE$.fromConfig(conf).at(namespace).load(reader);
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfigWithFallback(Config conf, Derivation<ConfigReader<Config>> reader) {
        return ConfigSource$.MODULE$.fromConfig(conf).withFallback(ConfigSource$.MODULE$.default()).load(reader);
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfigWithFallback(Config conf, String namespace, Derivation<ConfigReader<Config>> reader) {
        return ConfigSource$.MODULE$.fromConfig(conf).withFallback(ConfigSource$.MODULE$.default()).at(namespace).load(reader);
    }

    public <Config> Config loadConfigOrThrow(ClassTag<Config> evidence$1, Derivation<ConfigReader<Config>> reader) throws ConfigReaderException {
        return ConfigSource$.MODULE$.default().loadOrThrow(evidence$1, reader);
    }

    public <Config> Config loadConfigOrThrow(String namespace, ClassTag<Config> evidence$2, Derivation<ConfigReader<Config>> reader) throws ConfigReaderException {
        return ConfigSource$.MODULE$.default().at(namespace).loadOrThrow(evidence$2, reader);
    }

    public <Config> Config loadConfigOrThrow(Path path, ClassTag<Config> evidence$3, Derivation<ConfigReader<Config>> reader) throws ConfigReaderException {
        return ConfigSource$.MODULE$.default(ConfigSource$.MODULE$.file(path)).loadOrThrow(evidence$3, reader);
    }

    public <Config> Config loadConfigOrThrow(Path path, String namespace, ClassTag<Config> evidence$4, Derivation<ConfigReader<Config>> reader) throws ConfigReaderException {
        return ConfigSource$.MODULE$.default(ConfigSource$.MODULE$.file(path)).at(namespace).loadOrThrow(evidence$4, reader);
    }

    public <Config> Config loadConfigOrThrow(Config conf, ClassTag<Config> evidence$5, Derivation<ConfigReader<Config>> reader) throws ConfigReaderException {
        return ConfigSource$.MODULE$.fromConfig(conf).loadOrThrow(evidence$5, reader);
    }

    public <Config> Config loadConfigOrThrow(Config conf, String namespace, ClassTag<Config> evidence$6, Derivation<ConfigReader<Config>> reader) throws ConfigReaderException {
        return ConfigSource$.MODULE$.fromConfig(conf).at(namespace).loadOrThrow(evidence$6, reader);
    }

    public <Config> Config loadConfigWithFallbackOrThrow(Config conf, ClassTag<Config> evidence$7, Derivation<ConfigReader<Config>> reader) throws ConfigReaderException {
        return ConfigSource$.MODULE$.fromConfig(conf).withFallback(ConfigSource$.MODULE$.default()).loadOrThrow(evidence$7, reader);
    }

    public <Config> Config loadConfigWithFallbackOrThrow(Config conf, String namespace, ClassTag<Config> evidence$8, Derivation<ConfigReader<Config>> reader) throws ConfigReaderException {
        return ConfigSource$.MODULE$.fromConfig(conf).withFallback(ConfigSource$.MODULE$.default()).at(namespace).loadOrThrow(evidence$8, reader);
    }

    public <Config> void saveConfigAsPropertyFile(Config conf, Path outputPath, boolean overrideOutputPath, ConfigRenderOptions options, Derivation<ConfigWriter<Config>> writer) throws IllegalArgumentException {
        if (!overrideOutputPath && Files.isRegularFile(outputPath, new LinkOption[0])) {
            throw new IllegalArgumentException(new StringBuilder(62).append("Cannot save configuration in file '").append(outputPath).append("' because it already exists").toString());
        }
        if (Files.isDirectory(outputPath, new LinkOption[0])) {
            throw new IllegalArgumentException(new StringBuilder(81).append("Cannot save configuration in file '").append(outputPath).append("' because it already exists and is a directory").toString());
        }
        this.saveConfigToStream(conf, Files.newOutputStream(outputPath, new OpenOption[0]), options, writer);
    }

    public <Config> boolean saveConfigAsPropertyFile$default$3() {
        return false;
    }

    public <Config> ConfigRenderOptions saveConfigAsPropertyFile$default$4() {
        return ConfigRenderOptions.defaults();
    }

    public <Config> void saveConfigToStream(Config conf, OutputStream outputStream, ConfigRenderOptions options, Derivation<ConfigWriter<Config>> writer) {
        OutputStreamWriter printOutputStream = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
        ConfigValue rawConf = writer.value().to(conf);
        printOutputStream.write(rawConf.render(options));
        printOutputStream.close();
    }

    public <Config> ConfigRenderOptions saveConfigToStream$default$3() {
        return ConfigRenderOptions.defaults();
    }

    public <Config> Either<ConfigReaderFailures, Config> loadConfigFromFiles(Traversable<Path> files, boolean failOnReadError, String namespace, Derivation<ConfigReader<Config>> reader) {
        return ConfigSource$.MODULE$.default((ConfigObjectSource)((TraversableOnce)((TraversableLike)files.map((Function1 & Serializable & scala.Serializable)path -> ConfigSource$.MODULE$.file((Path)path), Traversable$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)cs -> failOnReadError ? cs : cs.optional(), Traversable$.MODULE$.canBuildFrom())).foldLeft((Object)ConfigSource$.MODULE$.empty(), (Function2 & Serializable & scala.Serializable)(x$1, x$2) -> x$1.withFallback((ConfigObjectSource)x$2))).at(namespace).load(reader);
    }

    public <Config> boolean loadConfigFromFiles$default$2() {
        return false;
    }

    public <Config> String loadConfigFromFiles$default$3() {
        return "";
    }

    public <Config> Config loadConfigFromFilesOrThrow(Traversable<Path> files, ClassTag<Config> evidence$9, Derivation<ConfigReader<Config>> reader) throws ConfigReaderException {
        return ConfigSource$.MODULE$.default((ConfigObjectSource)((TraversableOnce)files.map((Function1 & Serializable & scala.Serializable)x$3 -> ConfigSource$.MODULE$.file((Path)x$3).optional(), Traversable$.MODULE$.canBuildFrom())).foldLeft((Object)ConfigSource$.MODULE$.empty(), (Function2 & Serializable & scala.Serializable)(x$4, x$5) -> x$4.withFallback((ConfigObjectSource)x$5))).loadOrThrow(evidence$9, reader);
    }

    private package$() {
        MODULE$ = this;
    }
}

