/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.tasker;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.engine.api.execution.TaskPackageDependency;
import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;
import com.xebialabs.deployit.engine.tasker.PhaseContainer;
import com.xebialabs.deployit.engine.tasker.TaskInspectionContext;
import com.xebialabs.deployit.engine.tasker.TaskStep;
import com.xebialabs.deployit.plugin.api.udm.OnTaskFailurePolicy;
import com.xebialabs.deployit.plugin.api.udm.OnTaskSuccessPolicy;
import com.xebialabs.deployit.repository.WorkDir;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.springframework.security.core.Authentication;

public class TaskSpecification
implements Serializable {
    private final String description;
    private final Authentication owner;
    private final PhaseContainer block;
    private final Map<String, String> metadata = new HashMap<String, String>();
    private List<ExecutionStateListener> listeners = new ArrayList<ExecutionStateListener>();
    private final WorkDir workDir;
    private final String id;
    private TaskInspectionContext inspectionContext;
    private boolean recoverable;
    private boolean archiveable;
    private boolean rollback;
    private final OnTaskSuccessPolicy onSuccessPolicy;
    private final OnTaskFailurePolicy onFailurePolicy;
    private List<TaskPackageDependency> packageDependencies = new ArrayList<TaskPackageDependency>();

    public TaskSpecification(String description, Authentication owner, WorkDir workDir, PhaseContainer block) {
        this(description, owner, workDir, block, OnTaskSuccessPolicy.NOOP, OnTaskFailurePolicy.NOOP);
    }

    public TaskSpecification(String description, Authentication owner, WorkDir workDir, PhaseContainer block, OnTaskSuccessPolicy onSuccessPolicy, OnTaskFailurePolicy onFailurePolicy) {
        this(description, owner, workDir, block, null, true, true, onSuccessPolicy, onFailurePolicy);
    }

    public TaskSpecification(String id, String description, Authentication owner, WorkDir workDir, PhaseContainer block) {
        this(id, description, owner, workDir, block, null, true, true, false, OnTaskSuccessPolicy.NOOP);
    }

    public TaskSpecification(String description, Authentication owner, WorkDir workDir, PhaseContainer block, TaskInspectionContext inspectionContext) {
        this(description, owner, workDir, block, inspectionContext, true);
    }

    public TaskSpecification(String description, Authentication owner, WorkDir workDir, PhaseContainer block, TaskInspectionContext inspectionContext, boolean recoverable) {
        this(description, owner, workDir, block, inspectionContext, recoverable, true);
    }

    public TaskSpecification(String description, Authentication owner, WorkDir workDir, PhaseContainer block, TaskInspectionContext inspectionContext, boolean recoverable, boolean archiveable) {
        this(description, owner, workDir, block, inspectionContext, recoverable, archiveable, OnTaskSuccessPolicy.NOOP, OnTaskFailurePolicy.NOOP);
    }

    public TaskSpecification(String description, Authentication owner, WorkDir workDir, PhaseContainer block, TaskInspectionContext inspectionContext, boolean recoverable, boolean archiveable, OnTaskSuccessPolicy onSuccessPolicy) {
        this(UUID.randomUUID().toString(), description, owner, workDir, block, inspectionContext, recoverable, archiveable, false, onSuccessPolicy);
    }

    public TaskSpecification(String description, Authentication owner, WorkDir workDir, PhaseContainer block, TaskInspectionContext inspectionContext, boolean recoverable, boolean archiveable, OnTaskSuccessPolicy onSuccessPolicy, OnTaskFailurePolicy onFailurePolicy) {
        this(UUID.randomUUID().toString(), description, owner, workDir, block, inspectionContext, recoverable, archiveable, false, onSuccessPolicy, onFailurePolicy);
    }

    public TaskSpecification(String id, String description, Authentication owner, WorkDir workDir, PhaseContainer block, TaskInspectionContext inspectionContext, boolean recoverable, boolean archiveable) {
        this(id, description, owner, workDir, block, inspectionContext, recoverable, archiveable, false, OnTaskSuccessPolicy.NOOP);
    }

    public TaskSpecification(String id, String description, Authentication owner, WorkDir workDir, PhaseContainer block, TaskInspectionContext inspectionContext, boolean recoverable, boolean archiveable, boolean rollback, OnTaskSuccessPolicy onSuccessPolicy) {
        this(id, description, owner, workDir, block, inspectionContext, recoverable, archiveable, rollback, onSuccessPolicy, OnTaskFailurePolicy.NOOP);
    }

    public TaskSpecification(String id, String description, Authentication owner, WorkDir workDir, PhaseContainer block, TaskInspectionContext inspectionContext, boolean recoverable, boolean archiveable, boolean rollback, OnTaskSuccessPolicy onSuccessPolicy, OnTaskFailurePolicy onFailurePolicy) {
        Checks.checkNotNull((Object)workDir, (String)"WorkDir cannot be null");
        this.id = id;
        this.description = description;
        this.owner = owner;
        this.block = block;
        this.inspectionContext = inspectionContext;
        this.workDir = workDir;
        this.recoverable = recoverable;
        this.archiveable = archiveable;
        this.rollback = rollback;
        this.onSuccessPolicy = onSuccessPolicy;
        this.onFailurePolicy = onFailurePolicy;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public List<TaskStep> getSteps() {
        return this.block.getStepList();
    }

    public PhaseContainer getBlock() {
        return this.block;
    }

    public Authentication getOwner() {
        return this.owner;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public List<ExecutionStateListener> getListeners() {
        return this.listeners;
    }

    public TaskInspectionContext getInspectionContext() {
        return this.inspectionContext;
    }

    public WorkDir getWorkDir() {
        return this.workDir;
    }

    public boolean isRecoverable() {
        return this.recoverable;
    }

    public boolean isArchiveable() {
        return this.archiveable;
    }

    public boolean isRollback() {
        return this.rollback;
    }

    public OnTaskSuccessPolicy getOnSuccessPolicy() {
        return this.onSuccessPolicy == null ? OnTaskSuccessPolicy.NOOP : this.onSuccessPolicy;
    }

    public OnTaskFailurePolicy getOnFailurePolicy() {
        return this.onFailurePolicy == null ? OnTaskFailurePolicy.NOOP : this.onFailurePolicy;
    }

    public List<TaskPackageDependency> getPackageDependencies() {
        return this.packageDependencies;
    }
}

