/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.database.anonymizer;

import com.xebialabs.database.anonymizer.DatabaseName;
import com.xebialabs.database.anonymizer.utils.DbUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSetBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Import {
    private static final Logger logger = LoggerFactory.getLogger(Import.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start(String fileName) throws Exception {
        logger.info("Data import has been started. Please wait....");
        DatabaseConnection connection = null;
        try {
            connection = DbUtil.getDatabaseConnection();
            FlatXmlDataSet dataSet = Import.getDataset(fileName);
            String databaseName = DbUtil.getDatabaseName(connection.getConnection());
            DbUtil.getDatabaseOperation(databaseName).execute((IDatabaseConnection)connection, (IDataSet)dataSet);
            Import.resetDatabase(connection, databaseName);
            logger.info("Data import has been successfully finished");
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException exception) {
                    logger.error("Exception occurred while closing the connection ", (Throwable)exception);
                }
            }
        }
    }

    private static FlatXmlDataSet getDataset(String fileName) throws MalformedURLException, DataSetException {
        FlatXmlDataSetBuilder provider = new FlatXmlDataSetBuilder();
        provider.setColumnSensing(true);
        provider.setCaseSensitiveTableNames(true);
        fileName = fileName != null ? fileName : "xl-deploy-repository-dump.xml";
        return provider.build(new File(fileName));
    }

    private static void resetDatabase(DatabaseConnection connection, String databaseName) throws SQLException {
        if (DatabaseName.POSTGRES.getName().equalsIgnoreCase(databaseName)) {
            Statement seqStmt = connection.getConnection().createStatement();
            seqStmt.closeOnCompletion();
            ResultSet rs = seqStmt.executeQuery("SELECT c.relname FROM pg_class c WHERE c.relkind = 'S';");
            while (rs.next()) {
                String sequence = rs.getString("relname");
                String table = sequence.replace("_ID_seq", "");
                Statement updStmt = connection.getConnection().createStatement();
                updStmt.closeOnCompletion();
                String query = "SELECT SETVAL('\"%s\"', (SELECT MAX(\"ID\")+1 FROM \"%s\"));";
                query = String.format(query, sequence, table);
                updStmt.executeQuery(query);
            }
        }
    }
}

