/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.database.anonymizer;

import java.io.OutputStream;
import java.io.PrintStream;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class AnonymizerOptions {
    @Option(name="-f", usage="Imports a specified data file", aliases={"-source"})
    private String sourceFileName = null;
    @Option(name="-help", usage="Prints this usage message")
    private boolean printUsage = false;
    @Option(name="-import", usage="Clean and import database")
    private boolean dbImport = false;

    public void setSourceFileName(String sourceFileName) {
        this.sourceFileName = sourceFileName;
    }

    public String getSourceFileName() {
        return this.sourceFileName;
    }

    public boolean isDbImport() {
        return this.dbImport;
    }

    public void setDbImport(boolean dbImport) {
        this.dbImport = dbImport;
    }

    public boolean isPrintUsage() {
        return this.printUsage;
    }

    public void setPrintUsage(boolean printUsage) {
        this.printUsage = printUsage;
    }

    static AnonymizerOptions parse(String ... args) {
        AnonymizerOptions options = new AnonymizerOptions();
        CmdLineParser parser = new CmdLineParser((Object)options);
        try {
            parser.parseArgument(args);
            if (options.isPrintUsage()) {
                AnonymizerOptions.printUsage(parser, System.err);
                System.exit(1);
            }
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            AnonymizerOptions.printUsage(parser, System.out);
            System.exit(1);
        }
        return options;
    }

    private static void printUsage(CmdLineParser parser, PrintStream stream) {
        stream.println("Usage: ./db-anonymizer." + (System.getProperty("os.name").matches("(?i).*windows.*") ? "cmd" : "sh") + " [options] [[--] arguments]\n");
        stream.println("Options:\n");
        parser.printUsage((OutputStream)stream);
    }
}

