/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.Message;
import org.apache.camel.Ordered;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.Traceable;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.SynchronizationAdapter;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnCompletionProcessor
extends AsyncProcessorSupport
implements Traceable,
IdAware,
RouteIdAware {
    private static final Logger LOG = LoggerFactory.getLogger(OnCompletionProcessor.class);
    private final CamelContext camelContext;
    private String id;
    private String routeId;
    private final Processor processor;
    private final ExecutorService executorService;
    private final boolean shutdownExecutorService;
    private final boolean onCompleteOnly;
    private final boolean onFailureOnly;
    private final Predicate onWhen;
    private final boolean useOriginalBody;
    private final boolean afterConsumer;

    public OnCompletionProcessor(CamelContext camelContext, Processor processor, ExecutorService executorService, boolean shutdownExecutorService, boolean onCompleteOnly, boolean onFailureOnly, Predicate onWhen, boolean useOriginalBody, boolean afterConsumer) {
        ObjectHelper.notNull((Object)camelContext, (String)"camelContext");
        ObjectHelper.notNull((Object)processor, (String)"processor");
        this.camelContext = camelContext;
        this.processor = processor;
        this.executorService = executorService;
        this.shutdownExecutorService = shutdownExecutorService;
        this.onCompleteOnly = onCompleteOnly;
        this.onFailureOnly = onFailureOnly;
        this.onWhen = onWhen;
        this.useOriginalBody = useOriginalBody;
        this.afterConsumer = afterConsumer;
    }

    protected void doStart() throws Exception {
        ServiceHelper.startService((Object)this.processor);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.processor);
    }

    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownService((Object)this.processor);
        if (this.shutdownExecutorService) {
            this.getCamelContext().getExecutorServiceManager().shutdownNow(this.executorService);
        }
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (this.processor != null) {
            if (this.afterConsumer) {
                exchange.getUnitOfWork().addSynchronization((Synchronization)new OnCompletionSynchronizationAfterConsumer());
            } else {
                exchange.getUnitOfWork().addSynchronization((Synchronization)new OnCompletionSynchronizationBeforeConsumer());
            }
        }
        callback.done(true);
        return true;
    }

    protected boolean isCreateCopy() {
        return this.executorService != null || this.afterConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void doProcess(Processor processor, Exchange exchange) {
        ExtendedExchange ee = (ExtendedExchange)exchange;
        boolean stop = ee.isRouteStop();
        ee.setRouteStop(false);
        Object failureHandled = ee.removeProperty("CamelFailureHandled");
        Boolean errorhandlerHandled = ee.getErrorHandlerHandled();
        ee.setErrorHandlerHandled(null);
        boolean rollbackOnly = ee.isRollbackOnly();
        ee.setRollbackOnly(false);
        boolean rollbackOnlyLast = ee.isRollbackOnlyLast();
        ee.setRollbackOnlyLast(false);
        boolean exhausted = ((ExtendedExchange)ee.adapt(ExtendedExchange.class)).isRedeliveryExhausted();
        ee.setRedeliveryExhausted(false);
        Exception cause = ee.getException();
        ee.setException(null);
        try {
            processor.process(exchange);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        finally {
            ee.setRouteStop(stop);
            if (failureHandled != null) {
                ee.setProperty("CamelFailureHandled", failureHandled);
            }
            if (errorhandlerHandled != null) {
                ee.setErrorHandlerHandled(errorhandlerHandled);
            }
            ee.setRollbackOnly(rollbackOnly);
            ee.setRollbackOnlyLast(rollbackOnlyLast);
            ee.setRedeliveryExhausted(exhausted);
            if (cause != null) {
                ee.setException((Throwable)cause);
            }
        }
    }

    protected Exchange prepareExchange(Exchange exchange) {
        Exchange answer;
        if (this.isCreateCopy()) {
            answer = ExchangeHelper.createCorrelatedCopy((Exchange)exchange, (boolean)false);
            if (answer.hasOut()) {
                answer.setIn(answer.getOut());
                answer.setOut(null);
            }
            answer.setPattern(ExchangePattern.InOnly);
        } else {
            answer = exchange;
        }
        if (this.useOriginalBody) {
            LOG.trace("Using the original IN message instead of current");
            Message original = ExchangeHelper.getOriginalInMessage((Exchange)exchange);
            answer.setIn(original);
        }
        answer.setProperty("CamelOnCompletion", (Object)Boolean.TRUE);
        return answer;
    }

    public String toString() {
        return this.id;
    }

    public String getTraceLabel() {
        return "onCompletion";
    }

    private final class OnCompletionSynchronizationBeforeConsumer
    extends SynchronizationAdapter
    implements Ordered {
        private OnCompletionSynchronizationBeforeConsumer() {
        }

        public int getOrder() {
            return Integer.MAX_VALUE;
        }

        public void onAfterRoute(Route route, Exchange exchange) {
            if (exchange.isFailed() && OnCompletionProcessor.this.onCompleteOnly) {
                return;
            }
            if (!exchange.isFailed() && OnCompletionProcessor.this.onFailureOnly) {
                return;
            }
            if (OnCompletionProcessor.this.onWhen != null && !OnCompletionProcessor.this.onWhen.matches(exchange)) {
                return;
            }
            final Exchange copy = OnCompletionProcessor.this.prepareExchange(exchange);
            if (OnCompletionProcessor.this.executorService != null) {
                OnCompletionProcessor.this.executorService.submit(new Callable<Exchange>(){

                    @Override
                    public Exchange call() throws Exception {
                        LOG.debug("Processing onAfterRoute: {}", (Object)copy);
                        OnCompletionProcessor.doProcess(OnCompletionProcessor.this.processor, copy);
                        return copy;
                    }
                });
            } else {
                LOG.debug("Processing onAfterRoute: {}", (Object)copy);
                OnCompletionProcessor.doProcess(OnCompletionProcessor.this.processor, copy);
            }
        }

        public String toString() {
            return "onAfterRoute";
        }
    }

    private final class OnCompletionSynchronizationAfterConsumer
    extends SynchronizationAdapter
    implements Ordered {
        private OnCompletionSynchronizationAfterConsumer() {
        }

        public int getOrder() {
            return Integer.MAX_VALUE;
        }

        public void onComplete(Exchange exchange) {
            if (OnCompletionProcessor.this.onFailureOnly) {
                return;
            }
            if (OnCompletionProcessor.this.onWhen != null && !OnCompletionProcessor.this.onWhen.matches(exchange)) {
                return;
            }
            final Exchange copy = OnCompletionProcessor.this.prepareExchange(exchange);
            if (OnCompletionProcessor.this.executorService != null) {
                OnCompletionProcessor.this.executorService.submit(new Callable<Exchange>(){

                    @Override
                    public Exchange call() throws Exception {
                        LOG.debug("Processing onComplete: {}", (Object)copy);
                        OnCompletionProcessor.doProcess(OnCompletionProcessor.this.processor, copy);
                        return copy;
                    }
                });
            } else {
                LOG.debug("Processing onComplete: {}", (Object)copy);
                OnCompletionProcessor.doProcess(OnCompletionProcessor.this.processor, copy);
            }
        }

        public void onFailure(Exchange exchange) {
            if (OnCompletionProcessor.this.onCompleteOnly) {
                return;
            }
            if (OnCompletionProcessor.this.onWhen != null && !OnCompletionProcessor.this.onWhen.matches(exchange)) {
                return;
            }
            final Exchange copy = OnCompletionProcessor.this.prepareExchange(exchange);
            final Exception original = copy.getException();
            copy.setException(null);
            if (OnCompletionProcessor.this.executorService != null) {
                OnCompletionProcessor.this.executorService.submit(new Callable<Exchange>(){

                    @Override
                    public Exchange call() throws Exception {
                        LOG.debug("Processing onFailure: {}", (Object)copy);
                        OnCompletionProcessor.doProcess(OnCompletionProcessor.this.processor, copy);
                        copy.setException((Throwable)original);
                        return null;
                    }
                });
            } else {
                LOG.debug("Processing onFailure: {}", (Object)copy);
                OnCompletionProcessor.doProcess(OnCompletionProcessor.this.processor, copy);
                copy.setException((Throwable)original);
            }
        }

        public String toString() {
            if (!OnCompletionProcessor.this.onCompleteOnly && !OnCompletionProcessor.this.onFailureOnly) {
                return "onCompleteOrFailure";
            }
            if (OnCompletionProcessor.this.onCompleteOnly) {
                return "onCompleteOnly";
            }
            return "onFailureOnly";
        }
    }
}

