/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.FailedToCreateRouteException;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.ShutdownRoute;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.AdviceWithTask;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.engine.DefaultRoute;
import org.apache.camel.model.Model;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.PropertyDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteDefinitionHelper;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.processor.CamelInternalProcessor;
import org.apache.camel.processor.ContractAdvice;
import org.apache.camel.processor.Pipeline;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.reifier.rest.RestBindingReifier;
import org.apache.camel.spi.CamelInternalProcessorAdvice;
import org.apache.camel.spi.Contract;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.ManagementInterceptStrategy;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.spi.RoutePolicyFactory;
import org.apache.camel.util.ObjectHelper;

public class RouteReifier
extends ProcessorReifier<RouteDefinition> {
    private static final String[] RESERVED_PROPERTIES = new String[]{"id", "customId", "parent", "description", "group", "rest"};

    public RouteReifier(CamelContext camelContext, ProcessorDefinition<?> definition) {
        super(camelContext, (RouteDefinition)definition);
    }

    public static RouteDefinition adviceWith(RouteDefinition definition, CamelContext camelContext, RouteBuilder builder) throws Exception {
        ObjectHelper.notNull((Object)definition, (String)"RouteDefinition");
        ObjectHelper.notNull((Object)camelContext, (String)"CamelContext");
        ObjectHelper.notNull((Object)builder, (String)"RouteBuilder");
        if (definition.getInput() == null) {
            throw new IllegalArgumentException("RouteDefinition has no input");
        }
        return new RouteReifier(camelContext, definition).adviceWith(builder);
    }

    @Override
    public Processor createProcessor() throws Exception {
        throw new UnsupportedOperationException("Not implemented for RouteDefinition");
    }

    public Route createRoute() {
        try {
            return this.doCreateRoute();
        }
        catch (FailedToCreateRouteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FailedToCreateRouteException(((RouteDefinition)this.definition).getId(), ((RouteDefinition)this.definition).toString(), (Throwable)e);
        }
    }

    public RouteDefinition adviceWith(RouteBuilder builder) throws Exception {
        ObjectHelper.notNull((Object)builder, (String)"RouteBuilder");
        this.log.debug("AdviceWith route before: {}", (Object)this);
        ExtendedCamelContext ecc = (ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class);
        Model model = (Model)this.camelContext.getExtension(Model.class);
        if (builder instanceof AdviceWithRouteBuilder) {
            AdviceWithRouteBuilder arb = (AdviceWithRouteBuilder)builder;
            arb.setOriginalRoute((RouteDefinition)this.definition);
        }
        RoutesDefinition routes = builder.configureRoutes(this.camelContext);
        boolean logRoutesAsXml = true;
        if (builder instanceof AdviceWithRouteBuilder) {
            AdviceWithRouteBuilder arb = (AdviceWithRouteBuilder)builder;
            logRoutesAsXml = arb.isLogRouteAsXml();
        }
        this.log.debug("AdviceWith routes: {}", (Object)routes);
        if (!builder.getRouteCollection().getRoutes().isEmpty()) {
            throw new IllegalArgumentException("You can only advice from a RouteBuilder which has no existing routes. Remove all routes from the route builder.");
        }
        if (builder.getRouteCollection().getErrorHandlerFactory() != null && ecc.getErrorHandlerFactory() != builder.getRouteCollection().getErrorHandlerFactory()) {
            throw new IllegalArgumentException("You can not advice with error handlers. Remove the error handlers from the route builder.");
        }
        String beforeAsXml = null;
        if (logRoutesAsXml && this.log.isInfoEnabled()) {
            try {
                beforeAsXml = ecc.getModelToXMLDumper().dumpModelAsXml(this.camelContext, (NamedNode)this.definition);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        model.removeRouteDefinition((RouteDefinition)this.definition);
        if (builder instanceof AdviceWithRouteBuilder) {
            List<AdviceWithTask> tasks = ((AdviceWithRouteBuilder)builder).getAdviceWithTasks();
            for (AdviceWithTask task : tasks) {
                task.task();
            }
        }
        RouteDefinition merged = routes.route((RouteDefinition)this.definition);
        model.getRouteDefinitions().add(0, merged);
        if (this.log.isInfoEnabled()) {
            this.log.info("AdviceWith route after: {}", (Object)merged);
        }
        if (beforeAsXml != null && logRoutesAsXml && this.log.isInfoEnabled()) {
            try {
                String afterAsXml = ecc.getModelToXMLDumper().dumpModelAsXml(this.camelContext, (NamedNode)merged);
                this.log.info("Adviced route before/after as XML:\n{}\n{}", (Object)beforeAsXml, (Object)afterAsXml);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.camelContext.isStarted()) {
            model.addRouteDefinition(merged);
        }
        return merged;
    }

    protected Route doCreateRoute() throws Exception {
        CamelInternalProcessor.RouteLifecycleAdvice task2;
        CamelInternalProcessor.RoutePolicyAdvice task;
        Object policy;
        Object delayer;
        Boolean isStreamCache;
        Boolean isLogMask;
        Boolean isMessageHistory;
        Boolean isTrace;
        Endpoint endpoint = ((RouteDefinition)this.definition).getInput().getEndpoint();
        if (endpoint == null) {
            EndpointConsumerBuilder def = ((RouteDefinition)this.definition).getInput().getEndpointConsumerBuilder();
            endpoint = def != null ? def.resolve(this.camelContext) : this.resolveEndpoint(((RouteDefinition)this.definition).getInput().getEndpointUri());
        }
        String id = ((RouteDefinition)this.definition).idOrCreate(((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).getNodeIdFactory());
        String desc = RouteDefinitionHelper.getRouteMessage(((RouteDefinition)this.definition).toString());
        DefaultRoute route = new DefaultRoute(this.camelContext, (NamedNode)this.definition, id, desc, endpoint);
        route.setErrorHandlerFactory(((RouteDefinition)this.definition).getErrorHandlerFactory());
        if (((RouteDefinition)this.definition).getTrace() != null && (isTrace = this.parseBoolean(((RouteDefinition)this.definition).getTrace())) != null) {
            route.setTracing(isTrace);
            if (isTrace.booleanValue()) {
                this.log.debug("Tracing is enabled on route: {}", (Object)((RouteDefinition)this.definition).getId());
            }
        }
        if (((RouteDefinition)this.definition).getMessageHistory() != null && (isMessageHistory = this.parseBoolean(((RouteDefinition)this.definition).getMessageHistory())) != null) {
            route.setMessageHistory(isMessageHistory);
            if (isMessageHistory.booleanValue()) {
                this.log.debug("Message history is enabled on route: {}", (Object)((RouteDefinition)this.definition).getId());
            }
        }
        if (((RouteDefinition)this.definition).getLogMask() != null && (isLogMask = this.parseBoolean(((RouteDefinition)this.definition).getLogMask())) != null) {
            route.setLogMask(isLogMask);
            if (isLogMask.booleanValue()) {
                this.log.debug("Security mask for Logging is enabled on route: {}", (Object)((RouteDefinition)this.definition).getId());
            }
        }
        if (((RouteDefinition)this.definition).getStreamCache() != null && (isStreamCache = this.parseBoolean(((RouteDefinition)this.definition).getStreamCache())) != null) {
            route.setStreamCaching(isStreamCache);
            if (isStreamCache.booleanValue()) {
                this.log.debug("StreamCaching is enabled on route: {}", (Object)((RouteDefinition)this.definition).getId());
            }
        }
        if (((RouteDefinition)this.definition).getDelayer() != null && (delayer = this.parseDuration(((RouteDefinition)this.definition).getDelayer())) != null) {
            route.setDelayer((Long)delayer);
            if ((Long)delayer > 0L) {
                this.log.debug("Delayer is enabled with: {} ms. on route: {}", delayer, (Object)((RouteDefinition)this.definition).getId());
            } else {
                this.log.debug("Delayer is disabled on route: {}", (Object)((RouteDefinition)this.definition).getId());
            }
        }
        if (((RouteDefinition)this.definition).getRoutePolicies() != null && !((RouteDefinition)this.definition).getRoutePolicies().isEmpty()) {
            for (RoutePolicy policy2 : ((RouteDefinition)this.definition).getRoutePolicies()) {
                this.log.debug("RoutePolicy is enabled: {} on route: {}", (Object)policy2, (Object)((RouteDefinition)this.definition).getId());
                route.getRoutePolicyList().add(policy2);
            }
        }
        if (((RouteDefinition)this.definition).getRoutePolicyRef() != null) {
            StringTokenizer policyTokens = new StringTokenizer(((RouteDefinition)this.definition).getRoutePolicyRef(), ",");
            while (policyTokens.hasMoreTokens()) {
                String ref = policyTokens.nextToken().trim();
                policy = this.mandatoryLookup(ref, RoutePolicy.class);
                this.log.debug("RoutePolicy is enabled: {} on route: {}", policy, (Object)((RouteDefinition)this.definition).getId());
                route.getRoutePolicyList().add(policy);
            }
        }
        if (this.camelContext.getRoutePolicyFactories() != null) {
            for (RoutePolicyFactory factory : this.camelContext.getRoutePolicyFactories()) {
                policy = factory.createRoutePolicy(this.camelContext, ((RouteDefinition)this.definition).getId(), (NamedNode)this.definition);
                if (policy == null) continue;
                this.log.debug("RoutePolicy is enabled: {} on route: {}", policy, (Object)((RouteDefinition)this.definition).getId());
                route.getRoutePolicyList().add(policy);
            }
        }
        Boolean isAutoStartup = this.parseBoolean(((RouteDefinition)this.definition).getAutoStartup());
        Integer startupOrder = ((RouteDefinition)this.definition).getStartupOrder();
        if (((RouteDefinition)this.definition).getShutdownRoute() != null) {
            this.log.debug("Using ShutdownRoute {} on route: {}", (Object)((RouteDefinition)this.definition).getShutdownRoute(), (Object)((RouteDefinition)this.definition).getId());
            route.setShutdownRoute(this.parse(ShutdownRoute.class, ((RouteDefinition)this.definition).getShutdownRoute()));
        }
        if (((RouteDefinition)this.definition).getShutdownRunningTask() != null) {
            this.log.debug("Using ShutdownRunningTask {} on route: {}", (Object)((RouteDefinition)this.definition).getShutdownRunningTask(), (Object)((RouteDefinition)this.definition).getId());
            route.setShutdownRunningTask(this.parse(ShutdownRunningTask.class, ((RouteDefinition)this.definition).getShutdownRunningTask()));
        }
        route.getInterceptStrategies().addAll(((RouteDefinition)this.definition).getInterceptStrategies());
        for (LifecycleStrategy strategy : this.camelContext.getLifecycleStrategies()) {
            strategy.onRouteContextCreate((Route)route);
        }
        if (!this.hasOutputs(((RouteDefinition)this.definition).getOutputs(), true)) {
            String at = ((RouteDefinition)this.definition).getInput().toString();
            IllegalArgumentException cause = new IllegalArgumentException("Route " + ((RouteDefinition)this.definition).getId() + " has no output processors. You need to add outputs to the route such as to(\"log:foo\").");
            throw new FailedToCreateRouteException(((RouteDefinition)this.definition).getId(), ((RouteDefinition)this.definition).toString(), at, (Throwable)cause);
        }
        ArrayList list = new ArrayList(((RouteDefinition)this.definition).getOutputs());
        for (ProcessorDefinition processorDefinition : list) {
            try {
                ProcessorReifier.reifier((Route)route, processorDefinition).addRoutes();
            }
            catch (Exception e) {
                throw new FailedToCreateRouteException(((RouteDefinition)this.definition).getId(), ((RouteDefinition)this.definition).toString(), processorDefinition.toString(), (Throwable)e);
            }
        }
        List eventDrivenProcessors = route.getEventDrivenProcessors();
        if (eventDrivenProcessors.isEmpty()) {
            return null;
        }
        Map<String, Object> map = this.computeRouteProperties();
        Pipeline target = new Pipeline(this.camelContext, (Collection)eventDrivenProcessors);
        CamelInternalProcessor internal = new CamelInternalProcessor(this.camelContext, (Processor)target);
        internal.addAdvice((CamelInternalProcessorAdvice)new CamelInternalProcessor.UnitOfWorkProcessorAdvice((Route)route, this.camelContext));
        List routePolicyList = route.getRoutePolicyList();
        if (routePolicyList != null && !routePolicyList.isEmpty()) {
            for (RoutePolicy policy3 : routePolicyList) {
                if (this.camelContext.hasService((Object)policy3)) continue;
                try {
                    this.camelContext.addService((Object)policy3);
                }
                catch (Exception e) {
                    throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
                }
            }
            internal.addAdvice((CamelInternalProcessorAdvice)new CamelInternalProcessor.RoutePolicyAdvice(routePolicyList));
        }
        internal.addAdvice((CamelInternalProcessorAdvice)new CamelInternalProcessor.RouteInflightRepositoryAdvice(this.camelContext.getInflightRepository(), route.getRouteId()));
        ManagementInterceptStrategy managementInterceptStrategy = route.getManagementInterceptStrategy();
        if (managementInterceptStrategy != null) {
            internal.addAdvice(CamelInternalProcessor.wrap((ManagementInterceptStrategy.InstrumentationProcessor)managementInterceptStrategy.createProcessor("route")));
        }
        internal.addAdvice((CamelInternalProcessorAdvice)new CamelInternalProcessor.RouteLifecycleAdvice());
        if (((RouteDefinition)this.definition).getRestBindingDefinition() != null) {
            try {
                internal.addAdvice((CamelInternalProcessorAdvice)new RestBindingReifier((Route)route, ((RouteDefinition)this.definition).getRestBindingDefinition()).createRestBindingAdvice());
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
        }
        if (((RouteDefinition)this.definition).getInputType() != null || ((RouteDefinition)this.definition).getOutputType() != null) {
            Contract contract = new Contract();
            if (((RouteDefinition)this.definition).getInputType() != null) {
                contract.setInputType(this.parseString(((RouteDefinition)this.definition).getInputType().getUrn()));
                contract.setValidateInput(this.parseBoolean(((RouteDefinition)this.definition).getInputType().getValidate(), false));
            }
            if (((RouteDefinition)this.definition).getOutputType() != null) {
                contract.setOutputType(this.parseString(((RouteDefinition)this.definition).getOutputType().getUrn()));
                contract.setValidateOutput(this.parseBoolean(((RouteDefinition)this.definition).getOutputType().getValidate(), false));
            }
            internal.addAdvice((CamelInternalProcessorAdvice)new ContractAdvice(contract));
            this.camelContext.setUseDataType(Boolean.valueOf(true));
        }
        route.setProcessor((Processor)internal);
        route.getProperties().putAll(map);
        route.setStartupOrder(startupOrder);
        if (isAutoStartup != null) {
            this.log.debug("Using AutoStartup {} on route: {}", (Object)isAutoStartup, (Object)((RouteDefinition)this.definition).getId());
            route.setAutoStartup(isAutoStartup);
        }
        if ((task = (CamelInternalProcessor.RoutePolicyAdvice)internal.getAdvice(CamelInternalProcessor.RoutePolicyAdvice.class)) != null) {
            task.setRoute((Route)route);
        }
        if ((task2 = (CamelInternalProcessor.RouteLifecycleAdvice)internal.getAdvice(CamelInternalProcessor.RouteLifecycleAdvice.class)) != null) {
            task2.setRoute((Route)route);
        }
        if (routePolicyList != null && !routePolicyList.isEmpty()) {
            for (RoutePolicy policy4 : routePolicyList) {
                policy4.onInit((Route)route);
            }
        }
        return route;
    }

    protected Map<String, Object> computeRouteProperties() {
        HashMap<String, Object> routeProperties = new HashMap<String, Object>();
        routeProperties.put("id", ((RouteDefinition)this.definition).getId());
        routeProperties.put("customId", Boolean.toString(((RouteDefinition)this.definition).hasCustomIdAssigned()));
        routeProperties.put("parent", Integer.toHexString(((RouteDefinition)this.definition).hashCode()));
        routeProperties.put("description", ((RouteDefinition)this.definition).getDescriptionText());
        if (((RouteDefinition)this.definition).getGroup() != null) {
            routeProperties.put("group", ((RouteDefinition)this.definition).getGroup());
        }
        String rest = Boolean.toString(((RouteDefinition)this.definition).isRest() != null && ((RouteDefinition)this.definition).isRest() != false);
        routeProperties.put("rest", rest);
        List<PropertyDefinition> properties = ((RouteDefinition)this.definition).getRouteProperties();
        if (properties != null) {
            for (PropertyDefinition prop : properties) {
                try {
                    String key = this.parseString(prop.getKey());
                    String val = this.parseString(prop.getValue());
                    for (String property : RESERVED_PROPERTIES) {
                        if (!property.equalsIgnoreCase(key)) continue;
                        throw new IllegalArgumentException("Cannot set route property " + property + " as it is a reserved property");
                    }
                    routeProperties.put(key, val);
                }
                catch (Exception e) {
                    throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
                }
            }
        }
        return routeProperties;
    }
}

