/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.database.anonymizer.utils;

import com.typesafe.config.Config;
import com.xebialabs.database.anonymizer.DatabaseName;
import com.xebialabs.deployit.ServerConfigFile;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.XldServerPaths;
import com.xebialabs.deployit.core.config.XldConfig;
import com.xebialabs.deployit.security.SecretKeyHolder;
import com.xebialabs.deployit.util.DeployitKeys;
import com.xebialabs.deployit.util.PasswordEncrypter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import javax.crypto.SecretKey;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.ForwardOnlyResultSetTableFactory;
import org.dbunit.dataset.datatype.DefaultDataTypeFactory;
import org.dbunit.ext.db2.Db2DataTypeFactory;
import org.dbunit.ext.mssql.InsertIdentityOperation;
import org.dbunit.ext.mssql.MsSqlDataTypeFactory;
import org.dbunit.ext.mysql.MySqlDataTypeFactory;
import org.dbunit.ext.oracle.OracleDataTypeFactory;
import org.dbunit.ext.postgresql.PostgresqlDataTypeFactory;
import org.dbunit.operation.DatabaseOperation;

public class DbUtil {
    private static Connection getDriverConnection() throws SQLException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        ServerConfigFile serverConfigFile = new ServerConfigFile(XldServerPaths.DEFAULT_CONFIGURATION_FILE);
        ServerConfiguration serverConfiguration = serverConfigFile.loadConfig(false, false);
        String repositoryKeyStorePassword = serverConfiguration.getRepositoryKeyStorePassword();
        SecretKey passwordEncryptionKey = DeployitKeys.getPasswordEncryptionKey((String)repositoryKeyStorePassword);
        PasswordEncrypter.init((SecretKey)passwordEncryptionKey);
        Config xldConfig = new XldConfig("xl-deploy.conf", SecretKeyHolder.get()).rootConfig();
        Properties properties = new Properties();
        properties.put("user", xldConfig.getString("xl.repository.database.db-username"));
        properties.put("password", xldConfig.getString("xl.repository.database.db-password"));
        Driver driver = (Driver)Class.forName(xldConfig.getString("xl.repository.database.db-driver-classname")).newInstance();
        Connection driverConnection = driver.connect(xldConfig.getString("xl.repository.database.db-url"), properties);
        driverConnection.setAutoCommit(true);
        return driverConnection;
    }

    public static String getDatabaseName(Connection connection) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        return metaData.getDatabaseProductName().toLowerCase();
    }

    private static void updateDatabaseConfig(DatabaseConnection connection, String databaseName) {
        DatabaseConfig config = connection.getConfig();
        config.setProperty("http://www.dbunit.org/features/caseSensitiveTableNames", (Object)true);
        config.setProperty("http://www.dbunit.org/features/qualifiedTableNames", (Object)true);
        config.setProperty("http://www.dbunit.org/features/allowEmptyFields", (Object)true);
        config.setProperty("http://www.dbunit.org/properties/resultSetTableFactory", (Object)new ForwardOnlyResultSetTableFactory());
        if (databaseName.contains(DatabaseName.Oracle.getName())) {
            config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new OracleDataTypeFactory());
            config.setProperty("http://www.dbunit.org/properties/escapePattern", (Object)"\"?\"");
        } else if (databaseName.contains(DatabaseName.MSSQL.getName())) {
            config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new MsSqlDataTypeFactory());
            config.setProperty("http://www.dbunit.org/properties/escapePattern", (Object)"\"?\"");
        } else if (databaseName.contains(DatabaseName.POSTGRES.getName())) {
            config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new PostgresqlDataTypeFactory());
            config.setProperty("http://www.dbunit.org/properties/escapePattern", (Object)"\"?\"");
        } else if (databaseName.contains(DatabaseName.MYSQL.getName())) {
            config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new MySqlDataTypeFactory());
            config.setProperty("http://www.dbunit.org/properties/escapePattern", (Object)"`?`");
        } else if (databaseName.contains(DatabaseName.DB2.getName())) {
            config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new Db2DataTypeFactory());
            config.setProperty("http://www.dbunit.org/properties/escapePattern", (Object)"\"?\"");
        } else {
            config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new DefaultDataTypeFactory());
            config.setProperty("http://www.dbunit.org/properties/escapePattern", (Object)"\"?\"");
        }
    }

    public static DatabaseConnection getDatabaseConnection() throws DatabaseUnitException, SQLException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        Connection driverConnection = DbUtil.getDriverConnection();
        String databaseName = DbUtil.getDatabaseName(driverConnection);
        DatabaseConnection connection = databaseName.contains(DatabaseName.Oracle.getName()) ? new DatabaseConnection(driverConnection, driverConnection.getMetaData().getUserName()) : (databaseName.contains(DatabaseName.MSSQL.getName()) ? new DatabaseConnection(driverConnection, "dbo") : new DatabaseConnection(driverConnection));
        DbUtil.updateDatabaseConfig(connection, databaseName);
        return connection;
    }

    public static DatabaseOperation getDatabaseOperation(String databaseName) {
        if (databaseName.contains(DatabaseName.MSSQL.getName())) {
            return InsertIdentityOperation.CLEAN_INSERT;
        }
        return DatabaseOperation.CLEAN_INSERT;
    }
}

