/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.database.anonymizer;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xebialabs.database.anonymizer.dataset.XldReplacementDataSet;
import com.xebialabs.database.anonymizer.filter.AnonymizerDatabaseSequenceFilter;
import com.xebialabs.database.anonymizer.model.AnonymizerRules;
import com.xebialabs.database.anonymizer.model.ContentToAnonymize;
import com.xebialabs.database.anonymizer.utils.DbUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.sql.SQLException;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.FilteredDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.filter.ITableFilter;
import org.dbunit.dataset.xml.FlatXmlDataSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Export {
    private static final Logger logger = LoggerFactory.getLogger(Export.class);

    public static void start() throws ClassNotFoundException, SQLException, DatabaseUnitException, InstantiationException, IllegalAccessException, IOException {
        logger.info("Data export has been started. Please wait....");
        try (DatabaseConnection connection = null;){
            connection = DbUtil.getDatabaseConnection();
            XldReplacementDataSet replacementDataSet = Export.getReplacementDataset(connection);
            FlatXmlDataSet.write((IDataSet)replacementDataSet, (Writer)new FileWriter(new File("xl-deploy-repository-dump.xml")));
            logger.info("Data export has been successfully finished. You can find xl-deploy-repository-dump.xml in the server home directory");
        }
    }

    private static XldReplacementDataSet getReplacementDataset(DatabaseConnection connection) throws SQLException, DataSetException, IOException {
        AnonymizerRules rules = Export.getAnonymizerRules();
        AnonymizerDatabaseSequenceFilter filter = new AnonymizerDatabaseSequenceFilter(rules, (IDatabaseConnection)connection);
        FilteredDataSet dataset = new FilteredDataSet((ITableFilter)filter, connection.createDataSet());
        XldReplacementDataSet replacementDataSet = new XldReplacementDataSet((IDataSet)dataset);
        for (ContentToAnonymize item : rules.getReplacementItems()) {
            replacementDataSet.addReplacementSubstring(item.getKey(), item.getValue());
        }
        replacementDataSet.addReplacementTablesInput(rules.getTableValueReplacements());
        return replacementDataSet;
    }

    private static AnonymizerRules getAnonymizerRules() throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        DefaultPrettyPrinter defaultPrettyPrinter = new DefaultPrettyPrinter();
        defaultPrettyPrinter.indentArraysWith((DefaultPrettyPrinter.Indenter)DefaultIndenter.SYSTEM_LINEFEED_INSTANCE);
        defaultPrettyPrinter.indentObjectsWith((DefaultPrettyPrinter.Indenter)DefaultIndenter.SYSTEM_LINEFEED_INSTANCE);
        objectMapper.setDefaultPrettyPrinter((PrettyPrinter)defaultPrettyPrinter);
        URL anonymizerConfiguration = DbUtil.class.getClassLoader().getResource("db-anonymize.json");
        AnonymizerRules anonymizerRules = AnonymizerRules.createDefault();
        if (anonymizerConfiguration == null) {
            logger.info("Default configuration for anonymizer not found.");
        } else {
            anonymizerRules = (AnonymizerRules)objectMapper.readValue(new File(anonymizerConfiguration.getFile()), (TypeReference)new TypeReference<AnonymizerRules>(){});
        }
        return anonymizerRules;
    }
}

