/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;

public final class CatalogHelper {
    private CatalogHelper() {
    }

    public static void loadLines(InputStream in, List<String> lines) throws IOException {
        try (InputStreamReader isr = new InputStreamReader(in);
             LineNumberReader reader = new LineNumberReader(isr);){
            String line;
            while ((line = ((BufferedReader)reader).readLine()) != null) {
                lines.add(line);
            }
        }
    }

    public static List<String> loadLines(InputStream in) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        CatalogHelper.loadLines(in, lines);
        return lines;
    }

    public static String loadText(InputStream in) throws IOException {
        StringBuilder builder = new StringBuilder();
        try (InputStreamReader isr = new InputStreamReader(in);){
            String string;
            try (LineNumberReader reader = new LineNumberReader(isr);){
                String line;
                while ((line = ((BufferedReader)reader).readLine()) != null) {
                    builder.append(line);
                    builder.append("\n");
                }
                string = builder.toString();
            }
            return string;
        }
    }

    public static boolean matchWildcard(String name, String pattern) {
        return pattern.endsWith("*") && name.startsWith(pattern.substring(0, pattern.length() - 1));
    }

    public static String after(String text, String after) {
        if (!text.contains(after)) {
            return null;
        }
        return text.substring(text.indexOf(after) + after.length());
    }

    public static String before(String text, String before) {
        if (!text.contains(before)) {
            return null;
        }
        return text.substring(0, text.indexOf(before));
    }

    public static String between(String text, String after, String before) {
        if ((text = CatalogHelper.after(text, after)) == null) {
            return null;
        }
        return CatalogHelper.before(text, before);
    }

    public static boolean isEmpty(Object value) {
        return !CatalogHelper.isNotEmpty(value);
    }

    public static boolean isNotEmpty(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof String) {
            String text = (String)value;
            return text.trim().length() > 0;
        }
        return true;
    }

    public static String removeLeadingAndEndingQuotes(String s) {
        if (CatalogHelper.isEmpty(s)) {
            return s;
        }
        String copy = s.trim();
        if (copy.startsWith("'") && copy.endsWith("'")) {
            return copy.substring(1, copy.length() - 1);
        }
        if (copy.startsWith("\"") && copy.endsWith("\"")) {
            return copy.substring(1, copy.length() - 1);
        }
        return s;
    }
}

