/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.errorhandler;

import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Processor;
import org.apache.camel.builder.DefaultErrorHandlerBuilder;
import org.apache.camel.processor.ErrorHandler;
import org.apache.camel.processor.errorhandler.DefaultErrorHandler;
import org.apache.camel.reifier.errorhandler.ErrorHandlerReifier;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.ThreadPoolProfile;

public class DefaultErrorHandlerReifier<T extends DefaultErrorHandlerBuilder>
extends ErrorHandlerReifier<T> {
    public DefaultErrorHandlerReifier(RouteContext routeContext, ErrorHandlerFactory definition) {
        super(routeContext, (DefaultErrorHandlerBuilder)definition);
    }

    @Override
    public Processor createErrorHandler(Processor processor) throws Exception {
        DefaultErrorHandler answer = new DefaultErrorHandler(this.camelContext, processor, ((DefaultErrorHandlerBuilder)this.definition).getLogger(), ((DefaultErrorHandlerBuilder)this.definition).getOnRedelivery(), ((DefaultErrorHandlerBuilder)this.definition).getRedeliveryPolicy(), ((DefaultErrorHandlerBuilder)this.definition).getExceptionPolicyStrategy(), ((DefaultErrorHandlerBuilder)this.definition).getRetryWhilePolicy(this.camelContext), this.getExecutorService(this.camelContext), ((DefaultErrorHandlerBuilder)this.definition).getOnPrepareFailure(), ((DefaultErrorHandlerBuilder)this.definition).getOnExceptionOccurred());
        this.configure(this.routeContext, (ErrorHandler)answer);
        return answer;
    }

    protected synchronized ScheduledExecutorService getExecutorService(CamelContext camelContext) {
        ScheduledExecutorService executorService = ((DefaultErrorHandlerBuilder)this.definition).getExecutorService();
        String executorServiceRef = ((DefaultErrorHandlerBuilder)this.definition).getExecutorServiceRef();
        if (executorService == null || executorService.isShutdown()) {
            if (executorServiceRef != null) {
                executorService = (ScheduledExecutorService)camelContext.getRegistry().lookupByNameAndType(executorServiceRef, ScheduledExecutorService.class);
                if (executorService == null) {
                    ExecutorServiceManager manager = camelContext.getExecutorServiceManager();
                    ThreadPoolProfile profile = manager.getThreadPoolProfile(executorServiceRef);
                    executorService = manager.newScheduledThreadPool((Object)this, executorServiceRef, profile);
                }
                if (executorService == null) {
                    throw new IllegalArgumentException("ExecutorServiceRef " + executorServiceRef + " not found in registry.");
                }
            } else {
                executorService = null;
            }
            ((DefaultErrorHandlerBuilder)this.definition).setExecutorService(executorService);
        }
        return executorService;
    }
}

