/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.model.ExpressionSubElementDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.reifier.language.ExpressionReifier;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.support.CamelContextHelper;

public abstract class AbstractReifier {
    protected final RouteContext routeContext;
    protected final CamelContext camelContext;

    public AbstractReifier(RouteContext routeContext) {
        this.routeContext = routeContext;
        this.camelContext = routeContext.getCamelContext();
    }

    public AbstractReifier(CamelContext camelContext) {
        this.routeContext = null;
        this.camelContext = camelContext;
    }

    protected String parseString(String text) {
        return CamelContextHelper.parseText((CamelContext)this.camelContext, (String)text);
    }

    protected Boolean parseBoolean(String text) {
        return CamelContextHelper.parseBoolean((CamelContext)this.camelContext, (String)text);
    }

    protected boolean parseBoolean(String text, boolean def) {
        Boolean b = this.parseBoolean(text);
        return b != null ? b : def;
    }

    protected Long parseLong(String text) {
        return CamelContextHelper.parseLong((CamelContext)this.camelContext, (String)text);
    }

    protected long parseLong(String text, long def) {
        Long l = this.parseLong(text);
        return l != null ? l : def;
    }

    protected Integer parseInt(String text) {
        return CamelContextHelper.parseInteger((CamelContext)this.camelContext, (String)text);
    }

    protected int parseInt(String text, int def) {
        Integer i = this.parseInt(text);
        return i != null ? i : def;
    }

    protected Float parseFloat(String text) {
        return CamelContextHelper.parseFloat((CamelContext)this.camelContext, (String)text);
    }

    protected float parseFloat(String text, float def) {
        Float f = this.parseFloat(text);
        return f != null ? f.floatValue() : def;
    }

    protected <T> T parse(Class<T> clazz, String text) {
        return (T)CamelContextHelper.parse((CamelContext)this.camelContext, clazz, (String)text);
    }

    protected <T> T parse(Class<T> clazz, Object text) {
        if (text instanceof String) {
            text = this.parseString((String)text);
        }
        return (T)CamelContextHelper.convertTo((CamelContext)this.camelContext, clazz, (Object)text);
    }

    protected Expression createExpression(ExpressionDefinition expression) {
        return ExpressionReifier.reifier(this.camelContext, expression).createExpression();
    }

    protected Expression createExpression(ExpressionSubElementDefinition expression) {
        return ExpressionReifier.reifier(this.camelContext, expression).createExpression();
    }

    protected Predicate createPredicate(ExpressionDefinition expression) {
        return ExpressionReifier.reifier(this.camelContext, expression).createPredicate();
    }

    protected Predicate createPredicate(ExpressionSubElementDefinition expression) {
        return ExpressionReifier.reifier(this.camelContext, expression).createPredicate();
    }

    protected Object or(Object a, Object b) {
        return a != null ? a : b;
    }

    protected Object asRef(String s) {
        return s != null ? (s.startsWith("#") ? s : "#" + s) : null;
    }
}

