/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RecipientListDefinition;
import org.apache.camel.processor.EvaluateExpressionProcessor;
import org.apache.camel.processor.RecipientList;
import org.apache.camel.processor.aggregate.AggregationStrategyBeanAdapter;
import org.apache.camel.processor.aggregate.ShareUnitOfWorkAggregationStrategy;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.support.CamelContextHelper;

public class RecipientListReifier
extends ProcessorReifier<RecipientListDefinition<?>> {
    public RecipientListReifier(RouteContext routeContext, ProcessorDefinition<?> definition) {
        super(routeContext, (RecipientListDefinition)definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        long timeout;
        Expression expression = this.createExpression(((RecipientListDefinition)this.definition).getExpression());
        boolean isParallelProcessing = this.parseBoolean(((RecipientListDefinition)this.definition).getParallelProcessing(), false);
        boolean isStreaming = this.parseBoolean(((RecipientListDefinition)this.definition).getStreaming(), false);
        boolean isParallelAggregate = this.parseBoolean(((RecipientListDefinition)this.definition).getParallelAggregate(), false);
        boolean isShareUnitOfWork = this.parseBoolean(((RecipientListDefinition)this.definition).getShareUnitOfWork(), false);
        boolean isStopOnException = this.parseBoolean(((RecipientListDefinition)this.definition).getStopOnException(), false);
        boolean isIgnoreInvalidEndpoints = this.parseBoolean(((RecipientListDefinition)this.definition).getIgnoreInvalidEndpoints(), false);
        boolean isStopOnAggregateException = this.parseBoolean(((RecipientListDefinition)this.definition).getStopOnAggregateException(), false);
        RecipientList answer = ((RecipientListDefinition)this.definition).getDelimiter() != null ? new RecipientList(this.camelContext, expression, this.parseString(((RecipientListDefinition)this.definition).getDelimiter())) : new RecipientList(this.camelContext, expression);
        answer.setAggregationStrategy(this.createAggregationStrategy(this.routeContext));
        answer.setParallelProcessing(isParallelProcessing);
        answer.setParallelAggregate(isParallelAggregate);
        answer.setStreaming(isStreaming);
        answer.setShareUnitOfWork(isShareUnitOfWork);
        answer.setStopOnException(isStopOnException);
        answer.setIgnoreInvalidEndpoints(isIgnoreInvalidEndpoints);
        answer.setStopOnAggregateException(isStopOnAggregateException);
        if (((RecipientListDefinition)this.definition).getCacheSize() != null) {
            answer.setCacheSize(this.parseInt(((RecipientListDefinition)this.definition).getCacheSize()).intValue());
        }
        if (((RecipientListDefinition)this.definition).getOnPrepareRef() != null) {
            ((RecipientListDefinition)this.definition).setOnPrepare((Processor)CamelContextHelper.mandatoryLookup((CamelContext)this.camelContext, (String)((RecipientListDefinition)this.definition).getOnPrepareRef(), Processor.class));
        }
        if (((RecipientListDefinition)this.definition).getOnPrepare() != null) {
            answer.setOnPrepare(((RecipientListDefinition)this.definition).getOnPrepare());
        }
        if (((RecipientListDefinition)this.definition).getTimeout() != null) {
            answer.setTimeout(this.parseLong(((RecipientListDefinition)this.definition).getTimeout()).longValue());
        }
        boolean shutdownThreadPool = this.willCreateNewThreadPool((ExecutorServiceAwareDefinition)((Object)this.definition), isParallelProcessing);
        ExecutorService threadPool = this.getConfiguredExecutorService("RecipientList", (ExecutorServiceAwareDefinition)((Object)this.definition), isParallelProcessing);
        answer.setExecutorService(threadPool);
        answer.setShutdownExecutorService(shutdownThreadPool);
        long l = timeout = ((RecipientListDefinition)this.definition).getTimeout() != null ? this.parseLong(((RecipientListDefinition)this.definition).getTimeout()) : 0L;
        if (timeout > 0L && !isParallelProcessing) {
            throw new IllegalArgumentException("Timeout is used but ParallelProcessing has not been enabled.");
        }
        ArrayList<Object> pipe = new ArrayList<Object>(2);
        EvaluateExpressionProcessor evalProcessor = new EvaluateExpressionProcessor(expression);
        evalProcessor = super.wrapInErrorHandler((Processor)evalProcessor);
        pipe.add(evalProcessor);
        pipe.add(answer);
        return answer.newPipeline(this.camelContext, pipe);
    }

    private AggregationStrategy createAggregationStrategy(RouteContext routeContext) {
        AggregationStrategy strategy = ((RecipientListDefinition)this.definition).getAggregationStrategy();
        if (strategy == null && ((RecipientListDefinition)this.definition).getStrategyRef() != null) {
            Object aggStrategy = routeContext.lookup(this.parseString(((RecipientListDefinition)this.definition).getStrategyRef()), Object.class);
            if (aggStrategy instanceof AggregationStrategy) {
                strategy = (AggregationStrategy)aggStrategy;
            } else if (aggStrategy != null) {
                AggregationStrategyBeanAdapter adapter = new AggregationStrategyBeanAdapter(aggStrategy, this.parseString(((RecipientListDefinition)this.definition).getStrategyMethodName()));
                if (((RecipientListDefinition)this.definition).getStrategyMethodAllowNull() != null) {
                    adapter.setAllowNullNewExchange(this.parseBoolean(((RecipientListDefinition)this.definition).getStrategyMethodAllowNull(), false));
                    adapter.setAllowNullOldExchange(this.parseBoolean(((RecipientListDefinition)this.definition).getStrategyMethodAllowNull(), false));
                }
                strategy = adapter;
            } else {
                throw new IllegalArgumentException("Cannot find AggregationStrategy in Registry with name: " + ((RecipientListDefinition)this.definition).getStrategyRef());
            }
        }
        if (strategy == null) {
            strategy = new UseLatestAggregationStrategy();
        }
        if (strategy instanceof CamelContextAware) {
            ((CamelContextAware)strategy).setCamelContext(this.camelContext);
        }
        if (this.parseBoolean(((RecipientListDefinition)this.definition).getShareUnitOfWork(), false)) {
            strategy = new ShareUnitOfWorkAggregationStrategy(strategy);
        }
        return strategy;
    }
}

