/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.artery.aeron;

import akka.Done;
import akka.Done$;
import akka.actor.Address;
import akka.actor.Cancellable;
import akka.actor.ExtendedActorSystem;
import akka.event.Logging$;
import akka.remote.RemoteActorRefProvider;
import akka.remote.RemoteTransportException;
import akka.remote.artery.ArteryTransport;
import akka.remote.artery.ArteryTransport$;
import akka.remote.artery.ArteryTransport$ShuttingDown$;
import akka.remote.artery.Decoder;
import akka.remote.artery.DuplicateHandshakeReq;
import akka.remote.artery.EnvelopeBuffer;
import akka.remote.artery.EnvelopeBufferPool;
import akka.remote.artery.FixedSizePartitionHub;
import akka.remote.artery.FlightRecorderEvents$;
import akka.remote.artery.InboundControlJunction;
import akka.remote.artery.InboundEnvelope;
import akka.remote.artery.OutboundContext;
import akka.remote.artery.aeron.AeronErrorLog;
import akka.remote.artery.aeron.AeronSink;
import akka.remote.artery.aeron.AeronSource;
import akka.remote.artery.aeron.ArteryAeronUdpTransport$;
import akka.remote.artery.aeron.TaskRunner;
import akka.remote.artery.aeron.TaskRunner$;
import akka.remote.artery.compress.NoInboundCompressions$;
import akka.stream.Graph;
import akka.stream.KillSwitches$;
import akka.stream.SharedKillSwitch;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.Keep$;
import akka.stream.scaladsl.Sink;
import akka.stream.scaladsl.Sink$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import io.aeron.Aeron;
import io.aeron.AvailableImageHandler;
import io.aeron.CommonContext;
import io.aeron.Image;
import io.aeron.UnavailableImageHandler;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.ThreadingMode;
import io.aeron.exceptions.ConductorServiceTimeoutException;
import io.aeron.exceptions.DriverTimeoutException;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.IoUtil;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.status.CountersReader;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.MapLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericCompanion;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.concurrent.Await$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005g!B\u0010!\u0001\u0011B\u0003\"C\u0017\u0001\u0005\u0003\u0005\u000b\u0011B\u00186\u0011%I\u0004A!A!\u0002\u0013Qd\bC\u0003A\u0001\u0011\u0005\u0011)\u0002\u0003G\u0001\u0001:\u0005B\u0002(\u0001A\u0003%q\nC\u0005\"\u0001\u0001\u0007\t\u0011)Q\u0005U\"I!\u000f\u0001a\u0001\u0002\u0003\u0006Ka\u001d\u0005\no\u0002\u0001\r\u0011!Q!\nMD\u0011\"\u001f\u0001A\u0002\u0003\u0005\u000b\u0015\u0002>\t\u000fy\u0004!\u0019!C\u0005\u007f\"A\u0011q\u0001\u0001!\u0002\u0013\t\t\u0001C\u0004\u0002\n\u0001!I!a\u0003\t\u000f\u0005\r\u0002\u0001\"\u0003\u0002&!9\u0011\u0011\u0007\u0001\u0005R\u0005M\u0002bBA\u001e\u0001\u0011%\u00111\u0007\u0005\b\u0003{\u0001A\u0011BA\u0006\u0011\u001d\ty\u0004\u0001C\u0005\u0003gAq!!\u0011\u0001\t\u0013\t\u0019\u0004C\u0004\u0002D\u0001!I!a\r\t\u000f\u0005\u0015\u0003\u0001\"\u0003\u00024!9\u0011q\t\u0001\u0005\n\u0005M\u0002bBA%\u0001\u0011E\u00131\n\u0005\b\u0003'\u0003A\u0011BAK\u0011\u001d\t\u0019\u000b\u0001C\u0005\u0003KCq!a*\u0001\t#\n\u0019\u0004C\u0004\u0002*\u0002!I!a\r\t\u000f\u0005-\u0006\u0001\"\u0003\u00024!9\u0011Q\u0016\u0001\u0005\n\u0005M\u0002bBAX\u0001\u0011%\u0011\u0011\u0017\u0005\b\u0003{\u0003A\u0011KA`\u0005]\t%\u000f^3ss\u0006+'o\u001c8VIB$&/\u00198ta>\u0014HO\u0003\u0002\"E\u0005)\u0011-\u001a:p]*\u00111\u0005J\u0001\u0007CJ$XM]=\u000b\u0005\u00152\u0013A\u0002:f[>$XMC\u0001(\u0003\u0011\t7n[1\u0014\u0005\u0001I\u0003C\u0001\u0016,\u001b\u0005\u0011\u0013B\u0001\u0017#\u0005=\t%\u000f^3ssR\u0013\u0018M\\:q_J$\u0018aB0tsN$X-\\\u0002\u0001!\t\u00014'D\u00012\u0015\t\u0011d%A\u0003bGR|'/\u0003\u00025c\t\u0019R\t\u001f;f]\u0012,G-Q2u_J\u001c\u0016p\u001d;f[&\u0011agN\u0001\u0007gf\u001cH/Z7\n\u0005a\"#a\u0004*f[>$X\r\u0016:b]N\u0004xN\u001d;\u0002\u0013}\u0003(o\u001c<jI\u0016\u0014\bCA\u001e=\u001b\u0005!\u0013BA\u001f%\u0005Y\u0011V-\\8uK\u0006\u001bGo\u001c:SK\u001a\u0004&o\u001c<jI\u0016\u0014\u0018BA 8\u0003!\u0001(o\u001c<jI\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0002C\t\u0016\u0003\"a\u0011\u0001\u000e\u0003\u0001BQ!L\u0002A\u0002=BQ!O\u0002A\u0002i\u0012\u0011\u0002T5gK\u000eK8\r\\3\u0011\u0005![eBA\"J\u0013\tQ\u0005%A\u0006BKJ|gnU8ve\u000e,\u0017B\u0001'N\u00059\tUM]8o\u0019&4WmY=dY\u0016T!A\u0013\u0011\u0002\u00175,G-[1Ee&4XM\u001d\t\u0004!f[V\"A)\u000b\u0005I\u001b\u0016AB1u_6L7M\u0003\u0002U+\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005Y;\u0016\u0001B;uS2T\u0011\u0001W\u0001\u0005U\u00064\u0018-\u0003\u0002[#\ny\u0011\t^8nS\u000e\u0014VMZ3sK:\u001cW\rE\u0002]?\u0006l\u0011!\u0018\u0006\u0002=\u0006)1oY1mC&\u0011\u0001-\u0018\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\tDW\"A2\u000b\u0005\u0011,\u0017A\u00023sSZ,'O\u0003\u0002\"M*\tq-\u0001\u0002j_&\u0011\u0011n\u0019\u0002\f\u001b\u0016$\u0017.\u0019#sSZ,'\u000f\u0005\u0002lY6\tQ-\u0003\u0002nK\n)\u0011)\u001a:p]\"\u0012aa\u001c\t\u00039BL!!]/\u0003\u0011Y|G.\u0019;jY\u0016\f\u0001#Y3s_:\u001cu.\u001e8uKJ$\u0016m]6\u0011\u0005A\"\u0018BA;2\u0005-\u0019\u0015M\\2fY2\f'\r\\3)\u0005\u001dy\u0017!E1fe>tWI\u001d:pe2{w\rV1tW\"\u0012\u0001b\\\u0001\u000eC\u0016\u0014xN\\#se>\u0014Hj\\4\u0011\u0005\r[\u0018B\u0001?!\u00055\tUM]8o\u000bJ\u0014xN\u001d'pO\"\u0012\u0011b\\\u0001\u000bi\u0006\u001c8NU;o]\u0016\u0014XCAA\u0001!\r\u0019\u00151A\u0005\u0004\u0003\u000b\u0001#A\u0003+bg.\u0014VO\u001c8fe\u0006YA/Y:l%Vtg.\u001a:!\u00039IgNY8v]\u0012\u001c\u0005.\u00198oK2,\"!!\u0004\u0011\t\u0005=\u0011Q\u0004\b\u0005\u0003#\tI\u0002E\u0002\u0002\u0014uk!!!\u0006\u000b\u0007\u0005]a&\u0001\u0004=e>|GOP\u0005\u0004\u00037i\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0002 \u0005\u0005\"AB*ue&twMC\u0002\u0002\u001cu\u000bqb\\;uE>,h\u000eZ\"iC:tW\r\u001c\u000b\u0005\u0003\u001b\t9\u0003C\u0004\u0002*5\u0001\r!a\u000b\u0002\u0003\u0005\u00042\u0001MA\u0017\u0013\r\ty#\r\u0002\b\u0003\u0012$'/Z:t\u00039\u0019H/\u0019:u)J\fgn\u001d9peR$\"!!\u000e\u0011\u0007q\u000b9$C\u0002\u0002:u\u0013A!\u00168ji\u0006\u00012\u000f^1si6+G-[1Ee&4XM]\u0001\tC\u0016\u0014xN\u001c#je\u0006y1\u000f^8q\u001b\u0016$\u0017.\u0019#sSZ,'/\u0001\u0006ti\u0006\u0014H/Q3s_:\fqC\u00197pG.,f\u000e^5m\u0007\"\fgN\\3m\u0003\u000e$\u0018N^3\u0002%M$\u0018M\u001d;BKJ|g.\u0012:s_JdunZ\u0001\u0015gR\f'\u000f^!fe>t7i\\;oi\u0016\u0014Hj\\4\u0002+=,HOY8v]\u0012$&/\u00198ta>\u0014HoU5oWRA\u0011QJA;\u0003\u007f\nI\t\u0005\u0005\u0002P\u0005e\u0013QLA2\u001b\t\t\tF\u0003\u0003\u0002T\u0005U\u0013\u0001C:dC2\fGm\u001d7\u000b\u0007\u0005]c%\u0001\u0004tiJ,\u0017-\\\u0005\u0005\u00037\n\tF\u0001\u0003TS:\\\u0007c\u0001\u0016\u0002`%\u0019\u0011\u0011\r\u0012\u0003\u001d\u0015sg/\u001a7pa\u0016\u0014UO\u001a4feB1\u0011QMA5\u0003[j!!a\u001a\u000b\u0005Qk\u0016\u0002BA6\u0003O\u0012aAR;ukJ,\u0007\u0003BA8\u0003cj\u0011AJ\u0005\u0004\u0003g2#\u0001\u0002#p]\u0016Dq!a\u001e\u0017\u0001\u0004\tI(A\bpkR\u0014w.\u001e8e\u0007>tG/\u001a=u!\rQ\u00131P\u0005\u0004\u0003{\u0012#aD(vi\n|WO\u001c3D_:$X\r\u001f;\t\u000f\u0005\u0005e\u00031\u0001\u0002\u0004\u0006A1\u000f\u001e:fC6LE\rE\u0002]\u0003\u000bK1!a\"^\u0005\rIe\u000e\u001e\u0005\b\u0003\u00173\u0002\u0019AAG\u0003)\u0011WO\u001a4feB{w\u000e\u001c\t\u0004U\u0005=\u0015bAAIE\t\u0011RI\u001c<fY>\u0004XMQ;gM\u0016\u0014\bk\\8m\u0003-\tWM]8o'>,(oY3\u0015\r\u0005]\u0015QTAP!\u001d\ty%!'\u0002^\u001dKA!a'\u0002R\t11k\\;sG\u0016Dq!!!\u0018\u0001\u0004\t\u0019\tC\u0004\u0002\"^\u0001\r!!$\u0002\tA|w\u000e\\\u0001\u001cC\u0016\u0014xN\\*pkJ\u001cWm\u00159j]:LgnZ*ue\u0006$XmZ=\u0016\u0005\u0005\r\u0015!\u0005:v]&s'm\\;oIN#(/Z1ng\u00069\"/\u001e8J]\n|WO\u001c3D_:$(o\u001c7TiJ,\u0017-\\\u0001!eVt\u0017J\u001c2pk:$wJ\u001d3j]\u0006\u0014\u00180T3tg\u0006<Wm]*ue\u0016\fW.A\u000fsk:LeNY8v]\u0012d\u0015M]4f\u001b\u0016\u001c8/Y4fgN#(/Z1n\u0003U)\b\u000fZ1uKN#(/Z1n\u001b\u0006$h+\u00197vKN$\u0002\"!\u000e\u00024\u0006U\u0016\u0011\u0018\u0005\b\u0003\u0003k\u0002\u0019AAB\u0011\u0019\t9,\ba\u0001\u000f\u0006!\u0012-\u001a:p]N{WO]2f\u0019&4WmY=dY\u0016Dq!a/\u001e\u0001\u0004\t\u0019'A\u0005d_6\u0004H.\u001a;fI\u0006\t2\u000f[;uI><h\u000e\u0016:b]N\u0004xN\u001d;\u0015\u0005\u0005\r\u0004")
public class ArteryAeronUdpTransport
extends ArteryTransport {
    private final AtomicReference<Option<MediaDriver>> mediaDriver = new AtomicReference<None$>(None$.MODULE$);
    public volatile Aeron akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeron;
    public volatile Cancellable akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeronCounterTask;
    public volatile Cancellable akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeronErrorLogTask;
    private volatile AeronErrorLog aeronErrorLog;
    private final TaskRunner akka$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner = new TaskRunner(this.system(), this.settings().Advanced().IdleCpuLevel());

    public TaskRunner akka$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner() {
        return this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner;
    }

    private String inboundChannel() {
        return new StringBuilder(20).append("aeron:udp?endpoint=").append(this.bindAddress().address().host().get()).append(":").append(this.bindAddress().address().port().get()).toString();
    }

    private String outboundChannel(Address a) {
        return new StringBuilder(20).append("aeron:udp?endpoint=").append(a.host().get()).append(":").append(a.port().get()).toString();
    }

    @Override
    public void startTransport() {
        this.startMediaDriver();
        this.startAeron();
        this.startAeronErrorLog();
        this.topLevelFlightRecorder().loFreq(FlightRecorderEvents$.MODULE$.Transport_AeronErrorLogStarted(), FlightRecorderEvents$.MODULE$.NoMetaData());
        if (this.settings().LogAeronCounters()) {
            this.startAeronCounterLog();
        }
        this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner().start();
        this.topLevelFlightRecorder().loFreq(FlightRecorderEvents$.MODULE$.Transport_TaskRunnerStarted(), FlightRecorderEvents$.MODULE$.NoMetaData());
    }

    private void startMediaDriver() {
        if (this.settings().Advanced().EmbeddedMediaDriver()) {
            MediaDriver.Context context;
            MediaDriver.Context driverContext = new MediaDriver.Context();
            if (new StringOps(Predef$.MODULE$.augmentString(this.settings().Advanced().AeronDirectoryName())).nonEmpty()) {
                context = driverContext.aeronDirectoryName(this.settings().Advanced().AeronDirectoryName());
            } else {
                String uniquePart = UUID.randomUUID().toString();
                String randomName = new StringBuilder(2).append(CommonContext.AERON_DIR_PROP_DEFAULT).append("-").append(this.system().name()).append("-").append(uniquePart).toString();
                context = driverContext.aeronDirectoryName(randomName);
            }
            driverContext.clientLivenessTimeoutNs(this.settings().Advanced().ClientLivenessTimeout().toNanos());
            driverContext.imageLivenessTimeoutNs(this.settings().Advanced().ImageLivenessTimeout().toNanos());
            driverContext.driverTimeoutMs(this.settings().Advanced().DriverTimeout().toMillis());
            int idleCpuLevel = this.settings().Advanced().IdleCpuLevel();
            MediaDriver.Context context2 = idleCpuLevel == 10 ? driverContext.threadingMode(ThreadingMode.DEDICATED).conductorIdleStrategy((IdleStrategy)new BackoffIdleStrategy(1L, 1L, 1L, 1L)).receiverIdleStrategy(TaskRunner$.MODULE$.createIdleStrategy(idleCpuLevel)).senderIdleStrategy(TaskRunner$.MODULE$.createIdleStrategy(idleCpuLevel)) : (idleCpuLevel == 1 ? driverContext.threadingMode(ThreadingMode.SHARED).sharedIdleStrategy(TaskRunner$.MODULE$.createIdleStrategy(idleCpuLevel)) : (idleCpuLevel <= 7 ? driverContext.threadingMode(ThreadingMode.SHARED_NETWORK).sharedNetworkIdleStrategy(TaskRunner$.MODULE$.createIdleStrategy(idleCpuLevel)) : driverContext.threadingMode(ThreadingMode.DEDICATED).receiverIdleStrategy(TaskRunner$.MODULE$.createIdleStrategy(idleCpuLevel)).senderIdleStrategy(TaskRunner$.MODULE$.createIdleStrategy(idleCpuLevel))));
            MediaDriver driver = MediaDriver.launchEmbedded((MediaDriver.Context)driverContext);
            this.log().info("Started embedded media driver in directory [{}]", (Object)driver.aeronDirectoryName());
            this.topLevelFlightRecorder().loFreq(FlightRecorderEvents$.MODULE$.Transport_MediaDriverStarted(), driver.aeronDirectoryName());
            if (!this.mediaDriver.compareAndSet((Option<MediaDriver>)None$.MODULE$, (Option<MediaDriver>)new Some((Object)driver))) {
                throw new IllegalStateException("media driver started more than once");
            }
        }
    }

    private String aeronDir() {
        String string;
        Option<MediaDriver> option = this.mediaDriver.get();
        if (option instanceof Some) {
            Some some = (Some)option;
            MediaDriver driver = (MediaDriver)some.value();
            string = driver.aeronDirectoryName();
        } else if (None$.MODULE$.equals(option)) {
            string = this.settings().Advanced().AeronDirectoryName();
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    private void stopMediaDriver() {
        Option<MediaDriver> maybeDriver = this.mediaDriver.getAndSet((Option<MediaDriver>)None$.MODULE$);
        maybeDriver.foreach((Function1 & Serializable & scala.Serializable)driver -> {
            ArteryAeronUdpTransport.$anonfun$stopMediaDriver$1(this, driver);
            return BoxedUnit.UNIT;
        });
    }

    private void startAeron() {
        Aeron.Context ctx = new Aeron.Context();
        ctx.driverTimeoutMs(this.settings().Advanced().DriverTimeout().toMillis());
        ctx.availableImageHandler(new AvailableImageHandler(this){
            private final /* synthetic */ ArteryAeronUdpTransport $outer;

            public void onAvailableImage(Image img) {
                block0: {
                    if (!this.$outer.log().isDebugEnabled()) break block0;
                    this.$outer.log().debug(new StringBuilder(31).append("onAvailableImage from ").append(img.sourceIdentity()).append(" session ").append(img.sessionId()).toString());
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        ctx.unavailableImageHandler(new UnavailableImageHandler(this){
            private final /* synthetic */ ArteryAeronUdpTransport $outer;

            public void onUnavailableImage(Image img) {
                if (this.$outer.log().isDebugEnabled()) {
                    this.$outer.log().debug(new StringBuilder(33).append("onUnavailableImage from ").append(img.sourceIdentity()).append(" session ").append(img.sessionId()).toString());
                }
                ((MapLike)this.$outer.streamMatValues().get()).valuesIterator().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    $anon$2.$anonfun$onUnavailableImage$1(img, x0$1);
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ void $anonfun$onUnavailableImage$1(Image img$1, ArteryTransport.InboundStreamMatValues x0$1) {
                ArteryTransport.InboundStreamMatValues inboundStreamMatValues = x0$1;
                if (inboundStreamMatValues == null) {
                    throw new MatchError((Object)inboundStreamMatValues);
                }
                AeronSource.AeronLifecycle resourceLife = (AeronSource.AeronLifecycle)inboundStreamMatValues.lifeCycle();
                resourceLife.onUnavailableImage(img$1.sessionId());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onUnavailableImage$1$adapted(io.aeron.Image akka.remote.artery.ArteryTransport$InboundStreamMatValues )}, serializedLambda);
            }
        });
        ctx.errorHandler(new ErrorHandler(this){
            private final AtomicBoolean fatalErrorOccured;
            private final /* synthetic */ ArteryAeronUdpTransport $outer;

            private AtomicBoolean fatalErrorOccured() {
                return this.fatalErrorOccured;
            }

            public void onError(Throwable cause) {
                Throwable throwable = cause;
                if (throwable instanceof ConductorServiceTimeoutException) {
                    ConductorServiceTimeoutException conductorServiceTimeoutException = (ConductorServiceTimeoutException)throwable;
                    this.handleFatalError((Throwable)conductorServiceTimeoutException);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (throwable instanceof DriverTimeoutException) {
                    DriverTimeoutException driverTimeoutException = (DriverTimeoutException)throwable;
                    this.handleFatalError(driverTimeoutException);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (throwable instanceof ArteryTransport.AeronTerminated) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.$outer.log().error(cause, new StringBuilder(13).append("Aeron error, ").append(cause).toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }

            private void handleFatalError(Throwable cause) {
                if (this.fatalErrorOccured().compareAndSet(false, true)) {
                    if (!this.$outer.isShutdown()) {
                        this.$outer.log().error(cause, "Fatal Aeron error {}. Have to terminate ActorSystem because it lost contact with the {} Aeron media driver. Possible configuration properties to mitigate the problem are 'client-liveness-timeout' or 'driver-timeout'. {}", (Object)Logging$.MODULE$.simpleName((Object)cause), (Object)(this.$outer.settings().Advanced().EmbeddedMediaDriver() ? "embedded" : "external"), (Object)cause);
                        this.$outer.akka$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner().stop();
                        this.$outer.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeronErrorLogTask.cancel();
                        Object object = this.$outer.settings().LogAeronCounters() ? BoxesRunTime.boxToBoolean((boolean)this.$outer.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeronCounterTask.cancel()) : BoxedUnit.UNIT;
                        this.$outer.system().terminate();
                        throw new ArteryTransport.AeronTerminated(cause);
                    }
                } else {
                    throw new ArteryTransport.AeronTerminated(cause);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fatalErrorOccured = new AtomicBoolean();
            }
        });
        ctx.aeronDirectoryName(this.aeronDir());
        this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeron = Aeron.connect((Aeron.Context)ctx);
    }

    private void blockUntilChannelActive() {
        AeronSource.AeronLifecycle aeronLifecyle = (AeronSource.AeronLifecycle)((ArteryTransport.InboundStreamMatValues)((MapLike)this.streamMatValues().get()).apply((Object)BoxesRunTime.boxToInteger((int)ArteryTransport$.MODULE$.ControlStreamId()))).lifeCycle();
        int waitInterval = 200;
        long retries = package$.MODULE$.max(1L, this.settings().Bind().BindTimeout().toMillis() / (long)waitInterval);
        this.retry$1(retries, aeronLifecyle, waitInterval);
    }

    private void startAeronErrorLog() {
        this.aeronErrorLog = new AeronErrorLog(new File(this.aeronDir(), "cnc.dat"), this.log());
        AtomicLong lastTimestamp = new AtomicLong(0L);
        this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeronErrorLogTask = this.system().scheduler().schedule(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(3)).seconds(), new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(5)).seconds(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if (this.isShutdown()) break block0;
                long newLastTimestamp = $this.aeronErrorLog.logErrors(this.log(), lastTimestamp.get());
                lastTimestamp.set(newLastTimestamp + 1L);
            }
        }, (ExecutionContext)this.system().dispatcher());
    }

    private void startAeronCounterLog() {
        this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeronCounterTask = this.system().scheduler().schedule(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(5)).seconds(), new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(5)).seconds(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if (this.isShutdown() || !this.log().isDebugEnabled()) break block0;
                $this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeron.countersReader().forEach(new CountersReader.MetaData(this){
                    private final /* synthetic */ ArteryAeronUdpTransport $outer;

                    public void accept(int counterId, int typeId, DirectBuffer keyBuffer, String label) {
                        long value = this.$outer.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeron.countersReader().getCounterValue(counterId);
                        this.$outer.log().debug("Aeron Counter {}: {} {}]", (Object)BoxesRunTime.boxToInteger((int)counterId), (Object)BoxesRunTime.boxToLong((long)value), (Object)label);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
        }, (ExecutionContext)this.system().dispatcher());
    }

    @Override
    public Sink<EnvelopeBuffer, Future<Done>> outboundTransportSink(OutboundContext outboundContext, int streamId, EnvelopeBufferPool bufferPool) {
        FiniteDuration giveUpAfter = streamId == ArteryTransport$.MODULE$.ControlStreamId() ? this.settings().Advanced().GiveUpSystemMessageAfter() : this.settings().Advanced().GiveUpMessageAfter();
        return Sink$.MODULE$.fromGraph((Graph)new AeronSink(this.outboundChannel(outboundContext.remoteAddress()), streamId, this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeron, this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner(), bufferPool, (Duration)giveUpAfter, this.createFlightRecorderEventSink(this.createFlightRecorderEventSink$default$1())));
    }

    private Source<EnvelopeBuffer, AeronSource.AeronLifecycle> aeronSource(int streamId, EnvelopeBufferPool pool) {
        return Source$.MODULE$.fromGraph((Graph)new AeronSource(this.inboundChannel(), streamId, this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeron, this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner(), pool, this.createFlightRecorderEventSink(this.createFlightRecorderEventSink$default$1()), this.aeronSourceSpinningStrategy()));
    }

    private int aeronSourceSpinningStrategy() {
        return this.settings().Advanced().InboundLanes() > 1 || this.settings().Advanced().IdleCpuLevel() < 5 ? 0 : 50 * this.settings().Advanced().IdleCpuLevel() - 240;
    }

    @Override
    public void runInboundStreams() {
        this.runInboundControlStream();
        this.runInboundOrdinaryMessagesStream();
        if (this.largeMessageChannelEnabled()) {
            this.runInboundLargeMessagesStream();
        }
        this.blockUntilChannelActive();
    }

    private void runInboundControlStream() {
        if (this.isShutdown()) {
            throw ArteryTransport$ShuttingDown$.MODULE$;
        }
        Tuple3 tuple3 = (Tuple3)this.aeronSource(ArteryTransport$.MODULE$.ControlStreamId(), this.envelopeBufferPool()).via(this.inboundFlow(this.settings(), NoInboundCompressions$.MODULE$)).toMat(this.inboundControlSink(), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2;
            AeronSource.AeronLifecycle a;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$1, x1$1);
                    if (tuple22 == null) break block2;
                    a = (AeronSource.AeronLifecycle)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            InboundControlJunction.ControlMessageSubject c = (InboundControlJunction.ControlMessageSubject)tuple2._1();
            Future d = (Future)tuple2._2();
            Tuple3 tuple3 = new Tuple3((Object)a, (Object)c, (Object)d);
            return tuple3;
        }).run(this.controlMaterializer());
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        AeronSource.AeronLifecycle resourceLife = (AeronSource.AeronLifecycle)tuple3._1();
        InboundControlJunction.ControlMessageSubject ctrl = (InboundControlJunction.ControlMessageSubject)tuple3._2();
        Future completed = (Future)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)resourceLife, (Object)ctrl, (Object)completed);
        Tuple3 tuple33 = tuple32;
        AeronSource.AeronLifecycle resourceLife2 = (AeronSource.AeronLifecycle)tuple33._1();
        InboundControlJunction.ControlMessageSubject ctrl2 = (InboundControlJunction.ControlMessageSubject)tuple33._2();
        Future completed2 = (Future)tuple33._3();
        this.attachControlMessageObserver(ctrl2);
        this.updateStreamMatValues(ArteryTransport$.MODULE$.ControlStreamId(), resourceLife2, (Future<Done>)completed2);
        this.attachInboundStreamRestart("Inbound control stream", (Future<Done>)completed2, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.runInboundControlStream());
    }

    private void runInboundOrdinaryMessagesStream() {
        Tuple3 tuple3;
        Tuple3 tuple32;
        if (this.isShutdown()) {
            throw ArteryTransport$ShuttingDown$.MODULE$;
        }
        if (this.inboundLanes() == 1) {
            tuple32 = (Tuple3)this.aeronSource(ArteryTransport$.MODULE$.OrdinaryStreamId(), this.envelopeBufferPool()).viaMat(this.inboundFlow(this.settings(), this._inboundCompressions()), Keep$.MODULE$.both()).toMat(this.inboundSink(this.envelopeBufferPool()), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                Future c;
                Tuple2 tuple2;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = new Tuple2(x0$1, x1$1);
                        if (tuple22 == null) break block2;
                        tuple2 = (Tuple2)tuple22._1();
                        c = (Future)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                AeronSource.AeronLifecycle a = (AeronSource.AeronLifecycle)tuple2._1();
                Decoder.InboundCompressionAccess b = (Decoder.InboundCompressionAccess)tuple2._2();
                Tuple3 tuple3 = new Tuple3((Object)a, (Object)b, (Object)c);
                return tuple3;
            }).run(this.materializer());
        } else {
            SharedKillSwitch laneKillSwitch = KillSwitches$.MODULE$.shared("laneKillSwitch");
            Source laneSource = this.aeronSource(ArteryTransport$.MODULE$.OrdinaryStreamId(), this.envelopeBufferPool()).via(laneKillSwitch.flow()).viaMat(this.inboundFlow(this.settings(), this._inboundCompressions()), Keep$.MODULE$.both()).via((Graph)Flow$.MODULE$.fromGraph((Graph)new DuplicateHandshakeReq(this.inboundLanes(), this, this.system(), this.envelopeBufferPool())));
            Tuple3 tuple33 = (Tuple3)laneSource.toMat((Graph)Sink$.MODULE$.fromGraph(new FixedSizePartitionHub<InboundEnvelope>(this.inboundLanePartitioner(), this.inboundLanes(), this.settings().Advanced().InboundHubBufferSize())), (Function2 & Serializable & scala.Serializable)(x0$2, x1$2) -> {
                Source c;
                Tuple2 tuple2;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = new Tuple2(x0$2, x1$2);
                        if (tuple22 == null) break block2;
                        tuple2 = (Tuple2)tuple22._1();
                        c = (Source)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                AeronSource.AeronLifecycle a = (AeronSource.AeronLifecycle)tuple2._1();
                Decoder.InboundCompressionAccess b = (Decoder.InboundCompressionAccess)tuple2._2();
                Tuple3 tuple3 = new Tuple3((Object)a, (Object)b, (Object)c);
                return tuple3;
            }).run(this.materializer());
            if (tuple33 == null) {
                throw new MatchError((Object)tuple33);
            }
            AeronSource.AeronLifecycle resourceLife = (AeronSource.AeronLifecycle)tuple33._1();
            Decoder.InboundCompressionAccess compressionAccess = (Decoder.InboundCompressionAccess)tuple33._2();
            Source laneHub = (Source)tuple33._3();
            Tuple3 tuple34 = new Tuple3((Object)resourceLife, (Object)compressionAccess, (Object)laneHub);
            Tuple3 tuple35 = tuple34;
            AeronSource.AeronLifecycle resourceLife2 = (AeronSource.AeronLifecycle)tuple35._1();
            Decoder.InboundCompressionAccess compressionAccess2 = (Decoder.InboundCompressionAccess)tuple35._2();
            Source laneHub2 = (Source)tuple35._3();
            Sink<InboundEnvelope, Future<Done>> lane = this.inboundSink(this.envelopeBufferPool());
            Vector completedValues = (Vector)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.inboundLanes()).iterator().map((Function1 & Serializable & scala.Serializable)x$3 -> ArteryAeronUdpTransport.$anonfun$runInboundOrdinaryMessagesStream$3(this, laneHub2, lane, BoxesRunTime.unboxToInt((Object)x$3))).to(akka.util.ccompat.package$.MODULE$.genericCompanionToCBF((GenericCompanion)Vector$.MODULE$));
            Future$.MODULE$.firstCompletedOf((TraversableOnce)completedValues, (ExecutionContext)this.system().dispatcher()).failed().foreach((Function1 & Serializable & scala.Serializable)reason -> {
                laneKillSwitch.abort(reason);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)this.system().dispatcher());
            Future allCompleted = Future$.MODULE$.sequence((TraversableOnce)completedValues, Vector$.MODULE$.canBuildFrom(), (ExecutionContext)this.system().dispatcher()).map((Function1 & Serializable & scala.Serializable)x$4 -> Done$.MODULE$, (ExecutionContext)this.system().dispatcher());
            tuple32 = tuple3 = new Tuple3((Object)resourceLife2, (Object)compressionAccess2, (Object)allCompleted);
        }
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        AeronSource.AeronLifecycle resourceLife = (AeronSource.AeronLifecycle)tuple3._1();
        Decoder.InboundCompressionAccess inboundCompressionAccess = (Decoder.InboundCompressionAccess)tuple3._2();
        Future completed = (Future)tuple3._3();
        Tuple3 tuple36 = new Tuple3((Object)resourceLife, (Object)inboundCompressionAccess, (Object)completed);
        Tuple3 tuple37 = tuple36;
        AeronSource.AeronLifecycle resourceLife3 = (AeronSource.AeronLifecycle)tuple37._1();
        Decoder.InboundCompressionAccess inboundCompressionAccess2 = (Decoder.InboundCompressionAccess)tuple37._2();
        Future completed2 = (Future)tuple37._3();
        this.setInboundCompressionAccess(inboundCompressionAccess2);
        this.updateStreamMatValues(ArteryTransport$.MODULE$.OrdinaryStreamId(), resourceLife3, (Future<Done>)completed2);
        this.attachInboundStreamRestart("Inbound message stream", (Future<Done>)completed2, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.runInboundOrdinaryMessagesStream());
    }

    private void runInboundLargeMessagesStream() {
        if (this.isShutdown()) {
            throw ArteryTransport$ShuttingDown$.MODULE$;
        }
        Tuple2 tuple2 = (Tuple2)this.aeronSource(ArteryTransport$.MODULE$.LargeStreamId(), this.largeEnvelopeBufferPool()).via(this.inboundLargeFlow(this.settings())).toMat(this.inboundSink(this.largeEnvelopeBufferPool()), Keep$.MODULE$.both()).run(this.materializer());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        AeronSource.AeronLifecycle resourceLife = (AeronSource.AeronLifecycle)tuple2._1();
        Future completed = (Future)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)resourceLife, (Object)completed);
        Tuple2 tuple23 = tuple22;
        AeronSource.AeronLifecycle resourceLife2 = (AeronSource.AeronLifecycle)tuple23._1();
        Future completed2 = (Future)tuple23._2();
        this.updateStreamMatValues(ArteryTransport$.MODULE$.LargeStreamId(), resourceLife2, (Future<Done>)completed2);
        this.attachInboundStreamRestart("Inbound large message stream", (Future<Done>)completed2, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.runInboundLargeMessagesStream());
    }

    private void updateStreamMatValues(int streamId, AeronSource.AeronLifecycle aeronSourceLifecycle, Future<Done> completed) {
        ExecutionContextExecutor ec = this.materializer().executionContext();
        this.updateStreamMatValues(streamId, new ArteryTransport.InboundStreamMatValues<Object>(aeronSourceLifecycle, (Future<Done>)completed.recover((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Done$ done$ = Done$.MODULE$;
                return (B1)done$;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
        }, (ExecutionContext)ec)));
    }

    @Override
    public Future<Done> shutdownTransport() {
        return this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner().stop().map((Function1 & Serializable & scala.Serializable)x$7 -> {
            block3: {
                this.topLevelFlightRecorder().loFreq(FlightRecorderEvents$.MODULE$.Transport_Stopped(), FlightRecorderEvents$.MODULE$.NoMetaData());
                if ($this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeronErrorLogTask != null) {
                    $this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeronErrorLogTask.cancel();
                    this.topLevelFlightRecorder().loFreq(FlightRecorderEvents$.MODULE$.Transport_AeronErrorLogTaskStopped(), FlightRecorderEvents$.MODULE$.NoMetaData());
                }
                if ($this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeron != null) {
                    $this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeron.close();
                }
                if ($this.aeronErrorLog != null) {
                    $this.aeronErrorLog.close();
                }
                if (!$this.mediaDriver.get().isDefined()) break block3;
                this.stopMediaDriver();
            }
            return Done$.MODULE$;
        }, (ExecutionContext)this.system().dispatcher());
    }

    public static final /* synthetic */ void $anonfun$stopMediaDriver$1(ArteryAeronUdpTransport $this, MediaDriver driver) {
        try {
            driver.close();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                $this.log().warning("Couldn't close Aeron embedded media driver due to [{}]", (Object)e);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
        try {
            if ($this.settings().Advanced().DeleteAeronDirectory()) {
                IoUtil.delete((File)new File(driver.aeronDirectoryName()), (boolean)false);
                $this.topLevelFlightRecorder().loFreq(FlightRecorderEvents$.MODULE$.Transport_MediaFileDeleted(), FlightRecorderEvents$.MODULE$.NoMetaData());
            }
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable3);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                $this.log().warning("Couldn't delete Aeron embedded media driver files in [{}] due to [{}]", (Object)driver.aeronDirectoryName(), (Object)e);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    private final void retry$1(long retries, AeronSource.AeronLifecycle aeronLifecyle$1, int waitInterval$1) {
        block2: {
            while (true) {
                long status;
                if ((status = BoxesRunTime.unboxToLong((Object)Await$.MODULE$.result(aeronLifecyle$1.channelEndpointStatus(), (Duration)this.settings().Bind().BindTimeout()))) == 1L) break block2;
                if (status == -1L) {
                    this.aeronErrorLog.logErrors(this.log(), 0L);
                    this.stopMediaDriver();
                    throw new RemoteTransportException("Inbound Aeron channel is in errored state. See Aeron logs for details.");
                }
                if (status != 0L || retries <= 0L) break;
                Thread.sleep(waitInterval$1);
                --retries;
            }
            this.aeronErrorLog.logErrors(this.log(), 0L);
            this.stopMediaDriver();
            throw new RemoteTransportException("Timed out waiting for Aeron transport to bind. See Aeoron logs.");
        }
        this.log().debug("Inbound channel is now active");
    }

    public static final /* synthetic */ Future $anonfun$runInboundOrdinaryMessagesStream$3(ArteryAeronUdpTransport $this, Source laneHub$1, Sink lane$1, int x$3) {
        return (Future)laneHub$1.toMat((Graph)lane$1, Keep$.MODULE$.right()).run($this.materializer());
    }

    public ArteryAeronUdpTransport(ExtendedActorSystem _system, RemoteActorRefProvider _provider) {
        super(_system, _provider);
    }
}

