/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.checksum.ChecksumAlgorithmProvider;
import com.xebialabs.deployit.checksum.DefaultChecksumAlgorithmProviderFactory;
import com.xebialabs.overthere.util.OverthereUtils;
import java.security.MessageDigest;
import java.util.concurrent.atomic.AtomicReference;
import javax.crypto.SecretKey;
import org.apache.commons.codec.binary.Hex;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;
import org.bouncycastle.crypto.paddings.PKCS7Padding;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class SecretKeyHolder {
    private static final AtomicReference<SecretKeyHolder> instance = new AtomicReference();
    private final SecretKey secretKey;

    public static void init(SecretKey key) {
        instance.set(new SecretKeyHolder(key));
    }

    public static void reset() {
        instance.set(null);
    }

    public static SecretKeyHolder get() {
        SecretKeyHolder encryptionKeyHolder = instance.get();
        OverthereUtils.checkState((encryptionKeyHolder != null ? 1 : 0) != 0, (String)"EncryptionKeyHolder not yet set, please construct one.", (Object[])new Object[0]);
        return encryptionKeyHolder;
    }

    public SecretKeyHolder(SecretKey secretKey) {
        Checks.checkNotNull((Object)secretKey, (String)"secretKey cannot be null");
        this.secretKey = secretKey;
    }

    public String getKeyFingerprint() {
        ChecksumAlgorithmProvider provider = DefaultChecksumAlgorithmProviderFactory.defaultComparisonAlgorithm();
        return this.getKeyFingerprintWithProvider(provider);
    }

    public String getKeyFingerprint(String algorithm) {
        ChecksumAlgorithmProvider provider = DefaultChecksumAlgorithmProviderFactory.create(algorithm);
        return this.getKeyFingerprintWithProvider(provider);
    }

    private String getKeyFingerprintWithProvider(ChecksumAlgorithmProvider provider) {
        MessageDigest digest = provider.getMessageDigest();
        byte[] bytes = digest.digest(this.secretKey.getEncoded());
        return Hex.encodeHexString((byte[])bytes);
    }

    public BufferedBlockCipher getEncryption() {
        return this.getCipher(true);
    }

    public BufferedBlockCipher getDecryption() {
        return this.getCipher(false);
    }

    private BufferedBlockCipher getCipher(boolean forEncryption) {
        PaddedBufferedBlockCipher aes = new PaddedBufferedBlockCipher((BlockCipher)new AESEngine());
        aes.reset();
        aes.init(forEncryption, (CipherParameters)new KeyParameter(this.secretKey.getEncoded()));
        return aes;
    }

    public BufferedBlockCipher getEncryption(byte[] iv) {
        return this.getCipher(true, iv);
    }

    public BufferedBlockCipher getDecryption(byte[] iv) {
        return this.getCipher(false, iv);
    }

    private BufferedBlockCipher getCipher(boolean forEncryption, byte[] iv) {
        PaddedBufferedBlockCipher aes = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new AESEngine()), (BlockCipherPadding)new PKCS7Padding());
        ParametersWithIV params = new ParametersWithIV((CipherParameters)new KeyParameter(this.secretKey.getEncoded()), iv);
        aes.reset();
        aes.init(forEncryption, (CipherParameters)params);
        return aes;
    }
}

