/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.pattern.AskableActorRef$;
import akka.util.Timeout;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.core.service.PaginationService;
import com.xebialabs.deployit.engine.api.SatelliteService;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.engine.api.dto.SatelliteInfo;
import com.xebialabs.deployit.engine.tasker.satellite.ActorLocator;
import com.xebialabs.deployit.engine.tasker.satellite.ActorLocator$;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.satellite.ExtensionsDelta$;
import com.xebialabs.deployit.plugin.satellite.InstalledExtensionsDelta;
import com.xebialabs.deployit.plugin.satellite.SatelliteInfoChecker;
import com.xebialabs.deployit.plugin.satellite.SatelliteInfoChecker$;
import com.xebialabs.deployit.plugin.satellite.extension.ExtensionsLocator;
import com.xebialabs.deployit.plugin.satellite.extension.FileSystemExtensionsLocator$;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SatelliteRepository;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.tasksystem.TaskActorSystem$;
import com.xebialabs.satellite.protocol.Paths$;
import com.xebialabs.xlplatform.satellite.Satellite;
import com.xebialabs.xlplatform.settings.CommonSettings;
import com.xebialabs.xlplatform.settings.CommonSettings$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.List;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.spi.HttpResponse;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@Service
@ScalaSignature(bytes="\u0006\u0001\u0005}f\u0001\u0002\t\u0012\u0001yA\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005y!A!\t\u0001B\u0001B\u0003%1\tC\u0003G\u0001\u0011\u0005q\tC\u0004]\u0001\t\u0007I\u0011A/\t\r!\u0004\u0001\u0015!\u0003_\u0011\u0015)\b\u0001\"\u0001w\u0011%\t9\u0002\u0001b\u0001\n\u0007\tI\u0002\u0003\u0005\u0002\u001c\u0001\u0001\u000b\u0011BA\u0004\u0011%\ti\u0002\u0001b\u0001\n\u0007\ty\u0002\u0003\u0005\u0002*\u0001\u0001\u000b\u0011BA\u0011\u0011\u001d\tY\u0003\u0001C\u0001\u0003[Aq!!\u0016\u0001\t\u0013\t9\u0006C\u0004\u0002j\u0001!\t%a\u001b\t\u000f\u0005u\u0005\u0001\"\u0011\u0002 \n!2+\u0019;fY2LG/Z*feZL7-Z%na2T!AE\n\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u0015+\u0005!!/Z:u\u0015\t1r#\u0001\u0003d_J,'B\u0001\r\u001a\u0003!!W\r\u001d7ps&$(B\u0001\u000e\u001c\u0003%AXMY5bY\u0006\u00147OC\u0001\u001d\u0003\r\u0019w.\\\u0002\u0001'\u0011\u0001q$\n\u0017\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0005\t\u001a\u0012aB:fGV\u0014X\rZ\u0005\u0003I\u0005\u0012q#\u00112tiJ\f7\r^*fGV\u0014X\r\u001a*fg>,(oY3\u0011\u0005\u0019RS\"A\u0014\u000b\u0005IA#BA\u0015\u0018\u0003\u0019)gnZ5oK&\u00111f\n\u0002\u0011'\u0006$X\r\u001c7ji\u0016\u001cVM\u001d<jG\u0016\u0004\"!\f\u001a\u000e\u00039R!a\f\u0019\u0002\u000bMdg\r\u000e6\u000b\u0003E\n\u0001b\u001a:jujdW\rZ\u0005\u0003g9\u0012q\u0001T8hO&tw-A\ntCR,G\u000e\\5uKJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u00027s5\tqG\u0003\u00029/\u0005Q!/\u001a9pg&$xN]=\n\u0005i:$aE*bi\u0016dG.\u001b;f%\u0016\u0004xn]5u_JL\u0018!\u00059bO&t\u0017\r^5p]N+'O^5dKB\u0011Q\bQ\u0007\u0002})\u0011q(F\u0001\bg\u0016\u0014h/[2f\u0013\t\teHA\tQC\u001eLg.\u0019;j_:\u001cVM\u001d<jG\u0016\f\u0011C]3q_NLGo\u001c:z'\u0016\u0014h/[2f!\t1D)\u0003\u0002Fo\t\t\"+\u001a9pg&$xN]=TKJ4\u0018nY3\u0002\rqJg.\u001b;?)\u0011A%j\u0013'\u0011\u0005%\u0003Q\"A\t\t\u000bQ\"\u0001\u0019A\u001b\t\u000bm\"\u0001\u0019\u0001\u001f\t\u000b\t#\u0001\u0019A\")\u0005\u0011q\u0005CA([\u001b\u0005\u0001&BA)S\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003'R\u000bqAZ1di>\u0014\u0018P\u0003\u0002V-\u0006)!-Z1og*\u0011q\u000bW\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t\u0011,A\u0002pe\u001eL!a\u0017)\u0003\u0013\u0005+Ho\\<je\u0016$\u0017\u0001\u0003:fgB|gn]3\u0016\u0003y\u0003\"a\u00184\u000e\u0003\u0001T!!\u00192\u0002\u0007M\u0004\u0018N\u0003\u0002dI\u0006A!/Z:uK\u0006\u001c\u0018P\u0003\u0002f1\u0006)!NY8tg&\u0011q\r\u0019\u0002\r\u0011R$\bOU3ta>t7/Z\u0001\ne\u0016\u001c\bo\u001c8tK\u0002B#A\u00026\u0011\u0005-\u001cX\"\u00017\u000b\u0005Yi'B\u00018p\u0003\t\u00118O\u0003\u0002qc\u0006\u0011qo\u001d\u0006\u0002e\u0006)!.\u0019<bq&\u0011A\u000f\u001c\u0002\b\u0007>tG/\u001a=u\u0003I!WMZ1vYR\u0004\u0016N\\4US6,w.\u001e;\u0015\u0007]\f\u0019\u0001\u0005\u0002y\u007f6\t\u0011P\u0003\u0002{w\u0006AA-\u001e:bi&|gN\u0003\u0002}{\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0003y\fQa]2bY\u0006L1!!\u0001z\u000591\u0015N\\5uK\u0012+(/\u0019;j_:Dq!!\u0002\b\u0001\u0004\t9!A\buCN\\\u0017i\u0019;peNK8\u000f^3n!\u0011\tI!a\u0005\u000e\u0005\u0005-!\u0002BA\u0007\u0003\u001f\tQ!Y2u_JT!!!\u0005\u0002\t\u0005\\7.Y\u0005\u0005\u0003+\tYAA\u0006BGR|'oU=ti\u0016l\u0017aC1di>\u00148+_:uK6,\"!a\u0002\u0002\u0019\u0005\u001cGo\u001c:TsN$X-\u001c\u0011\u0002\u0015\u0011L7\u000f]1uG\",'/\u0006\u0002\u0002\"A!\u00111EA\u0013\u001b\u0005Y\u0018bAA\u0014w\nAR\t_3dkRLwN\\\"p]R,\u0007\u0010^#yK\u000e,Ho\u001c:\u0002\u0017\u0011L7\u000f]1uG\",'\u000fI\u0001\bO\u0016$\u0018J\u001c4p)\u0011\ty#a\u000f\u0011\t\u0005E\u0012qG\u0007\u0003\u0003gQ1!!\u000e(\u0003\r!Go\\\u0005\u0005\u0003s\t\u0019DA\u0007TCR,G\u000e\\5uK&sgm\u001c\u0005\b\u0003{a\u0001\u0019AA \u0003\u0011\u0019\u0017.\u00133\u0011\t\u0005\u0005\u0013q\n\b\u0005\u0003\u0007\nY\u0005E\u0002\u0002Ful!!a\u0012\u000b\u0007\u0005%S$\u0001\u0004=e>|GOP\u0005\u0004\u0003\u001bj\u0018A\u0002)sK\u0012,g-\u0003\u0003\u0002R\u0005M#AB*ue&twMC\u0002\u0002Nu\f\u0001#\u0019:f!2,x-\u001b8t'ft7-\u001a3\u0015\t\u0005e\u0013q\r\t\u0007\u00037\ni&!\u0019\u000e\u0003uL1!a\u0018~\u0005\u0019y\u0005\u000f^5p]B!\u00111LA2\u0013\r\t)' \u0002\b\u0005>|G.Z1o\u0011\u001d\ti$\u0004a\u0001\u0003\u007f\t\u0011\u0002\\5ti\"{7\u000f^:\u0015\u0015\u00055\u00141QAC\u0003\u0013\u000b\u0019\n\u0005\u0004\u0002p\u0005e\u0014QP\u0007\u0003\u0003cRA!a\u001d\u0002v\u0005!Q\u000f^5m\u0015\t\t9(\u0001\u0003kCZ\f\u0017\u0002BA>\u0003c\u0012A\u0001T5tiB!\u0011\u0011GA@\u0013\u0011\t\t)a\r\u0003'\r{gNZ5hkJ\fG/[8o\u0013R,W.\u00133\t\u000f\u0005ub\u00021\u0001\u0002@!9\u0011q\u0011\bA\u0002\u0005}\u0012\u0001\u00028b[\u0016Dq!a#\u000f\u0001\u0004\ti)\u0001\u0004qC\u001eLgn\u001a\t\u0005\u0003c\ty)\u0003\u0003\u0002\u0012\u0006M\"A\u0002)bO&tw\rC\u0004\u0002\u0016:\u0001\r!a&\u0002\u000b=\u0014H-\u001a:\u0011\t\u0005E\u0012\u0011T\u0005\u0005\u00037\u000b\u0019D\u0001\u0005Pe\u0012,'/\u001b8h\u0003)\u0019w.\u001e8u\u0011>\u001cHo\u001d\u000b\u0007\u0003C\u000bi+a,\u0011\t\u0005\r\u0016\u0011V\u0007\u0003\u0003KSA!a*\u0002v\u0005!A.\u00198h\u0013\u0011\tY+!*\u0003\u000f%sG/Z4fe\"9\u0011QH\bA\u0002\u0005}\u0002bBAD\u001f\u0001\u0007\u0011q\b\u0015\u0004\u0001\u0005M\u0006\u0003BA[\u0003wk!!a.\u000b\u0007\u0005ef+\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LA!!0\u00028\n91+\u001a:wS\u000e,\u0007")
public class SatelliteServiceImpl
extends AbstractSecuredResource
implements SatelliteService,
Logging {
    private final SatelliteRepository satelliteRepository;
    private final PaginationService paginationService;
    private final RepositoryService repositoryService;
    @Context
    private final HttpResponse response;
    private final ActorSystem actorSystem;
    private final ExecutionContextExecutor dispatcher;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SatelliteServiceImpl satelliteServiceImpl = this;
        synchronized (satelliteServiceImpl) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public HttpResponse response() {
        return this.response;
    }

    public FiniteDuration defaultPingTimeout(ActorSystem taskActorSystem) {
        return ((CommonSettings)CommonSettings$.MODULE$.apply(taskActorSystem)).satellite().infoTimeout().duration();
    }

    public ActorSystem actorSystem() {
        return this.actorSystem;
    }

    public ExecutionContextExecutor dispatcher() {
        return this.dispatcher;
    }

    public SatelliteInfo getInfo(String ciId) {
        Timeout timeout = new Timeout(this.defaultPingTimeout(this.actorSystem()));
        ConfigurationItem ci = this.repositoryService.read(ciId);
        if (!ci.getType().instanceOf(Type.valueOf((String)"xl.Satellite"))) {
            return null;
        }
        Satellite satellite = (Satellite)ci;
        ActorLocator actorLocator = ActorLocator$.MODULE$.apply(satellite);
        ActorRef checker = TaskActorSystem$.MODULE$.actorSystem().actorOf(SatelliteInfoChecker$.MODULE$.props(satellite.getAddress()));
        ActorRef qual$1 = akka.pattern.package$.MODULE$.ask(checker);
        SatelliteInfoChecker.Get x$1 = new SatelliteInfoChecker.Get(actorLocator.locate(Paths$.MODULE$.info(), this.actorSystem()));
        Timeout x$2 = timeout;
        ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
        Future future = AskableActorRef$.MODULE$.$qmark$extension1(qual$1, (Object)x$1, x$2, x$3).recover((PartialFunction)new scala.Serializable(this, satellite){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SatelliteServiceImpl $outer;
            private final Satellite satellite$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                this.$outer.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Operation failed on satellite ").append($this.satellite$1.getAddress()).append(" (").append(A1.getMessage()).append(")").toString());
                SatelliteInfo satelliteInfo = new SatelliteInfo();
                return (B1)satelliteInfo;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.satellite$1 = satellite$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(com.xebialabs.deployit.core.rest.api.SatelliteServiceImpl$$anonfun$1 java.lang.Throwable )}, serializedLambda);
            }
        }, (ExecutionContext)this.dispatcher());
        SatelliteInfo satelliteInfo = (SatelliteInfo)Await$.MODULE$.result((Awaitable)future, package.DoubleMult$.MODULE$.$times$extension(package$.MODULE$.DoubleMult(1.5), (Duration)this.defaultPingTimeout(this.actorSystem())));
        Option<Object> option = this.arePluginsSynced(ci.getId());
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            boolean pluginSync = BoxesRunTime.unboxToBoolean((Object)some.value());
            if (Predef$.MODULE$.Boolean2boolean(satelliteInfo.isAvailable())) {
                satelliteInfo.setPluginsSynced(Predef$.MODULE$.boolean2Boolean(pluginSync));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
        satelliteInfo.setSatelliteId(ciId);
        return satelliteInfo;
    }

    private Option<Object> arePluginsSynced(String ciId) {
        Option option;
        Timeout timeout = new Timeout(this.defaultPingTimeout(this.actorSystem()));
        ConfigurationItem ci = this.repositoryService.read(ciId);
        if (!ci.getType().instanceOf(Type.valueOf((String)"xl.Satellite"))) {
            return None$.MODULE$;
        }
        Satellite satellite = (Satellite)ci;
        ActorLocator actorLocator = ActorLocator$.MODULE$.apply(satellite);
        try {
            InstalledExtensionsDelta deltas = ExtensionsDelta$.MODULE$.calculateExtensionsDelta((ExtensionsLocator)FileSystemExtensionsLocator$.MODULE$, actorLocator, this.actorSystem());
            option = new Some((Object)BoxesRunTime.boxToBoolean((boolean)deltas.empty()));
        }
        catch (Exception exception) {
            option = Option$.MODULE$.empty();
        }
        return option;
    }

    public List<ConfigurationItemId> listHosts(String ciId, String name, Paging paging, Ordering order) {
        this.checkPermission(PlatformPermissions.READ, ciId);
        this.paginationService.addPagingHeaderIfNeeded(this.paginationService.toSetHeader(this.response()), () -> this.countHosts(ciId, name), paging);
        return this.satelliteRepository.listHosts(ciId, name, paging, order);
    }

    public Integer countHosts(String ciId, String name) {
        this.checkPermission(PlatformPermissions.READ, ciId);
        return Predef$.MODULE$.int2Integer(this.satelliteRepository.countHosts(ciId, name));
    }

    @Autowired
    public SatelliteServiceImpl(SatelliteRepository satelliteRepository, PaginationService paginationService, RepositoryService repositoryService) {
        this.satelliteRepository = satelliteRepository;
        this.paginationService = paginationService;
        this.repositoryService = repositoryService;
        Logging.$init$((Logging)this);
        this.response = null;
        this.actorSystem = TaskActorSystem$.MODULE$.actorSystem();
        this.dispatcher = this.actorSystem().dispatcher();
    }
}

