/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.spi;

import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.spi.BaseOverthereConnection;
import com.xebialabs.overthere.util.CapturingOverthereExecutionOutputHandler;
import com.xebialabs.overthere.util.LoggingOverthereExecutionOutputHandler;
import com.xebialabs.overthere.util.MultipleOverthereExecutionOutputHandler;
import com.xebialabs.overthere.util.OverthereFileCopier;
import com.xebialabs.overthere.util.OverthereUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseOverthereFile<C extends BaseOverthereConnection>
implements OverthereFile {
    protected C connection;
    private static final Logger logger = LoggerFactory.getLogger(BaseOverthereFile.class);

    protected BaseOverthereFile() {
        this.connection = null;
    }

    protected BaseOverthereFile(C connection) {
        this.connection = connection;
    }

    public C getConnection() {
        return this.connection;
    }

    @Override
    public OverthereFile getFile(String child) {
        return this.getConnection().getFile(this, child);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void deleteRecursively() throws RuntimeIOException {
        if (this.isDirectory()) {
            RuntimeIOException accumulator = new RuntimeIOException("Cannot delete " + this + ", not all children are deleted.");
            for (OverthereFile each : this.listFiles()) {
                try {
                    each.deleteRecursively();
                }
                catch (RuntimeIOException rio) {
                    logger.warn("Unable to delete child {}. Continue...", (Object)each);
                    accumulator.addSuppressed(rio);
                }
            }
            Throwable[] suppressed = accumulator.getSuppressed();
            if (suppressed != null && suppressed.length != 0) throw accumulator;
            this.delete();
            return;
        } else {
            this.delete();
        }
    }

    @Override
    public final void copyTo(OverthereFile dest) {
        OverthereUtils.checkArgument(dest instanceof BaseOverthereFile, "dest is not a subclass of BaseOverthereFile", new Object[0]);
        if (((BaseOverthereConnection)this.getConnection()).equals(dest.getConnection())) {
            ((BaseOverthereFile)dest).shortCircuitCopyFrom(this);
        } else {
            ((BaseOverthereFile)dest).copyFrom(this);
        }
    }

    protected void copyFrom(OverthereFile source) {
        OverthereFileCopier.copy(source, this);
    }

    protected void shortCircuitCopyFrom(OverthereFile source) {
        String copyCommandTemplate;
        OverthereUtils.checkArgument(source.exists(), "Source file [%s] does not exist", source);
        boolean srcIsDir = source.isDirectory();
        if (this.exists()) {
            if (srcIsDir) {
                OverthereUtils.checkArgument(this.isDirectory(), "Cannot copy source directory [%s] to target file [%s]", source, this);
            } else {
                OverthereUtils.checkArgument(!this.isDirectory(), "Cannot copy source file [%s] to target directory [%s]", source, this);
            }
        } else if (srcIsDir) {
            this.mkdir();
        }
        switch (source.getConnection().getHostOperatingSystem()) {
            case UNIX: {
                if (srcIsDir) {
                    copyCommandTemplate = ((BaseOverthereConnection)this.getConnection()).getOptions().get("directoryCopyCommandForUnix", "cd {1} ; tar -cf - -C {0} . | tar xpf -");
                    break;
                }
                copyCommandTemplate = ((BaseOverthereConnection)this.getConnection()).getOptions().get("fileCopyCommandForUnix", "cp -p {0} {1}");
                break;
            }
            case WINDOWS: {
                if (srcIsDir) {
                    copyCommandTemplate = ((BaseOverthereConnection)this.getConnection()).getOptions().get("directoryCopyCommandForWindows", "xcopy {0} {1} /i /y /s /e /h /q");
                    break;
                }
                copyCommandTemplate = ((BaseOverthereConnection)this.getConnection()).getOptions().get("fileCopyCommandForWindows", "copy {0} {1} /y");
                break;
            }
            case ZOS: {
                if (srcIsDir) {
                    copyCommandTemplate = ((BaseOverthereConnection)this.getConnection()).getOptions().get("directoryCopyCommandForZos", "tar cC {0} . | tar xmC {1}");
                    break;
                }
                copyCommandTemplate = ((BaseOverthereConnection)this.getConnection()).getOptions().get("fileCopyCommandForZos", "cp -p {0} {1}");
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown operating system [%s]", new Object[]{source.getConnection().getHostOperatingSystem()}));
            }
        }
        CmdLine cmdLine = this.postProcessShortCircuitCopyCommand(new CmdLine().addTemplatedFragment(copyCommandTemplate, source.getPath(), this.getPath()));
        CapturingOverthereExecutionOutputHandler capturedStderr = CapturingOverthereExecutionOutputHandler.capturingHandler();
        int errno = source.getConnection().execute(LoggingOverthereExecutionOutputHandler.loggingOutputHandler(logger), MultipleOverthereExecutionOutputHandler.multiHandler(LoggingOverthereExecutionOutputHandler.loggingErrorHandler(logger), capturedStderr), cmdLine);
        if (errno != 0) {
            throw new RuntimeIOException(String.format("Cannot copy [%s] to [%s] on [%s]: %s (errno=%d)", source.getPath(), this.getPath(), this.getConnection(), capturedStderr.getOutput(), errno));
        }
    }

    protected CmdLine postProcessShortCircuitCopyCommand(CmdLine cmd) {
        return cmd;
    }

    protected InputStream asBuffered(InputStream is) {
        if (is instanceof BufferedInputStream) {
            return is;
        }
        int streamBufferSize = ((BaseOverthereConnection)this.getConnection()).streamBufferSize;
        logger.debug("Using buffer of size [{}] for streaming from [{}]", (Object)streamBufferSize, (Object)this);
        return new BufferedInputStream(is, streamBufferSize);
    }

    protected OutputStream asBuffered(OutputStream os) {
        if (os instanceof BufferedOutputStream) {
            return os;
        }
        int streamBufferSize = ((BaseOverthereConnection)this.getConnection()).streamBufferSize;
        logger.debug("Using buffer of size [{}] for streaming to [{}]", (Object)streamBufferSize, (Object)this);
        return new BufferedOutputStream(os, ((BaseOverthereConnection)this.getConnection()).streamBufferSize);
    }

    public abstract String toString();
}

