/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xldeploy.packager.placeholders;

import com.xebialabs.deployit.plugin.api.udm.artifact.FolderArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.util.BOM;
import com.xebialabs.deployit.util.DetectBOM$;
import com.xebialabs.deployit.util.TryWith$;
import com.xebialabs.overthere.util.OverthereUtils;
import com.xebialabs.xldeploy.packager.MustacheScanningReader;
import com.xebialabs.xldeploy.packager.Mustacher;
import com.xebialabs.xldeploy.packager.Mustacher$;
import com.xebialabs.xldeploy.packager.io.ArtifactIOUtils$;
import com.xebialabs.xldeploy.packager.io.StreamEntry;
import com.xebialabs.xldeploy.packager.io.Streamer;
import com.xebialabs.xldeploy.packager.io.StreamerFactory;
import com.xebialabs.xldeploy.packager.placeholders.DigestOnly$;
import com.xebialabs.xldeploy.packager.placeholders.PlaceholdersUtil$;
import com.xebialabs.xldeploy.packager.placeholders.ProcessArchive$;
import com.xebialabs.xldeploy.packager.placeholders.ProcessTextFile$;
import com.xebialabs.xldeploy.packager.placeholders.ProcessingType;
import com.xebialabs.xldeploy.packager.placeholders.SourceArtifactScanner$;
import com.xebialabs.xldeploy.packager.placeholders.StreamFile;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Set;
import org.apache.commons.codec.binary.Hex;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005]s!\u0002\n\u0014\u0011\u0003qb!\u0002\u0011\u0014\u0011\u0003\t\u0003\"\u0002\u0015\u0002\t\u0003I\u0003\u0002\u0003\u0016\u0002\u0005\u0004%\t!A\u0016\t\rQ\n\u0001\u0015!\u0003-\u0011!)\u0014A1A\u0005\u0002\u00051\u0004BB\u001f\u0002A\u0003%q\u0007\u0003\u0005?\u0003\t\u0007I\u0011A\u0001@\u0011\u00199\u0015\u0001)A\u0005\u0001\u001a!\u0001e\u0005\u0001I\u0011!I\u0015B!A!\u0002\u0013Q\u0005\"\u0002\u0015\n\t\u0003i\u0005\"\u0002)\n\t\u0003\t\u0006B\u0002=\nA\u0013%\u0011\u0010\u0003\u0005\u0002\f%\u0001K\u0011BA\u0007\u0011!\t\t#\u0003Q\u0005\n\u0005\r\u0002\u0002CA\u0017\u0013\u0001&I!a\f\t\u0011\u0005u\u0012\u0002)C\u0005\u0003\u007f\tQcU8ve\u000e,\u0017I\u001d;jM\u0006\u001cGoU2b]:,'O\u0003\u0002\u0015+\u0005a\u0001\u000f\\1dK\"|G\u000eZ3sg*\u0011acF\u0001\ta\u0006\u001c7.Y4fe*\u0011\u0001$G\u0001\tq2$W\r\u001d7ps*\u0011!dG\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011\u0001H\u0001\u0004G>l7\u0001\u0001\t\u0003?\u0005i\u0011a\u0005\u0002\u0016'>,(oY3BeRLg-Y2u'\u000e\fgN\\3s'\t\t!\u0005\u0005\u0002$M5\tAEC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9CE\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003y\ta\u0001\\8hO\u0016\u0014X#\u0001\u0017\u0011\u00055\u0012T\"\u0001\u0018\u000b\u0005=\u0002\u0014!B:mMRR'\"A\u0019\u0002\u0007=\u0014x-\u0003\u00024]\t1Aj\\4hKJ\fq\u0001\\8hO\u0016\u0014\b%A\u0004eKZtU\u000f\u001c7\u0016\u0003]\u0002\"\u0001O\u001e\u000e\u0003eR!AO\u000b\u0002\u0005%|\u0017B\u0001\u001f:\u0005\u001d!UM\u001e(vY2\f\u0001\u0002Z3w\u001dVdG\u000eI\u0001\u000eI\u00164h*\u001e7m/JLG/\u001a:\u0016\u0003\u0001\u0003\"!Q#\u000e\u0003\tS!AO\"\u000b\u0003\u0011\u000bAA[1wC&\u0011aI\u0011\u0002\u0013\u001fV$\b/\u001e;TiJ,\u0017-\\,sSR,'/\u0001\beKZtU\u000f\u001c7Xe&$XM\u001d\u0011\u0014\u0005%\u0011\u0013aD:ue\u0016\fW.\u001a:GC\u000e$xN]=\u0011\u0005aZ\u0015B\u0001':\u0005=\u0019FO]3b[\u0016\u0014h)Y2u_JLHC\u0001(P!\ty\u0012\u0002C\u0003J\u0017\u0001\u0007!*\u0001\bf]JL7\r[!si&4\u0017m\u0019;\u0015\tI+V-\u001c\t\u0003GMK!\u0001\u0016\u0013\u0003\tUs\u0017\u000e\u001e\u0005\u0006-2\u0001\raV\u0001\u0003g\u0006\u0004\"\u0001W2\u000e\u0003eS!AW.\u0002\u0011\u0005\u0014H/\u001b4bGRT!\u0001X/\u0002\u0007U$WN\u0003\u0002_?\u0006\u0019\u0011\r]5\u000b\u0005\u0001\f\u0017A\u00029mk\u001eLgN\u0003\u0002c3\u0005AA-\u001a9m_fLG/\u0003\u0002e3\nq1k\\;sG\u0016\f%\u000f^5gC\u000e$\b\"\u00024\r\u0001\u00049\u0017AC:ue\u0016\fWNR5mKB\u00191\u0005\u001b6\n\u0005%$#AB(qi&|g\u000e\u0005\u0002 W&\u0011An\u0005\u0002\u000b'R\u0014X-Y7GS2,\u0007\"\u00028\r\u0001\u0004y\u0017!D7fgN\fw-\u001a#jO\u0016\u001cH\u000fE\u0002$aJL!!\u001d\u0013\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004CA:w\u001b\u0005!(BA;D\u0003!\u0019XmY;sSRL\u0018BA<u\u00055iUm]:bO\u0016$\u0015nZ3ti\u0006q2-\u00197dk2\fG/\u001a)mC\u000e,\u0007n\u001c7eKJ\u001c\u0018I\u001c3ES\u001e,7\u000f\u001e\u000b\u0007%j\\H0!\u0002\t\u000bYk\u0001\u0019A,\t\u000b\u0019l\u0001\u0019A4\t\u000bul\u0001\u0019\u0001@\u0002\u00135,8\u000f^1dQ\u0016\u0014\bcA@\u0002\u00025\tQ#C\u0002\u0002\u0004U\u0011\u0011\"T;ti\u0006\u001c\u0007.\u001a:\t\u000f\u0005\u001dQ\u00021\u0001\u0002\n\u0005Iq\u000e\u001d;ES\u001e,7\u000f\u001e\t\u0004G!\u0014\u0018AE:dC:4u\u000e\u001c3fe\u0006\u0013H/\u001b4bGR$\u0012BUA\b\u00033\tY\"a\b\t\u000f\u0005Ea\u00021\u0001\u0002\u0014\u0005\u0011a-\u0019\t\u00041\u0006U\u0011bAA\f3\nqai\u001c7eKJ\f%\u000f^5gC\u000e$\b\"\u00024\u000f\u0001\u00049\u0007bBA\u000f\u001d\u0001\u0007\u0011\u0011B\u0001\u0007I&<Wm\u001d;\t\u000but\u0001\u0019\u0001@\u00023M\u001c\u0017M\u001c$jY\u0016|%/\u0011:dQ&4X-\u0011:uS\u001a\f7\r\u001e\u000b\n%\u0006\u0015\u0012qEA\u0015\u0003WAQAV\bA\u0002]CQAZ\bA\u0002)Dq!!\b\u0010\u0001\u0004\tI\u0001C\u0003~\u001f\u0001\u0007a0\u0001\rva\u0012\fG/\u001a#jO\u0016\u001cHoV5uQ\u001aKG.\u001a8b[\u0016$RAUA\u0019\u0003wAq!a\r\u0011\u0001\u0004\t)$A\u0003f]R\u0014\u0018\u0010E\u00029\u0003oI1!!\u000f:\u0005-\u0019FO]3b[\u0016sGO]=\t\r\u0005u\u0001\u00031\u0001s\u0003\u0019!wnU2b]RI!+!\u0011\u0002D\u0005\u0015\u0013q\t\u0005\u0006-F\u0001\ra\u0016\u0005\b\u0003g\t\u0002\u0019AA\u001b\u0011\u0015i\u0018\u00031\u0001\u007f\u0011\u001d\tI%\u0005a\u0001\u0003\u0017\n\u0011\u0002\u001e:b]N4wN]7\u0011\u000f\r\ni%!\u0015\u0002R%\u0019\u0011q\n\u0013\u0003\u0013\u0019+hn\u0019;j_:\f\u0004cA!\u0002T%\u0019\u0011Q\u000b\"\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\u001c")
public class SourceArtifactScanner {
    private final StreamerFactory streamerFactory;

    public void enrichArtifact(SourceArtifact sa, Option<StreamFile> streamFile, Function0<MessageDigest> messageDigest) {
        if (!PlaceholdersUtil$.MODULE$.SourceArtifactUtil(sa).shouldScanPlaceholders() && PlaceholdersUtil$.MODULE$.SourceArtifactUtil(sa).hasCheckSum()) {
            SourceArtifactScanner$.MODULE$.logger().info(new StringBuilder(75).append("Not enriching ").append(sa).append(" as no placeholders should be scanned and checksum is present").toString());
            return;
        }
        None$ digest = !PlaceholdersUtil$.MODULE$.SourceArtifactUtil(sa).hasCheckSum() ? new Some(messageDigest.apply()) : None$.MODULE$;
        Mustacher mustacher = Mustacher$.MODULE$.apply(PlaceholdersUtil$.MODULE$.SourceArtifactUtil(sa).mustacheDelimiters());
        this.calculatePlaceholdersAndDigest(sa, streamFile, mustacher, (Option<MessageDigest>)digest);
        sa.setPlaceholders((Set)JavaConverters$.MODULE$.setAsJavaSetConverter(mustacher.placeholders()).asJava());
        digest.foreach((Function1 & Serializable & scala.Serializable)d -> {
            sa.setProperty("checksum", (Object)Hex.encodeHexString((byte[])d.digest()));
            return BoxedUnit.UNIT;
        });
    }

    private void calculatePlaceholdersAndDigest(SourceArtifact sa, Option<StreamFile> streamFile, Mustacher mustacher, Option<MessageDigest> optDigest) {
        SourceArtifact sourceArtifact = sa;
        if (sourceArtifact instanceof FolderArtifact) {
            FolderArtifact folderArtifact = (FolderArtifact)sourceArtifact;
            SourceArtifactScanner$.MODULE$.logger().info(new StringBuilder(44).append("Going to scan artifact ").append(folderArtifact).append(" as a folder artifact").toString());
            this.scanFolderArtifact(folderArtifact, streamFile, optDigest, mustacher);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (streamFile.isEmpty()) {
            SourceArtifactScanner$.MODULE$.logger().info(new StringBuilder(23).append("Going to scan artifact ").append(sa).toString());
            TryWith$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> sa.getFile().getInputStream(), (Function1 & Serializable & scala.Serializable)fis -> {
                this.scanFileOrArchiveArtifact(sa, new StreamFile(sa.getFile().getName(), fis), (Option<MessageDigest>)optDigest, mustacher);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            SourceArtifactScanner$.MODULE$.logger().info(new StringBuilder(35).append("Going to scan artifact ").append(sa).append(" from stream").toString());
            this.scanFileOrArchiveArtifact(sa, (StreamFile)streamFile.get(), optDigest, mustacher);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void scanFolderArtifact(FolderArtifact fa, Option<StreamFile> streamFile, Option<MessageDigest> digest, Mustacher mustacher) {
        Streamer streamer;
        Option<StreamFile> option = streamFile;
        if (option instanceof Some) {
            Some some = (Some)option;
            StreamFile x = (StreamFile)some.value();
            streamer = this.streamerFactory.streamer(x.inputStream(), x.name());
        } else if (None$.MODULE$.equals(option)) {
            streamer = this.streamerFactory.streamer(PlaceholdersUtil$.MODULE$.SourceArtifactUtil((SourceArtifact)fa).toLocalFile());
        } else {
            throw new MatchError(option);
        }
        Streamer streamer2 = streamer;
        streamer2.stream().foreach((Function1 & Serializable & scala.Serializable)entry -> {
            SourceArtifactScanner.$anonfun$scanFolderArtifact$1(this, digest, fa, mustacher, entry);
            return BoxedUnit.UNIT;
        });
    }

    private void scanFileOrArchiveArtifact(SourceArtifact sa, StreamFile streamFile, Option<MessageDigest> digest, Mustacher mustacher) {
        InputStream inputStream = (InputStream)digest.map((Function1 & Serializable & scala.Serializable)x$2 -> new DigestInputStream(streamFile.inputStream(), (MessageDigest)x$2)).getOrElse((Function0 & Serializable & scala.Serializable)() -> streamFile.inputStream());
        if (!PlaceholdersUtil$.MODULE$.SourceArtifactUtil(sa).shouldScanPlaceholders()) {
            SourceArtifactScanner$.MODULE$.logger().debug(new StringBuilder(45).append("Artifact [").append(sa).append("] has disabled placeholder scanning").toString());
        } else {
            this.streamerFactory.streamer(inputStream, streamFile.name()).stream().foreach((Function1 & Serializable & scala.Serializable)entry -> {
                this.doScan(sa, entry, mustacher, (Function1<InputStream, InputStream>)(Function1 & Serializable & scala.Serializable)x -> (InputStream)Predef$.MODULE$.identity(x));
                return BoxedUnit.UNIT;
            });
        }
        OverthereUtils.write((InputStream)inputStream, (OutputStream)SourceArtifactScanner$.MODULE$.devNull());
    }

    private void updateDigestWithFilename(StreamEntry entry, MessageDigest digest) {
        String digestPath = new StringBuilder(0).append(entry.getPath()).append((Object)(entry.isDirectory() ? File.separator : "")).toString();
        digestPath = digestPath.replace("\\", "/");
        SourceArtifactScanner$.MODULE$.logger().trace(new StringBuilder(46).append("scanFolderArtifact: update digest with path [").append(digestPath).append("]").toString());
        digest.update(digestPath.getBytes(StandardCharsets.UTF_8));
    }

    private void doScan(SourceArtifact sa, StreamEntry entry, Mustacher mustacher, Function1<InputStream, InputStream> transform) {
        if (entry.isDirectory()) {
            return;
        }
        TryWith$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> entry.getInputStream(), (Function1 & Serializable & scala.Serializable)inputStream -> {
            Try try_;
            InputStream is = (InputStream)transform.apply(inputStream);
            StreamerFactory sf = $this.streamerFactory;
            ProcessingType processingType = PlaceholdersUtil$.MODULE$.SourceArtifactUtil(sa).getScanTypeForEntry(entry, sf);
            if (DigestOnly$.MODULE$.equals(processingType)) {
                SourceArtifactScanner$.MODULE$.logger().debug(new StringBuilder(11).append(sa).append(": Skipping ").append(entry.getName()).toString());
                OverthereUtils.write((InputStream)is, (OutputStream)SourceArtifactScanner$.MODULE$.devNull());
                try_ = BoxedUnit.UNIT;
            } else if (ProcessArchive$.MODULE$.equals(processingType)) {
                SourceArtifactScanner$.MODULE$.logger().debug(new StringBuilder(23).append(sa).append(": Detected archive for ").append(entry.getName()).toString());
                $this.streamerFactory.streamer(is, entry.getName()).stream().foreach((Function1 & Serializable & scala.Serializable)e2 -> {
                    this.doScan(sa, e2, mustacher, (Function1<InputStream, InputStream>)(Function1 & Serializable & scala.Serializable)x -> (InputStream)Predef$.MODULE$.identity(x));
                    return BoxedUnit.UNIT;
                });
                OverthereUtils.write((InputStream)is, (OutputStream)SourceArtifactScanner$.MODULE$.devNull());
                try_ = BoxedUnit.UNIT;
            } else if (ProcessTextFile$.MODULE$.equals(processingType)) {
                InputStreamReader inputStreamReader;
                SourceArtifactScanner$.MODULE$.logger().debug(new StringBuilder(18).append(sa).append(": ").append(entry.getName()).append(" is a text file.").toString());
                InputStream resettableInputStream = ArtifactIOUtils$.MODULE$.getResettableInputStream(is);
                BOM bOM = DetectBOM$.MODULE$.detect(resettableInputStream);
                if (((Object)((Object)BOM.NONE)).equals((Object)bOM)) {
                    inputStreamReader = new InputStreamReader(resettableInputStream);
                } else if (bOM != null) {
                    BOM bOM2 = bOM;
                    inputStreamReader = new InputStreamReader(resettableInputStream, bOM2.getCharset());
                } else {
                    throw new MatchError((Object)bOM);
                }
                InputStreamReader reader = inputStreamReader;
                try_ = TryWith$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> mustacher.newReader(reader), (Function1 & Serializable & scala.Serializable)r -> {
                    SourceArtifactScanner.$anonfun$doScan$6(r);
                    return BoxedUnit.UNIT;
                });
            } else {
                throw new MatchError((Object)processingType);
            }
            return try_;
        });
    }

    public static final /* synthetic */ void $anonfun$scanFolderArtifact$1(SourceArtifactScanner $this, Option digest$1, FolderArtifact fa$1, Mustacher mustacher$2, StreamEntry entry) {
        digest$1.foreach((Function1 & Serializable & scala.Serializable)d -> {
            $this.updateDigestWithFilename(entry, d);
            return BoxedUnit.UNIT;
        });
        $this.doScan((SourceArtifact)fa$1, entry, mustacher$2, (Function1<InputStream, InputStream>)(Function1 & Serializable & scala.Serializable)is -> (InputStream)digest$1.map((Function1 & Serializable & scala.Serializable)x$1 -> new DigestInputStream((InputStream)is, (MessageDigest)x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> is));
    }

    public static final /* synthetic */ void $anonfun$doScan$6(MustacheScanningReader r) {
        OverthereUtils.write((Reader)r, (Writer)SourceArtifactScanner$.MODULE$.devNullWriter());
    }

    public SourceArtifactScanner(StreamerFactory streamerFactory) {
        this.streamerFactory = streamerFactory;
    }
}

