/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.discovery;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.pattern.AskableActorRef$;
import akka.pattern.package$;
import akka.util.Timeout;
import akka.util.Timeout$;
import com.google.common.base.Strings;
import com.xebialabs.deployit.engine.tasker.BlockBuilders$;
import com.xebialabs.deployit.engine.tasker.PhaseContainer;
import com.xebialabs.deployit.engine.tasker.TaskInspectionContext;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.service.discovery.DiscoveryContext;
import com.xebialabs.deployit.service.discovery.DiscoveryMessages;
import com.xebialabs.deployit.service.discovery.DiscoveryResult;
import com.xebialabs.deployit.service.discovery.DiscoveryResultsRetriever$;
import com.xebialabs.deployit.service.discovery.DiscoveryTrigger;
import com.xebialabs.deployit.task.TaskMetadata;
import com.xebialabs.deployit.task.TaskType;
import com.xebialabs.deployit.task.WorkdirCleanerTrigger;
import com.xebialabs.xlplatform.settings.CommonSettings;
import com.xebialabs.xlplatform.settings.CommonSettings$;
import java.util.concurrent.TimeUnit;
import scala.None$;
import scala.Option;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001\u0002\u0007\u000e\u0001aA\u0001b\b\u0001\u0003\u0006\u0004%\t\u0001\t\u0005\tS\u0001\u0011\t\u0011)A\u0005C!A!\u0006\u0001BC\u0002\u0013\u00051\u0006\u0003\u00050\u0001\t\u0005\t\u0015!\u0003-\u0011\u0015\u0001\u0004\u0001\"\u00012\u0011\u001d1\u0004A1A\u0005\n]Ba\u0001\u0011\u0001!\u0002\u0013A\u0004bB!\u0001\u0005\u0004%Ia\u000b\u0005\u0007\u0005\u0002\u0001\u000b\u0011\u0002\u0017\t\u000b\r\u0003A\u0011\u0001#\t\u000b\u0005\u0004A\u0011\u00012\u0003!\u0011K7oY8wKJL8+\u001a:wS\u000e,'B\u0001\b\u0010\u0003%!\u0017n]2pm\u0016\u0014\u0018P\u0003\u0002\u0011#\u000591/\u001a:wS\u000e,'B\u0001\n\u0014\u0003!!W\r\u001d7ps&$(B\u0001\u000b\u0016\u0003%AXMY5bY\u0006\u00147OC\u0001\u0017\u0003\r\u0019w.\\\u0002\u0001'\t\u0001\u0011\u0004\u0005\u0002\u001b;5\t1DC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq2D\u0001\u0004B]f\u0014VMZ\u0001\u0007gf\u001cH/Z7\u0016\u0003\u0005\u0002\"AI\u0014\u000e\u0003\rR!\u0001J\u0013\u0002\u000b\u0005\u001cGo\u001c:\u000b\u0003\u0019\nA!Y6lC&\u0011\u0001f\t\u0002\f\u0003\u000e$xN]*zgR,W.A\u0004tsN$X-\u001c\u0011\u0002\u001b]|'o[3s\u001b\u0006t\u0017mZ3s+\u0005a\u0003C\u0001\u0012.\u0013\tq3E\u0001\u0005BGR|'OU3g\u000399xN]6fe6\u000bg.Y4fe\u0002\na\u0001P5oSRtDc\u0001\u001a5kA\u00111\u0007A\u0007\u0002\u001b!)q$\u0002a\u0001C!)!&\u0002a\u0001Y\u0005q1m\\7n_:\u001cV\r\u001e;j]\u001e\u001cX#\u0001\u001d\u0011\u0005erT\"\u0001\u001e\u000b\u0005mb\u0014\u0001C:fiRLgnZ:\u000b\u0005u\u001a\u0012A\u0003=ma2\fGOZ8s[&\u0011qH\u000f\u0002\u000f\u0007>lWn\u001c8TKR$\u0018N\\4t\u0003=\u0019w.\\7p]N+G\u000f^5oON\u0004\u0013!\u00073jg\u000e|g/\u001a:z%\u0016\u001cX\u000f\u001c;t%\u0016$(/[3wKJ\f!\u0004Z5tG>4XM]=SKN,H\u000e^:SKR\u0014\u0018.\u001a<fe\u0002\n\u0001\u0003\u001d:fa\u0006\u0014X\rR5tG>4XM]=\u0015\u0007\u0015k\u0015\f\u0005\u0002G\u00176\tqI\u0003\u0002I\u0013\u00061A/Y:lKJT!AS\t\u0002\r\u0015tw-\u001b8f\u0013\tauIA\tUCN\\7\u000b]3dS\u001aL7-\u0019;j_:DQA\u0014\u0006A\u0002=\u000b!aY5\u0011\u0005A;V\"A)\u000b\u0005I\u001b\u0016aA;e[*\u0011A+V\u0001\u0004CBL'B\u0001,\u0012\u0003\u0019\u0001H.^4j]&\u0011\u0001,\u0015\u0002\u0012\u0007>tg-[4ve\u0006$\u0018n\u001c8Ji\u0016l\u0007\"\u0002.\u000b\u0001\u0004Y\u0016aB<pe.$\u0015N\u001d\t\u00039~k\u0011!\u0018\u0006\u0003=F\t!B]3q_NLGo\u001c:z\u0013\t\u0001WLA\u0004X_J\\G)\u001b:\u0002'\u001d,G\u000fR5tG>4XM]=SKN,H\u000e^:\u0015\u0005\r4\u0007CA\u001ae\u0013\t)WBA\bESN\u001cwN^3ssJ+7/\u001e7u\u0011\u001597\u00021\u0001i\u0003\u0019!\u0018m]6JIB\u0011\u0011\u000e\u001d\b\u0003U:\u0004\"a[\u000e\u000e\u00031T!!\\\f\u0002\rq\u0012xn\u001c;?\u0013\ty7$\u0001\u0004Qe\u0016$WMZ\u0005\u0003cJ\u0014aa\u0015;sS:<'BA8\u001cQ\u0011YA\u000f`?\u0011\u0005UTX\"\u0001<\u000b\u0005]D\u0018\u0001\u00027b]\u001eT\u0011!_\u0001\u0005U\u00064\u0018-\u0003\u0002|m\n\u00012+\u001e9qe\u0016\u001c8oV1s]&twm]\u0001\u0006m\u0006dW/\u001a\u0017\u0002}\u0006\nq0A\u0002bY2\u0004")
public class DiscoveryService {
    private final ActorSystem system;
    private final ActorRef workerManager;
    private final CommonSettings commonSettings;
    private final ActorRef discoveryResultsRetriever;

    public ActorSystem system() {
        return this.system;
    }

    public ActorRef workerManager() {
        return this.workerManager;
    }

    private CommonSettings commonSettings() {
        return this.commonSettings;
    }

    private ActorRef discoveryResultsRetriever() {
        return this.discoveryResultsRetriever;
    }

    public TaskSpecification prepareDiscovery(ConfigurationItem ci, WorkDir workDir) {
        DiscoveryContext inspectionContext = new DiscoveryContext();
        inspectionContext.discovered(ci);
        String description = new StringBuilder(14).append("Inspection of ").append(ci.getId()).toString();
        PhaseContainer stepBlock = BlockBuilders$.MODULE$.steps(description, (Option)None$.MODULE$, (List)Nil$.MODULE$).build();
        TaskSpecification spec = new TaskSpecification(description, Permissions.getAuthentication(), workDir, stepBlock, (TaskInspectionContext)inspectionContext, false);
        spec.getListeners().add(new WorkdirCleanerTrigger(workDir));
        spec.getListeners().add(new DiscoveryTrigger(inspectionContext));
        TaskMetadata.putMetadata((TaskSpecification)spec, (String)"taskType", (String)TaskType.INSPECTION.name());
        return spec;
    }

    public DiscoveryResult getDiscoveryResults(String taskId) {
        DiscoveryResult discoveryResult;
        Timeout timeout = Timeout$.MODULE$.apply(10L, TimeUnit.SECONDS);
        try {
            ActorRef qual$1 = package$.MODULE$.ask(this.discoveryResultsRetriever());
            DiscoveryMessages.RetrieveResults x$1 = new DiscoveryMessages.RetrieveResults(taskId);
            Timeout x$2 = timeout;
            ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
            discoveryResult = (DiscoveryResult)((DiscoveryMessages.DiscoveryResultsFound)((Object)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension1(qual$1, (Object)x$1, x$2, x$3), (Duration)timeout.duration()))).discoveryResult().get();
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)"Could not find any results associated with the id [%s]", (Object[])new Object[]{taskId}));
        }
        return discoveryResult;
    }

    public DiscoveryService(ActorSystem system, ActorRef workerManager) {
        this.system = system;
        this.workerManager = workerManager;
        this.commonSettings = (CommonSettings)CommonSettings$.MODULE$.apply(system);
        this.discoveryResultsRetriever = system.actorOf(DiscoveryResultsRetriever$.MODULE$.props(workerManager, this.commonSettings().inProcessTaskEngine()), DiscoveryResultsRetriever$.MODULE$.name());
    }
}

