/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp;

import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.DestinationPatternsMessageCondition;
import org.springframework.messaging.handler.MessageCondition;
import org.springframework.messaging.simp.SimpMessageTypeMessageCondition;

public class SimpMessageMappingInfo
implements MessageCondition<SimpMessageMappingInfo> {
    private final SimpMessageTypeMessageCondition messageTypeMessageCondition;
    private final DestinationPatternsMessageCondition destinationConditions;

    public SimpMessageMappingInfo(SimpMessageTypeMessageCondition messageTypeMessageCondition, DestinationPatternsMessageCondition destinationConditions) {
        this.messageTypeMessageCondition = messageTypeMessageCondition;
        this.destinationConditions = destinationConditions;
    }

    public SimpMessageTypeMessageCondition getMessageTypeMessageCondition() {
        return this.messageTypeMessageCondition;
    }

    public DestinationPatternsMessageCondition getDestinationConditions() {
        return this.destinationConditions;
    }

    @Override
    public SimpMessageMappingInfo combine(SimpMessageMappingInfo other) {
        SimpMessageTypeMessageCondition typeCond = this.getMessageTypeMessageCondition().combine(other.getMessageTypeMessageCondition());
        DestinationPatternsMessageCondition destCond = this.destinationConditions.combine(other.getDestinationConditions());
        return new SimpMessageMappingInfo(typeCond, destCond);
    }

    @Override
    @Nullable
    public SimpMessageMappingInfo getMatchingCondition(Message<?> message) {
        Object typeCond = this.messageTypeMessageCondition.getMatchingCondition((Message)message);
        if (typeCond == null) {
            return null;
        }
        Object destCond = this.destinationConditions.getMatchingCondition((Message)message);
        if (destCond == null) {
            return null;
        }
        return new SimpMessageMappingInfo((SimpMessageTypeMessageCondition)typeCond, (DestinationPatternsMessageCondition)destCond);
    }

    @Override
    public int compareTo(SimpMessageMappingInfo other, Message<?> message) {
        int result = this.messageTypeMessageCondition.compareTo(other.messageTypeMessageCondition, message);
        if (result != 0) {
            return result;
        }
        result = this.destinationConditions.compareTo(other.destinationConditions, message);
        if (result != 0) {
            return result;
        }
        return 0;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SimpMessageMappingInfo)) {
            return false;
        }
        SimpMessageMappingInfo otherInfo = (SimpMessageMappingInfo)other;
        return this.destinationConditions.equals(otherInfo.destinationConditions) && this.messageTypeMessageCondition.equals(otherInfo.messageTypeMessageCondition);
    }

    public int hashCode() {
        return this.destinationConditions.hashCode() * 31 + this.messageTypeMessageCondition.hashCode();
    }

    public String toString() {
        return "{" + this.destinationConditions + ",messageType=" + this.messageTypeMessageCondition + '}';
    }
}

