/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.io;

import com.xebialabs.deployit.io.ArtifactAwareFile;
import com.xebialabs.deployit.io.ArtifactFile;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.FolderArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xldeploy.packager.io.StreamerFactory;
import com.xebialabs.xldeploy.packager.placeholders.DerivedArtifactEnricher;
import java.io.InputStream;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DerivedArtifactFile
extends ArtifactFile
implements ArtifactAwareFile,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(DerivedArtifactFile.class);
    private final DerivedArtifact<? extends SourceArtifact> derivedArtifact;
    private transient OverthereFile resolvedFile;

    public DerivedArtifactFile(DerivedArtifact<? extends SourceArtifact> derivedArtifact) {
        this.derivedArtifact = derivedArtifact;
    }

    @Override
    public boolean isResolvable() {
        return this.derivedArtifact.getSourceArtifact() != null && this.derivedArtifact.getSourceArtifact().getFile() != null;
    }

    @Override
    public InputStream getRawStream() {
        throw new UnsupportedOperationException("Raw stream is not available on derived artifact. Use source artifact or use input stream");
    }

    @Override
    protected synchronized OverthereFile getLazyFile() {
        if (this.resolvedFile == null) {
            logger.debug("Creating derived file for {}", this.derivedArtifact);
            DerivedArtifactEnricher dae = new DerivedArtifactEnricher(this.derivedArtifact, StreamerFactory.defaultMappings());
            this.resolvedFile = dae.createDerivedFile();
            logger.debug("Derived file for {} created: {}", this.derivedArtifact, (Object)this.resolvedFile);
        }
        return this.resolvedFile;
    }

    @Override
    public Artifact underlyingArtifact() {
        return this.derivedArtifact;
    }

    @Override
    public String getName() {
        if (this.isResolvable()) {
            return this.derivedArtifact.getSourceArtifact().getFile().getName();
        }
        throw new RuntimeException("File name is not available because source artifact is not set");
    }

    @Override
    public boolean isFile() {
        return !this.isDirectory();
    }

    @Override
    public boolean isDirectory() {
        return this.derivedArtifact.getSourceArtifact() instanceof FolderArtifact;
    }

    @Override
    public boolean isResolved() {
        return this.resolvedFile != null;
    }
}

