/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.management.MBeanServer;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQDeleteAddressException;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQQueueExistsException;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryImpl;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.ConfigurationUtils;
import org.apache.activemq.artemis.core.config.CoreAddressConfiguration;
import org.apache.activemq.artemis.core.config.CoreQueueConfiguration;
import org.apache.activemq.artemis.core.config.DivertConfiguration;
import org.apache.activemq.artemis.core.config.FederationConfiguration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.StoreConfiguration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.config.impl.LegacyJMSConfiguration;
import org.apache.activemq.artemis.core.config.storage.DatabaseStorageConfiguration;
import org.apache.activemq.artemis.core.deployers.impl.FileConfigurationParser;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.filter.impl.FilterImpl;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.aio.AIOSequentialFileFactory;
import org.apache.activemq.artemis.core.journal.JournalLoadInformation;
import org.apache.activemq.artemis.core.management.impl.ActiveMQServerControlImpl;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.PagingStoreFactory;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.paging.impl.PagingManagerImpl;
import org.apache.activemq.artemis.core.paging.impl.PagingStoreFactoryDatabase;
import org.apache.activemq.artemis.core.paging.impl.PagingStoreFactoryNIO;
import org.apache.activemq.artemis.core.persistence.AddressBindingInfo;
import org.apache.activemq.artemis.core.persistence.GroupingInfo;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.persistence.QueueBindingInfo;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.config.PersistedAddressSetting;
import org.apache.activemq.artemis.core.persistence.config.PersistedRoles;
import org.apache.activemq.artemis.core.persistence.impl.PageCountPending;
import org.apache.activemq.artemis.core.persistence.impl.journal.JDBCJournalStorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.JournalStorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.OperationContextImpl;
import org.apache.activemq.artemis.core.persistence.impl.nullpm.NullStorageManager;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.BindingType;
import org.apache.activemq.artemis.core.postoffice.Bindings;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.postoffice.impl.DivertBinding;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.core.postoffice.impl.PostOfficeImpl;
import org.apache.activemq.artemis.core.remoting.server.RemotingService;
import org.apache.activemq.artemis.core.remoting.server.impl.RemotingServiceImpl;
import org.apache.activemq.artemis.core.replication.ReplicationEndpoint;
import org.apache.activemq.artemis.core.replication.ReplicationManager;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.security.SecurityAuth;
import org.apache.activemq.artemis.core.security.SecurityStore;
import org.apache.activemq.artemis.core.security.impl.SecurityStoreImpl;
import org.apache.activemq.artemis.core.server.ActivateCallback;
import org.apache.activemq.artemis.core.server.ActivationFailureListener;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.AddressQueryResult;
import org.apache.activemq.artemis.core.server.Bindable;
import org.apache.activemq.artemis.core.server.BindingQueryResult;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.core.server.LoggingConfigurationFileReloader;
import org.apache.activemq.artemis.core.server.MemoryManager;
import org.apache.activemq.artemis.core.server.NetworkHealthCheck;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.PostQueueCreationCallback;
import org.apache.activemq.artemis.core.server.PostQueueDeletionCallback;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.QueueConfig;
import org.apache.activemq.artemis.core.server.QueueFactory;
import org.apache.activemq.artemis.core.server.QueueQueryResult;
import org.apache.activemq.artemis.core.server.SecuritySettingPlugin;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.ServiceComponent;
import org.apache.activemq.artemis.core.server.ServiceRegistry;
import org.apache.activemq.artemis.core.server.cluster.BackupManager;
import org.apache.activemq.artemis.core.server.cluster.ClusterManager;
import org.apache.activemq.artemis.core.server.cluster.ha.HAPolicy;
import org.apache.activemq.artemis.core.server.federation.FederationManager;
import org.apache.activemq.artemis.core.server.files.FileMoveManager;
import org.apache.activemq.artemis.core.server.files.FileStoreMonitor;
import org.apache.activemq.artemis.core.server.group.GroupingHandler;
import org.apache.activemq.artemis.core.server.group.impl.GroupHandlingAbstract;
import org.apache.activemq.artemis.core.server.group.impl.GroupingHandlerConfiguration;
import org.apache.activemq.artemis.core.server.group.impl.LocalGroupingHandler;
import org.apache.activemq.artemis.core.server.group.impl.RemoteGroupingHandler;
import org.apache.activemq.artemis.core.server.impl.Activation;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.impl.ConnectorsService;
import org.apache.activemq.artemis.core.server.impl.DivertImpl;
import org.apache.activemq.artemis.core.server.impl.FileLockNodeManager;
import org.apache.activemq.artemis.core.server.impl.InVMNodeManager;
import org.apache.activemq.artemis.core.server.impl.JournalLoader;
import org.apache.activemq.artemis.core.server.impl.QueueFactoryImpl;
import org.apache.activemq.artemis.core.server.impl.QueueManagerImpl;
import org.apache.activemq.artemis.core.server.impl.ServerInfo;
import org.apache.activemq.artemis.core.server.impl.ServerSessionImpl;
import org.apache.activemq.artemis.core.server.impl.ServiceRegistryImpl;
import org.apache.activemq.artemis.core.server.impl.SharedNothingBackupActivation;
import org.apache.activemq.artemis.core.server.impl.SharedNothingLiveActivation;
import org.apache.activemq.artemis.core.server.impl.TransientQueueManagerImpl;
import org.apache.activemq.artemis.core.server.impl.jdbc.JdbcNodeManager;
import org.apache.activemq.artemis.core.server.management.ManagementService;
import org.apache.activemq.artemis.core.server.management.impl.ManagementServiceImpl;
import org.apache.activemq.artemis.core.server.metrics.MetricsManager;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQPluginRunnable;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerAddressPlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBasePlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBindingPlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBridgePlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerConnectionPlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerConsumerPlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerCriticalPlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerMessagePlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerQueuePlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerSessionPlugin;
import org.apache.activemq.artemis.core.server.reload.ReloadCallback;
import org.apache.activemq.artemis.core.server.reload.ReloadManager;
import org.apache.activemq.artemis.core.server.reload.ReloadManagerImpl;
import org.apache.activemq.artemis.core.server.transformer.Transformer;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.settings.impl.DeletionPolicy;
import org.apache.activemq.artemis.core.settings.impl.HierarchicalObjectRepository;
import org.apache.activemq.artemis.core.settings.impl.ResourceLimitSettings;
import org.apache.activemq.artemis.core.transaction.ResourceManager;
import org.apache.activemq.artemis.core.transaction.impl.ResourceManagerImpl;
import org.apache.activemq.artemis.core.version.Version;
import org.apache.activemq.artemis.logs.AuditLogger;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManagerFactory;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.protocol.SessionCallback;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.apache.activemq.artemis.utils.ActiveMQThreadPoolExecutor;
import org.apache.activemq.artemis.utils.CompositeAddress;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.apache.activemq.artemis.utils.SecurityFormatter;
import org.apache.activemq.artemis.utils.ThreadDumpUtil;
import org.apache.activemq.artemis.utils.TimeUtils;
import org.apache.activemq.artemis.utils.VersionLoader;
import org.apache.activemq.artemis.utils.actors.OrderedExecutorFactory;
import org.apache.activemq.artemis.utils.collections.ConcurrentHashSet;
import org.apache.activemq.artemis.utils.critical.CriticalAction;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzer;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzerImpl;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzerPolicy;
import org.apache.activemq.artemis.utils.critical.CriticalComponent;
import org.apache.activemq.artemis.utils.critical.EmptyCriticalAnalyzer;
import org.jboss.logging.Logger;

public class ActiveMQServerImpl
implements ActiveMQServer {
    private static final Logger logger = Logger.getLogger(ActiveMQServerImpl.class);
    public static final String INTERNAL_NAMING_PREFIX = "$.artemis.internal";
    @Deprecated
    public static final String GENERIC_IGNORED_FILTER = "__AMQX=-1";
    private HAPolicy haPolicy;
    private volatile ActiveMQServer.SERVER_STATE state = ActiveMQServer.SERVER_STATE.STOPPED;
    private final Version version;
    private final ActiveMQSecurityManager securityManager;
    private final Configuration configuration;
    private final AtomicBoolean configurationReloadDeployed;
    private MBeanServer mbeanServer;
    private volatile SecurityStore securityStore;
    private final HierarchicalRepository<AddressSettings> addressSettingsRepository;
    private volatile QueueFactory queueFactory;
    private volatile PagingManager pagingManager;
    private volatile PostOffice postOffice;
    private volatile ExecutorService threadPool;
    protected volatile ScheduledExecutorService scheduledPool;
    protected volatile ExecutorFactory executorFactory;
    private volatile ExecutorService ioExecutorPool;
    protected volatile ExecutorFactory ioExecutorFactory;
    private final NetworkHealthCheck networkHealthCheck = new NetworkHealthCheck(ActiveMQDefaultConfiguration.getDefaultNetworkCheckNic(), ActiveMQDefaultConfiguration.getDefaultNetworkCheckPeriod(), ActiveMQDefaultConfiguration.getDefaultNetworkCheckTimeout());
    private final HierarchicalRepository<Set<Role>> securityRepository;
    private volatile ResourceManager resourceManager;
    private volatile MetricsManager metricsManager;
    private volatile ActiveMQServerControlImpl messagingServerControl;
    private volatile ClusterManager clusterManager;
    private volatile BackupManager backupManager;
    private volatile StorageManager storageManager;
    private volatile RemotingService remotingService;
    private final List<ProtocolManagerFactory> protocolManagerFactories = new ArrayList<ProtocolManagerFactory>();
    private volatile ManagementService managementService;
    private volatile ConnectorsService connectorsService;
    private MemoryManager memoryManager;
    private ReloadManager reloadManager;
    private FileStoreMonitor fileStoreMonitor;
    private final Map<String, ServerSession> sessions = new ConcurrentHashMap<String, ServerSession>();
    private final Semaphore activationLock = new Semaphore(1);
    private final ReusableLatch activationLatch = new ReusableLatch(0);
    private final Set<ActivateCallback> activateCallbacks = new ConcurrentHashSet();
    private final Set<ActivationFailureListener> activationFailureListeners = new ConcurrentHashSet();
    private final Set<PostQueueCreationCallback> postQueueCreationCallbacks = new ConcurrentHashSet();
    private final Set<PostQueueDeletionCallback> postQueueDeletionCallbacks = new ConcurrentHashSet();
    private volatile GroupingHandler groupingHandler;
    private NodeManager nodeManager;
    private String identity;
    private Thread activationThread;
    private Activation activation;
    private final Map<String, Object> activationParams = new HashMap<String, Object>();
    protected final ShutdownOnCriticalErrorListener shutdownOnCriticalIO = new ShutdownOnCriticalErrorListener();
    private final ActiveMQServer parentServer;
    private CriticalAnalyzer analyzer;
    private Runnable afterActivationCreated;
    private final List<SimpleString> scaledDownNodeIDs = new ArrayList<SimpleString>();
    private boolean threadPoolSupplied = false;
    private boolean scheduledPoolSupplied = false;
    private final ServiceRegistry serviceRegistry;
    private Date startDate;
    private final List<ActiveMQComponent> externalComponents = new ArrayList<ActiveMQComponent>();
    private final ConcurrentMap<String, AtomicInteger> connectedClientIds = new ConcurrentHashMap<String, AtomicInteger>();
    private volatile FederationManager federationManager;
    private final ActiveMQComponent networkCheckMonitor = new ActiveMQComponent(){

        public void start() throws Exception {
            ActiveMQServerImpl.this.internalStart();
        }

        public void stop() throws Exception {
            ActiveMQServerImpl.this.stop(false);
        }

        public String toString() {
            return ActiveMQServerImpl.this.toString();
        }

        public boolean isStarted() {
            return ActiveMQServerImpl.this.isStarted();
        }
    };

    public ActiveMQServerImpl() {
        this(null, null, null);
    }

    public ActiveMQServerImpl(Configuration configuration) {
        this(configuration, null, null);
    }

    public ActiveMQServerImpl(Configuration configuration, ActiveMQServer parentServer) {
        this(configuration, null, null, parentServer);
    }

    public ActiveMQServerImpl(Configuration configuration, MBeanServer mbeanServer) {
        this(configuration, mbeanServer, null);
    }

    public ActiveMQServerImpl(Configuration configuration, ActiveMQSecurityManager securityManager) {
        this(configuration, null, securityManager);
    }

    public ActiveMQServerImpl(Configuration configuration, MBeanServer mbeanServer, ActiveMQSecurityManager securityManager) {
        this(configuration, mbeanServer, securityManager, null);
    }

    public ActiveMQServerImpl(Configuration configuration, MBeanServer mbeanServer, ActiveMQSecurityManager securityManager, ActiveMQServer parentServer) {
        this(configuration, mbeanServer, securityManager, parentServer, null);
    }

    public ActiveMQServerImpl(Configuration configuration, MBeanServer mbeanServer, ActiveMQSecurityManager securityManager, ActiveMQServer parentServer, ServiceRegistry serviceRegistry) {
        if (configuration == null) {
            configuration = new ConfigurationImpl();
        } else {
            ConfigurationUtils.validateConfiguration(configuration);
        }
        if (mbeanServer == null) {
            mbeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        this.version = VersionLoader.getVersion();
        this.configuration = configuration;
        this.configurationReloadDeployed = new AtomicBoolean(true);
        this.mbeanServer = mbeanServer;
        this.securityManager = securityManager;
        this.addressSettingsRepository = new HierarchicalObjectRepository<AddressSettings>(configuration.getWildcardConfiguration(), new HierarchicalObjectRepository.MatchModifier(){

            @Override
            public String modify(String input) {
                return CompositeAddress.extractAddressName((String)input);
            }
        });
        this.addressSettingsRepository.setDefault(new AddressSettings());
        this.securityRepository = new HierarchicalObjectRepository<Set<Role>>(configuration.getWildcardConfiguration());
        this.securityRepository.setDefault(new HashSet());
        this.parentServer = parentServer;
        this.serviceRegistry = serviceRegistry == null ? new ServiceRegistryImpl() : serviceRegistry;
    }

    @Override
    public ReloadManager getReloadManager() {
        return this.reloadManager;
    }

    @Override
    public NetworkHealthCheck getNetworkHealthCheck() {
        return this.networkHealthCheck;
    }

    public Runnable getAfterActivationCreated() {
        return this.afterActivationCreated;
    }

    public ActiveMQServerImpl setAfterActivationCreated(Runnable afterActivationCreated) {
        this.afterActivationCreated = afterActivationCreated;
        return this;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected NodeManager createNodeManager(File directory, boolean replicatingBackup) {
        void var3_8;
        if (!this.configuration.isPersistenceEnabled()) {
            InVMNodeManager inVMNodeManager = new InVMNodeManager(replicatingBackup);
            return var3_8;
        } else if (this.configuration.getStoreConfiguration() != null && this.configuration.getStoreConfiguration().getStoreType() == StoreConfiguration.StoreType.DATABASE) {
            HAPolicyConfiguration.TYPE haType;
            HAPolicyConfiguration.TYPE tYPE = haType = this.configuration.getHAPolicyConfiguration() == null ? null : this.configuration.getHAPolicyConfiguration().getType();
            if (haType == HAPolicyConfiguration.TYPE.SHARED_STORE_MASTER || haType == HAPolicyConfiguration.TYPE.SHARED_STORE_SLAVE) {
                if (replicatingBackup) {
                    throw new IllegalArgumentException("replicatingBackup is not supported yet while using JDBC persistence");
                }
                DatabaseStorageConfiguration dbConf = (DatabaseStorageConfiguration)this.configuration.getStoreConfiguration();
                JdbcNodeManager jdbcNodeManager = JdbcNodeManager.with(dbConf, this.scheduledPool, this.executorFactory, this.shutdownOnCriticalIO);
                return var3_8;
            } else {
                if (haType != null && haType != HAPolicyConfiguration.TYPE.LIVE_ONLY) throw new IllegalArgumentException("JDBC persistence allows only Shared Store HA options");
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Detected no Shared Store HA options on JDBC store");
                }
                FileLockNodeManager fileLockNodeManager = new FileLockNodeManager(directory, replicatingBackup, this.configuration.getJournalLockAcquisitionTimeout());
            }
            return var3_8;
        } else {
            FileLockNodeManager fileLockNodeManager = new FileLockNodeManager(directory, replicatingBackup, this.configuration.getJournalLockAcquisitionTimeout());
        }
        return var3_8;
    }

    @Override
    public OperationContext newOperationContext() {
        return this.getStorageManager().newContext((Executor)this.getExecutorFactory().getExecutor());
    }

    public final synchronized void start() throws Exception {
        ActiveMQServer.SERVER_STATE originalState = this.state;
        try {
            this.internalStart();
        }
        catch (Throwable t) {
            ActiveMQServerLogger.LOGGER.failedToStartServer(t);
        }
        finally {
            if (originalState == ActiveMQServer.SERVER_STATE.STOPPED) {
                this.networkHealthCheck.setTimeUnit(TimeUnit.MILLISECONDS).setPeriod(this.configuration.getNetworkCheckPeriod()).setNetworkTimeout(this.configuration.getNetworkCheckTimeout()).parseAddressList(this.configuration.getNetworkCheckList()).parseURIList(this.configuration.getNetworkCheckURLList()).setNICName(this.configuration.getNetworkCheckNIC()).setIpv4Command(this.configuration.getNetworkCheckPingCommand()).setIpv6Command(this.configuration.getNetworkCheckPing6Command());
                this.networkHealthCheck.addComponent(this.networkCheckMonitor);
            }
        }
    }

    @Override
    public CriticalAnalyzer getCriticalAnalyzer() {
        return this.analyzer;
    }

    private void internalStart() throws Exception {
        if (this.state != ActiveMQServer.SERVER_STATE.STOPPED) {
            logger.debug((Object)"Server already started!");
            return;
        }
        this.configuration.parseSystemProperties();
        this.initializeExecutorServices();
        this.initializeCriticalAnalyzer();
        this.startDate = new Date();
        this.state = ActiveMQServer.SERVER_STATE.STARTING;
        if (this.haPolicy == null) {
            this.haPolicy = ConfigurationUtils.getHAPolicy(this.configuration.getHAPolicyConfiguration(), this);
        }
        this.activationLatch.setCount(1);
        logger.debug((Object)("Starting server " + this));
        OperationContextImpl.clearContext();
        try {
            boolean wasLive;
            this.checkJournalDirectory();
            this.nodeManager = this.createNodeManager(this.configuration.getNodeManagerLockLocation(), false);
            this.nodeManager.start();
            ActiveMQServerLogger.LOGGER.serverStarting(this.haPolicy.isBackup() ? "backup" : "live", this.configuration);
            boolean bl = wasLive = !this.haPolicy.isBackup();
            if (!this.haPolicy.isBackup()) {
                this.activation = this.haPolicy.createActivation(this, false, this.activationParams, this.shutdownOnCriticalIO);
                if (this.afterActivationCreated != null) {
                    try {
                        this.afterActivationCreated.run();
                    }
                    catch (Throwable e) {
                        logger.warn((Object)e.getMessage(), e);
                    }
                    this.afterActivationCreated = null;
                }
                if (this.haPolicy.isWaitForActivation()) {
                    this.activation.run();
                } else {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)"starting activation");
                    }
                    this.activationThread = new ActivationThread((Runnable)this.activation, ActiveMQMessageBundle.BUNDLE.activationForServer(this));
                    this.activationThread.start();
                }
            }
            if (this.haPolicy.isBackup()) {
                this.activation = this.haPolicy.isSharedStore() ? this.haPolicy.createActivation(this, false, this.activationParams, this.shutdownOnCriticalIO) : this.haPolicy.createActivation(this, wasLive, this.activationParams, this.shutdownOnCriticalIO);
                if (this.afterActivationCreated != null) {
                    try {
                        this.afterActivationCreated.run();
                    }
                    catch (Throwable e) {
                        logger.warn((Object)e.getMessage(), e);
                    }
                    this.afterActivationCreated = null;
                }
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"starting backupActivation");
                }
                this.activationThread = new ActivationThread((Runnable)this.activation, ActiveMQMessageBundle.BUNDLE.activationForServer(this));
                this.activationThread.start();
            } else {
                ActiveMQServerLogger.LOGGER.serverStarted(this.getVersion().getFullVersion(), this.configuration.getName(), this.nodeManager.getNodeId(), this.identity != null ? this.identity : "");
            }
            this.connectorsService = new ConnectorsService(this.configuration, this.storageManager, this.scheduledPool, this.postOffice, this.serviceRegistry);
            this.connectorsService.start();
        }
        finally {
            OperationContextImpl.clearContext();
        }
    }

    private void initializeCriticalAnalyzer() throws Exception {
        Object analyzer = this.getCriticalAnalyzer();
        if (analyzer == null) {
            analyzer = this.configuration.isCriticalAnalyzer() ? new CriticalAnalyzerImpl() : EmptyCriticalAnalyzer.getInstance();
            this.analyzer = analyzer;
        }
        analyzer.clear();
        analyzer.setCheckTime(this.configuration.getCriticalAnalyzerCheckPeriod(), TimeUnit.MILLISECONDS).setTimeout(this.configuration.getCriticalAnalyzerTimeout(), TimeUnit.MILLISECONDS);
        if (this.configuration.isCriticalAnalyzer()) {
            analyzer.start();
        }
        CriticalAction criticalAction = null;
        CriticalAnalyzerPolicy criticalAnalyzerPolicy = this.configuration.getCriticalAnalyzerPolicy();
        switch (criticalAnalyzerPolicy) {
            case HALT: {
                criticalAction = criticalComponent -> {
                    ActiveMQServerLogger.LOGGER.criticalSystemHalt(criticalComponent);
                    this.threadDump();
                    this.sendCriticalNotification(criticalComponent);
                    Runtime.getRuntime().halt(70);
                };
                break;
            }
            case SHUTDOWN: {
                criticalAction = criticalComponent -> {
                    ActiveMQServerLogger.LOGGER.criticalSystemShutdown(criticalComponent);
                    this.threadDump();
                    this.sendCriticalNotification(criticalComponent);
                    Thread stopThread = new Thread(){

                        @Override
                        public void run() {
                            try {
                                ActiveMQServerImpl.this.stop();
                            }
                            catch (Throwable e) {
                                logger.warn((Object)e.getMessage(), e);
                            }
                        }
                    };
                    stopThread.start();
                };
                break;
            }
            case LOG: {
                criticalAction = criticalComponent -> {
                    ActiveMQServerLogger.LOGGER.criticalSystemLog(criticalComponent);
                    this.threadDump();
                    this.sendCriticalNotification(criticalComponent);
                };
            }
        }
        analyzer.addAction(criticalAction);
    }

    private void sendCriticalNotification(final CriticalComponent criticalComponent) {
        long timeout = this.configuration.getGracefulShutdownTimeout() < 0L ? 30000L : this.configuration.getGracefulShutdownTimeout();
        Thread notificationSender = new Thread(){

            @Override
            public void run() {
                try {
                    if (ActiveMQServerImpl.this.hasBrokerCriticalPlugins()) {
                        ActiveMQServerImpl.this.callBrokerCriticalPlugins(plugin -> plugin.criticalFailure(criticalComponent));
                    }
                }
                catch (Throwable e) {
                    logger.warn((Object)e.getMessage(), e);
                }
            }
        };
        notificationSender.start();
        try {
            notificationSender.join(timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public ReplicationEndpoint getReplicationEndpoint() {
        if (this.activation instanceof SharedNothingBackupActivation) {
            return ((SharedNothingBackupActivation)this.activation).getReplicationEndpoint();
        }
        return null;
    }

    @Override
    public void unlockActivation() {
        this.activationLock.release();
    }

    @Override
    public void lockActivation() {
        try {
            this.activationLock.acquire();
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.unableToAcquireLock(e);
        }
    }

    @Override
    public void setState(ActiveMQServer.SERVER_STATE state) {
        this.state = state;
    }

    @Override
    public ActiveMQServer.SERVER_STATE getState() {
        return this.state;
    }

    public void interruptActivationThread(NodeManager nodeManagerInUse) throws InterruptedException {
        long timeout = 30000L;
        long start = System.currentTimeMillis();
        while (this.activationThread.isAlive() && System.currentTimeMillis() - start < timeout) {
            if (nodeManagerInUse != null) {
                nodeManagerInUse.interrupt();
            }
            this.activationThread.interrupt();
            this.activationThread.join(1000L);
        }
        if (System.currentTimeMillis() - start >= timeout) {
            ActiveMQServerLogger.LOGGER.activationTimeout();
            this.threadDump();
        }
    }

    public void resetNodeManager() throws Exception {
        if (this.nodeManager != null) {
            this.nodeManager.stop();
        }
        this.nodeManager = this.createNodeManager(this.configuration.getNodeManagerLockLocation(), true);
    }

    @Override
    public Activation getActivation() {
        return this.activation;
    }

    @Override
    public HAPolicy getHAPolicy() {
        return this.haPolicy;
    }

    @Override
    public void setHAPolicy(HAPolicy haPolicy) {
        if (logger.isTraceEnabled()) {
            logger.tracef("XXX @@@ Setting %s, isBackup=%s at %s", (Object)haPolicy, (Object)haPolicy.isBackup(), (Object)this);
        }
        this.haPolicy = haPolicy;
    }

    @Override
    public void setMBeanServer(MBeanServer mbeanServer) {
        if (this.state == ActiveMQServer.SERVER_STATE.STARTING || this.state == ActiveMQServer.SERVER_STATE.STARTED) {
            throw ActiveMQMessageBundle.BUNDLE.cannotSetMBeanserver();
        }
        this.mbeanServer = mbeanServer;
    }

    @Override
    public void addExternalComponent(ActiveMQComponent externalComponent) {
        this.externalComponents.add(externalComponent);
    }

    @Override
    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public void setActivation(SharedNothingLiveActivation activation) {
        this.activation = activation;
    }

    public final void stopTheServer(final boolean criticalIOError) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    ActiveMQServerImpl.this.stop(false, criticalIOError, false);
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.errorStoppingServer(e);
                }
            }
        };
        thread.start();
    }

    public void stop() throws Exception {
        this.stop(true);
    }

    public void stop(boolean isShutdown) throws Exception {
        try {
            this.stop(false, isShutdown);
        }
        finally {
            if (isShutdown) {
                this.networkHealthCheck.stop();
            }
        }
    }

    @Override
    public void addActivationParam(String key, Object val) {
        this.activationParams.put(key, val);
    }

    @Override
    public boolean isAddressBound(String address) throws Exception {
        return this.postOffice.isAddressBound(SimpleString.toSimpleString((String)address));
    }

    @Override
    public BindingQueryResult bindingQuery(SimpleString address, boolean newFQQN) throws Exception {
        if (address == null) {
            throw ActiveMQMessageBundle.BUNDLE.addressIsNull();
        }
        SimpleString realAddress = CompositeAddress.extractAddressName((SimpleString)address);
        AddressSettings addressSettings = this.getAddressSettingsRepository().getMatch(realAddress.toString());
        boolean autoCreateQeueus = addressSettings.isAutoCreateQueues();
        boolean autoCreateAddresses = addressSettings.isAutoCreateAddresses();
        boolean defaultPurgeOnNoConsumers = addressSettings.isDefaultPurgeOnNoConsumers();
        int defaultMaxConsumers = addressSettings.getDefaultMaxConsumers();
        boolean defaultExclusive = addressSettings.isDefaultExclusiveQueue();
        boolean defaultLastValue = addressSettings.isDefaultLastValueQueue();
        SimpleString defaultLastValueKey = addressSettings.getDefaultLastValueKey();
        boolean defaultNonDestructive = addressSettings.isDefaultNonDestructive();
        int defaultConsumersBeforeDispatch = addressSettings.getDefaultConsumersBeforeDispatch();
        long defaultDelayBeforeDispatch = addressSettings.getDefaultDelayBeforeDispatch();
        ArrayList<SimpleString> names = new ArrayList<SimpleString>();
        ManagementService managementService = this.getManagementService();
        if (managementService != null && realAddress.equals((Object)managementService.getManagementAddress())) {
            return new BindingQueryResult(true, null, names, autoCreateQeueus, autoCreateAddresses, defaultPurgeOnNoConsumers, defaultMaxConsumers, defaultExclusive, defaultLastValue, defaultLastValueKey, defaultNonDestructive, defaultConsumersBeforeDispatch, defaultDelayBeforeDispatch);
        }
        Bindings bindings = this.getPostOffice().getMatchingBindings(realAddress);
        for (Binding binding : bindings.getBindings()) {
            if (binding.getType() != BindingType.LOCAL_QUEUE && binding.getType() != BindingType.REMOTE_QUEUE) continue;
            SimpleString name = !newFQQN && CompositeAddress.isFullyQualified((String)address.toString()) ? CompositeAddress.toFullyQualified((SimpleString)realAddress, (SimpleString)binding.getUniqueName()) : binding.getUniqueName();
            names.add(name);
        }
        AddressInfo info = this.getAddressInfo(realAddress);
        return new BindingQueryResult(info != null, info, names, autoCreateQeueus, autoCreateAddresses, defaultPurgeOnNoConsumers, defaultMaxConsumers, defaultExclusive, defaultLastValue, defaultLastValueKey, defaultNonDestructive, defaultConsumersBeforeDispatch, defaultDelayBeforeDispatch);
    }

    @Override
    public QueueQueryResult queueQuery(SimpleString name) {
        QueueQueryResult response;
        SimpleString managementAddress;
        if (name == null) {
            throw ActiveMQMessageBundle.BUNDLE.queueNameIsNull();
        }
        SimpleString realName = CompositeAddress.extractQueueName((SimpleString)name);
        Binding binding = this.getPostOffice().getBinding(realName);
        SimpleString addressName = binding != null && binding.getType() == BindingType.LOCAL_QUEUE ? binding.getAddress() : CompositeAddress.extractAddressName((SimpleString)name);
        AddressSettings addressSettings = this.getAddressSettingsRepository().getMatch(addressName.toString());
        boolean autoCreateQueues = addressSettings.isAutoCreateQueues();
        boolean defaultPurgeOnNoConsumers = addressSettings.isDefaultPurgeOnNoConsumers();
        int defaultMaxConsumers = addressSettings.getDefaultMaxConsumers();
        boolean defaultExclusiveQueue = addressSettings.isDefaultExclusiveQueue();
        boolean defaultLastValueQueue = addressSettings.isDefaultLastValueQueue();
        SimpleString defaultLastValueKey = addressSettings.getDefaultLastValueKey();
        boolean defaultNonDestructive = addressSettings.isDefaultNonDestructive();
        int defaultConsumersBeforeDispatch = addressSettings.getDefaultConsumersBeforeDispatch();
        long defaultDelayBeforeDispatch = addressSettings.getDefaultDelayBeforeDispatch();
        int defaultConsumerWindowSize = addressSettings.getDefaultConsumerWindowSize();
        boolean defaultGroupRebalance = addressSettings.isDefaultGroupRebalance();
        int defaultGroupBuckets = addressSettings.getDefaultGroupBuckets();
        SimpleString defaultGroupFirstKey = addressSettings.getDefaultGroupFirstKey();
        long autoDeleteQueuesDelay = addressSettings.getAutoDeleteQueuesDelay();
        long autoDeleteQueuesMessageCount = addressSettings.getAutoDeleteQueuesMessageCount();
        SimpleString simpleString = managementAddress = this.getManagementService() != null ? this.getManagementService().getManagementAddress() : null;
        if (binding != null && binding.getType() == BindingType.LOCAL_QUEUE) {
            Queue queue = (Queue)binding.getBindable();
            Filter filter = queue.getFilter();
            SimpleString filterString = filter == null ? null : filter.getFilterString();
            response = new QueueQueryResult(realName, binding.getAddress(), queue.isDurable(), queue.isTemporary(), filterString, queue.getConsumerCount(), queue.getMessageCount(), autoCreateQueues, true, queue.isAutoCreated(), queue.isPurgeOnNoConsumers(), queue.getRoutingType(), queue.getMaxConsumers(), Boolean.valueOf(queue.isExclusive()), Boolean.valueOf(queue.isGroupRebalance()), Integer.valueOf(queue.getGroupBuckets()), queue.getGroupFirstKey(), Boolean.valueOf(queue.isLastValue()), queue.getLastValueKey(), Boolean.valueOf(queue.isNonDestructive()), Integer.valueOf(queue.getConsumersBeforeDispatch()), Long.valueOf(queue.getDelayBeforeDispatch()), Boolean.valueOf(queue.isAutoDelete()), Long.valueOf(queue.getAutoDeleteDelay()), Long.valueOf(queue.getAutoDeleteMessageCount()), Integer.valueOf(defaultConsumerWindowSize));
        } else {
            response = realName.equals((Object)managementAddress) ? new QueueQueryResult(realName, managementAddress, true, false, null, -1, -1L, autoCreateQueues, true, false, false, RoutingType.MULTICAST, -1, Boolean.valueOf(false), Boolean.valueOf(false), null, null, null, null, null, null, null, null, null, null, Integer.valueOf(defaultConsumerWindowSize)) : new QueueQueryResult(realName, addressName, true, false, null, 0, 0L, autoCreateQueues, false, false, defaultPurgeOnNoConsumers, RoutingType.MULTICAST, defaultMaxConsumers, Boolean.valueOf(defaultExclusiveQueue), Boolean.valueOf(defaultGroupRebalance), Integer.valueOf(defaultGroupBuckets), defaultGroupFirstKey, Boolean.valueOf(defaultLastValueQueue), defaultLastValueKey, Boolean.valueOf(defaultNonDestructive), Integer.valueOf(defaultConsumersBeforeDispatch), Long.valueOf(defaultDelayBeforeDispatch), Boolean.valueOf(ActiveMQServerImpl.isAutoDelete(false, addressSettings)), Long.valueOf(autoDeleteQueuesDelay), Long.valueOf(autoDeleteQueuesMessageCount), Integer.valueOf(defaultConsumerWindowSize));
        }
        return response;
    }

    @Override
    public AddressQueryResult addressQuery(SimpleString name) throws Exception {
        if (name == null) {
            throw ActiveMQMessageBundle.BUNDLE.queueNameIsNull();
        }
        SimpleString realName = CompositeAddress.extractAddressName((SimpleString)name);
        AddressSettings addressSettings = this.getAddressSettingsRepository().getMatch(realName.toString());
        boolean autoCreateAddresses = addressSettings.isAutoCreateAddresses();
        boolean defaultPurgeOnNoConsumers = addressSettings.isDefaultPurgeOnNoConsumers();
        int defaultMaxConsumers = addressSettings.getDefaultMaxConsumers();
        AddressInfo addressInfo = this.postOffice.getAddressInfo(realName);
        AddressQueryResult response = addressInfo != null ? new AddressQueryResult(addressInfo.getName(), addressInfo.getRoutingTypes(), addressInfo.getId(), addressInfo.isAutoCreated(), true, autoCreateAddresses, defaultPurgeOnNoConsumers, defaultMaxConsumers) : new AddressQueryResult(realName, null, -1L, false, false, autoCreateAddresses, defaultPurgeOnNoConsumers, defaultMaxConsumers);
        return response;
    }

    @Override
    public void threadDump() {
        ActiveMQServerLogger.LOGGER.threadDump(ThreadDumpUtil.threadDump((String)""));
    }

    @Override
    public final void fail(boolean failoverOnServerShutdown) throws Exception {
        this.stop(failoverOnServerShutdown, false, false, false);
    }

    @Override
    public final void stop(boolean failoverOnServerShutdown, boolean isExit) throws Exception {
        this.stop(failoverOnServerShutdown, false, false, isExit);
    }

    @Override
    public boolean isReplicaSync() {
        if (this.activation instanceof SharedNothingLiveActivation) {
            ReplicationManager replicationManager = this.getReplicationManager();
            if (replicationManager == null) {
                return false;
            }
            return !replicationManager.isSynchronizing();
        }
        if (this.activation instanceof SharedNothingBackupActivation) {
            return ((SharedNothingBackupActivation)this.activation).isRemoteBackupUpToDate();
        }
        return false;
    }

    public void stop(boolean failoverOnServerShutdown, boolean criticalIOError, boolean restarting) {
        this.stop(failoverOnServerShutdown, criticalIOError, restarting, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop(boolean failoverOnServerShutdown, boolean criticalIOError, boolean restarting, boolean isShutdown) {
        logger.debug((Object)"Stopping server");
        ActiveMQServerImpl activeMQServerImpl = this;
        synchronized (activeMQServerImpl) {
            if (this.state == ActiveMQServer.SERVER_STATE.STOPPED || this.state == ActiveMQServer.SERVER_STATE.STOPPING) {
                return;
            }
            this.state = ActiveMQServer.SERVER_STATE.STOPPING;
            if (this.fileStoreMonitor != null) {
                this.fileStoreMonitor.stop();
                this.fileStoreMonitor = null;
            }
            if (failoverOnServerShutdown) {
                this.activation.sendLiveIsStopping();
            }
            ActiveMQServerImpl.stopComponent(this.connectorsService);
            if (this.groupingHandler != null) {
                this.managementService.removeNotificationListener(this.groupingHandler);
                ActiveMQServerImpl.stopComponent(this.groupingHandler);
            }
            ActiveMQServerImpl.stopComponent(this.federationManager);
            ActiveMQServerImpl.stopComponent(this.clusterManager);
            if (this.remotingService != null) {
                this.remotingService.pauseAcceptors();
            }
            if (this.remotingService != null && this.configuration.isGracefulShutdownEnabled()) {
                long timeout = this.configuration.getGracefulShutdownTimeout();
                try {
                    if (timeout == -1L) {
                        this.remotingService.getConnectionCountLatch().await();
                    } else {
                        this.remotingService.getConnectionCountLatch().await(timeout);
                    }
                }
                catch (InterruptedException e) {
                    ActiveMQServerLogger.LOGGER.interruptWhilstStoppingComponent(this.remotingService.getClass().getName());
                }
            }
            this.freezeConnections();
        }
        this.activation.postConnectionFreeze();
        this.closeAllServerSessions(criticalIOError);
        if (this.storageManager != null) {
            this.storageManager.clearContext();
        }
        this.callDeActiveCallbacks();
        ActiveMQServerImpl.stopComponent(this.backupManager);
        try {
            this.activation.preStorageClose();
        }
        catch (Throwable t) {
            ActiveMQServerLogger.LOGGER.errorStoppingComponent(t, this.activation.getClass().getName());
        }
        ActiveMQServerImpl.stopComponent(this.pagingManager);
        if (this.storageManager != null) {
            try {
                this.storageManager.stop(criticalIOError, failoverOnServerShutdown);
            }
            catch (Throwable t) {
                ActiveMQServerLogger.LOGGER.errorStoppingComponent(t, this.storageManager.getClass().getName());
            }
        }
        if (this.remotingService != null) {
            try {
                this.remotingService.stop(criticalIOError);
            }
            catch (Throwable t) {
                ActiveMQServerLogger.LOGGER.errorStoppingComponent(t, this.remotingService.getClass().getName());
            }
        }
        if (this.managementService != null) {
            try {
                this.managementService.unregisterServer();
            }
            catch (Throwable t) {
                ActiveMQServerLogger.LOGGER.errorStoppingComponent(t, this.managementService.getClass().getName());
            }
        }
        ActiveMQServerImpl.stopComponent(this.managementService);
        this.unregisterMeters();
        ActiveMQServerImpl.stopComponent(this.resourceManager);
        ActiveMQServerImpl.stopComponent(this.postOffice);
        if (this.scheduledPool != null && !this.scheduledPoolSupplied) {
            this.scheduledPool.shutdownNow();
        }
        ActiveMQServerImpl.stopComponent(this.memoryManager);
        for (SecuritySettingPlugin securitySettingPlugin : this.configuration.getSecuritySettingPlugins()) {
            securitySettingPlugin.stop();
        }
        if (this.threadPool != null && !this.threadPoolSupplied) {
            this.shutdownPool(this.threadPool);
        }
        if (this.ioExecutorPool != null) {
            this.shutdownPool(this.ioExecutorPool);
        }
        if (!this.threadPoolSupplied) {
            this.threadPool = null;
        }
        if (!this.scheduledPoolSupplied) {
            this.scheduledPool = null;
        }
        if (this.securityStore != null) {
            try {
                this.securityStore.stop();
            }
            catch (Throwable t) {
                ActiveMQServerLogger.LOGGER.errorStoppingComponent(t, this.managementService.getClass().getName());
            }
        }
        this.pagingManager = null;
        this.securityStore = null;
        this.resourceManager = null;
        this.postOffice = null;
        this.queueFactory = null;
        this.resourceManager = null;
        this.messagingServerControl = null;
        this.memoryManager = null;
        this.backupManager = null;
        this.storageManager = null;
        this.sessions.clear();
        this.state = ActiveMQServer.SERVER_STATE.STOPPED;
        this.activationLatch.setCount(1);
        SimpleString tempNodeID = this.getNodeID();
        if (this.activation != null) {
            try {
                this.activation.close(failoverOnServerShutdown, restarting);
            }
            catch (Throwable t) {
                ActiveMQServerLogger.LOGGER.errorStoppingComponent(t, this.activation.getClass().getName());
            }
        }
        if (this.activationThread != null) {
            try {
                this.activationThread.join(30000L);
            }
            catch (InterruptedException e) {
                ActiveMQServerLogger.LOGGER.interruptWhilstStoppingComponent(this.activationThread.getClass().getName());
            }
            if (this.activationThread.isAlive()) {
                ActiveMQServerLogger.LOGGER.activationDidntFinish(this);
                this.activationThread.interrupt();
            }
        }
        ActiveMQServerImpl.stopComponent(this.nodeManager);
        this.nodeManager = null;
        this.addressSettingsRepository.clearListeners();
        this.addressSettingsRepository.clearCache();
        this.scaledDownNodeIDs.clear();
        for (ActiveMQComponent externalComponent : this.externalComponents) {
            try {
                if (externalComponent instanceof ServiceComponent) {
                    ((ServiceComponent)externalComponent).stop(isShutdown || criticalIOError);
                    continue;
                }
                externalComponent.stop();
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorStoppingComponent(e, externalComponent.getClass().getName());
            }
        }
        try {
            this.analyzer.stop();
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.analyzer = null;
        }
        if (this.identity != null) {
            ActiveMQServerLogger.LOGGER.serverStopped("identity=" + this.identity + ",version=" + this.getVersion().getFullVersion(), tempNodeID, this.getUptime());
        } else {
            ActiveMQServerLogger.LOGGER.serverStopped(this.getVersion().getFullVersion(), tempNodeID, this.getUptime());
        }
    }

    private void shutdownPool(ExecutorService executorService) {
        executorService.shutdown();
        try {
            if (!executorService.awaitTermination(10L, TimeUnit.SECONDS)) {
                ActiveMQServerLogger.LOGGER.timedOutStoppingThreadpool(this.threadPool);
                for (Runnable r : executorService.shutdownNow()) {
                    logger.debug((Object)("Cancelled the execution of " + r));
                }
            }
        }
        catch (InterruptedException e) {
            ActiveMQServerLogger.LOGGER.interruptWhilstStoppingComponent(this.threadPool.getClass().getName());
        }
    }

    public boolean checkLiveIsNotColocated(String nodeId) {
        if (this.parentServer == null) {
            return true;
        }
        return !this.parentServer.getNodeID().toString().equals(nodeId);
    }

    private void freezeConnections() {
        this.activation.freezeConnections(this.remotingService);
        for (ServerSession serverSession : this.sessions.values()) {
            try {
                serverSession.close(true);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorClosingSession(e);
            }
        }
    }

    private void closeAllServerSessions(boolean criticalIOError) {
        if (this.state != ActiveMQServer.SERVER_STATE.STOPPING) {
            return;
        }
        for (ServerSession session : this.sessions.values()) {
            try {
                session.close(true);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorClosingSessionsWhileStoppingServer(e);
            }
        }
    }

    static void stopComponent(ActiveMQComponent component) {
        try {
            if (component != null) {
                component.stop();
            }
        }
        catch (Throwable t) {
            ActiveMQServerLogger.LOGGER.errorStoppingComponent(t, component.getClass().getName());
        }
    }

    @Override
    public String describe() {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        out.println(ActiveMQMessageBundle.BUNDLE.serverDescribe(this.identity, this.getClusterManager().describe()));
        return str.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String destroyConnectionWithSessionMetadata(String metaKey, String parameterValue) throws Exception {
        StringBuffer operationsExecuted = new StringBuffer();
        try {
            operationsExecuted.append("**************************************************************************************************\n");
            operationsExecuted.append(ActiveMQMessageBundle.BUNDLE.destroyConnectionWithSessionMetadataHeader(metaKey, parameterValue) + "\n");
            Set<ServerSession> allSessions = this.getSessions();
            ServerSession sessionFound = null;
            for (ServerSession session : allSessions) {
                try {
                    String value = session.getMetaData(metaKey);
                    if (value == null || !value.equals(parameterValue)) continue;
                    sessionFound = session;
                    operationsExecuted.append(ActiveMQMessageBundle.BUNDLE.destroyConnectionWithSessionMetadataClosingConnection(sessionFound.toString()) + "\n");
                    RemotingConnection conn = session.getRemotingConnection();
                    if (conn != null) {
                        conn.fail((ActiveMQException)ActiveMQMessageBundle.BUNDLE.destroyConnectionWithSessionMetadataSendException(metaKey, parameterValue));
                    }
                    session.close(true);
                    this.sessions.remove(session.getName());
                }
                catch (Throwable e) {
                    ActiveMQServerLogger.LOGGER.unableDestroyConnectionWithSessionMetadata(e);
                }
            }
            if (sessionFound == null) {
                operationsExecuted.append(ActiveMQMessageBundle.BUNDLE.destroyConnectionWithSessionMetadataNoSessionFound(metaKey, parameterValue) + "\n");
            }
            operationsExecuted.append("**************************************************************************************************");
            String string = operationsExecuted.toString();
            return string;
        }
        finally {
            ActiveMQServerLogger.LOGGER.onDestroyConnectionWithSessionMetadata(operationsExecuted.toString());
        }
    }

    @Override
    public void setIdentity(String identity) {
        this.identity = identity;
    }

    @Override
    public String getIdentity() {
        return this.identity;
    }

    @Override
    public ScheduledExecutorService getScheduledPool() {
        return this.scheduledPool;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public PagingManager getPagingManager() {
        return this.pagingManager;
    }

    @Override
    public RemotingService getRemotingService() {
        return this.remotingService;
    }

    @Override
    public StorageManager getStorageManager() {
        return this.storageManager;
    }

    @Override
    public ActiveMQSecurityManager getSecurityManager() {
        return this.securityManager;
    }

    @Override
    public ManagementService getManagementService() {
        return this.managementService;
    }

    @Override
    public HierarchicalRepository<Set<Role>> getSecurityRepository() {
        return this.securityRepository;
    }

    @Override
    public NodeManager getNodeManager() {
        return this.nodeManager;
    }

    @Override
    public HierarchicalRepository<AddressSettings> getAddressSettingsRepository() {
        return this.addressSettingsRepository;
    }

    @Override
    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    @Override
    public MetricsManager getMetricsManager() {
        return this.metricsManager;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    public boolean isStarted() {
        return this.state == ActiveMQServer.SERVER_STATE.STARTED;
    }

    @Override
    public ClusterManager getClusterManager() {
        return this.clusterManager;
    }

    public BackupManager getBackupManager() {
        return this.backupManager;
    }

    @Override
    public ServerSession createSession(String name, String username, String password, int minLargeMessageSize, RemotingConnection connection, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, boolean xa, String defaultAddress, SessionCallback callback, boolean autoCreateQueues, OperationContext context, Map<SimpleString, RoutingType> prefixes) throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.createCoreSession((Object)this, (Object[])new Object[]{name, username, "****", minLargeMessageSize, connection, autoCommitSends, autoCommitAcks, preAcknowledge, xa, defaultAddress, callback, autoCreateQueues, context, prefixes});
        }
        String validatedUser = "";
        if (this.securityStore != null) {
            validatedUser = this.securityStore.authenticate(username, password, connection);
        }
        this.checkSessionLimit(validatedUser);
        if (this.hasBrokerSessionPlugins()) {
            this.callBrokerSessionPlugins(plugin -> plugin.beforeCreateSession(name, username, minLargeMessageSize, connection, autoCommitSends, autoCommitAcks, preAcknowledge, xa, defaultAddress, callback, autoCreateQueues, context, prefixes));
        }
        ServerSessionImpl session = this.internalCreateSession(name, username, password, validatedUser, minLargeMessageSize, connection, autoCommitSends, autoCommitAcks, preAcknowledge, xa, defaultAddress, callback, context, autoCreateQueues, prefixes);
        this.sessions.put(name, session);
        if (this.hasBrokerSessionPlugins()) {
            this.callBrokerSessionPlugins(plugin -> plugin.afterCreateSession(session));
        }
        return session;
    }

    private void checkSessionLimit(String username) throws Exception {
        if (this.configuration.getResourceLimitSettings() != null && this.configuration.getResourceLimitSettings().containsKey(username)) {
            ResourceLimitSettings limits = this.configuration.getResourceLimitSettings().get(username);
            if (limits.getMaxConnections() == -1) {
                return;
            }
            if (limits.getMaxConnections() == 0 || this.getSessionCountForUser(username) >= limits.getMaxConnections()) {
                throw ActiveMQMessageBundle.BUNDLE.sessionLimitReached(username, limits.getMaxConnections());
            }
        }
    }

    private int getSessionCountForUser(String username) {
        int sessionCount = 0;
        for (Map.Entry<String, ServerSession> sessionEntry : this.sessions.entrySet()) {
            if (!sessionEntry.getValue().getUsername().equals(username)) continue;
            ++sessionCount;
        }
        return sessionCount;
    }

    @Override
    public void checkQueueCreationLimit(String username) throws Exception {
        if (this.configuration.getResourceLimitSettings() != null && this.configuration.getResourceLimitSettings().containsKey(username)) {
            ResourceLimitSettings limits = this.configuration.getResourceLimitSettings().get(username);
            if (limits.getMaxQueues() == -1) {
                return;
            }
            if (limits.getMaxQueues() == 0 || this.getQueueCountForUser(username) >= limits.getMaxQueues()) {
                throw ActiveMQMessageBundle.BUNDLE.queueLimitReached(username, limits.getMaxQueues());
            }
        }
    }

    public int getQueueCountForUser(String username) throws Exception {
        Map<SimpleString, Binding> bindings = this.postOffice.getAllBindings();
        int queuesForUser = 0;
        for (Binding binding : bindings.values()) {
            if (!(binding instanceof LocalQueueBinding) || !((LocalQueueBinding)binding).getQueue().getUser().equals((Object)SimpleString.toSimpleString((String)username))) continue;
            ++queuesForUser;
        }
        return queuesForUser;
    }

    protected ServerSessionImpl internalCreateSession(String name, String username, String password, String validatedUser, int minLargeMessageSize, RemotingConnection connection, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, boolean xa, String defaultAddress, SessionCallback callback, OperationContext context, boolean autoCreateJMSQueues, Map<SimpleString, RoutingType> prefixes) throws Exception {
        return new ServerSessionImpl(name, username, password, validatedUser, minLargeMessageSize, autoCommitSends, autoCommitAcks, preAcknowledge, this.configuration.isPersistDeliveryCountBeforeDelivery(), xa, connection, this.storageManager, this.postOffice, this.resourceManager, this.securityStore, this.managementService, this, this.configuration.getManagementAddress(), defaultAddress == null ? null : new SimpleString(defaultAddress), callback, context, this.pagingManager, prefixes);
    }

    @Override
    public SecurityStore getSecurityStore() {
        return this.securityStore;
    }

    @Override
    public void removeSession(String name) throws Exception {
        this.sessions.remove(name);
    }

    @Override
    public ServerSession lookupSession(String key, String value) {
        Set<ServerSession> allSessions = this.getSessions();
        for (ServerSession session : allSessions) {
            String metaValue = session.getMetaData(key);
            if (metaValue == null || !metaValue.equals(value)) continue;
            return session;
        }
        return null;
    }

    @Override
    public synchronized List<ServerSession> getSessions(String connectionID) {
        Set<Map.Entry<String, ServerSession>> sessionEntries = this.sessions.entrySet();
        ArrayList<ServerSession> matchingSessions = new ArrayList<ServerSession>();
        for (Map.Entry<String, ServerSession> sessionEntry : sessionEntries) {
            ServerSession serverSession = sessionEntry.getValue();
            if (!serverSession.getConnectionID().toString().equals(connectionID)) continue;
            matchingSessions.add(serverSession);
        }
        return matchingSessions;
    }

    @Override
    public synchronized Set<ServerSession> getSessions() {
        return new HashSet<ServerSession>(this.sessions.values());
    }

    @Override
    public boolean isActive() {
        return this.activationLatch.getCount() < 1;
    }

    @Override
    public boolean waitForActivation(long timeout, TimeUnit unit) throws InterruptedException {
        return this.activationLatch.await(timeout, unit);
    }

    @Override
    public ActiveMQServerControlImpl getActiveMQServerControl() {
        return this.messagingServerControl;
    }

    @Override
    public int getConnectionCount() {
        return this.remotingService.getConnections().size();
    }

    @Override
    public long getTotalConnectionCount() {
        return this.remotingService.getTotalConnectionCount();
    }

    @Override
    public long getTotalMessageCount() {
        long total = 0L;
        for (Binding binding : this.postOffice.getAllBindings().values()) {
            if (binding.getType() != BindingType.LOCAL_QUEUE) continue;
            total += ((LocalQueueBinding)binding).getQueue().getMessageCount();
        }
        return total;
    }

    @Override
    public long getTotalMessagesAdded() {
        long total = 0L;
        for (Binding binding : this.postOffice.getAllBindings().values()) {
            if (binding.getType() != BindingType.LOCAL_QUEUE) continue;
            total += ((LocalQueueBinding)binding).getQueue().getMessagesAdded();
        }
        return total;
    }

    @Override
    public long getTotalMessagesAcknowledged() {
        long total = 0L;
        for (Binding binding : this.postOffice.getAllBindings().values()) {
            if (binding.getType() != BindingType.LOCAL_QUEUE) continue;
            total += ((LocalQueueBinding)binding).getQueue().getMessagesAcknowledged();
        }
        return total;
    }

    @Override
    public long getTotalConsumerCount() {
        long total = 0L;
        for (Binding binding : this.postOffice.getAllBindings().values()) {
            if (binding.getType() != BindingType.LOCAL_QUEUE) continue;
            total += (long)((LocalQueueBinding)binding).getQueue().getConsumerCount();
        }
        return total;
    }

    @Override
    public PostOffice getPostOffice() {
        return this.postOffice;
    }

    @Override
    public QueueFactory getQueueFactory() {
        return this.queueFactory;
    }

    @Override
    public SimpleString getNodeID() {
        return this.nodeManager == null ? null : this.nodeManager.getNodeId();
    }

    @Override
    public Queue createQueue(SimpleString address, RoutingType routingType, SimpleString queueName, SimpleString filterString, boolean durable, boolean temporary) throws Exception {
        AddressSettings as = this.getAddressSettingsRepository().getMatch(address == null ? queueName.toString() : address.toString());
        return this.createQueue(address, routingType, queueName, filterString, durable, temporary, as.getDefaultMaxConsumers(), as.isDefaultPurgeOnNoConsumers(), as.isAutoCreateAddresses());
    }

    @Override
    public Queue createQueue(SimpleString address, RoutingType routingType, SimpleString queueName, SimpleString user, SimpleString filterString, boolean durable, boolean temporary) throws Exception {
        AddressSettings as = this.getAddressSettingsRepository().getMatch(address == null ? queueName.toString() : address.toString());
        return this.createQueue(address, routingType, queueName, filterString, user, durable, temporary, false, as.getDefaultMaxConsumers(), as.isDefaultPurgeOnNoConsumers(), as.isAutoCreateAddresses());
    }

    @Override
    public Queue createQueue(SimpleString address, RoutingType routingType, SimpleString queueName, SimpleString filter, boolean durable, boolean temporary, int maxConsumers, boolean purgeOnNoConsumers, boolean autoCreateAddress) throws Exception {
        return this.createQueue(address, routingType, queueName, filter, null, durable, temporary, false, maxConsumers, purgeOnNoConsumers, autoCreateAddress);
    }

    @Override
    public Queue createQueue(SimpleString address, RoutingType routingType, SimpleString queueName, SimpleString filter, boolean durable, boolean temporary, int maxConsumers, boolean purgeOnNoConsumers, boolean exclusive, boolean groupRebalance, int groupBuckets, boolean lastValue, SimpleString lastValueKey, boolean nonDestructive, int consumersBeforeDispatch, long delayBeforeDispatch, boolean autoDelete, long autoDeleteDelay, long autoDeleteMessageCount, boolean autoCreateAddress) throws Exception {
        return this.createQueue(address, routingType, queueName, filter, null, durable, temporary, false, false, false, maxConsumers, purgeOnNoConsumers, exclusive, groupRebalance, groupBuckets, lastValue, lastValueKey, nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, autoDelete, autoDeleteDelay, autoDeleteMessageCount, autoCreateAddress);
    }

    @Override
    public Queue createQueue(SimpleString address, RoutingType routingType, SimpleString queueName, SimpleString filter, boolean durable, boolean temporary, int maxConsumers, boolean purgeOnNoConsumers, boolean exclusive, boolean groupRebalance, int groupBuckets, SimpleString groupFirstKey, boolean lastValue, SimpleString lastValueKey, boolean nonDestructive, int consumersBeforeDispatch, long delayBeforeDispatch, boolean autoDelete, long autoDeleteDelay, long autoDeleteMessageCount, boolean autoCreateAddress) throws Exception {
        return this.createQueue(address, routingType, queueName, filter, null, durable, temporary, false, false, false, maxConsumers, purgeOnNoConsumers, exclusive, groupRebalance, groupBuckets, groupFirstKey, lastValue, lastValueKey, nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, autoDelete, autoDeleteDelay, autoDeleteMessageCount, autoCreateAddress);
    }

    @Override
    @Deprecated
    public Queue createQueue(SimpleString address, RoutingType routingType, SimpleString queueName, SimpleString filter, SimpleString user, boolean durable, boolean temporary, boolean autoCreated, Integer maxConsumers, Boolean purgeOnNoConsumers, boolean autoCreateAddress) throws Exception {
        return this.createQueue(address, routingType, queueName, filter, user, durable, temporary, false, false, autoCreated, maxConsumers, purgeOnNoConsumers, autoCreateAddress);
    }

    @Override
    public Queue createQueue(AddressInfo addressInfo, SimpleString queueName, SimpleString filter, SimpleString user, boolean durable, boolean temporary, boolean autoCreated, Integer maxConsumers, Boolean purgeOnNoConsumers, boolean autoCreateAddress) throws Exception {
        AddressSettings as = this.getAddressSettingsRepository().getMatch(addressInfo == null ? queueName.toString() : addressInfo.getName().toString());
        return this.createQueue(addressInfo, queueName, filter, user, durable, temporary, false, false, autoCreated, maxConsumers, purgeOnNoConsumers, as.isDefaultExclusiveQueue(), as.isDefaultGroupRebalance(), as.getDefaultGroupBuckets(), as.getDefaultGroupFirstKey(), as.isDefaultLastValueQueue(), as.getDefaultLastValueKey(), as.isDefaultNonDestructive(), as.getDefaultConsumersBeforeDispatch(), as.getDefaultDelayBeforeDispatch(), ActiveMQServerImpl.isAutoDelete(autoCreated, as), as.getAutoDeleteQueuesDelay(), as.getAutoDeleteQueuesMessageCount(), autoCreateAddress, false);
    }

    @Override
    public Queue createQueue(AddressInfo addressInfo, SimpleString queueName, SimpleString filter, SimpleString user, boolean durable, boolean temporary, boolean autoCreated, Integer maxConsumers, Boolean purgeOnNoConsumers, Boolean exclusive, Boolean lastValue, boolean autoCreateAddress) throws Exception {
        AddressSettings as = this.getAddressSettingsRepository().getMatch(addressInfo == null ? queueName.toString() : addressInfo.getName().toString());
        return this.createQueue(addressInfo, queueName, filter, user, durable, temporary, false, false, autoCreated, maxConsumers, purgeOnNoConsumers, (boolean)exclusive, as.isDefaultGroupRebalance(), as.getDefaultGroupBuckets(), as.getDefaultGroupFirstKey(), lastValue, as.getDefaultLastValueKey(), as.isDefaultNonDestructive(), as.getDefaultConsumersBeforeDispatch(), as.getDefaultDelayBeforeDispatch(), ActiveMQServerImpl.isAutoDelete(autoCreated, as), as.getAutoDeleteQueuesDelay(), as.getAutoDeleteQueuesMessageCount(), autoCreateAddress, false);
    }

    @Override
    public Queue createQueue(AddressInfo addressInfo, SimpleString queueName, SimpleString filter, SimpleString user, boolean durable, boolean temporary, boolean autoCreated, Integer maxConsumers, Boolean purgeOnNoConsumers, Boolean exclusive, Boolean groupRebalance, Integer groupBuckets, Boolean lastValue, SimpleString lastValueKey, Boolean nonDestructive, Integer consumersBeforeDispatch, Long delayBeforeDispatch, Boolean autoDelete, Long autoDeleteDelay, Long autoDeleteMessageCount, boolean autoCreateAddress) throws Exception {
        AddressSettings as = this.getAddressSettingsRepository().getMatch(addressInfo == null ? queueName.toString() : addressInfo.getName().toString());
        return this.createQueue(addressInfo, queueName, filter, user, durable, temporary, false, false, autoCreated, maxConsumers, purgeOnNoConsumers, (boolean)exclusive, (boolean)groupRebalance, groupBuckets, as.getDefaultGroupFirstKey(), lastValue, lastValueKey, nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, autoDelete, autoDeleteDelay, (long)autoDeleteMessageCount, autoCreateAddress, false);
    }

    @Override
    public Queue createQueue(AddressInfo addressInfo, SimpleString queueName, SimpleString filter, SimpleString user, boolean durable, boolean temporary, boolean autoCreated, Integer maxConsumers, Boolean purgeOnNoConsumers, Boolean exclusive, Boolean groupRebalance, Integer groupBuckets, SimpleString groupFirstKey, Boolean lastValue, SimpleString lastValueKey, Boolean nonDestructive, Integer consumersBeforeDispatch, Long delayBeforeDispatch, Boolean autoDelete, Long autoDeleteDelay, Long autoDeleteMessageCount, boolean autoCreateAddress) throws Exception {
        return this.createQueue(addressInfo, queueName, filter, user, durable, temporary, false, false, autoCreated, maxConsumers, purgeOnNoConsumers, (boolean)exclusive, (boolean)groupRebalance, groupBuckets, groupFirstKey, lastValue, lastValueKey, nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, autoDelete, autoDeleteDelay, (long)autoDeleteMessageCount, autoCreateAddress, false);
    }

    static boolean isAutoDelete(boolean autoCreated, AddressSettings addressSettings) {
        return autoCreated ? addressSettings.isAutoDeleteQueues() : addressSettings.isAutoDeleteCreatedQueues();
    }

    @Override
    public Queue createQueue(SimpleString address, RoutingType routingType, SimpleString queueName, SimpleString filter, SimpleString user, boolean durable, boolean temporary, boolean ignoreIfExists, boolean transientQueue, boolean autoCreated, int maxConsumers, boolean purgeOnNoConsumers, boolean autoCreateAddress) throws Exception {
        AddressSettings as = this.getAddressSettingsRepository().getMatch(address == null ? queueName.toString() : address.toString());
        return this.createQueue(address, routingType, queueName, filter, user, durable, temporary, ignoreIfExists, transientQueue, autoCreated, maxConsumers, purgeOnNoConsumers, as.isDefaultExclusiveQueue(), as.isDefaultGroupRebalance(), as.getDefaultGroupBuckets(), as.isDefaultLastValueQueue(), as.getDefaultLastValueKey(), as.isDefaultNonDestructive(), as.getDefaultConsumersBeforeDispatch(), as.getDefaultDelayBeforeDispatch(), ActiveMQServerImpl.isAutoDelete(autoCreated, as), as.getAutoDeleteQueuesDelay(), as.getAutoDeleteQueuesMessageCount(), autoCreateAddress);
    }

    @Override
    public Queue createQueue(SimpleString address, RoutingType routingType, SimpleString queueName, SimpleString filter, SimpleString user, boolean durable, boolean temporary, boolean ignoreIfExists, boolean transientQueue, boolean autoCreated, int maxConsumers, boolean purgeOnNoConsumers, boolean exclusive, boolean lastValue, boolean autoCreateAddress) throws Exception {
        AddressSettings as = this.getAddressSettingsRepository().getMatch(address == null ? queueName.toString() : address.toString());
        return this.createQueue(address, routingType, queueName, filter, user, durable, temporary, ignoreIfExists, transientQueue, autoCreated, maxConsumers, purgeOnNoConsumers, exclusive, as.isDefaultGroupRebalance(), as.getDefaultGroupBuckets(), lastValue, as.getDefaultLastValueKey(), as.isDefaultNonDestructive(), as.getDefaultConsumersBeforeDispatch(), as.getDefaultDelayBeforeDispatch(), ActiveMQServerImpl.isAutoDelete(autoCreated, as), as.getAutoDeleteQueuesDelay(), as.getAutoDeleteQueuesMessageCount(), autoCreateAddress);
    }

    @Override
    @Deprecated
    public Queue createQueue(SimpleString address, SimpleString queueName, SimpleString filterString, boolean durable, boolean temporary) throws Exception {
        return this.createQueue(address, this.getAddressSettingsRepository().getMatch(address == null ? queueName.toString() : address.toString()).getDefaultQueueRoutingType(), queueName, filterString, durable, temporary);
    }

    @Override
    public void createSharedQueue(SimpleString address, RoutingType routingType, SimpleString name, SimpleString filterString, SimpleString user, boolean durable) throws Exception {
        AddressSettings as = this.getAddressSettingsRepository().getMatch(address == null ? name.toString() : address.toString());
        this.createSharedQueue(address, routingType, name, filterString, user, durable, as.getDefaultMaxConsumers(), as.isDefaultPurgeOnNoConsumers(), as.isDefaultExclusiveQueue(), as.isDefaultLastValueQueue());
    }

    @Override
    public void createSharedQueue(SimpleString address, RoutingType routingType, SimpleString name, SimpleString filterString, SimpleString user, boolean durable, int maxConsumers, boolean purgeOnNoConsumers, boolean exclusive, boolean lastValue) throws Exception {
        AddressSettings as = this.getAddressSettingsRepository().getMatch(address == null ? name.toString() : address.toString());
        this.createSharedQueue(address, routingType, name, filterString, user, durable, maxConsumers, purgeOnNoConsumers, exclusive, as.isDefaultGroupRebalance(), as.getDefaultGroupBuckets(), lastValue, as.getDefaultLastValueKey(), as.isDefaultNonDestructive(), as.getDefaultConsumersBeforeDispatch(), as.getDefaultDelayBeforeDispatch(), ActiveMQServerImpl.isAutoDelete(false, as), as.getAutoDeleteQueuesDelay(), as.getAutoDeleteQueuesMessageCount());
    }

    @Override
    public void createSharedQueue(SimpleString address, RoutingType routingType, SimpleString name, SimpleString filterString, SimpleString user, boolean durable, int maxConsumers, boolean purgeOnNoConsumers, boolean exclusive, boolean groupRebalance, int groupBuckets, boolean lastValue, SimpleString lastValueKey, boolean nonDestructive, int consumersBeforeDispatch, long delayBeforeDispatch, boolean autoDelete, long autoDeleteDelay, long autoDeleteMessageCount) throws Exception {
        AddressSettings as = this.getAddressSettingsRepository().getMatch(address == null ? name.toString() : address.toString());
        this.createSharedQueue(address, routingType, name, filterString, user, durable, maxConsumers, purgeOnNoConsumers, exclusive, groupRebalance, groupBuckets, as.getDefaultGroupFirstKey(), lastValue, lastValueKey, nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, autoDelete, autoDeleteDelay, autoDeleteMessageCount);
    }

    @Override
    public void createSharedQueue(SimpleString address, RoutingType routingType, SimpleString name, SimpleString filterString, SimpleString user, boolean durable, int maxConsumers, boolean purgeOnNoConsumers, boolean exclusive, boolean groupRebalance, int groupBuckets, SimpleString groupFirstKey, boolean lastValue, SimpleString lastValueKey, boolean nonDestructive, int consumersBeforeDispatch, long delayBeforeDispatch, boolean autoDelete, long autoDeleteDelay, long autoDeleteMessageCount) throws Exception {
        Queue queue;
        if (address == null) {
            throw new NullPointerException("address can't be null!");
        }
        if (routingType == null) {
            AddressInfo addressInfo = this.getAddressInfo(address);
            RoutingType routingType2 = routingType = addressInfo.getRoutingTypes().size() == 1 ? addressInfo.getRoutingType() : this.getAddressSettingsRepository().getMatch(address.toString()).getDefaultQueueRoutingType();
            if (routingType == null) {
                // empty if block
            }
        }
        if (!(queue = this.createQueue(address, routingType, name, filterString, user, durable, !durable, true, !durable, false, maxConsumers, purgeOnNoConsumers, exclusive, groupRebalance, groupBuckets, groupFirstKey, lastValue, lastValueKey, nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, autoDelete, autoDeleteDelay, autoDeleteMessageCount, true)).getAddress().equals((Object)address)) {
            throw ActiveMQMessageBundle.BUNDLE.queueSubscriptionBelongsToDifferentAddress(name);
        }
        if (filterString != null && (queue.getFilter() == null || !queue.getFilter().getFilterString().equals((Object)filterString)) || filterString == null && queue.getFilter() != null) {
            throw ActiveMQMessageBundle.BUNDLE.queueSubscriptionBelongsToDifferentFilter(name);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Transient Queue " + name + " created on address " + name + " with filter=" + filterString));
        }
    }

    @Override
    public Queue locateQueue(SimpleString queueName) {
        Binding binding = this.postOffice.getBinding(queueName);
        if (binding == null) {
            return null;
        }
        Bindable queue = binding.getBindable();
        if (!(queue instanceof Queue)) {
            throw new IllegalStateException("locateQueue should only be used to locate queues");
        }
        return (Queue)binding.getBindable();
    }

    @Override
    @Deprecated
    public Queue deployQueue(SimpleString address, SimpleString resourceName, SimpleString filterString, boolean durable, boolean temporary) throws Exception {
        return this.createQueue(address, this.getAddressSettingsRepository().getMatch(address == null ? resourceName.toString() : address.toString()).getDefaultQueueRoutingType(), resourceName, filterString, durable, temporary);
    }

    @Override
    @Deprecated
    public Queue deployQueue(String address, String resourceName, String filterString, boolean durable, boolean temporary) throws Exception {
        return this.deployQueue(SimpleString.toSimpleString((String)address), SimpleString.toSimpleString((String)resourceName), SimpleString.toSimpleString((String)filterString), durable, temporary);
    }

    @Override
    public void destroyQueue(SimpleString queueName) throws Exception {
        this.destroyQueue(queueName, null, true);
    }

    @Override
    public void destroyQueue(SimpleString queueName, SecurityAuth session) throws Exception {
        this.destroyQueue(queueName, session, true);
    }

    @Override
    public void destroyQueue(SimpleString queueName, SecurityAuth session, boolean checkConsumerCount) throws Exception {
        this.destroyQueue(queueName, session, checkConsumerCount, false);
    }

    @Override
    public void destroyQueue(SimpleString queueName, SecurityAuth session, boolean checkConsumerCount, boolean removeConsumers) throws Exception {
        if (this.postOffice == null) {
            return;
        }
        Binding binding = this.postOffice.getBinding(queueName);
        if (binding == null) {
            throw ActiveMQMessageBundle.BUNDLE.noSuchQueue(queueName);
        }
        String address = binding.getAddress().toString();
        this.destroyQueue(queueName, session, checkConsumerCount, removeConsumers, this.addressSettingsRepository.getMatch(address).isAutoDeleteAddresses());
    }

    @Override
    public void destroyQueue(SimpleString queueName, SecurityAuth session, boolean checkConsumerCount, boolean removeConsumers, boolean autoDeleteAddress) throws Exception {
        this.destroyQueue(queueName, session, checkConsumerCount, removeConsumers, autoDeleteAddress, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyQueue(SimpleString queueName, SecurityAuth session, boolean checkConsumerCount, boolean removeConsumers, boolean autoDeleteAddress, boolean checkMessageCount) throws Exception {
        if (this.postOffice == null) {
            return;
        }
        try {
            Binding binding = this.postOffice.getBinding(queueName);
            if (binding == null) {
                throw ActiveMQMessageBundle.BUNDLE.noSuchQueue(queueName);
            }
            SimpleString address = binding.getAddress();
            Queue queue = (Queue)binding.getBindable();
            if (this.hasBrokerQueuePlugins()) {
                this.callBrokerQueuePlugins(plugin -> plugin.beforeDestroyQueue(queueName, session, checkConsumerCount, removeConsumers, autoDeleteAddress));
            }
            if (session != null) {
                if (queue.isDurable()) {
                    this.securityStore.check(address, queueName, CheckType.DELETE_DURABLE_QUEUE, session);
                } else {
                    this.securityStore.check(address, queueName, CheckType.DELETE_NON_DURABLE_QUEUE, session);
                }
            }
            if (checkConsumerCount && queue.getConsumerCount() != 0) {
                throw ActiveMQMessageBundle.BUNDLE.cannotDeleteQueueWithConsumers(queue.getName(), queueName, binding.getClass().getName());
            }
            if (checkMessageCount && queue.getAutoDeleteMessageCount() != -1L) {
                long messageCount = queue.getMessageCount();
                if (queue.getMessageCount() > queue.getAutoDeleteMessageCount()) {
                    throw ActiveMQMessageBundle.BUNDLE.cannotDeleteQueueWithMessages(queue.getName(), queueName, messageCount);
                }
            }
            queue.deleteQueue(removeConsumers);
            if (this.hasBrokerQueuePlugins()) {
                this.callBrokerQueuePlugins(plugin -> plugin.afterDestroyQueue(queue, address, session, checkConsumerCount, removeConsumers, autoDeleteAddress));
            }
            AddressInfo addressInfo = this.getAddressInfo(address);
            if (autoDeleteAddress && this.postOffice != null && addressInfo != null && addressInfo.isAutoCreated() && !this.isAddressBound(address.toString()) && this.addressSettingsRepository.getMatch(address.toString()).getAutoDeleteAddressesDelay() == 0L) {
                try {
                    this.removeAddressInfo(address, session);
                }
                catch (ActiveMQDeleteAddressException activeMQDeleteAddressException) {
                    // empty catch block
                }
            }
            this.callPostQueueDeletionCallbacks(address, queueName);
        }
        finally {
            this.clearAddressCache();
        }
    }

    @Override
    public void clearAddressCache() {
        this.securityRepository.clearCache();
        this.addressSettingsRepository.clearCache();
    }

    @Override
    public void registerActivateCallback(ActivateCallback callback) {
        this.activateCallbacks.add(callback);
    }

    @Override
    public void unregisterActivateCallback(ActivateCallback callback) {
        this.activateCallbacks.remove(callback);
    }

    @Override
    public void registerActivationFailureListener(ActivationFailureListener listener) {
        this.activationFailureListeners.add(listener);
    }

    @Override
    public void unregisterActivationFailureListener(ActivationFailureListener listener) {
        this.activationFailureListeners.remove(listener);
    }

    @Override
    public void callActivationFailureListeners(Exception e) {
        for (ActivationFailureListener listener : this.activationFailureListeners) {
            listener.activationFailed(e);
        }
    }

    @Override
    public void registerPostQueueCreationCallback(PostQueueCreationCallback callback) {
        this.postQueueCreationCallbacks.add(callback);
    }

    @Override
    public void unregisterPostQueueCreationCallback(PostQueueCreationCallback callback) {
        this.postQueueCreationCallbacks.remove(callback);
    }

    @Override
    public void callPostQueueCreationCallbacks(SimpleString queueName) throws Exception {
        for (PostQueueCreationCallback callback : this.postQueueCreationCallbacks) {
            callback.callback(queueName);
        }
    }

    @Override
    public void registerPostQueueDeletionCallback(PostQueueDeletionCallback callback) {
        this.postQueueDeletionCallbacks.add(callback);
    }

    @Override
    public void unregisterPostQueueDeletionCallback(PostQueueDeletionCallback callback) {
        this.postQueueDeletionCallbacks.remove(callback);
    }

    @Override
    public void callPostQueueDeletionCallbacks(SimpleString address, SimpleString queueName) throws Exception {
        for (PostQueueDeletionCallback callback : this.postQueueDeletionCallbacks) {
            callback.callback(address, queueName);
        }
    }

    @Override
    public void registerBrokerPlugins(List<ActiveMQServerBasePlugin> plugins) {
        this.configuration.registerBrokerPlugins(plugins);
        plugins.forEach(plugin -> plugin.registered(this));
    }

    @Override
    public void registerBrokerPlugin(ActiveMQServerBasePlugin plugin) {
        this.configuration.registerBrokerPlugin(plugin);
        plugin.registered(this);
    }

    @Override
    public void unRegisterBrokerPlugin(ActiveMQServerBasePlugin plugin) {
        this.configuration.unRegisterBrokerPlugin(plugin);
        plugin.unregistered(this);
    }

    @Override
    public List<ActiveMQServerBasePlugin> getBrokerPlugins() {
        return this.configuration.getBrokerPlugins();
    }

    @Override
    public List<ActiveMQServerConnectionPlugin> getBrokerConnectionPlugins() {
        return this.configuration.getBrokerConnectionPlugins();
    }

    @Override
    public List<ActiveMQServerSessionPlugin> getBrokerSessionPlugins() {
        return this.configuration.getBrokerSessionPlugins();
    }

    @Override
    public List<ActiveMQServerConsumerPlugin> getBrokerConsumerPlugins() {
        return this.configuration.getBrokerConsumerPlugins();
    }

    @Override
    public List<ActiveMQServerAddressPlugin> getBrokerAddressPlugins() {
        return this.configuration.getBrokerAddressPlugins();
    }

    @Override
    public List<ActiveMQServerQueuePlugin> getBrokerQueuePlugins() {
        return this.configuration.getBrokerQueuePlugins();
    }

    @Override
    public List<ActiveMQServerBindingPlugin> getBrokerBindingPlugins() {
        return this.configuration.getBrokerBindingPlugins();
    }

    @Override
    public List<ActiveMQServerMessagePlugin> getBrokerMessagePlugins() {
        return this.configuration.getBrokerMessagePlugins();
    }

    @Override
    public List<ActiveMQServerBridgePlugin> getBrokerBridgePlugins() {
        return this.configuration.getBrokerBridgePlugins();
    }

    @Override
    public List<ActiveMQServerCriticalPlugin> getBrokerCriticalPlugins() {
        return this.configuration.getBrokerCriticalPlugins();
    }

    @Override
    public void callBrokerPlugins(ActiveMQPluginRunnable pluginRun) throws ActiveMQException {
        this.callBrokerPlugins(this.getBrokerPlugins(), pluginRun);
    }

    @Override
    public void callBrokerConnectionPlugins(ActiveMQPluginRunnable<ActiveMQServerConnectionPlugin> pluginRun) throws ActiveMQException {
        this.callBrokerPlugins(this.getBrokerConnectionPlugins(), pluginRun);
    }

    @Override
    public void callBrokerSessionPlugins(ActiveMQPluginRunnable<ActiveMQServerSessionPlugin> pluginRun) throws ActiveMQException {
        this.callBrokerPlugins(this.getBrokerSessionPlugins(), pluginRun);
    }

    @Override
    public void callBrokerConsumerPlugins(ActiveMQPluginRunnable<ActiveMQServerConsumerPlugin> pluginRun) throws ActiveMQException {
        this.callBrokerPlugins(this.getBrokerConsumerPlugins(), pluginRun);
    }

    @Override
    public void callBrokerAddressPlugins(ActiveMQPluginRunnable<ActiveMQServerAddressPlugin> pluginRun) throws ActiveMQException {
        this.callBrokerPlugins(this.getBrokerAddressPlugins(), pluginRun);
    }

    @Override
    public void callBrokerQueuePlugins(ActiveMQPluginRunnable<ActiveMQServerQueuePlugin> pluginRun) throws ActiveMQException {
        this.callBrokerPlugins(this.getBrokerQueuePlugins(), pluginRun);
    }

    @Override
    public void callBrokerBindingPlugins(ActiveMQPluginRunnable<ActiveMQServerBindingPlugin> pluginRun) throws ActiveMQException {
        this.callBrokerPlugins(this.getBrokerBindingPlugins(), pluginRun);
    }

    @Override
    public void callBrokerMessagePlugins(ActiveMQPluginRunnable<ActiveMQServerMessagePlugin> pluginRun) throws ActiveMQException {
        this.callBrokerPlugins(this.getBrokerMessagePlugins(), pluginRun);
    }

    @Override
    public void callBrokerBridgePlugins(ActiveMQPluginRunnable<ActiveMQServerBridgePlugin> pluginRun) throws ActiveMQException {
        this.callBrokerPlugins(this.getBrokerBridgePlugins(), pluginRun);
    }

    @Override
    public void callBrokerCriticalPlugins(ActiveMQPluginRunnable<ActiveMQServerCriticalPlugin> pluginRun) throws ActiveMQException {
        this.callBrokerPlugins(this.getBrokerCriticalPlugins(), pluginRun);
    }

    private <P extends ActiveMQServerBasePlugin> void callBrokerPlugins(List<P> plugins, ActiveMQPluginRunnable<P> pluginRun) throws ActiveMQException {
        if (pluginRun != null) {
            for (ActiveMQServerBasePlugin plugin : plugins) {
                try {
                    pluginRun.run(plugin);
                }
                catch (Throwable e) {
                    if (e instanceof ActiveMQException) {
                        logger.debug((Object)("plugin " + plugin + " is throwing ActiveMQException"));
                        throw (ActiveMQException)e;
                    }
                    logger.warn("Internal error on plugin " + pluginRun, (Object)e.getMessage(), e);
                }
            }
        }
    }

    @Override
    public boolean hasBrokerPlugins() {
        return !this.getBrokerPlugins().isEmpty();
    }

    @Override
    public boolean hasBrokerConnectionPlugins() {
        return !this.getBrokerConnectionPlugins().isEmpty();
    }

    @Override
    public boolean hasBrokerSessionPlugins() {
        return !this.getBrokerSessionPlugins().isEmpty();
    }

    @Override
    public boolean hasBrokerConsumerPlugins() {
        return !this.getBrokerConsumerPlugins().isEmpty();
    }

    @Override
    public boolean hasBrokerAddressPlugins() {
        return !this.getBrokerAddressPlugins().isEmpty();
    }

    @Override
    public boolean hasBrokerQueuePlugins() {
        return !this.getBrokerQueuePlugins().isEmpty();
    }

    @Override
    public boolean hasBrokerBindingPlugins() {
        return !this.getBrokerBindingPlugins().isEmpty();
    }

    @Override
    public boolean hasBrokerMessagePlugins() {
        return !this.getBrokerMessagePlugins().isEmpty();
    }

    @Override
    public boolean hasBrokerBridgePlugins() {
        return !this.getBrokerBridgePlugins().isEmpty();
    }

    @Override
    public boolean hasBrokerCriticalPlugins() {
        return !this.getBrokerCriticalPlugins().isEmpty();
    }

    @Override
    public ExecutorFactory getExecutorFactory() {
        return this.executorFactory;
    }

    @Override
    public ExecutorFactory getIOExecutorFactory() {
        return this.ioExecutorFactory;
    }

    @Override
    public void setGroupingHandler(GroupingHandler groupingHandler) {
        if (this.groupingHandler != null && this.managementService != null) {
            this.managementService.removeNotificationListener(this.groupingHandler);
        }
        this.groupingHandler = groupingHandler;
        if (this.managementService != null) {
            this.managementService.addNotificationListener(this.groupingHandler);
        }
    }

    @Override
    public GroupingHandler getGroupingHandler() {
        return this.groupingHandler;
    }

    @Override
    public ReplicationManager getReplicationManager() {
        return this.activation.getReplicationManager();
    }

    @Override
    public ConnectorsService getConnectorsService() {
        return this.connectorsService;
    }

    @Override
    public FederationManager getFederationManager() {
        return this.federationManager;
    }

    @Override
    public void deployDivert(DivertConfiguration config) throws Exception {
        if (config.getName() == null) {
            throw ActiveMQMessageBundle.BUNDLE.divertWithNoName();
        }
        if (config.getAddress() == null) {
            ActiveMQServerLogger.LOGGER.divertWithNoAddress();
            return;
        }
        if (config.getForwardingAddress() == null) {
            ActiveMQServerLogger.LOGGER.divertWithNoForwardingAddress();
            return;
        }
        SimpleString sName = new SimpleString(config.getName());
        if (this.postOffice.getBinding(sName) != null) {
            ActiveMQServerLogger.LOGGER.divertBindingAlreadyExists(sName);
            return;
        }
        SimpleString sAddress = new SimpleString(config.getAddress());
        Transformer transformer = this.getServiceRegistry().getDivertTransformer(config.getName(), config.getTransformerConfiguration());
        Filter filter = FilterImpl.createFilter(config.getFilterString());
        DivertImpl divert = new DivertImpl(new SimpleString(config.getForwardingAddress()), sName, new SimpleString(config.getRoutingName()), config.isExclusive(), filter, transformer, this.postOffice, this.storageManager, config.getRoutingType());
        DivertBinding binding = new DivertBinding(this.storageManager.generateID(), sAddress, divert);
        this.postOffice.addBinding(binding);
        this.managementService.registerDivert(divert, config);
    }

    @Override
    public void destroyDivert(SimpleString name) throws Exception {
        Binding binding = this.postOffice.getBinding(name);
        if (binding == null) {
            throw ActiveMQMessageBundle.BUNDLE.noBindingForDivert(name);
        }
        if (!(binding instanceof DivertBinding)) {
            throw ActiveMQMessageBundle.BUNDLE.bindingNotDivert(name);
        }
        this.postOffice.removeBinding(name, null, true);
    }

    @Override
    public void deployBridge(BridgeConfiguration config) throws Exception {
        if (this.clusterManager != null) {
            this.clusterManager.deployBridge(config);
        }
    }

    @Override
    public void destroyBridge(String name) throws Exception {
        if (this.clusterManager != null) {
            this.clusterManager.destroyBridge(name);
        }
    }

    @Override
    public void deployFederation(FederationConfiguration config) throws Exception {
        if (this.federationManager != null) {
            this.federationManager.deploy(config);
        }
    }

    @Override
    public void undeployFederation(String name) throws Exception {
        if (this.federationManager != null) {
            this.federationManager.undeploy(name);
        }
    }

    @Override
    public ServerSession getSessionByID(String sessionName) {
        return this.sessions.get(sessionName);
    }

    public String toString() {
        if (this.identity != null) {
            return "ActiveMQServerImpl::" + this.identity;
        }
        return "ActiveMQServerImpl::" + (this.nodeManager != null ? "serverUUID=" + this.nodeManager.getUUID() : "");
    }

    public void replaceQueueFactory(QueueFactory factory) {
        this.queueFactory = factory;
    }

    @Override
    public PagingManager createPagingManager() throws Exception {
        return new PagingManagerImpl(this.getPagingStoreFactory(), this.addressSettingsRepository, this.configuration.getGlobalMaxSize(), this.configuration.getManagementAddress());
    }

    protected PagingStoreFactory getPagingStoreFactory() throws Exception {
        if (this.configuration.getStoreConfiguration() != null && this.configuration.getStoreConfiguration().getStoreType() == StoreConfiguration.StoreType.DATABASE) {
            DatabaseStorageConfiguration dbConf = (DatabaseStorageConfiguration)this.configuration.getStoreConfiguration();
            return new PagingStoreFactoryDatabase(dbConf, this.storageManager, this.configuration.getJournalBufferTimeout_NIO(), this.scheduledPool, this.ioExecutorFactory, false, this.shutdownOnCriticalIO);
        }
        return new PagingStoreFactoryNIO(this.storageManager, this.configuration.getPagingLocation(), this.configuration.getJournalBufferTimeout_NIO(), this.scheduledPool, this.ioExecutorFactory, this.configuration.isJournalSyncNonTransactional(), this.shutdownOnCriticalIO);
    }

    protected StorageManager createStorageManager() {
        if (this.configuration.isPersistenceEnabled()) {
            if (this.configuration.getStoreConfiguration() != null && this.configuration.getStoreConfiguration().getStoreType() == StoreConfiguration.StoreType.DATABASE) {
                JDBCJournalStorageManager journal = new JDBCJournalStorageManager(this.configuration, this.getCriticalAnalyzer(), this.getScheduledPool(), this.executorFactory, this.ioExecutorFactory, (IOCriticalErrorListener)this.shutdownOnCriticalIO);
                this.getCriticalAnalyzer().add((CriticalComponent)journal);
                return journal;
            }
            JournalStorageManager journal = new JournalStorageManager(this.configuration, this.getCriticalAnalyzer(), this.executorFactory, this.scheduledPool, this.ioExecutorFactory, this.shutdownOnCriticalIO);
            this.getCriticalAnalyzer().add((CriticalComponent)journal);
            return journal;
        }
        return new NullStorageManager();
    }

    private void callActivateCallbacks() {
        for (ActivateCallback callback : this.activateCallbacks) {
            callback.activated();
        }
    }

    private void callPreActiveCallbacks() {
        for (ActivateCallback callback : this.activateCallbacks) {
            callback.preActivate();
        }
    }

    private void callDeActiveCallbacks() {
        for (ActivateCallback callback : this.activateCallbacks) {
            try {
                callback.deActivate();
            }
            catch (Throwable e) {
                ActiveMQServerLogger.LOGGER.unableToDeactiveCallback(e);
            }
        }
    }

    private void callActivationCompleteCallbacks() {
        for (ActivateCallback callback : this.activateCallbacks) {
            callback.activationComplete();
        }
    }

    private void initializeExecutorServices() {
        ThreadFactory tFactory;
        if (this.serviceRegistry.getExecutorService() == null) {
            tFactory = AccessController.doPrivileged(new PrivilegedAction<ThreadFactory>(){

                @Override
                public ThreadFactory run() {
                    return new ActiveMQThreadFactory("ActiveMQ-server-" + this.toString(), false, ClientSessionFactoryImpl.class.getClassLoader());
                }
            });
            this.threadPool = this.configuration.getThreadPoolMaxSize() == -1 ? new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), tFactory) : new ActiveMQThreadPoolExecutor(0, this.configuration.getThreadPoolMaxSize(), 60L, TimeUnit.SECONDS, tFactory);
        } else {
            this.threadPool = this.serviceRegistry.getExecutorService();
            this.threadPoolSupplied = true;
        }
        this.executorFactory = new OrderedExecutorFactory((Executor)this.threadPool);
        if (this.serviceRegistry.getIOExecutorService() != null) {
            this.ioExecutorFactory = new OrderedExecutorFactory((Executor)this.serviceRegistry.getIOExecutorService());
        } else {
            tFactory = AccessController.doPrivileged(new PrivilegedAction<ThreadFactory>(){

                @Override
                public ThreadFactory run() {
                    return new ActiveMQThreadFactory("ActiveMQ-IO-server-" + this.toString(), false, ClientSessionFactoryImpl.class.getClassLoader());
                }
            });
            this.ioExecutorPool = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), tFactory);
            this.ioExecutorFactory = new OrderedExecutorFactory((Executor)this.ioExecutorPool);
        }
        if (this.serviceRegistry.getScheduledExecutorService() == null) {
            tFactory = AccessController.doPrivileged(new PrivilegedAction<ThreadFactory>(){

                @Override
                public ThreadFactory run() {
                    return new ActiveMQThreadFactory("ActiveMQ-scheduled-threads", false, ClientSessionFactoryImpl.class.getClassLoader());
                }
            });
            this.scheduledPool = new ScheduledThreadPoolExecutor(this.configuration.getScheduledThreadPoolMaxSize(), tFactory);
        } else {
            this.scheduledPoolSupplied = true;
            this.scheduledPool = this.serviceRegistry.getScheduledExecutorService();
        }
    }

    @Override
    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    synchronized boolean initialisePart1(boolean scalingDown) throws Exception {
        if (this.state == ActiveMQServer.SERVER_STATE.STOPPED) {
            return false;
        }
        if (this.configuration.getJournalType() == JournalType.ASYNCIO) {
            if (!AIOSequentialFileFactory.isSupported()) {
                ActiveMQServerLogger.LOGGER.switchingNIO();
                this.configuration.setJournalType(JournalType.NIO);
            } else if (!AIOSequentialFileFactory.isSupported((File)this.configuration.getJournalLocation())) {
                ActiveMQServerLogger.LOGGER.switchingNIOonPath(this.configuration.getJournalLocation().getAbsolutePath());
                this.configuration.setJournalType(JournalType.NIO);
            }
        }
        this.managementService = new ManagementServiceImpl(this.mbeanServer, this.configuration);
        if (this.configuration.getMemoryMeasureInterval() != -1L) {
            this.memoryManager = new MemoryManager(this.configuration.getMemoryWarningThreshold(), this.configuration.getMemoryMeasureInterval());
            this.memoryManager.start();
        }
        this.callPreActiveCallbacks();
        this.storageManager = this.createStorageManager();
        if (this.configuration.getClusterConfigurations().size() > 0 && ActiveMQDefaultConfiguration.getDefaultClusterUser().equals(this.configuration.getClusterUser()) && ActiveMQDefaultConfiguration.getDefaultClusterPassword().equals(this.configuration.getClusterPassword())) {
            ActiveMQServerLogger.LOGGER.clusterSecurityRisk();
        }
        this.securityStore = new SecurityStoreImpl(this.securityRepository, this.securityManager, this.configuration.getSecurityInvalidationInterval(), this.configuration.isSecurityEnabled(), this.configuration.getClusterUser(), this.configuration.getClusterPassword(), this.managementService);
        this.queueFactory = new QueueFactoryImpl(this.executorFactory, this.scheduledPool, this.addressSettingsRepository, this.storageManager, this);
        this.pagingManager = this.createPagingManager();
        this.resourceManager = new ResourceManagerImpl((int)(this.configuration.getTransactionTimeout() / 1000L), this.configuration.getTransactionTimeoutScanPeriod(), this.scheduledPool);
        if (this.configuration.getMetricsPlugin() != null) {
            this.metricsManager = new MetricsManager(this.configuration.getName(), this.configuration.getMetricsPlugin());
        }
        this.registerMeters();
        this.postOffice = new PostOfficeImpl(this, this.storageManager, this.pagingManager, this.queueFactory, this.managementService, this.configuration.getMessageExpiryScanPeriod(), this.configuration.getAddressQueueScanPeriod(), this.configuration.getWildcardConfiguration(), this.configuration.getIDCacheSize(), this.configuration.isPersistIDCache(), this.addressSettingsRepository);
        this.clusterManager = new ClusterManager(this.executorFactory, this, this.postOffice, this.scheduledPool, this.managementService, this.configuration, this.nodeManager, this.haPolicy.isBackup());
        this.federationManager = new FederationManager(this);
        this.backupManager = new BackupManager(this, this.executorFactory, this.scheduledPool, this.nodeManager, this.configuration, this.clusterManager);
        this.clusterManager.deploy();
        this.federationManager.deploy();
        this.remotingService = new RemotingServiceImpl(this.clusterManager, this.configuration, this, this.managementService, this.scheduledPool, this.protocolManagerFactories, (Executor)this.executorFactory.getExecutor(), this.serviceRegistry);
        this.messagingServerControl = this.managementService.registerServer(this.postOffice, this.securityStore, this.storageManager, this.configuration, this.addressSettingsRepository, this.securityRepository, this.resourceManager, this.remotingService, this, this.queueFactory, this.scheduledPool, this.pagingManager, this.haPolicy.isBackup());
        if (!scalingDown) {
            this.deployAddressSettingsFromConfiguration();
        }
        if (!this.configuration.isPersistenceEnabled()) {
            for (AddressSettings addressSettings : this.addressSettingsRepository.values()) {
                if (addressSettings.getAddressFullMessagePolicy() != AddressFullMessagePolicy.PAGE) continue;
                ActiveMQServerLogger.LOGGER.pageWillBePersisted();
                break;
            }
        }
        this.storageManager.start();
        this.postOffice.start();
        this.pagingManager.start();
        this.managementService.start();
        this.resourceManager.start();
        this.deploySecurityFromConfiguration();
        this.deployGroupingHandlerConfiguration(this.configuration.getGroupingHandlerConfiguration());
        this.reloadManager = new ReloadManagerImpl(this.getScheduledPool(), (Executor)this.executorFactory.getExecutor(), this.configuration.getConfigurationFileRefreshPeriod());
        if (this.configuration.getConfigurationUrl() != null && this.getScheduledPool() != null) {
            this.reloadManager.addCallback(this.configuration.getConfigurationUrl(), new ConfigurationFileReloader());
        }
        if (System.getProperty("logging.configuration") != null) {
            try {
                this.reloadManager.addCallback(new URL(System.getProperty("logging.configuration")), new LoggingConfigurationFileReloader());
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.problemAddingConfigReloadCallback(System.getProperty("logging.configuration"), e);
            }
        }
        if (this.hasBrokerPlugins()) {
            this.callBrokerPlugins(plugin -> plugin.registered(this));
        }
        return true;
    }

    synchronized void initialisePart2(boolean scalingDown) throws Exception {
        if (this.state == ActiveMQServer.SERVER_STATE.STOPPED || this.state == ActiveMQServer.SERVER_STATE.STOPPING) {
            return;
        }
        this.pagingManager.reloadStores();
        JournalLoadInformation[] journalInfo = this.loadJournals();
        this.removeExtraAddressStores();
        final ServerInfo dumper = new ServerInfo(this, this.pagingManager);
        long dumpInfoInterval = this.configuration.getServerDumpInterval();
        if (dumpInfoInterval > 0L) {
            this.scheduledPool.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    ActiveMQServerLogger.LOGGER.dumpServerInfo(dumper.dump());
                }
            }, 0L, dumpInfoInterval, TimeUnit.MILLISECONDS);
        }
        this.deployAddressesFromConfiguration();
        this.deployQueuesFromConfiguration();
        this.undeployAddressesAndQueueNotInConfiguration();
        this.deployReloadableConfigFromConfiguration();
        this.callActivateCallbacks();
        this.checkForPotentialOOMEInAddressConfiguration();
        if (!scalingDown) {
            this.deployDiverts();
            if (this.groupingHandler != null) {
                this.groupingHandler.start();
            }
            if (this.groupingHandler != null && this.groupingHandler instanceof LocalGroupingHandler) {
                this.clusterManager.start();
                this.federationManager.start();
                this.groupingHandler.awaitBindings();
                this.remotingService.start();
            } else {
                this.remotingService.start();
                this.clusterManager.start();
                this.federationManager.start();
            }
            if (this.nodeManager.getNodeId() == null) {
                throw ActiveMQMessageBundle.BUNDLE.nodeIdNull();
            }
            this.postOffice.startExpiryScanner();
            this.postOffice.startAddressQueueScanner();
        }
        if (this.configuration.getMaxDiskUsage() != -1) {
            try {
                this.injectMonitor(new FileStoreMonitor(this.getScheduledPool(), (Executor)this.executorFactory.getExecutor(), this.configuration.getDiskScanPeriod(), TimeUnit.MILLISECONDS, (float)this.configuration.getMaxDiskUsage() / 100.0f, this.shutdownOnCriticalIO));
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.unableToInjectMonitor(e);
            }
        }
    }

    public void injectMonitor(FileStoreMonitor storeMonitor) throws Exception {
        this.fileStoreMonitor = storeMonitor;
        this.pagingManager.injectMonitor(storeMonitor);
        this.storageManager.injectMonitor(storeMonitor);
        this.fileStoreMonitor.start();
    }

    public FileStoreMonitor getMonitor() {
        return this.fileStoreMonitor;
    }

    public void completeActivation() throws Exception {
        this.setState(ActiveMQServer.SERVER_STATE.STARTED);
        this.getRemotingService().startAcceptors();
        this.activationLatch.countDown();
        this.callActivationCompleteCallbacks();
    }

    private void registerMeters() {
        MetricsManager metricsManager = this.metricsManager;
        if (metricsManager != null) {
            metricsManager.registerBrokerGauge(builder -> {
                builder.register("connection.count", this, metrics -> this.getConnectionCount(), "Number of clients connected to this server");
                builder.register("total.connection.count", this, metrics -> this.getTotalConnectionCount(), "Number of clients which have connected to this server since it was started");
                builder.register("address.memory.usage", this, metrics -> this.getPagingManager().getGlobalSize(), "Memory used by all the addresses on broker for in-memory messages");
            });
        }
    }

    private void unregisterMeters() {
        MetricsManager metricsManager = this.metricsManager;
        if (metricsManager != null) {
            metricsManager.remove("broker." + this.configuration.getName());
        }
    }

    private void deploySecurityFromConfiguration() {
        for (Map.Entry<String, Set<Role>> entry : this.configuration.getSecurityRoles().entrySet()) {
            this.securityRepository.addMatch(entry.getKey(), entry.getValue(), true);
        }
        for (SecuritySettingPlugin securitySettingPlugin : this.configuration.getSecuritySettingPlugins()) {
            securitySettingPlugin.setSecurityRepository(this.securityRepository);
        }
    }

    private void undeployAddressesAndQueueNotInConfiguration() throws Exception {
        this.undeployAddressesAndQueueNotInConfiguration(this.configuration);
    }

    private void undeployAddressesAndQueueNotInConfiguration(Configuration configuration) throws Exception {
        Set addressesInConfig = configuration.getAddressConfigurations().stream().map(CoreAddressConfiguration::getName).collect(Collectors.toSet());
        Set queuesInConfig = configuration.getAddressConfigurations().stream().map(CoreAddressConfiguration::getQueueConfigurations).flatMap(Collection::stream).map(CoreQueueConfiguration::getName).collect(Collectors.toSet());
        for (SimpleString addressName : this.listAddressNames()) {
            AddressSettings addressSettings = this.getAddressSettingsRepository().getMatch(addressName.toString());
            if (!addressesInConfig.contains(addressName.toString()) && addressSettings.getConfigDeleteAddresses() == DeletionPolicy.FORCE) {
                for (Queue queue : this.listQueues(addressName)) {
                    ActiveMQServerLogger.LOGGER.undeployQueue(queue.getName());
                    queue.deleteQueue(true);
                }
                ActiveMQServerLogger.LOGGER.undeployAddress(addressName);
                this.removeAddressInfo(addressName, null);
                continue;
            }
            if (addressSettings.getConfigDeleteQueues() != DeletionPolicy.FORCE) continue;
            for (Queue queue : this.listConfiguredQueues(addressName)) {
                if (queuesInConfig.contains(queue.getName().toString())) continue;
                ActiveMQServerLogger.LOGGER.undeployQueue(queue.getName());
                queue.deleteQueue(true);
            }
        }
    }

    private Set<SimpleString> listAddressNames() {
        return this.postOffice.getAddresses();
    }

    private List<Queue> listConfiguredQueues(SimpleString address) throws Exception {
        return this.listQueues(address).stream().filter(queue -> queue.isConfigurationManaged()).collect(Collectors.toList());
    }

    private List<Queue> listQueues(SimpleString address) throws Exception {
        return this.postOffice.listQueuesForAddress(address);
    }

    private void deployAddressesFromConfiguration() throws Exception {
        this.deployAddressesFromConfiguration(this.configuration);
    }

    private void deployAddressesFromConfiguration(Configuration configuration) throws Exception {
        for (CoreAddressConfiguration config : configuration.getAddressConfigurations()) {
            try {
                ActiveMQServerLogger.LOGGER.deployAddress(config.getName(), config.getRoutingTypes().toString());
                SimpleString address = SimpleString.toSimpleString((String)config.getName());
                AddressInfo tobe = new AddressInfo(address, config.getRoutingTypes());
                AddressInfo current = this.getAddressInfo(address);
                AddressInfo merged = new AddressInfo(address, tobe.getRoutingType());
                if (current != null) {
                    merged.getRoutingTypes().addAll(current.getRoutingTypes());
                }
                this.addOrUpdateAddressInfo(merged);
                this.deployQueuesFromListCoreQueueConfiguration(config.getQueueConfigurations());
                this.addOrUpdateAddressInfo(tobe);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.problemDeployingAddress(config.getName(), e.getMessage());
            }
        }
    }

    private AddressInfo mergedRoutingTypes(SimpleString address, AddressInfo ... addressInfos) {
        EnumSet<RoutingType> mergedRoutingTypes = EnumSet.noneOf(RoutingType.class);
        for (AddressInfo addressInfo : addressInfos) {
            if (addressInfo == null) continue;
            mergedRoutingTypes.addAll(addressInfo.getRoutingTypes());
        }
        return new AddressInfo(address, mergedRoutingTypes);
    }

    private void deployQueuesFromListCoreQueueConfiguration(List<CoreQueueConfiguration> queues) throws Exception {
        for (CoreQueueConfiguration config : queues) {
            try {
                long delayBeforeDispatch;
                SimpleString queueName = SimpleString.toSimpleString((String)config.getName());
                ActiveMQServerLogger.LOGGER.deployQueue(config.getName(), config.getAddress(), config.getRoutingType().toString());
                AddressSettings as = this.addressSettingsRepository.getMatch(config.getAddress());
                int maxConsumers = config.getMaxConsumers() == null ? as.getDefaultMaxConsumers() : config.getMaxConsumers().intValue();
                boolean isExclusive = config.isExclusive() == null ? as.isDefaultExclusiveQueue() : config.isExclusive().booleanValue();
                boolean groupRebalance = config.isGroupRebalance() == null ? as.isDefaultGroupRebalance() : config.isGroupRebalance().booleanValue();
                int groupBuckets = config.getGroupBuckets() == null ? as.getDefaultGroupBuckets() : config.getGroupBuckets().intValue();
                SimpleString groupFirstKey = config.getGroupFirstKey() == null ? as.getDefaultGroupFirstKey() : SimpleString.toSimpleString((String)config.getGroupFirstKey());
                boolean isLastValue = config.isLastValue() == null ? as.isDefaultLastValueQueue() : config.isLastValue().booleanValue();
                SimpleString lastValueKey = config.getLastValueKey() == null ? as.getDefaultLastValueKey() : SimpleString.toSimpleString((String)config.getLastValueKey());
                boolean isNonDestructive = config.isNonDestructive() == null ? as.isDefaultNonDestructive() : config.isNonDestructive().booleanValue();
                int consumersBeforeDispatch = config.getConsumersBeforeDispatch() == null ? as.getDefaultConsumersBeforeDispatch() : config.getConsumersBeforeDispatch().intValue();
                long l = delayBeforeDispatch = config.getDelayBeforeDispatch() == null ? as.getDefaultDelayBeforeDispatch() : config.getDelayBeforeDispatch().longValue();
                if (this.locateQueue(queueName) != null && this.locateQueue(queueName).getAddress().toString().equals(config.getAddress())) {
                    this.updateQueue(config.getName(), config.getRoutingType(), config.getFilterString(), maxConsumers, config.getPurgeOnNoConsumers(), isExclusive, groupRebalance, groupBuckets, groupFirstKey != null ? groupFirstKey.toString() : null, isNonDestructive, consumersBeforeDispatch, delayBeforeDispatch, config.getUser(), true);
                    continue;
                }
                try {
                    this.createQueue(new AddressInfo(SimpleString.toSimpleString((String)config.getAddress())).addRoutingType(config.getRoutingType()), queueName, SimpleString.toSimpleString((String)config.getFilterString()), SimpleString.toSimpleString((String)config.getUser()), config.isDurable(), false, false, false, false, maxConsumers, config.getPurgeOnNoConsumers(), isExclusive, groupRebalance, groupBuckets, groupFirstKey, isLastValue, lastValueKey, isNonDestructive, consumersBeforeDispatch, delayBeforeDispatch, ActiveMQServerImpl.isAutoDelete(false, as), as.getAutoDeleteQueuesDelay(), as.getAutoDeleteQueuesMessageCount(), true, true);
                }
                catch (ActiveMQQueueExistsException e) {
                    ActiveMQServerLogger.LOGGER.warn(e.getMessage());
                }
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.problemDeployingQueue(config.getName(), e.getMessage());
            }
        }
    }

    private void deployQueuesFromConfiguration() throws Exception {
        this.deployQueuesFromListCoreQueueConfiguration(this.configuration.getQueueConfigurations());
    }

    private void checkForPotentialOOMEInAddressConfiguration() {
        long totalMaxSizeBytes = 0L;
        long addressCount = 0L;
        for (SimpleString address : this.postOffice.getAddresses()) {
            totalMaxSizeBytes += this.addressSettingsRepository.getMatch(address.toString()).getMaxSizeBytes();
            ++addressCount;
        }
        long maxMemory = Runtime.getRuntime().maxMemory();
        if (totalMaxSizeBytes >= maxMemory && this.configuration.getGlobalMaxSize() < 0L) {
            ActiveMQServerLogger.LOGGER.potentialOOME(addressCount, totalMaxSizeBytes, maxMemory);
        }
    }

    private void deployAddressSettingsFromConfiguration() {
        for (Map.Entry<String, AddressSettings> entry : this.configuration.getAddressesSettings().entrySet()) {
            this.addressSettingsRepository.addMatch(entry.getKey(), entry.getValue(), true);
        }
    }

    private JournalLoadInformation[] loadJournals() throws Exception {
        JournalLoader journalLoader = this.activation.createJournalLoader(this.postOffice, this.pagingManager, this.storageManager, this.queueFactory, this.nodeManager, this.managementService, this.groupingHandler, this.configuration, this.parentServer);
        JournalLoadInformation[] journalInfo = new JournalLoadInformation[2];
        ArrayList<QueueBindingInfo> queueBindingInfos = new ArrayList<QueueBindingInfo>();
        ArrayList<GroupingInfo> groupingInfos = new ArrayList<GroupingInfo>();
        ArrayList<AddressBindingInfo> addressBindingInfos = new ArrayList<AddressBindingInfo>();
        journalInfo[0] = this.storageManager.loadBindingJournal(queueBindingInfos, groupingInfos, addressBindingInfos);
        this.recoverStoredConfigs();
        HashMap<Long, AddressBindingInfo> addressBindingInfosMap = new HashMap<Long, AddressBindingInfo>();
        journalLoader.initAddresses(addressBindingInfosMap, addressBindingInfos);
        HashMap<Long, QueueBindingInfo> queueBindingInfosMap = new HashMap<Long, QueueBindingInfo>();
        journalLoader.initQueues(queueBindingInfosMap, queueBindingInfos);
        journalLoader.handleGroupingBindings(groupingInfos);
        HashMap<SimpleString, List<Pair<byte[], Long>>> duplicateIDMap = new HashMap<SimpleString, List<Pair<byte[], Long>>>();
        HashSet<Pair<Long, Long>> pendingLargeMessages = new HashSet<Pair<Long, Long>>();
        LinkedList<PageCountPending> pendingNonTXPageCounter = new LinkedList<PageCountPending>();
        journalInfo[1] = this.storageManager.loadMessageJournal(this.postOffice, this.pagingManager, this.resourceManager, queueBindingInfosMap, duplicateIDMap, pendingLargeMessages, pendingNonTXPageCounter, journalLoader);
        journalLoader.handleDuplicateIds(duplicateIDMap);
        for (Pair<Long, Long> msgToDelete : pendingLargeMessages) {
            ActiveMQServerLogger.LOGGER.deletingPendingMessage(msgToDelete);
            LargeServerMessage msg = this.storageManager.createLargeMessage();
            msg.setMessageID((Long)msgToDelete.getB());
            msg.setPendingRecordID((Long)msgToDelete.getA());
            msg.setDurable(true);
            msg.deleteFile();
        }
        if (pendingNonTXPageCounter.size() != 0) {
            try {
                journalLoader.recoverPendingPageCounters(pendingNonTXPageCounter);
            }
            catch (Throwable e) {
                ActiveMQServerLogger.LOGGER.errorRecoveringPageCounter(e);
            }
        }
        journalLoader.cleanUp();
        return journalInfo;
    }

    private void recoverStoredConfigs() throws Exception {
        List<PersistedAddressSetting> adsettings = this.storageManager.recoverAddressSettings();
        for (PersistedAddressSetting set : adsettings) {
            this.addressSettingsRepository.addMatch(set.getAddressMatch().toString(), set.getSetting());
        }
        List<PersistedRoles> roles = this.storageManager.recoverPersistedRoles();
        for (PersistedRoles roleItem : roles) {
            Set setRoles = SecurityFormatter.createSecurity((String)roleItem.getSendRoles(), (String)roleItem.getConsumeRoles(), (String)roleItem.getCreateDurableQueueRoles(), (String)roleItem.getDeleteDurableQueueRoles(), (String)roleItem.getCreateNonDurableQueueRoles(), (String)roleItem.getDeleteNonDurableQueueRoles(), (String)roleItem.getManageRoles(), (String)roleItem.getBrowseRoles(), (String)roleItem.getCreateAddressRoles(), (String)roleItem.getDeleteAddressRoles());
            this.securityRepository.addMatch(roleItem.getAddressMatch().toString(), setRoles);
        }
    }

    @Override
    public boolean updateAddressInfo(SimpleString address, EnumSet<RoutingType> routingTypes) throws Exception {
        if (this.getAddressInfo(address) == null) {
            return false;
        }
        this.postOffice.updateAddressInfo(address, routingTypes);
        return true;
    }

    @Override
    public boolean updateAddressInfo(SimpleString address, Collection<RoutingType> routingTypes) throws Exception {
        return this.updateAddressInfo(address, EnumSet.copyOf(routingTypes));
    }

    @Override
    public boolean addAddressInfo(AddressInfo addressInfo) throws Exception {
        boolean result = this.postOffice.addAddressInfo(addressInfo);
        return result;
    }

    @Override
    public AddressInfo addOrUpdateAddressInfo(AddressInfo addressInfo) throws Exception {
        if (!this.addAddressInfo(addressInfo)) {
            this.updateAddressInfo(addressInfo.getName(), addressInfo.getRoutingTypes());
        }
        return this.getAddressInfo(addressInfo.getName());
    }

    @Override
    public void removeAddressInfo(SimpleString address, SecurityAuth auth) throws Exception {
        this.removeAddressInfo(address, auth, false);
    }

    @Override
    public void removeAddressInfo(SimpleString address, SecurityAuth auth, boolean force) throws Exception {
        if (auth != null) {
            this.securityStore.check(address, CheckType.DELETE_ADDRESS, auth);
        }
        AddressInfo addressInfo = this.getAddressInfo(address);
        if (this.postOffice.removeAddressInfo(address, force) == null) {
            throw ActiveMQMessageBundle.BUNDLE.addressDoesNotExist(address);
        }
        long txID = this.storageManager.generateID();
        this.storageManager.deleteAddressBinding(txID, addressInfo.getId());
        this.storageManager.commitBindings(txID);
        this.pagingManager.deletePageStore(address);
    }

    @Override
    public String getInternalNamingPrefix() {
        return this.configuration.getInternalNamingPrefix();
    }

    @Override
    public AddressInfo getAddressInfo(SimpleString address) {
        return this.postOffice.getAddressInfo(address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Queue createQueue(AddressInfo addrInfo, SimpleString queueName, SimpleString filterString, SimpleString user, boolean durable, boolean temporary, boolean ignoreIfExists, boolean transientQueue, boolean autoCreated, int maxConsumers, boolean purgeOnNoConsumers, boolean exclusive, boolean groupRebalance, int groupBuckets, SimpleString groupFirstKey, boolean lastValue, SimpleString lastValueKey, boolean nonDestructive, int consumersBeforeDispatch, long delayBeforeDispatch, boolean autoDelete, long autoDeleteDelay, long autoDeleteMessageCount, boolean autoCreateAddress, boolean configurationManaged) throws Exception {
        RoutingType rt;
        SimpleString realQueueName = CompositeAddress.extractQueueName((SimpleString)queueName);
        if (realQueueName == null || realQueueName.length() == 0) {
            throw ActiveMQMessageBundle.BUNDLE.invalidQueueName(queueName);
        }
        QueueBinding binding = (QueueBinding)this.postOffice.getBinding(realQueueName);
        if (binding != null) {
            if (ignoreIfExists) {
                return binding.getQueue();
            }
            throw ActiveMQMessageBundle.BUNDLE.queueAlreadyExists(realQueueName, binding.getAddress());
        }
        Filter filter = FilterImpl.createFilter(filterString);
        long txID = this.storageManager.generateID();
        long queueID = this.storageManager.generateID();
        SimpleString addressToUse = addrInfo == null || addrInfo.getName() == null ? realQueueName : addrInfo.getName();
        QueueConfig.Builder queueConfigBuilder = QueueConfig.builderWith(queueID, realQueueName, addressToUse);
        AddressInfo info = this.postOffice.getAddressInfo(addressToUse);
        RoutingType routingType = addrInfo == null ? null : addrInfo.getRoutingType();
        RoutingType routingType2 = rt = routingType == null ? ActiveMQDefaultConfiguration.getDefaultRoutingType() : routingType;
        if (autoCreateAddress || temporary) {
            if (info == null) {
                AddressInfo addressInfo = new AddressInfo(addressToUse, rt);
                addressInfo.setAutoCreated(true);
                addressInfo.setInternal(addrInfo == null ? false : addrInfo.isInternal());
                this.addAddressInfo(addressInfo);
            } else if (!info.getRoutingTypes().contains(rt)) {
                EnumSet<RoutingType> routingTypes = EnumSet.copyOf(info.getRoutingTypes());
                routingTypes.add(rt);
                this.updateAddressInfo(info.getName(), routingTypes);
            }
        } else {
            if (info == null) {
                throw ActiveMQMessageBundle.BUNDLE.addressDoesNotExist(addressToUse);
            }
            if (!info.getRoutingTypes().contains(rt)) {
                throw ActiveMQMessageBundle.BUNDLE.invalidRoutingTypeForAddress(rt, info.getName().toString(), info.getRoutingTypes());
            }
        }
        QueueConfig queueConfig = queueConfigBuilder.filter(filter).pagingManager(this.pagingManager).user(user).durable(durable).temporary(temporary).autoCreated(autoCreated).routingType(rt).maxConsumers(maxConsumers).purgeOnNoConsumers(purgeOnNoConsumers).exclusive(exclusive).groupRebalance(groupRebalance).groupBuckets(groupBuckets).groupFirstKey(groupFirstKey).lastValue(lastValue).lastValueKey(lastValueKey).nonDestructive(nonDestructive).consumersBeforeDispatch(consumersBeforeDispatch).delayBeforeDispatch(delayBeforeDispatch).autoDelete(autoDelete).autoDeleteDelay(autoDeleteDelay).autoDeleteMessageCount(autoDeleteMessageCount).configurationManaged(configurationManaged).build();
        if (this.hasBrokerQueuePlugins()) {
            this.callBrokerQueuePlugins(plugin -> plugin.beforeCreateQueue(queueConfig));
        }
        Queue queue = this.queueFactory.createQueueWith(queueConfig);
        if (transientQueue) {
            queue.setConsumersRefCount(new TransientQueueManagerImpl(this, queue.getName()));
        } else {
            queue.setConsumersRefCount(new QueueManagerImpl(this, queue.getName()));
        }
        LocalQueueBinding localQueueBinding = new LocalQueueBinding(queue.getAddress(), queue, this.nodeManager.getNodeId());
        if (queue.isDurable()) {
            this.storageManager.addQueueBinding(txID, localQueueBinding);
        }
        try {
            this.postOffice.addBinding(localQueueBinding);
            if (queue.isDurable()) {
                this.storageManager.commitBindings(txID);
            }
        }
        catch (Exception e) {
            try {
                if (durable) {
                    this.storageManager.rollbackBindings(txID);
                }
                PageSubscription pageSubscription = queue.getPageSubscription();
                try {
                    queue.close();
                }
                finally {
                    if (pageSubscription != null) {
                        pageSubscription.destroy();
                    }
                }
            }
            catch (Throwable ignored) {
                logger.debug((Object)ignored.getMessage(), ignored);
            }
            throw e;
        }
        if (addrInfo == null || !addrInfo.isInternal()) {
            this.managementService.registerQueue(queue, queue.getAddress(), this.storageManager);
        }
        if (this.hasBrokerQueuePlugins()) {
            this.callBrokerQueuePlugins(plugin -> plugin.afterCreateQueue(queue));
        }
        this.callPostQueueCreationCallbacks(queue.getName());
        return queue;
    }

    @Override
    public Queue createQueue(SimpleString address, RoutingType routingType, SimpleString queueName, SimpleString filterString, SimpleString user, boolean durable, boolean temporary, boolean ignoreIfExists, boolean transientQueue, boolean autoCreated, int maxConsumers, boolean purgeOnNoConsumers, boolean exclusive, boolean groupRebalance, int groupBuckets, boolean lastValue, SimpleString lastValueKey, boolean nonDestructive, int consumersBeforeDispatch, long delayBeforeDispatch, boolean autoDelete, long autoDeleteDelay, long autoDeleteMessageCount, boolean autoCreateAddress) throws Exception {
        AddressSettings as = this.getAddressSettingsRepository().getMatch(address == null ? queueName.toString() : address.toString());
        return this.createQueue(new AddressInfo(address).addRoutingType(routingType), queueName, filterString, user, durable, temporary, ignoreIfExists, transientQueue, autoCreated, maxConsumers, purgeOnNoConsumers, exclusive, groupRebalance, groupBuckets, as.getDefaultGroupFirstKey(), lastValue, lastValueKey, nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, autoDelete, autoDeleteDelay, autoDeleteMessageCount, autoCreateAddress, false);
    }

    @Override
    public Queue createQueue(SimpleString address, RoutingType routingType, SimpleString queueName, SimpleString filterString, SimpleString user, boolean durable, boolean temporary, boolean ignoreIfExists, boolean transientQueue, boolean autoCreated, int maxConsumers, boolean purgeOnNoConsumers, boolean exclusive, boolean groupRebalance, int groupBuckets, SimpleString groupFirstKey, boolean lastValue, SimpleString lastValueKey, boolean nonDestructive, int consumersBeforeDispatch, long delayBeforeDispatch, boolean autoDelete, long autoDeleteDelay, long autoDeleteMessageCount, boolean autoCreateAddress) throws Exception {
        return this.createQueue(new AddressInfo(address).addRoutingType(routingType), queueName, filterString, user, durable, temporary, ignoreIfExists, transientQueue, autoCreated, maxConsumers, purgeOnNoConsumers, exclusive, groupRebalance, groupBuckets, groupFirstKey, lastValue, lastValueKey, nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, autoDelete, autoDeleteDelay, autoDeleteMessageCount, autoCreateAddress, false);
    }

    @Override
    @Deprecated
    public Queue updateQueue(String name, RoutingType routingType, Integer maxConsumers, Boolean purgeOnNoConsumers) throws Exception {
        return this.updateQueue(name, routingType, maxConsumers, purgeOnNoConsumers, null);
    }

    @Override
    @Deprecated
    public Queue updateQueue(String name, RoutingType routingType, Integer maxConsumers, Boolean purgeOnNoConsumers, Boolean exclusive) throws Exception {
        return this.updateQueue(name, routingType, maxConsumers, purgeOnNoConsumers, null, null);
    }

    @Override
    @Deprecated
    public Queue updateQueue(String name, RoutingType routingType, Integer maxConsumers, Boolean purgeOnNoConsumers, Boolean exclusive, String user) throws Exception {
        return this.updateQueue(name, routingType, null, maxConsumers, purgeOnNoConsumers, exclusive, null, null, null, null, null, user);
    }

    @Override
    public Queue updateQueue(String name, RoutingType routingType, String filterString, Integer maxConsumers, Boolean purgeOnNoConsumers, Boolean exclusive, Boolean groupRebalance, Integer groupBuckets, Boolean nonDestructive, Integer consumersBeforeDispatch, Long delayBeforeDispatch, String user) throws Exception {
        return this.updateQueue(name, routingType, filterString, maxConsumers, purgeOnNoConsumers, exclusive, groupRebalance, groupBuckets, null, nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, user, null);
    }

    @Override
    public Queue updateQueue(String name, RoutingType routingType, String filterString, Integer maxConsumers, Boolean purgeOnNoConsumers, Boolean exclusive, Boolean groupRebalance, Integer groupBuckets, String groupFirstKey, Boolean nonDestructive, Integer consumersBeforeDispatch, Long delayBeforeDispatch, String user) throws Exception {
        return this.updateQueue(name, routingType, filterString, maxConsumers, purgeOnNoConsumers, exclusive, groupRebalance, groupBuckets, groupFirstKey, nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, user, null);
    }

    private Queue updateQueue(String name, RoutingType routingType, String filterString, Integer maxConsumers, Boolean purgeOnNoConsumers, Boolean exclusive, Boolean groupRebalance, Integer groupBuckets, String groupFirstKey, Boolean nonDestructive, Integer consumersBeforeDispatch, Long delayBeforeDispatch, String user, Boolean configurationManaged) throws Exception {
        Filter filter = FilterImpl.createFilter(filterString);
        QueueBinding queueBinding = this.postOffice.updateQueue(new SimpleString(name), routingType, filter, maxConsumers, purgeOnNoConsumers, exclusive, groupRebalance, groupBuckets, SimpleString.toSimpleString((String)groupFirstKey), nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, SimpleString.toSimpleString((String)user), configurationManaged);
        if (queueBinding != null) {
            Queue queue = queueBinding.getQueue();
            return queue;
        }
        return null;
    }

    private void deployDiverts() throws Exception {
        for (DivertConfiguration config : this.configuration.getDivertConfigurations()) {
            this.deployDivert(config);
        }
    }

    private void deployGroupingHandlerConfiguration(GroupingHandlerConfiguration config) throws Exception {
        if (config != null) {
            GroupHandlingAbstract groupingHandler1 = config.getType() == GroupingHandlerConfiguration.TYPE.LOCAL ? new LocalGroupingHandler(this.executorFactory, this.scheduledPool, this.managementService, config.getName(), config.getAddress(), this.getStorageManager(), config.getTimeout(), config.getGroupTimeout(), config.getReaperPeriod()) : new RemoteGroupingHandler(this.executorFactory, this.managementService, config.getName(), config.getAddress(), config.getTimeout(), config.getGroupTimeout());
            this.groupingHandler = groupingHandler1;
            this.managementService.addNotificationListener(groupingHandler1);
        }
    }

    public void checkJournalDirectory() {
        File nodeManagerLockDir;
        File journalDir = this.configuration.getJournalLocation();
        if (!journalDir.exists() && this.configuration.isPersistenceEnabled()) {
            if (this.configuration.isCreateJournalDir()) {
                journalDir.mkdirs();
            } else {
                throw ActiveMQMessageBundle.BUNDLE.cannotCreateDir(journalDir.getAbsolutePath());
            }
        }
        if (!journalDir.equals(nodeManagerLockDir = this.configuration.getNodeManagerLockLocation()) && this.configuration.isPersistenceEnabled() && !nodeManagerLockDir.exists()) {
            nodeManagerLockDir.mkdirs();
        }
    }

    @Override
    public void addProtocolManagerFactory(ProtocolManagerFactory factory) {
        this.protocolManagerFactories.add(factory);
    }

    @Override
    public void removeProtocolManagerFactory(ProtocolManagerFactory factory) {
        this.protocolManagerFactories.remove(factory);
    }

    @Override
    public ActiveMQServer createBackupServer(Configuration configuration) {
        return new ActiveMQServerImpl(configuration, null, this.securityManager, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addScaledDownNode(SimpleString scaledDownNodeId) {
        List<SimpleString> list = this.scaledDownNodeIDs;
        synchronized (list) {
            this.scaledDownNodeIDs.add(scaledDownNodeId);
            if (this.scaledDownNodeIDs.size() > 10) {
                this.scaledDownNodeIDs.remove(10);
            }
        }
    }

    @Override
    public boolean hasScaledDown(SimpleString scaledDownNodeId) {
        return this.scaledDownNodeIDs.contains(scaledDownNodeId);
    }

    void moveServerData(int maxSavedReplicated) throws IOException {
        File[] dataDirs;
        for (File data : dataDirs = new File[]{this.configuration.getBindingsLocation(), this.configuration.getJournalLocation(), this.configuration.getPagingLocation(), this.configuration.getLargeMessagesLocation()}) {
            FileMoveManager moveManager = new FileMoveManager(data, maxSavedReplicated);
            moveManager.doMove();
        }
    }

    @Override
    public String getUptime() {
        long delta = this.getUptimeMillis();
        if (delta == 0L) {
            return "not started";
        }
        return TimeUtils.printDuration((double)delta);
    }

    @Override
    public long getUptimeMillis() {
        if (this.startDate == null) {
            return 0L;
        }
        return new Date().getTime() - this.startDate.getTime();
    }

    @Override
    public boolean addClientConnection(String clientId, boolean unique) {
        AtomicInteger i = this.connectedClientIds.putIfAbsent(clientId, new AtomicInteger(1));
        if (i != null) {
            if (unique && i.get() != 0) {
                return false;
            }
            if (i.incrementAndGet() > 0) {
                this.connectedClientIds.put(clientId, i);
            }
        }
        return true;
    }

    @Override
    public void removeClientConnection(String clientId) {
        AtomicInteger i = (AtomicInteger)this.connectedClientIds.get(clientId);
        if (i != null && i.decrementAndGet() == 0) {
            this.connectedClientIds.remove(clientId);
        }
    }

    private void removeExtraAddressStores() throws Exception {
        SimpleString[] storeNames = this.pagingManager.getStoreNames();
        if (storeNames != null && storeNames.length > 0) {
            for (SimpleString storeName : storeNames) {
                if (this.getAddressInfo(storeName) != null) continue;
                this.pagingManager.deletePageStore(storeName);
            }
        }
    }

    private void deployReloadableConfigFromConfiguration() throws Exception {
        if (this.configurationReloadDeployed.compareAndSet(false, true)) {
            ActiveMQServerLogger.LOGGER.reloadingConfiguration("security");
            this.securityRepository.swap(this.configuration.getSecurityRoles().entrySet());
            ActiveMQServerLogger.LOGGER.reloadingConfiguration("address settings");
            this.addressSettingsRepository.swap(this.configuration.getAddressesSettings().entrySet());
            ActiveMQServerLogger.LOGGER.reloadingConfiguration("diverts");
            for (DivertConfiguration divertConfig : this.configuration.getDivertConfigurations()) {
                if (this.postOffice.getBinding(new SimpleString(divertConfig.getName())) != null) continue;
                this.deployDivert(divertConfig);
            }
            ActiveMQServerLogger.LOGGER.reloadingConfiguration("addresses");
            this.undeployAddressesAndQueueNotInConfiguration(this.configuration);
            this.deployAddressesFromConfiguration(this.configuration);
            this.deployQueuesFromListCoreQueueConfiguration(this.configuration.getQueueConfigurations());
        }
    }

    public Set<ActivateCallback> getActivateCallbacks() {
        return this.activateCallbacks;
    }

    @Override
    public List<ActiveMQComponent> getExternalComponents() {
        return this.externalComponents;
    }

    private final class ConfigurationFileReloader
    implements ReloadCallback {
        private ConfigurationFileReloader() {
        }

        @Override
        public void reload(URL uri) throws Exception {
            Configuration config = new FileConfigurationParser().parseMainConfig(uri.openStream());
            LegacyJMSConfiguration legacyJMSConfiguration = new LegacyJMSConfiguration(config);
            legacyJMSConfiguration.parseConfiguration(uri.openStream());
            ActiveMQServerImpl.this.configuration.setSecurityRoles(config.getSecurityRoles());
            ActiveMQServerImpl.this.configuration.setAddressesSettings(config.getAddressesSettings());
            ActiveMQServerImpl.this.configuration.setDivertConfigurations(config.getDivertConfigurations());
            ActiveMQServerImpl.this.configuration.setAddressConfigurations(config.getAddressConfigurations());
            ActiveMQServerImpl.this.configuration.setQueueConfigurations(config.getQueueConfigurations());
            ActiveMQServerImpl.this.configurationReloadDeployed.set(false);
            if (ActiveMQServerImpl.this.isActive()) {
                ActiveMQServerImpl.this.deployReloadableConfigFromConfiguration();
            }
        }
    }

    private final class ActivationThread
    extends Thread {
        final Runnable runnable;

        ActivationThread(Runnable runnable, String name) {
            super(name);
            this.runnable = runnable;
        }

        @Override
        public void run() {
            ActiveMQServerImpl.this.lockActivation();
            try {
                this.runnable.run();
            }
            finally {
                ActiveMQServerImpl.this.unlockActivation();
            }
        }
    }

    public final class ShutdownOnCriticalErrorListener
    implements IOCriticalErrorListener {
        boolean failedAlready = false;

        public synchronized void onIOException(Throwable cause, String message, SequentialFile file) {
            if (!this.failedAlready) {
                this.failedAlready = true;
                if (file == null) {
                    ActiveMQServerLogger.LOGGER.ioCriticalIOError(message, "NULL", cause);
                } else {
                    ActiveMQServerLogger.LOGGER.ioCriticalIOError(message, file.toString(), cause);
                }
                ActiveMQServerImpl.this.stopTheServer(true);
            }
        }
    }
}

