/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.jdbc.config.annotation.web.http;

import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.serializer.support.DeserializingConverter;
import org.springframework.core.serializer.support.SerializingConverter;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;
import org.springframework.jdbc.support.lob.DefaultLobHandler;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.session.config.annotation.web.http.SpringHttpSessionConfiguration;
import org.springframework.session.jdbc.JdbcOperationsSessionRepository;
import org.springframework.session.jdbc.config.annotation.SpringSessionDataSource;
import org.springframework.session.jdbc.config.annotation.web.http.EnableJdbcHttpSession;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

@Configuration
@EnableScheduling
public class JdbcHttpSessionConfiguration
extends SpringHttpSessionConfiguration
implements BeanClassLoaderAware,
EmbeddedValueResolverAware,
ImportAware,
SchedulingConfigurer {
    static final String DEFAULT_CLEANUP_CRON = "0 * * * * *";
    private Integer maxInactiveIntervalInSeconds = 1800;
    private String tableName = "SPRING_SESSION";
    private String cleanupCron = "0 * * * * *";
    private DataSource dataSource;
    private PlatformTransactionManager transactionManager;
    private LobHandler lobHandler;
    private ConversionService springSessionConversionService;
    private ConversionService conversionService;
    private ClassLoader classLoader;
    private StringValueResolver embeddedValueResolver;

    @Bean
    public JdbcOperationsSessionRepository sessionRepository() {
        JdbcTemplate jdbcTemplate = JdbcHttpSessionConfiguration.createJdbcTemplate(this.dataSource);
        JdbcOperationsSessionRepository sessionRepository = new JdbcOperationsSessionRepository((JdbcOperations)jdbcTemplate, this.transactionManager);
        if (StringUtils.hasText((String)this.tableName)) {
            sessionRepository.setTableName(this.tableName);
        }
        sessionRepository.setDefaultMaxInactiveInterval(this.maxInactiveIntervalInSeconds);
        if (this.lobHandler != null) {
            sessionRepository.setLobHandler(this.lobHandler);
        } else if (JdbcHttpSessionConfiguration.requiresTemporaryLob(this.dataSource)) {
            DefaultLobHandler lobHandler = new DefaultLobHandler();
            lobHandler.setCreateTemporaryLob(true);
            sessionRepository.setLobHandler((LobHandler)lobHandler);
        }
        if (this.springSessionConversionService != null) {
            sessionRepository.setConversionService(this.springSessionConversionService);
        } else if (this.conversionService != null) {
            sessionRepository.setConversionService(this.conversionService);
        } else {
            sessionRepository.setConversionService((ConversionService)this.createConversionServiceWithBeanClassLoader());
        }
        return sessionRepository;
    }

    private static boolean requiresTemporaryLob(DataSource dataSource) {
        try {
            String productName = (String)JdbcUtils.extractDatabaseMetaData((DataSource)dataSource, (String)"getDatabaseProductName");
            return "Oracle".equalsIgnoreCase(JdbcUtils.commonDatabaseName((String)productName));
        }
        catch (MetaDataAccessException ex) {
            return false;
        }
    }

    public void setMaxInactiveIntervalInSeconds(Integer maxInactiveIntervalInSeconds) {
        this.maxInactiveIntervalInSeconds = maxInactiveIntervalInSeconds;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setCleanupCron(String cleanupCron) {
        this.cleanupCron = cleanupCron;
    }

    @Autowired
    public void setDataSource(@SpringSessionDataSource ObjectProvider<DataSource> springSessionDataSource, ObjectProvider<DataSource> dataSource) {
        DataSource dataSourceToUse = (DataSource)springSessionDataSource.getIfAvailable();
        if (dataSourceToUse == null) {
            dataSourceToUse = (DataSource)dataSource.getObject();
        }
        this.dataSource = dataSourceToUse;
    }

    @Autowired
    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Autowired(required=false)
    @Qualifier(value="springSessionLobHandler")
    public void setLobHandler(LobHandler lobHandler) {
        this.lobHandler = lobHandler;
    }

    @Autowired(required=false)
    @Qualifier(value="springSessionConversionService")
    public void setSpringSessionConversionService(ConversionService conversionService) {
        this.springSessionConversionService = conversionService;
    }

    @Autowired(required=false)
    @Qualifier(value="conversionService")
    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.embeddedValueResolver = resolver;
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        String cleanupCron;
        Map attributeMap = importMetadata.getAnnotationAttributes(EnableJdbcHttpSession.class.getName());
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)attributeMap);
        this.maxInactiveIntervalInSeconds = (Integer)attributes.getNumber("maxInactiveIntervalInSeconds");
        String tableNameValue = attributes.getString("tableName");
        if (StringUtils.hasText((String)tableNameValue)) {
            this.tableName = this.embeddedValueResolver.resolveStringValue(tableNameValue);
        }
        if (StringUtils.hasText((String)(cleanupCron = attributes.getString("cleanupCron")))) {
            this.cleanupCron = cleanupCron;
        }
    }

    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
        taskRegistrar.addCronTask(() -> this.sessionRepository().cleanUpExpiredSessions(), this.cleanupCron);
    }

    private static JdbcTemplate createJdbcTemplate(DataSource dataSource) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
        jdbcTemplate.afterPropertiesSet();
        return jdbcTemplate;
    }

    private GenericConversionService createConversionServiceWithBeanClassLoader() {
        GenericConversionService conversionService = new GenericConversionService();
        conversionService.addConverter(Object.class, byte[].class, (Converter)new SerializingConverter());
        conversionService.addConverter(byte[].class, Object.class, (Converter)new DeserializingConverter(this.classLoader));
        return conversionService;
    }
}

