/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.management;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.MBeanServerBuilder;
import javax.management.MBeanServerDelegate;
import org.apache.activemq.artemis.core.server.management.ArtemisMBeanServerGuard;

public class ArtemisMBeanServerBuilder
extends MBeanServerBuilder {
    private static volatile InvocationHandler guard;

    public static void setGuard(InvocationHandler guardHandler) {
        guard = guardHandler;
    }

    public static ArtemisMBeanServerGuard getArtemisMBeanServerGuard() {
        return (ArtemisMBeanServerGuard)guard;
    }

    @Override
    public MBeanServer newMBeanServer(String defaultDomain, MBeanServer outer, MBeanServerDelegate delegate) {
        MBeanInvocationHandler handler = new MBeanInvocationHandler(super.newMBeanServer(defaultDomain, outer, delegate));
        return (MBeanServer)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{MBeanServer.class}, (InvocationHandler)handler);
    }

    private static final class MBeanInvocationHandler
    implements InvocationHandler {
        private final MBeanServer wrapped;
        private final List<String> guarded = Collections.unmodifiableList(Arrays.asList("invoke", "getAttribute", "getAttributes", "setAttribute", "setAttributes"));

        MBeanInvocationHandler(MBeanServer mbeanServer) {
            this.wrapped = mbeanServer;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (this.guarded.contains(method.getName())) {
                if (guard == null) {
                    throw new IllegalStateException("ArtemisMBeanServerBuilder not initialized");
                }
                guard.invoke(proxy, method, args);
            }
            if (method.getName().equals("queryMBeans")) {
                guard.invoke(this.wrapped, method, args);
            }
            if (method.getName().equals("equals") && method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == Object.class) {
                InvocationHandler handler;
                Object target = args[0];
                if (target != null && Proxy.isProxyClass(target.getClass()) && (handler = Proxy.getInvocationHandler(target)) instanceof MBeanInvocationHandler) {
                    args[0] = ((MBeanInvocationHandler)handler).wrapped;
                }
            } else if (method.getName().equals("finalize") && method.getParameterTypes().length == 0) {
                return null;
            }
            try {
                return method.invoke((Object)this.wrapped, args);
            }
            catch (InvocationTargetException ite) {
                throw ite.getCause();
            }
        }
    }
}

