/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.upgrade;

import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.JcrUpgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.deployit.upgrade.RawRepositoryImpl;
import java.util.Collection;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Deployit371PolicyClear
extends JcrUpgrade {
    private static final Logger logger = LoggerFactory.getLogger(Deployit371PolicyClear.class);

    public boolean doUpgrade(RawRepository repository) throws UpgradeException {
        logger.info("*** Running Deployit 3.7.1 upgrade -- Remove policies blocking deletion ***");
        try {
            AccessControlManager manager = Deployit371PolicyClear.getAccessControlManager(repository);
            Collection subtypes = DescriptorRegistry.getSubtypes((Type)Type.valueOf(ConfigurationItem.class));
            for (Type subtype : subtypes) {
                List nodesByType = repository.findNodesByType(subtype);
                for (Node node : nodesByType) {
                    AccessControlPolicy[] policies = manager.getPolicies(node.getPath());
                    if (policies.length <= 0) continue;
                    logger.info("Node [{}] has unwanted policies, cleaning them", (Object)node.getPath());
                    this.clearPolicies(node, manager);
                }
            }
            logger.info("*** Finished Deployit 3.7.1 upgrade ***");
            return true;
        }
        catch (RepositoryException e) {
            throw new UpgradeException("", (Exception)((Object)e));
        }
    }

    private void clearPolicies(Node node, AccessControlManager manager) throws RepositoryException {
        AccessControlPolicy[] policies;
        for (AccessControlPolicy policy : policies = manager.getPolicies(node.getPath())) {
            manager.removePolicy(node.getPath(), policy);
        }
    }

    public Version upgradeVersion() {
        return Version.valueOf((String)"deployit", (String)"3.7.1");
    }

    private static AccessControlManager getAccessControlManager(RawRepository repository) throws RepositoryException {
        Session session = ((RawRepositoryImpl)repository).getSession();
        return session.getAccessControlManager();
    }
}

