/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.exts.concurrent;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000114A!\u0001\u0002\u0001\u0017\tQ\"\t\\8dW&tw\r\u00165sK\u0006$\u0007k\\8m\u000bb,7-\u001e;pe*\u00111\u0001B\u0001\u000bG>t7-\u001e:sK:$(BA\u0003\u0007\u0003\u0011)\u0007\u0010^:\u000b\u0005\u001dA\u0011\u0001C:lg\u0006lW/\u001a7\u000b\u0003%\t1aY8n\u0007\u0001\u00192\u0001\u0001\u0007\u0016!\ti1#D\u0001\u000f\u0015\t\u0019qB\u0003\u0002\u0011#\u0005!Q\u000f^5m\u0015\u0005\u0011\u0012\u0001\u00026bm\u0006L!\u0001\u0006\b\u0003%QC'/Z1e!>|G.\u0012=fGV$xN\u001d\t\u0003-ei\u0011a\u0006\u0006\u00031E\tA\u0001\\1oO&\u0011!d\u0006\u0002\u000e\u0003V$xn\u00117pg\u0016\f'\r\\3\t\u0011q\u0001!\u0011!Q\u0001\nu\t\u0001\u0002]8pYNK'0\u001a\t\u0003=\u0005j\u0011a\b\u0006\u0002A\u0005)1oY1mC&\u0011!e\b\u0002\u0004\u0013:$\b\u0002\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011B\u000f\u0002\u0013E,X-^3TSj,\u0007\"\u0002\u0014\u0001\t\u00039\u0013A\u0002\u001fj]&$h\bF\u0002)U-\u0002\"!\u000b\u0001\u000e\u0003\tAQ\u0001H\u0013A\u0002uAQ\u0001J\u0013A\u0002uAq!\f\u0001C\u0002\u0013\u0005a&A\u0005tK6\f\u0007\u000f[8sKV\tq\u0006\u0005\u0002\u000ea%\u0011\u0011G\u0004\u0002\n'\u0016l\u0017\r\u001d5pe\u0016Daa\r\u0001!\u0002\u0013y\u0013AC:f[\u0006\u0004\bn\u001c:fA!9Q\u0007\u0001b\u0001\n\u00031\u0014a\u0002:v]:LgnZ\u000b\u0002oA\u0011\u0001hO\u0007\u0002s)\u0011!HD\u0001\u0007CR|W.[2\n\u0005qJ$!D!u_6L7MQ8pY\u0016\fg\u000e\u0003\u0004?\u0001\u0001\u0006IaN\u0001\teVtg.\u001b8hA!)\u0001\t\u0001C\u0001\u0003\u00069Q\r_3dkR,GC\u0001\"F!\tq2)\u0003\u0002E?\t!QK\\5u\u0011\u00191u\b\"a\u0001\u000f\u0006!A/Y:l!\rq\u0002JS\u0005\u0003\u0013~\u0011\u0001\u0002\u00102z]\u0006lWM\u0010\t\u0003=-K!\u0001T\u0010\u0003\u0007\u0005s\u0017\u0010C\u0003A\u0001\u0011\u0005c\n\u0006\u0002C\u001f\")\u0001+\u0014a\u0001#\u0006A!/\u001e8oC\ndW\r\u0005\u0002\u0017%&\u00111k\u0006\u0002\t%Vtg.\u00192mK\")Q\u000b\u0001C!-\u0006a\u0011M\u001a;fe\u0016CXmY;uKR\u0019!iV-\t\u000ba#\u0006\u0019A)\u0002\u0003IDQA\u0017+A\u0002m\u000b\u0011\u0001\u001e\t\u00039\u0012t!!\u00182\u000f\u0005y\u000bW\"A0\u000b\u0005\u0001T\u0011A\u0002\u001fs_>$h(C\u0001!\u0013\t\u0019w$A\u0004qC\u000e\\\u0017mZ3\n\u0005\u00154'!\u0003+ie><\u0018M\u00197f\u0015\t\u0019w\u0004C\u0003i\u0001\u0011\u0005\u0013.A\u0003dY>\u001cX\rF\u0001C\u0011\u0015Y\u0007\u0001\"\u0011j\u0003!\u0019\b.\u001e;e_^t\u0007")
public class BlockingThreadPoolExecutor
extends ThreadPoolExecutor
implements AutoCloseable {
    private final Semaphore semaphore;
    private final AtomicBoolean running;

    public Semaphore semaphore() {
        return this.semaphore;
    }

    public AtomicBoolean running() {
        return this.running;
    }

    public void execute(Function0<Object> task) {
        this.execute(new Runnable(null, task){
            private final Function0 task$1;

            public void run() {
                this.task$1.apply();
            }
            {
                this.task$1 = task$1;
            }
        });
    }

    @Override
    public void execute(Runnable runnable) {
        Predef$.MODULE$.require(this.running().get(), (Function0 & java.io.Serializable & Serializable)() -> "This executor has shutdown, cannot accept anymore tasks");
        boolean acquired = false;
        while (!acquired) {
            try {
                this.semaphore().acquire();
                acquired = true;
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            super.execute(runnable);
        }
        catch (RejectedExecutionException e) {
            this.semaphore().release();
            throw e;
        }
    }

    @Override
    public void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        this.semaphore().release();
    }

    @Override
    public void close() {
        this.shutdown();
    }

    @Override
    public void shutdown() {
        this.running().set(false);
        super.shutdown();
    }

    public BlockingThreadPoolExecutor(int poolSize, int queueSize) {
        super(poolSize, poolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.semaphore = new Semaphore(poolSize + queueSize);
        this.running = new AtomicBoolean(true);
    }
}

