/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.crypto;

import java.util.Arrays;
import org.rzo.netty.ahessian.crypto.CryptoException;
import org.rzo.netty.ahessian.crypto.StreamCipher;
import org.rzo.netty.ahessian.crypto.StreamCipherFactory;

public class RC4Cipher
implements StreamCipher {
    public static final int UNINITIALIZED = 0;
    public static final int ENCRYPT = 1;
    public static final int DECRYPT = 2;
    private int[] sBox = new int[256];
    private int x;
    private int y;
    private static final int BLOCK_SIZE = 1;
    private int state;
    private String cipherName = "RC4";

    public final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public int engineBlockSize() {
        return 1;
    }

    @Override
    public void engineInitEncrypt(byte[] key, byte[] iv) throws CryptoException {
        this.makeKey(key);
        this.state = 1;
    }

    @Override
    public void engineInitDecrypt(byte[] key, byte[] iv) throws CryptoException {
        this.makeKey(key);
        this.state = 1;
    }

    protected int engineUpdate(byte[] in, int inOffset, int inLen, byte[] out, int outOffset) {
        boolean doEncrypt;
        if (inLen < 0) {
            throw new IllegalArgumentException("inLen < 0");
        }
        boolean bl = doEncrypt = this.getState() == 1;
        if (in == out && (outOffset >= inOffset && outOffset < inOffset + inLen || inOffset >= outOffset && inOffset < outOffset + inLen)) {
            byte[] newin = new byte[inLen];
            System.arraycopy(in, inOffset, newin, 0, inLen);
            in = newin;
            inOffset = 0;
        }
        this.rc4(in, inOffset, inLen, out, outOffset);
        return inLen;
    }

    private void rc4(byte[] in, int inOffset, int inLen, byte[] out, int outOffset) {
        for (int i = 0; i < inLen; ++i) {
            this.x = this.x + 1 & 0xFF;
            this.y = this.sBox[this.x] + this.y & 0xFF;
            int t = this.sBox[this.x];
            this.sBox[this.x] = this.sBox[this.y];
            this.sBox[this.y] = t;
            int xorIndex = this.sBox[this.x] + this.sBox[this.y] & 0xFF;
            out[outOffset++] = (byte)(in[inOffset++] ^ this.sBox[xorIndex]);
        }
    }

    private void makeKey(byte[] userkey) throws CryptoException {
        if (userkey == null) {
            throw new CryptoException(this.getAlgorithm() + ": Null user key");
        }
        int len = userkey.length;
        if (len == 0) {
            throw new CryptoException(this.getAlgorithm() + ": Invalid user key length");
        }
        this.y = 0;
        this.x = 0;
        for (int i = 0; i < 256; ++i) {
            this.sBox[i] = i;
        }
        int i1 = 0;
        int i2 = 0;
        for (int i = 0; i < 256; ++i) {
            i2 = (userkey[i1] & 0xFF) + this.sBox[i] + i2 & 0xFF;
            int t = this.sBox[i];
            this.sBox[i] = this.sBox[i2];
            this.sBox[i2] = t;
            i1 = (i1 + 1) % len;
        }
    }

    public final String getAlgorithm() {
        return this.cipherName;
    }

    public final int getState() {
        return this.state;
    }

    @Override
    public final byte[] crypt(byte[] data, int position, int length) {
        byte[] buffer = new byte[length];
        this.engineUpdate(data, position, length, buffer, 0);
        return buffer;
    }

    public final byte[] crypt(byte[] data) {
        byte[] buffer = new byte[data.length];
        this.engineUpdate(data, 0, data.length, buffer, 0);
        return buffer;
    }

    @Override
    public final void crypt(byte[] in, int in_offset, int length, byte[] out, int out_offset) {
        this.engineUpdate(in, in_offset, length, out, out_offset);
    }

    public static void main(String[] args) throws Exception {
        byte[] iv = new byte[8];
        byte[] key = new byte[16];
        StreamCipher eCipher = StreamCipherFactory.createCipher("RC4");
        StreamCipher dCipher = StreamCipherFactory.createCipher("RC4");
        eCipher.engineInitEncrypt(key, iv);
        dCipher.engineInitDecrypt(key, iv);
        byte[] msg = "this is a secret message".getBytes();
        byte[] eMsg = new byte[]{};
        long t = System.currentTimeMillis();
        for (int i = 0; i < 1000000; ++i) {
            byte[] cMsg = eCipher.crypt(msg, 0, msg.length);
            eMsg = dCipher.crypt(cMsg, 0, cMsg.length);
        }
        System.out.println(System.currentTimeMillis() - t);
        if (!Arrays.equals(msg, eMsg)) {
            System.out.println("error");
        }
    }
}

