/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.deployment.planner;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.deployment.planner.ExecutablePlan;
import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.rules.StepMetadata;
import com.xebialabs.xlplatform.satellite.Satellite;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public class StepPlan
extends ExecutablePlan {
    public static final Function<StepWithPlanningInfo, Step> stepsWithDeltaToSteps = StepWithPlanningInfo::getStep;
    private ListMultimap<Integer, StepWithPlanningInfo> stepsMap = ArrayListMultimap.create();
    private List<Checkpoint> checkpoints = Lists.newArrayList();
    private Delta deltaUnderPlanning;
    private String ruleUnderPlanning;

    public StepPlan(String description, List<ExecutionStateListener> listeners) {
        super(description, listeners);
    }

    public StepPlan(String description, List<ExecutionStateListener> listeners, Satellite satellite) {
        super(description, listeners, satellite);
    }

    public StepPlan(String description, Collection<Step> steps, List<ExecutionStateListener> listeners) {
        super(description, listeners);
        this.addSteps(steps);
    }

    public StepPlan(String description, Collection<Step> steps, List<ExecutionStateListener> listeners, Satellite satellite) {
        super(description, listeners, satellite);
        this.addSteps(steps);
    }

    public StepPlan(String description, Collection<StepWithPlanningInfo> steps, List<Checkpoint> checkpoints, List<ExecutionStateListener> listeners) {
        super(description, listeners);
        this.checkpoints = checkpoints;
        for (StepWithPlanningInfo step2 : steps) {
            this.stepsMap.put((Object)step2.getStep().getOrder(), (Object)step2);
        }
    }

    public StepPlan(String description, Collection<StepWithPlanningInfo> steps, List<Checkpoint> checkpoints, List<ExecutionStateListener> listeners, Satellite satellite) {
        super(description, listeners, satellite);
        this.checkpoints = checkpoints;
        for (StepWithPlanningInfo step2 : steps) {
            this.stepsMap.put((Object)step2.getStep().getOrder(), (Object)step2);
        }
    }

    public void addStep(Step step2) {
        this.stepsMap.put((Object)step2.getOrder(), (Object)new StepWithPlanningInfo(step2, this.deltaUnderPlanning, this.ruleUnderPlanning));
    }

    public void addSteps(Collection<Step> steps) {
        for (Step step2 : steps) {
            this.addStep(step2);
        }
    }

    public List<StepWithPlanningInfo> getStepsWithPlanningInfo() {
        ArrayList orderedKeys = Lists.newArrayList((Iterable)this.stepsMap.keySet());
        Collections.sort(orderedKeys);
        ArrayList steps = Lists.newArrayList();
        for (Integer key : orderedKeys) {
            steps.addAll(this.stepsMap.get((Object)key));
        }
        return steps;
    }

    public List<Step> getSteps() {
        return Lists.transform(this.getStepsWithPlanningInfo(), stepsWithDeltaToSteps);
    }

    public List<Checkpoint> getCheckpoints() {
        return this.checkpoints;
    }

    @Override
    public List<Checkpoint> findCheckpoints() {
        return new ArrayList<Checkpoint>(this.getCheckpoints());
    }

    @Override
    public Writer writePlan(Writer writer) {
        PrintWriter out = new PrintWriter(writer);
        out.println(" * " + this.getDescription());
        out.println("   " + Strings.repeat((String)"-", (int)this.getDescription().length()));
        ArrayListMultimap checkpointsByStep = ArrayListMultimap.create();
        for (Checkpoint checkpoint2 : this.checkpoints) {
            checkpointsByStep.put((Object)checkpoint2.getStep(), (Object)checkpoint2);
        }
        int index = 0;
        for (StepWithPlanningInfo swo : this.getStepsWithPlanningInfo()) {
            out.format("%2s. (%3s) - %s  (step: %s, rule: %s)%n", ++index, swo.getStep().getOrder(), swo.getStep().getDescription(), this.getStepName(swo.getStep()), swo.getRule());
            if (!checkpointsByStep.containsKey((Object)swo.step)) continue;
            for (Checkpoint checkpoint3 : checkpointsByStep.get((Object)swo.getStep())) {
                out.format("            *checkpoint*  %s%n", checkpoint3);
            }
        }
        if (index == 0) {
            out.format("<empty plan>", new Object[0]);
        }
        return writer;
    }

    private String getStepName(Step step2) {
        StepMetadata stepMetadata = step2.getClass().getAnnotation(StepMetadata.class);
        return stepMetadata != null ? stepMetadata.name() : step2.getClass().getSimpleName();
    }

    public void setDeltaUnderPlanning(Delta delta) {
        this.deltaUnderPlanning = delta;
    }

    public void setRuleUnderPlanning(String rule) {
        this.ruleUnderPlanning = rule;
    }

    public static class Checkpoint
    implements Serializable {
        private Delta delta;
        private Operation operation;
        private String intermediateCheckpointName;
        private Step step;
        private final String id = UUID.randomUUID().toString();

        public Checkpoint(Delta delta, Step step2) {
            this(delta, step2, delta.getOperation(), null);
        }

        public Checkpoint(Delta delta, Step step2, Operation operation, String intermediateCheckpointName) {
            this.delta = delta;
            this.step = step2;
            this.operation = operation != null ? operation : delta.getOperation();
            this.intermediateCheckpointName = intermediateCheckpointName;
        }

        public Delta getDelta() {
            return this.delta;
        }

        public Step getStep() {
            return this.step;
        }

        public Operation getOperation() {
            return this.operation;
        }

        public String getId() {
            return this.id;
        }

        public String getIntermediateCheckpointName() {
            return this.intermediateCheckpointName;
        }

        public String toString() {
            String prefix = "";
            if (this.intermediateCheckpointName != null) {
                prefix = String.format("(intermediate: '%s') ", this.intermediateCheckpointName);
            }
            switch (this.operation) {
                case CREATE: {
                    return prefix + String.format("%s %s", this.operation, this.delta.getDeployed());
                }
                case MODIFY: {
                    return prefix + String.format("%s from %s to %s", this.operation, this.delta.getPrevious(), this.delta.getDeployed());
                }
                case DESTROY: {
                    return prefix + String.format("%s %s", this.operation, this.delta.getPrevious());
                }
            }
            return prefix + this.operation.toString();
        }
    }

    public static class StepWithPlanningInfo {
        private Set<Delta> deltas = Sets.newHashSet();
        private Step step;
        private String rule;

        public StepWithPlanningInfo(Step step2, Delta delta, String rule) {
            this.rule = rule;
            if (delta != null) {
                this.deltas.add(delta);
            }
            this.step = step2;
        }

        public StepWithPlanningInfo(Step step2, Set<Delta> deltas) {
            this.deltas.addAll(deltas);
            this.step = step2;
        }

        public Set<Delta> getDeltas() {
            return this.deltas;
        }

        public String getRule() {
            return this.rule;
        }

        public Step getStep() {
            return this.step;
        }
    }
}

