/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security.sql;

import com.xebialabs.deployit.core.sql.OrderBy;
import com.xebialabs.deployit.core.sql.OrderBy$;
import com.xebialabs.deployit.core.sql.Queries;
import com.xebialabs.deployit.core.sql.SelectBuilder;
import com.xebialabs.deployit.core.sql.Selectable;
import com.xebialabs.deployit.core.sql.SqlCondition;
import com.xebialabs.deployit.core.sql.SqlCondition$;
import com.xebialabs.deployit.core.sql.SqlDialect;
import com.xebialabs.deployit.core.sql.SqlFunction$;
import com.xebialabs.deployit.core.sql.spring.Setter;
import com.xebialabs.deployit.core.sql.spring.package;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.security.RepoUser;
import com.xebialabs.deployit.security.SHA256PasswordEncoder;
import com.xebialabs.deployit.security.User;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.deployit.security.authentication.AuthenticationFailureException;
import com.xebialabs.deployit.security.authentication.UserAlreadyExistsException;
import com.xebialabs.deployit.security.sql.InternalUser;
import com.xebialabs.deployit.security.sql.UserQueries;
import com.xebialabs.deployit.security.sql.UserSchema$;
import com.xebialabs.deployit.security.sql.package$;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Component
@Scope(proxyMode=ScopedProxyMode.TARGET_CLASS)
@Transactional(value="mainTransactionManager")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005h\u0001\u0002\u000b\u0016\u0001\u0001B\u0001\"\r\u0001\u0003\u0006\u0004%\tA\r\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005g!A\u0001\t\u0001BC\u0002\u0013\r\u0011\t\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003C\u0011\u0015I\u0005\u0001\"\u0001K\u0011\u001d)\u0007A1A\u0005\u0002\u0019DaA\u001b\u0001!\u0002\u00139\u0007\"B6\u0001\t\u0013a\u0007bBA\u0006\u0001\u0011\u0005\u0013Q\u0002\u0005\b\u0003/\u0001A\u0011BA\r\u0011\u001d\t\u0019\u0003\u0001C\u0005\u0003KAq!!\u000e\u0001\t\u0003\n9\u0004C\u0004\u0002B\u0001!\t%a\u0011\t\u000f\u0005-\u0003\u0001\"\u0011\u0002N!9\u00111\n\u0001\u0005B\u0005U\u0003bBA0\u0001\u0011\u0005\u0013\u0011\r\u0005\b\u0003K\u0002A\u0011IA4\u0011\u001d\ti\u0007\u0001C!\u0003_Bq!!\u001c\u0001\t\u0003\niH\u0001\bTc2,6/\u001a:TKJ4\u0018nY3\u000b\u0005Y9\u0012aA:rY*\u0011\u0001$G\u0001\tg\u0016\u001cWO]5us*\u0011!dG\u0001\tI\u0016\u0004Hn\\=ji*\u0011A$H\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011AH\u0001\u0004G>l7\u0001A\n\u0005\u0001\u0005JS\u0006\u0005\u0002#O5\t1E\u0003\u0002%K\u0005!A.\u00198h\u0015\u00051\u0013\u0001\u00026bm\u0006L!\u0001K\u0012\u0003\r=\u0013'.Z2u!\tQ3&D\u0001\u0018\u0013\tasCA\u0006Vg\u0016\u00148+\u001a:wS\u000e,\u0007C\u0001\u00180\u001b\u0005)\u0012B\u0001\u0019\u0016\u0005-)6/\u001a:Rk\u0016\u0014\u0018.Z:\u0002\u0019)$'m\u0019+f[Bd\u0017\r^3\u0016\u0003M\u0002\"\u0001N\u001f\u000e\u0003UR!AN\u001c\u0002\t\r|'/\u001a\u0006\u0003qe\nAA\u001b3cG*\u0011!hO\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\tA(A\u0002pe\u001eL!AP\u001b\u0003\u0019)#'m\u0019+f[Bd\u0017\r^3\u0002\u001b)$'m\u0019+f[Bd\u0017\r^3!\u0003)\u0019\u0018\u000f\u001c#jC2,7\r^\u000b\u0002\u0005B\u00111IR\u0007\u0002\t*\u0011a#\u0012\u0006\u0003meI!a\u0012#\u0003\u0015M\u000bH\u000eR5bY\u0016\u001cG/A\u0006tc2$\u0015.\u00197fGR\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002LAR\u0011A*\u0014\t\u0003]\u0001AQ\u0001Q\u0003A\u0004\tCC!T(Z5B\u0011\u0001kV\u0007\u0002#*\u0011!kU\u0001\u000bC:tw\u000e^1uS>t'B\u0001+V\u0003\u001d1\u0017m\u0019;pefT!AV\u001d\u0002\u000b\t,\u0017M\\:\n\u0005a\u000b&!C)vC2Lg-[3s\u0003\u00151\u0018\r\\;fC\u0005Y\u0016AD7bS:\u001c\u0016\u000f\u001c#jC2,7\r\u001e\u0015\u0003\u001bv\u0003\"\u0001\u00150\n\u0005}\u000b&!C!vi><\u0018N]3e\u0011\u0015\tT\u00011\u00014Q\u0011\u0001w*\u00172\"\u0003\r\f\u0001#\\1j]*#'m\u0019+f[Bd\u0017\r^3)\u0005\u0001l\u0016a\u00049bgN<xN\u001d3F]\u000e|G-\u001a:\u0016\u0003\u001d\u0004\"A\u000b5\n\u0005%<\"!F*I\u0003J*d\u0007U1tg^|'\u000fZ#oG>$WM]\u0001\u0011a\u0006\u001c8o^8sI\u0016s7m\u001c3fe\u0002\n!c^5uQV\u001bXM\u001d8b[\u00164\u0015\u000e\u001c;feR!Qn]A\u0001!\tq\u0017/D\u0001p\u0015\u0005\u0001\u0018!B:dC2\f\u0017B\u0001:p\u0005\r\te.\u001f\u0005\u0006i\"\u0001\r!^\u0001\tkN,'O\\1nKB\u0011a/ \b\u0003on\u0004\"\u0001_8\u000e\u0003eT!A_\u0010\u0002\rq\u0012xn\u001c;?\u0013\tax.\u0001\u0004Qe\u0016$WMZ\u0005\u0003}~\u0014aa\u0015;sS:<'B\u0001?p\u0011\u001d\t\u0019\u0001\u0003a\u0001\u0003\u000b\tqAY;jY\u0012,'\u000fE\u0002D\u0003\u000fI1!!\u0003E\u00055\u0019V\r\\3di\n+\u0018\u000e\u001c3fe\u0006Q1m\\;oiV\u001bXM]:\u0015\t\u0005=\u0011Q\u0003\t\u0004]\u0006E\u0011bAA\n_\n!Aj\u001c8h\u0011\u0015!\u0018\u00021\u0001v\u0003I\u0019\u0007.Z2l-\u0006d\u0017\u000eZ+tKJt\u0017-\\3\u0015\t\u0005m\u0011\u0011\u0005\t\u0004]\u0006u\u0011bAA\u0010_\n!QK\\5u\u0011\u0015!(\u00021\u0001v\u0003!\u0011X-\u00193Vg\u0016\u0014H\u0003BA\u0014\u0003g\u0001RA\\A\u0015\u0003[I1!a\u000bp\u0005\u0019y\u0005\u000f^5p]B\u0019a&a\f\n\u0007\u0005ERC\u0001\u0007J]R,'O\\1m+N,'\u000fC\u0003u\u0017\u0001\u0007Q/\u0001\u0003sK\u0006$G\u0003BA\u001d\u0003\u007f\u00012AKA\u001e\u0013\r\tid\u0006\u0002\u0005+N,'\u000fC\u0003u\u0019\u0001\u0007Q/\u0001\u0007bkRDWM\u001c;jG\u0006$X\r\u0006\u0004\u0002\u001c\u0005\u0015\u0013q\t\u0005\u0006i6\u0001\r!\u001e\u0005\u0007\u0003\u0013j\u0001\u0019A;\u0002\u0011A\f7o]<pe\u0012\fa\"\\8eS\u001aL\b+Y:to>\u0014H\r\u0006\u0004\u0002\u001c\u0005=\u0013\u0011\u000b\u0005\u0006i:\u0001\r!\u001e\u0005\u0007\u0003'r\u0001\u0019A;\u0002\u00179,w\u000fU1tg^|'\u000f\u001a\u000b\t\u00037\t9&!\u0017\u0002\\!)Ao\u0004a\u0001k\"1\u00111K\bA\u0002UDa!!\u0018\u0010\u0001\u0004)\u0018aC8mIB\u000b7o]<pe\u0012\fa\u0001Z3mKR,G\u0003BA\u000e\u0003GBQ\u0001\u001e\tA\u0002U\faa\u0019:fCR,GCBA\u000e\u0003S\nY\u0007C\u0003u#\u0001\u0007Q\u000f\u0003\u0004\u0002JE\u0001\r!^\u0001\u000eY&\u001cH/V:fe:\fW.Z:\u0015\u0005\u0005E\u0004#BA:\u0003s*XBAA;\u0015\r\t9(J\u0001\u0005kRLG.\u0003\u0003\u0002|\u0005U$\u0001\u0002'jgR$\u0002\"!\u001d\u0002\u0000\u0005\u0005\u0015\u0011\u0014\u0005\u0006iN\u0001\r!\u001e\u0005\b\u0003\u0007\u001b\u0002\u0019AAC\u0003\u0019\u0001\u0018mZ5oOB!\u0011qQAK\u001b\t\tII\u0003\u0003\u0002\f\u00065\u0015a\u00013u_*!\u0011qRAI\u0003\r\t\u0007/\u001b\u0006\u0004\u0003'K\u0012AB3oO&tW-\u0003\u0003\u0002\u0018\u0006%%A\u0002)bO&tw\rC\u0004\u0002\u001cN\u0001\r!!(\u0002\u000b=\u0014H-\u001a:\u0011\t\u0005\u001d\u0015qT\u0005\u0005\u0003C\u000bII\u0001\u0005Pe\u0012,'/\u001b8hQ\u0019\u0001\u0011QU-\u00024B!\u0011qUAX\u001b\t\tIKC\u0002S\u0003WS1!!,:\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\n\t\u0005E\u0016\u0011\u0016\u0002\u000e)J\fgn]1di&|g.\u00197\"\u0005\u0005U\u0016AF7bS:$&/\u00198tC\u000e$\u0018n\u001c8NC:\fw-\u001a:)\u000f\u0001\tI,a2\u0002JB!\u00111XAb\u001b\t\tiLC\u0002S\u0003\u007fS1!!1:\u0003\u001d\u0019wN\u001c;fqRLA!!2\u0002>\n)1kY8qK\u0006I\u0001O]8ys6{G-\u001a\u0013\u0003\u0003\u0017LA!!4\u0002P\u0006aA+\u0011*H\u000bR{6\tT!T'*!\u0011\u0011[A_\u0003=\u00196m\u001c9fIB\u0013x\u000e_=N_\u0012,\u0007f\u0001\u0001\u0002VB!\u0011q[Ao\u001b\t\tINC\u0002\u0002\\f\n!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\ty.!7\u0003\u0013\r{W\u000e]8oK:$\b")
public class SqlUserService
implements UserService,
UserQueries {
    private final JdbcTemplate jdbcTemplate;
    private final SqlDialect sqlDialect;
    private final SHA256PasswordEncoder passwordEncoder;
    private final String SELECT;
    private final String SELECT_NAMES;
    private final String INSERT;
    private final String UPDATE;
    private final String DELETE;

    public Queries.SqlBuilderHelper SqlBuilderHelper(StringContext sc) {
        return Queries.SqlBuilderHelper$((Queries)this, (StringContext)sc);
    }

    @Override
    public String SELECT() {
        return this.SELECT;
    }

    @Override
    public String SELECT_NAMES() {
        return this.SELECT_NAMES;
    }

    @Override
    public String INSERT() {
        return this.INSERT;
    }

    @Override
    public String UPDATE() {
        return this.UPDATE;
    }

    @Override
    public String DELETE() {
        return this.DELETE;
    }

    @Override
    public void com$xebialabs$deployit$security$sql$UserQueries$_setter_$SELECT_$eq(String x$1) {
        this.SELECT = x$1;
    }

    @Override
    public void com$xebialabs$deployit$security$sql$UserQueries$_setter_$SELECT_NAMES_$eq(String x$1) {
        this.SELECT_NAMES = x$1;
    }

    @Override
    public void com$xebialabs$deployit$security$sql$UserQueries$_setter_$INSERT_$eq(String x$1) {
        this.INSERT = x$1;
    }

    @Override
    public void com$xebialabs$deployit$security$sql$UserQueries$_setter_$UPDATE_$eq(String x$1) {
        this.UPDATE = x$1;
    }

    @Override
    public void com$xebialabs$deployit$security$sql$UserQueries$_setter_$DELETE_$eq(String x$1) {
        this.DELETE = x$1;
    }

    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public SqlDialect sqlDialect() {
        return this.sqlDialect;
    }

    public SHA256PasswordEncoder passwordEncoder() {
        return this.passwordEncoder;
    }

    private Object withUsernameFilter(String username, SelectBuilder builder) {
        return username != null ? builder.where((SqlCondition)SqlCondition$.MODULE$.like((Selectable)SqlFunction$.MODULE$.lower().apply((Object)UserSchema$.MODULE$.USERNAME()), new StringBuilder(2).append("%").append(username.toLowerCase()).append("%").toString())) : BoxedUnit.UNIT;
    }

    public long countUsers(String username) {
        SelectBuilder builder = (SelectBuilder)new SelectBuilder(UserSchema$.MODULE$.tableName(), this.sqlDialect()).select((Selectable)SqlFunction$.MODULE$.countAll());
        this.withUsernameFilter(username, builder);
        return BoxesRunTime.unboxToLong((Object)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.jdbcTemplate().query(builder.query(), (PreparedStatementSetter)new Setter(builder.parameters()), (RowMapper)new SingleColumnRowMapper(Long.TYPE))).asScala()).head());
    }

    private void checkValidUsername(String username) {
        if (username == null || username.length() == 0) {
            throw new IllegalArgumentException("Username can neither be null nor empty.");
        }
        this.readUser(username).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            throw new UserAlreadyExistsException(username);
        });
    }

    private Option<InternalUser> readUser(String username) {
        return ((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.jdbcTemplate().queryForList(this.SELECT(), new Object[]{username.toLowerCase()})).asScala()).map((Function1 & Serializable & scala.Serializable)map -> new InternalUser((String)map.get(UserSchema$.MODULE$.USERNAME().name()), (String)map.get(UserSchema$.MODULE$.PASSWORD().name())), Buffer$.MODULE$.canBuildFrom())).headOption();
    }

    public User read(String username) {
        return (User)this.readUser(username).map((Function1 & Serializable & scala.Serializable)user -> {
            String string = user.username();
            String string2 = "admin";
            return new RepoUser(user.username(), !(string != null ? !string.equals(string2) : string2 != null));
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(14).append("No such user: ").append(username).toString(), new Object[0]);
        });
    }

    public void authenticate(String username, String password) {
        InternalUser user = (InternalUser)this.readUser(username).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new AuthenticationFailureException(new StringBuilder(20).append("Cannot authenticate ").append(username).toString());
        });
        if (!this.passwordEncoder().matches((CharSequence)password, user.passwordHash())) {
            throw new AuthenticationFailureException(new StringBuilder(36).append("Wrong credentials supplied for user ").append(username).toString());
        }
    }

    public void modifyPassword(String username, String newPassword) {
        this.jdbcTemplate().update(this.UPDATE(), new Object[]{this.passwordEncoder().encode((CharSequence)newPassword), username});
    }

    public void modifyPassword(String username, String newPassword, String oldPassword) {
        this.readUser(username).foreach((Function1 & Serializable & scala.Serializable)user -> {
            SqlUserService.$anonfun$modifyPassword$1(this, oldPassword, username, newPassword, user);
            return BoxedUnit.UNIT;
        });
    }

    public void delete(String username) {
        this.jdbcTemplate().update(this.DELETE(), new Object[]{username});
    }

    public void create(String username, String password) {
        this.checkValidUsername(username);
        this.jdbcTemplate().update(this.INSERT(), new Object[]{username, this.passwordEncoder().encode((CharSequence)password)});
    }

    public java.util.List<String> listUsernames() {
        return this.jdbcTemplate().queryForList(this.SELECT_NAMES(), String.class);
    }

    public java.util.List<String> listUsernames(String username, Paging paging, Ordering order) {
        SelectBuilder builder = (SelectBuilder)new SelectBuilder(UserSchema$.MODULE$.tableName(), this.sqlDialect()).select((Selectable)UserSchema$.MODULE$.USERNAME());
        this.withUsernameFilter(username, builder);
        Object object = paging != null ? builder.showPage(paging.page(), paging.resultsPerPage()) : BoxedUnit.UNIT;
        Object object2 = order != null ? builder.orderBy((OrderBy)(order.isAscending() ? OrderBy$.MODULE$.asc((Selectable)SqlFunction$.MODULE$.lower().apply((Object)UserSchema$.MODULE$.USERNAME())) : OrderBy$.MODULE$.desc((Selectable)SqlFunction$.MODULE$.lower().apply((Object)UserSchema$.MODULE$.USERNAME())))) : BoxedUnit.UNIT;
        List names = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.jdbcTemplate().query(builder.query(), (PreparedStatementSetter)new Setter(builder.parameters()), (RowMapper)new package.MapRowMapper())).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.get(UserSchema$.MODULE$.USERNAME().name()).toString(), Buffer$.MODULE$.canBuildFrom())).toList();
        return package$.MODULE$.asMutableJavaList(names);
    }

    public static final /* synthetic */ void $anonfun$modifyPassword$1(SqlUserService $this, String oldPassword$1, String username$4, String newPassword$1, InternalUser user) {
        if (!$this.passwordEncoder().matches((CharSequence)oldPassword$1, user.passwordHash())) {
            throw new IllegalArgumentException("Failed to change password: Old password does not match.");
        }
        $this.modifyPassword(username$4, newPassword$1);
    }

    public SqlUserService(@Autowired @Qualifier(value="mainJdbcTemplate") JdbcTemplate jdbcTemplate, @Autowired @Qualifier(value="mainSqlDialect") SqlDialect sqlDialect) {
        this.jdbcTemplate = jdbcTemplate;
        this.sqlDialect = sqlDialect;
        Queries.$init$((Queries)this);
        UserQueries.$init$(this);
        this.passwordEncoder = new SHA256PasswordEncoder();
    }
}

