/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.config;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.core.config.XldConfig;
import com.xebialabs.xlplatform.settings.CommonSettings;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Configuration;
import org.springframework.session.jdbc.config.annotation.SpringSessionDataSource;
import org.springframework.session.jdbc.config.annotation.web.http.JdbcHttpSessionConfiguration;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
public class SpringSessionConfig
extends JdbcHttpSessionConfiguration {
    private final int DEFAULT_MAX_INACTIVE_INTERVAL = 2592000;

    public SpringSessionConfig(XldConfig xldConfig) {
        ServerConfiguration serverConfiguration = ServerConfiguration.getInstance();
        int sessionTimeoutSeconds = (int)TimeUnit.MINUTES.toSeconds(serverConfiguration.getClientSessionTimeoutMinutes());
        int maxInactiveInterval = sessionTimeoutSeconds == 0 ? 2592000 : sessionTimeoutSeconds;
        super.setMaxInactiveIntervalInSeconds(Integer.valueOf(maxInactiveInterval));
        CommonSettings commonSettings = new CommonSettings(xldConfig.rootConfig());
        super.setCleanupCron(commonSettings.session().cleanupCron());
    }

    @Autowired
    public void setDataSource(@SpringSessionDataSource ObjectProvider<DataSource> springSessionDataSource, @Qualifier(value="mainDataSource") ObjectProvider<DataSource> dataSource) {
        super.setDataSource(springSessionDataSource, dataSource);
    }

    @Autowired
    public void setTransactionManager(@Qualifier(value="mainTransactionManager") PlatformTransactionManager transactionManager) {
        super.setTransactionManager(transactionManager);
    }
}

