/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.impl.journal;

import java.nio.ByteBuffer;
import java.sql.Connection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.storage.DatabaseStorageConfiguration;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.io.nio.NIOSequentialFileFactory;
import org.apache.activemq.artemis.core.persistence.impl.journal.JournalStorageManager;
import org.apache.activemq.artemis.jdbc.store.drivers.JDBCUtils;
import org.apache.activemq.artemis.jdbc.store.file.JDBCSequentialFileFactory;
import org.apache.activemq.artemis.jdbc.store.journal.JDBCJournalImpl;
import org.apache.activemq.artemis.jdbc.store.sql.PropertySQLProvider;
import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzer;

public class JDBCJournalStorageManager
extends JournalStorageManager {
    private Connection connection;

    public JDBCJournalStorageManager(Configuration config, CriticalAnalyzer analyzer, ExecutorFactory executorFactory, ExecutorFactory ioExecutorFactory, ScheduledExecutorService scheduledExecutorService) {
        super(config, analyzer, executorFactory, scheduledExecutorService, ioExecutorFactory);
    }

    public JDBCJournalStorageManager(Configuration config, CriticalAnalyzer analyzer, ScheduledExecutorService scheduledExecutorService, ExecutorFactory executorFactory, ExecutorFactory ioExecutorFactory, IOCriticalErrorListener criticalErrorListener) {
        super(config, analyzer, executorFactory, scheduledExecutorService, ioExecutorFactory, criticalErrorListener);
    }

    @Override
    protected synchronized void init(Configuration config, IOCriticalErrorListener criticalErrorListener) {
        try {
            JDBCSequentialFileFactory largeMessagesFactory;
            JDBCJournalImpl messageJournal;
            JDBCJournalImpl bindingsJournal;
            DatabaseStorageConfiguration dbConf = (DatabaseStorageConfiguration)config.getStoreConfiguration();
            if (dbConf.getDataSource() != null) {
                SQLProvider.Factory sqlProviderFactory = dbConf.getSqlProviderFactory();
                if (sqlProviderFactory == null) {
                    sqlProviderFactory = new PropertySQLProvider.Factory(dbConf.getDataSource());
                }
                bindingsJournal = new JDBCJournalImpl(dbConf.getDataSource(), sqlProviderFactory.create(dbConf.getBindingsTableName(), SQLProvider.DatabaseStoreType.BINDINGS_JOURNAL), this.scheduledExecutorService, (Executor)this.executorFactory.getExecutor(), criticalErrorListener, dbConf.getJdbcJournalSyncPeriodMillis());
                messageJournal = new JDBCJournalImpl(dbConf.getDataSource(), sqlProviderFactory.create(dbConf.getMessageTableName(), SQLProvider.DatabaseStoreType.MESSAGE_JOURNAL), this.scheduledExecutorService, (Executor)this.executorFactory.getExecutor(), criticalErrorListener, dbConf.getJdbcJournalSyncPeriodMillis());
                largeMessagesFactory = new JDBCSequentialFileFactory(dbConf.getDataSource(), sqlProviderFactory.create(dbConf.getLargeMessageTableName(), SQLProvider.DatabaseStoreType.LARGE_MESSAGE), (Executor)this.executorFactory.getExecutor(), criticalErrorListener);
            } else {
                String driverClassName = dbConf.getJdbcDriverClassName();
                bindingsJournal = new JDBCJournalImpl(dbConf.getJdbcConnectionUrl(), dbConf.getJdbcUser(), dbConf.getJdbcPassword(), driverClassName, JDBCUtils.getSQLProvider((String)driverClassName, (String)dbConf.getBindingsTableName(), (SQLProvider.DatabaseStoreType)SQLProvider.DatabaseStoreType.BINDINGS_JOURNAL), this.scheduledExecutorService, (Executor)this.executorFactory.getExecutor(), criticalErrorListener, dbConf.getJdbcJournalSyncPeriodMillis());
                messageJournal = new JDBCJournalImpl(dbConf.getJdbcConnectionUrl(), dbConf.getJdbcUser(), dbConf.getJdbcPassword(), driverClassName, JDBCUtils.getSQLProvider((String)driverClassName, (String)dbConf.getMessageTableName(), (SQLProvider.DatabaseStoreType)SQLProvider.DatabaseStoreType.MESSAGE_JOURNAL), this.scheduledExecutorService, (Executor)this.executorFactory.getExecutor(), criticalErrorListener, dbConf.getJdbcJournalSyncPeriodMillis());
                largeMessagesFactory = new JDBCSequentialFileFactory(dbConf.getJdbcConnectionUrl(), dbConf.getJdbcUser(), dbConf.getJdbcPassword(), driverClassName, JDBCUtils.getSQLProvider((String)driverClassName, (String)dbConf.getLargeMessageTableName(), (SQLProvider.DatabaseStoreType)SQLProvider.DatabaseStoreType.LARGE_MESSAGE), (Executor)this.executorFactory.getExecutor(), criticalErrorListener);
            }
            int networkTimeout = dbConf.getJdbcNetworkTimeout();
            if (networkTimeout >= 0) {
                bindingsJournal.setNetworkTimeout((Executor)this.executorFactory.getExecutor(), networkTimeout);
            }
            if (networkTimeout >= 0) {
                messageJournal.setNetworkTimeout((Executor)this.executorFactory.getExecutor(), networkTimeout);
            }
            if (networkTimeout >= 0) {
                largeMessagesFactory.setNetworkTimeout((Executor)this.executorFactory.getExecutor(), networkTimeout);
            }
            this.bindingsJournal = bindingsJournal;
            this.messageJournal = messageJournal;
            this.largeMessagesFactory = largeMessagesFactory;
            largeMessagesFactory.start();
        }
        catch (Exception e) {
            criticalErrorListener.onIOException((Throwable)e, e.getMessage(), null);
        }
    }

    @Override
    public synchronized void stop(boolean ioCriticalError, boolean sendFailover) throws Exception {
        if (!this.started) {
            return;
        }
        if (!ioCriticalError) {
            this.performCachedLargeMessageDeletes();
            if (this.journalLoaded && this.idGenerator != null) {
                this.idGenerator.persistCurrentID();
            }
        }
        final CountDownLatch latch = new CountDownLatch(1);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                latch.countDown();
            }
        });
        latch.await(30L, TimeUnit.SECONDS);
        this.beforeStop();
        this.bindingsJournal.stop();
        this.messageJournal.stop();
        this.largeMessagesFactory.stop();
        this.journalLoaded = false;
        this.started = false;
    }

    @Override
    public ByteBuffer allocateDirectBuffer(int size) {
        return NIOSequentialFileFactory.allocateDirectByteBuffer((int)size);
    }

    @Override
    public void freeDirectBuffer(ByteBuffer buffer) {
    }
}

