/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.chill;

import java.util.concurrent.ArrayBlockingQueue;

public abstract class ResourcePool<T> {
    private ArrayBlockingQueue<T> pool;

    protected abstract T newInstance();

    public ResourcePool(int n) {
        this.pool = new ArrayBlockingQueue(n);
    }

    public T borrow() {
        try {
            T t = this.pool.poll();
            if (null == t) {
                return this.newInstance();
            }
            return t;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void release(T t) {
        try {
            this.pool.offer(t);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

