/*
 * Decompiled with CFR 0.152.
 */
package kamon.util.executors;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ThreadPoolExecutor;
import kamon.Kamon$;
import kamon.metric.Entity;
import kamon.util.executors.ExecutorServiceMetrics;
import kamon.util.executors.ForkJoinPoolMetrics$;
import kamon.util.executors.ForkJoinPools$JavaForkJoin$;
import kamon.util.executors.ThreadPoolExecutorMetrics$;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;

public final class ExecutorServiceMetrics$ {
    public static ExecutorServiceMetrics$ MODULE$;
    private final String Category;
    private final Class<?> DelegatedExecutor;
    private final Class<?> FinalizableDelegated;
    private final Class<?> DelegateScheduled;
    private final Class<ForkJoinPool> JavaForkJoinPool;
    private final Class<ForkJoinPool> ScalaForkJoinPool;
    private final Field executorField;

    static {
        new ExecutorServiceMetrics$();
    }

    public String Category() {
        return this.Category;
    }

    private Class<?> DelegatedExecutor() {
        return this.DelegatedExecutor;
    }

    private Class<?> FinalizableDelegated() {
        return this.FinalizableDelegated;
    }

    private Class<?> DelegateScheduled() {
        return this.DelegateScheduled;
    }

    private Class<ForkJoinPool> JavaForkJoinPool() {
        return this.JavaForkJoinPool;
    }

    private Class<ForkJoinPool> ScalaForkJoinPool() {
        return this.ScalaForkJoinPool;
    }

    private Field executorField() {
        return this.executorField;
    }

    private Entity registerThreadPool(String name, ThreadPoolExecutor threadPool, scala.collection.immutable.Map<String, String> tags) {
        Entity threadPoolEntity = new Entity(name, this.Category(), (scala.collection.immutable.Map<String, String>)tags.$plus(Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)"executor-type"), (Object)"thread-pool-executor")));
        Kamon$.MODULE$.metrics().entity(ThreadPoolExecutorMetrics$.MODULE$.factory(threadPool, this.Category()), threadPoolEntity);
        return threadPoolEntity;
    }

    private Entity registerScalaForkJoin(String name, ForkJoinPool forkJoinPool, scala.collection.immutable.Map<String, String> tags) {
        Entity forkJoinEntity = new Entity(name, this.Category(), (scala.collection.immutable.Map<String, String>)tags.$plus(Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)"executor-type"), (Object)"fork-join-pool")));
        Kamon$.MODULE$.metrics().entity(ForkJoinPoolMetrics$.MODULE$.factory(forkJoinPool, this.Category(), ForkJoinPools$JavaForkJoin$.MODULE$), forkJoinEntity);
        return forkJoinEntity;
    }

    private Entity registerJavaForkJoin(String name, ForkJoinPool forkJoinPool, scala.collection.immutable.Map<String, String> tags) {
        Entity forkJoinEntity = new Entity(name, this.Category(), (scala.collection.immutable.Map<String, String>)tags.$plus(Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)"executor-type"), (Object)"fork-join-pool")));
        Kamon$.MODULE$.metrics().entity(ForkJoinPoolMetrics$.MODULE$.factory(forkJoinPool, this.Category(), ForkJoinPools$JavaForkJoin$.MODULE$), forkJoinEntity);
        return forkJoinEntity;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Entity register(String name, ExecutorService executorService, scala.collection.immutable.Map<String, String> tags) {
        ExecutorService executorService2;
        ExecutorService executorService3;
        ExecutorService executorService4;
        boolean bl = false;
        ForkJoinPool forkJoinPool = null;
        ExecutorService executorService5 = executorService;
        if (executorService5 instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)executorService5;
            return this.registerThreadPool(name, threadPoolExecutor, tags);
        }
        if (executorService5 instanceof ForkJoinPool) {
            bl = true;
            forkJoinPool = (ForkJoinPool)executorService5;
            if (forkJoinPool.getClass().isAssignableFrom(this.ScalaForkJoinPool())) {
                return this.registerScalaForkJoin(name, forkJoinPool, tags);
            }
        }
        if (bl && forkJoinPool.getClass().isAssignableFrom(this.JavaForkJoinPool())) {
            return this.registerJavaForkJoin(name, forkJoinPool, tags);
        }
        if (executorService5 != null && (executorService4 = executorService5).getClass().isAssignableFrom(this.DelegatedExecutor())) {
            return this.registerDelegatedExecutor(name, executorService4, tags);
        }
        if (executorService5 != null && (executorService3 = executorService5).getClass().isAssignableFrom(this.DelegateScheduled())) {
            return this.registerDelegatedExecutor(name, executorService3, tags);
        }
        if (executorService5 == null || !(executorService2 = executorService5).getClass().isAssignableFrom(this.FinalizableDelegated())) throw new ExecutorServiceMetrics.NotSupportedException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The ExecutorService ", " is not supported."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
        return this.registerDelegatedExecutor(name, executorService2, tags);
    }

    public Entity register(String name, ExecutorService executorService, Map<String, String> tags) {
        return this.register(name, executorService, (scala.collection.immutable.Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(tags).asScala()).toMap(Predef$.MODULE$.$conforms()));
    }

    public Entity register(String name, ExecutorService executorService) {
        return this.register(name, executorService, (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    public void remove(Entity entity) {
        Kamon$.MODULE$.metrics().removeEntity(entity);
    }

    private Entity registerDelegatedExecutor(String name, ExecutorService executor, scala.collection.immutable.Map<String, String> tags) {
        Object object;
        Object object2 = this.executorField().get(executor);
        if (object2 instanceof ExecutorService) {
            ExecutorService executorService = (ExecutorService)object2;
            object = executorService;
        } else {
            object = object2;
        }
        Object underlyingExecutor = object;
        return this.register(name, (ExecutorService)underlyingExecutor, tags);
    }

    /*
     * WARNING - void declaration
     */
    private ExecutorServiceMetrics$() {
        void var1_1;
        MODULE$ = this;
        this.Category = "executor-service";
        this.DelegatedExecutor = Class.forName("java.util.concurrent.Executors$DelegatedExecutorService");
        this.FinalizableDelegated = Class.forName("java.util.concurrent.Executors$FinalizableDelegatedExecutorService");
        this.DelegateScheduled = Class.forName("java.util.concurrent.Executors$DelegatedScheduledExecutorService");
        this.JavaForkJoinPool = ForkJoinPool.class;
        this.ScalaForkJoinPool = ForkJoinPool.class;
        Field field = this.DelegatedExecutor().getDeclaredField("e");
        field.setAccessible(true);
        this.executorField = var1_1;
    }
}

