/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.xebialabs.deployit.creator.CreatorContextImpl;
import com.xebialabs.deployit.engine.spi.command.CopyCiCommand;
import com.xebialabs.deployit.engine.spi.command.CreateCiCommand;
import com.xebialabs.deployit.engine.spi.command.CreateCisCommand;
import com.xebialabs.deployit.engine.spi.command.DeleteCiCommand;
import com.xebialabs.deployit.engine.spi.command.DeleteCisCommand;
import com.xebialabs.deployit.engine.spi.command.MoveCiCommand;
import com.xebialabs.deployit.engine.spi.command.RenameCiCommand;
import com.xebialabs.deployit.engine.spi.command.UpdateCiCommand;
import com.xebialabs.deployit.engine.spi.command.UpdateCisCommand;
import com.xebialabs.deployit.engine.spi.event.DeployitEventListener;
import com.xebialabs.deployit.plugin.api.creator.CreatorContext;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ChangeSet;
import com.xebialabs.deployit.repository.ConfigurationItemData;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.RepositoryServiceHolder;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.core.Directory;
import java.util.List;
import java.util.function.Function;
import nl.javadude.t2bus.Subscribe;

@DeployitEventListener
public class RepositoryEventListener {
    public static final String DUPLICATE_NAME_SUFFIX = "Copy";

    @Subscribe
    public void receiveCreate(CreateCiCommand command) {
        this.checkApplicationOnUniqueness(command.getCi());
        ChangeSet changeSet = new ChangeSet();
        this.populateChangeSet(command.getCi(), changeSet);
        RepositoryServiceHolder.getRepositoryService().execute(changeSet);
    }

    @Subscribe
    public void receiveCreate(CreateCisCommand command) {
        List listOfCis = command.getCis();
        ConfigurationItem[] cis = listOfCis.toArray(new ConfigurationItem[listOfCis.size()]);
        this.checkApplicationOnUniqueness(cis);
        ChangeSet changeSet = new ChangeSet();
        for (ConfigurationItem ci : cis) {
            this.populateChangeSet(ci, changeSet);
        }
        RepositoryServiceHolder.getRepositoryService().execute(changeSet);
    }

    @Subscribe
    public void receiveUpdate(UpdateCiCommand command) {
        ChangeSet changeSet = new ChangeSet();
        if (command.getUpdate().getPreviousCi() == null) {
            this.populateChangeSet(command.getUpdate().getNewCi(), changeSet, ci -> {
                changeSet.update((ConfigurationItem)ci);
                return null;
            });
        } else {
            changeSet.update(command.getUpdate().getNewCi());
        }
        RepositoryServiceHolder.getRepositoryService().execute(changeSet);
    }

    @Subscribe
    public void receiveUpdate(UpdateCisCommand command) {
        List updates = command.getUpdates();
        ChangeSet changeSet = new ChangeSet();
        changeSet.setSCMTraceabilityData(command.getSCMTraceabilityData());
        updates.forEach(update -> {
            if (update.getPreviousCi() == null) {
                this.populateChangeSet(update.getNewCi(), changeSet, ci -> {
                    changeSet.createOrUpdate((ConfigurationItem)ci);
                    return null;
                });
            } else {
                changeSet.createOrUpdate(update.getNewCi());
            }
        });
        RepositoryServiceHolder.getRepositoryService().execute(changeSet);
    }

    @Subscribe
    public void receiveDelete(DeleteCiCommand command) {
        RepositoryServiceHolder.getRepositoryService().delete(command.getCiId());
    }

    @Subscribe
    public void receiveDelete(DeleteCisCommand command) {
        RepositoryServiceHolder.getRepositoryService().delete(command.getCis().toArray(new String[command.getCis().size()]));
    }

    @Subscribe
    public void receiveMove(MoveCiCommand command) {
        RepositoryServiceHolder.getRepositoryService().move(command.getId(), command.getTargetId());
    }

    @Subscribe
    public void receiveCopy(CopyCiCommand command) {
        this.checkApplicationOnUniquenessByName(this.getName(command.getTargetId()), command.getType());
        RepositoryServiceHolder.getRepositoryService().copy(command.getId(), command.getTargetId());
        this.ensureChildApplicationNamesAreUnique(command);
    }

    @Subscribe
    public void receiveRename(RenameCiCommand command) {
        this.checkApplicationOnUniquenessByName(command.getTargetName(), command.getType());
        RepositoryServiceHolder.getRepositoryService().rename(command.getId(), command.getTargetName());
    }

    private void populateChangeSet(ConfigurationItem ci, ChangeSet changeSet) {
        this.populateChangeSet(ci, changeSet, item -> {
            changeSet.create((ConfigurationItem)item);
            return null;
        });
    }

    private void populateChangeSet(ConfigurationItem ci, ChangeSet changeSet, Function<ConfigurationItem, Void> operation) {
        if (ci.getType().getDescriptor().getCreator() != null) {
            ci.getType().getDescriptor().getCreator().invoke((CreatorContext)new CreatorContextImpl(ci, changeSet));
        } else {
            operation.apply(ci);
        }
    }

    private void checkApplicationOnUniqueness(ConfigurationItem ... cis) {
        for (ConfigurationItem ci : cis) {
            this.checkApplicationOnUniquenessByName(ci.getName(), ci.getType());
        }
    }

    private void checkApplicationOnUniquenessByName(String ciName, Type type) {
        Type applicationType = Type.valueOf(Application.class);
        if (!applicationType.instanceOf(type)) {
            return;
        }
        if (this.existsByName(ciName, type)) {
            throw new ItemAlreadyExistsException("Application with name [%s] already exists", ciName);
        }
    }

    private void ensureChildApplicationNamesAreUnique(CopyCiCommand command) {
        if (!Type.valueOf(Directory.class).instanceOf(command.getType())) {
            return;
        }
        Type applicationType = Type.valueOf(Application.class);
        SearchParameters parameters = new SearchParameters().setType(applicationType).setAncestor(command.getTargetId());
        for (ConfigurationItemData childApplication : RepositoryServiceHolder.getRepositoryService().list(parameters)) {
            String duplicateName = this.findUniqueName(applicationType, this.getName(childApplication.getId()), DUPLICATE_NAME_SUFFIX);
            RepositoryServiceHolder.getRepositoryService().rename(childApplication.getId(), duplicateName);
        }
    }

    private String findUniqueName(Type type, String baseName, String suffix) {
        String name = baseName + " " + suffix;
        return this.existsByName(name, type) ? this.findUniqueName(type, name, suffix) : name;
    }

    private boolean existsByName(String ciName, Type type) {
        SearchParameters parameters = new SearchParameters().setType(type).setName(ciName).setExactNameSearch(true);
        return !RepositoryServiceHolder.getRepositoryService().list(parameters).isEmpty();
    }

    private String getName(String id) {
        int indexOfLastSlash = id.lastIndexOf(47);
        if (indexOfLastSlash > -1) {
            return id.substring(indexOfLastSlash + 1);
        }
        return id;
    }
}

