/*
 * Decompiled with CFR 0.152.
 */
package akka.kamon.instrumentation;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Cell;
import akka.kamon.instrumentation.ActorMonitor;
import akka.kamon.instrumentation.ActorMonitors;
import akka.kamon.instrumentation.ActorMonitors$;
import akka.kamon.instrumentation.CellInfo;
import akka.kamon.instrumentation.CellInfo$;
import java.io.Serializable;
import kamon.Kamon$;
import kamon.akka.ActorGroupMetrics;
import kamon.akka.ActorGroupMetrics$;
import kamon.akka.ActorMetrics;
import kamon.akka.ActorMetrics$;
import kamon.akka.RouterMetrics;
import kamon.akka.RouterMetrics$;
import kamon.metric.Entity$;
import kamon.metric.EntityRecorderFactory;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;

public final class ActorMonitor$ {
    public static ActorMonitor$ MODULE$;

    static {
        new ActorMonitor$();
    }

    public ActorMonitor createActorMonitor(Cell cell, ActorSystem system, ActorRef ref, ActorRef parent, boolean actorCellCreation) {
        CellInfo cellInfo = CellInfo$.MODULE$.cellInfoFor(cell, system, ref, parent, actorCellCreation);
        return cellInfo.isRouter() ? ActorMonitors$.MODULE$.ContextPropagationOnly() : (cellInfo.isRoutee() && cellInfo.isTracked() ? this.createRouteeMonitor(cellInfo) : this.createRegularActorMonitor(cellInfo));
    }

    public ActorMonitor createRegularActorMonitor(CellInfo cellInfo) {
        ActorMonitor actorMonitor;
        if (cellInfo.isTracked() || !cellInfo.trackingGroups().isEmpty()) {
            None$ actorMetrics = cellInfo.isTracked() ? new Some((Object)Kamon$.MODULE$.metrics().entity((EntityRecorderFactory)ActorMetrics$.MODULE$, cellInfo.entity())) : None$.MODULE$;
            actorMonitor = new ActorMonitors.TrackedActor(cellInfo.entity(), (Option<ActorMetrics>)actorMetrics, this.trackingGroupMetrics(cellInfo), cellInfo.actorCellCreation());
        } else {
            actorMonitor = ActorMonitors$.MODULE$.ContextPropagationOnly();
        }
        return actorMonitor;
    }

    public ActorMonitor createRouteeMonitor(CellInfo cellInfo) {
        return new ActorMonitors.TrackedRoutee(cellInfo.entity(), ActorMonitor$.routerMetrics$1(cellInfo), this.trackingGroupMetrics(cellInfo), cellInfo.actorCellCreation());
    }

    private List<ActorGroupMetrics> trackingGroupMetrics(CellInfo cellInfo) {
        return (List)cellInfo.trackingGroups().map((Function1 & Serializable & scala.Serializable)groupName -> (ActorGroupMetrics)Kamon$.MODULE$.metrics().entity((EntityRecorderFactory)ActorGroupMetrics$.MODULE$, Entity$.MODULE$.apply(groupName, ActorGroupMetrics$.MODULE$.category())), List$.MODULE$.canBuildFrom());
    }

    private static final RouterMetrics routerMetrics$1(CellInfo cellInfo$1) {
        return (RouterMetrics)Kamon$.MODULE$.metrics().entity((EntityRecorderFactory)RouterMetrics$.MODULE$, cellInfo$1.entity());
    }

    private ActorMonitor$() {
        MODULE$ = this;
    }
}

