/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.core.api.ReportService;
import com.xebialabs.deployit.core.api.dto.ControlTaskReportLine;
import com.xebialabs.deployit.core.api.dto.DeploymentTaskReportLine;
import com.xebialabs.deployit.core.api.dto.ReportLine;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.rest.api.DownloadResource;
import com.xebialabs.deployit.core.rest.api.SearchParametersFactory;
import com.xebialabs.deployit.core.rest.api.reports.ReportUtils;
import com.xebialabs.deployit.core.rest.resteasy.Workdir;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.core.service.PaginationService;
import com.xebialabs.deployit.core.service.ReportGenerator;
import com.xebialabs.deployit.core.util.TaskFilterUtils$;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.engine.api.execution.FetchMode;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.sql.CiRepository;
import com.xebialabs.deployit.repository.sql.ConfigurationItemDataWithInternalId;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.TaskType;
import com.xebialabs.deployit.task.archive.TaskArchive;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Stream;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.spi.HttpResponse;
import org.joda.time.ReadableInstant;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Controller
@Autowired
@ScalaSignature(bytes="\u0006\u0001\r%c\u0001B\f\u0019\u0001\u0015B\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005\u0003\"AA\t\u0001B\u0001B\u0003%Q\t\u0003\u0005N\u0001\t\u0005\t\u0015!\u0003O\u0011!1\u0006A!A!\u0002\u00139\u0006\"B.\u0001\t\u0003a\u0006\"C2\u0001\u0001\u0004\u0005\r\u0011\"\u0003e\u0011%\t\b\u00011AA\u0002\u0013%!\u000fC\u0005|\u0001\u0001\u0007\t\u0011)Q\u0005K\"9\u0011\u0011\u0003\u0001\u0005\u0002\u0005M\u0001bBA\f\u0001\u0011%\u0011\u0011\u0004\u0005\b\u0003\u001b\u0002A\u0011BA(\u0011\u001d\t\u0019\n\u0001C\u0005\u0003+CqAa\u0002\u0001\t\u0003\u0012I\u0001C\u0004\u0003\"\u0001!\tEa\t\t\u000f\te\u0004\u0001\"\u0003\u0003|!9!1\u0015\u0001\u0005B\t\u0015\u0006b\u0002B]\u0001\u0011\u0005#1\u0018\u0005\b\u0005\u001f\u0004A\u0011\u0002Bi\u0011\u001d\u0019\t\u0002\u0001C\u0005\u0007'Aqa!\t\u0001\t\u0003\u001a\u0019\u0003C\u0004\u0004&\u0001!\tea\t\u0003#I+\u0007o\u001c:u'\u0016\u0014h/[2f\u00136\u0004HN\u0003\u0002\u001a5\u0005\u0019\u0011\r]5\u000b\u0005ma\u0012\u0001\u0002:fgRT!!\b\u0010\u0002\t\r|'/\u001a\u0006\u0003?\u0001\n\u0001\u0002Z3qY>L\u0018\u000e\u001e\u0006\u0003C\t\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003\r\n1aY8n\u0007\u0001\u0019B\u0001\u0001\u0014-cA\u0011qEK\u0007\u0002Q)\u0011\u0011FG\u0001\bg\u0016\u001cWO]3e\u0013\tY\u0003FA\fBEN$(/Y2u'\u0016\u001cWO]3e%\u0016\u001cx.\u001e:dKB\u0011QfL\u0007\u0002])\u0011\u0011\u0004H\u0005\u0003a9\u0012QBU3q_J$8+\u001a:wS\u000e,\u0007C\u0001\u001a8\u001b\u0005\u0019$B\u0001\u001b6\u0003\u0015\u0019HN\u001a\u001bk\u0015\u00051\u0014\u0001C4sSjTH.\u001a3\n\u0005a\u001a$a\u0002'pO\u001eLgnZ\u0001\u0010e\u0016\u0004xN\u001d;HK:,'/\u0019;peB\u00111HP\u0007\u0002y)\u0011Q\bH\u0001\bg\u0016\u0014h/[2f\u0013\tyDHA\bSKB|'\u000f^$f]\u0016\u0014\u0018\r^8s\u0003E\u0001\u0018mZ5oCRLwN\\*feZL7-\u001a\t\u0003w\tK!a\u0011\u001f\u0003#A\u000bw-\u001b8bi&|gnU3sm&\u001cW-\u0001\u0007dSJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002G\u00176\tqI\u0003\u0002I\u0013\u0006\u00191/\u001d7\u000b\u0005)s\u0012A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011Aj\u0012\u0002\r\u0007&\u0014V\r]8tSR|'/_\u0001\fi\u0006\u001c8.\u0011:dQ&4X\r\u0005\u0002P)6\t\u0001K\u0003\u0002R%\u00069\u0011M]2iSZ,'BA*\u001f\u0003\u0011!\u0018m]6\n\u0005U\u0003&a\u0003+bg.\f%o\u00195jm\u0016\f\u0001\u0003Z8x]2|\u0017\r\u001a*fg>,(oY3\u0011\u0005aKV\"\u0001\r\n\u0005iC\"\u0001\u0005#po:dw.\u00193SKN|WO]2f\u0003\u0019a\u0014N\\5u}Q1QLX0aC\n\u0004\"\u0001\u0017\u0001\t\u000be2\u0001\u0019\u0001\u001e\t\u000b\u00013\u0001\u0019A!\t\u000b\u00113\u0001\u0019A#\t\u000b53\u0001\u0019\u0001(\t\u000bY3\u0001\u0019A,\u0002\u0011I,7\u000f]8og\u0016,\u0012!\u001a\t\u0003M>l\u0011a\u001a\u0006\u0003Q&\f1a\u001d9j\u0015\tQ7.\u0001\u0005sKN$X-Y:z\u0015\taW.A\u0003kE>\u001c8OC\u0001o\u0003\ry'oZ\u0005\u0003a\u001e\u0014A\u0002\u0013;uaJ+7\u000f]8og\u0016\fAB]3ta>t7/Z0%KF$\"a]=\u0011\u0005Q<X\"A;\u000b\u0003Y\fQa]2bY\u0006L!\u0001_;\u0003\tUs\u0017\u000e\u001e\u0005\bu\"\t\t\u00111\u0001f\u0003\rAH%M\u0001\ne\u0016\u001c\bo\u001c8tK\u0002B#!C?\u0011\u0007y\fi!D\u0001\u0000\u0015\ri\u0012\u0011\u0001\u0006\u0005\u0003\u0007\t)!\u0001\u0002sg*!\u0011qAA\u0005\u0003\t98O\u0003\u0002\u0002\f\u0005)!.\u0019<bq&\u0019\u0011qB@\u0003\u000f\r{g\u000e^3yi\u0006Y1/\u001a;SKN\u0004xN\\:f)\r\u0019\u0018Q\u0003\u0005\u0006G*\u0001\r!Z\u0001\rg\u0016$8)\u001b$jYR,'o\u001d\u000b\u0006g\u0006m\u0011q\u0005\u0005\b\u0003;Y\u0001\u0019AA\u0010\u0003A\u0019X-\u0019:dQB\u000b'/Y7fi\u0016\u00148\u000f\u0005\u0003\u0002\"\u0005\rR\"\u0001*\n\u0007\u0005\u0015\"K\u0001\u000fBe\u000eD\u0017N^3e)\u0006\u001c8nU3be\u000eD\u0007+\u0019:b[\u0016$XM]:\t\u000f\u0005%2\u00021\u0001\u0002,\u0005!2m\u001c8gS\u001e,(/\u0019;j_:LE/Z7JIN\u0004b!!\f\u00028\u0005mRBAA\u0018\u0015\u0011\t\t$a\r\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003k\tAA[1wC&!\u0011\u0011HA\u0018\u0005\u0011a\u0015n\u001d;\u0011\t\u0005u\u0012\u0011J\u0007\u0003\u0003\u007fQA!!\u0011\u0002D\u0005\u0019A\r^8\u000b\u0007e\t)EC\u0002\u0002Hy\ta!\u001a8hS:,\u0017\u0002BA&\u0003\u007f\u00111cQ8oM&<WO]1uS>t\u0017\n^3n\u0013\u0012\fAb\u001d;sK\u0006l'+\u001a9peR,B!!\u0015\u0002dQA\u00111KA;\u0003\u000b\u000by\t\u0005\u0004\u0002V\u0005m\u0013qL\u0007\u0003\u0003/RA!!\u0017\u00020\u000511\u000f\u001e:fC6LA!!\u0018\u0002X\t11\u000b\u001e:fC6\u0004B!!\u0019\u0002d1\u0001AaBA3\u0019\t\u0007\u0011q\r\u0002\u0002)F!\u0011\u0011NA8!\r!\u00181N\u0005\u0004\u0003[*(a\u0002(pi\"Lgn\u001a\t\u0004i\u0006E\u0014bAA:k\n\u0019\u0011I\\=\t\u000f\u0005]D\u00021\u0001\u0002z\u00051\u0001/Y4j]\u001e\u0004R\u0001^A>\u0003\u007fJ1!! v\u0005\u0019y\u0005\u000f^5p]B!\u0011QHAA\u0013\u0011\t\u0019)a\u0010\u0003\rA\u000bw-\u001b8h\u0011\u001d\t9\t\u0004a\u0001\u0003\u0013\u000b1BY;jY\u0012\u0004\u0016M]1ngB9A/a#\u0002\u0000\u0005}\u0011bAAGk\nIa)\u001e8di&|g.\r\u0005\b\u00033b\u0001\u0019AAI!\u001d!\u00181RA\u0010\u0003'\n!d\u001d;sK\u0006lG)\u001a9m_flWM\u001c;UCN\\'+\u001a9peR$\u0002$a&\u0002$\u0006E\u0016QWA\\\u0003\u0007\fy.a9\u0002h\u0006]\u00181 B\u0003!\u0019\t)&a\u0017\u0002\u001aB!\u00111TAP\u001b\t\tiJC\u0002\u0002B9JA!!)\u0002\u001e\nAB)\u001a9m_flWM\u001c;UCN\\'+\u001a9peRd\u0015N\\3\t\u000f\u0005\u0015V\u00021\u0001\u0002(\u0006)!-Z4j]B!\u0011\u0011VAW\u001b\t\tYK\u0003\u0002k]%!\u0011qVAV\u0005\u0011!\u0015\r^3\t\u000f\u0005MV\u00021\u0001\u0002(\u0006\u0019QM\u001c3\t\u000f\u0005]T\u00021\u0001\u0002z!9\u0011\u0011X\u0007A\u0002\u0005m\u0016!B8sI\u0016\u0014\bCBA\u0017\u0003o\ti\f\u0005\u0003\u0002>\u0005}\u0016\u0002BAa\u0003\u007f\u0011\u0001b\u0014:eKJLgn\u001a\u0005\b\u0003\u000bl\u0001\u0019AAd\u0003\u0015)8/\u001a:t!\u0019\ti#a\u000e\u0002JB!\u00111ZAm\u001d\u0011\ti-!6\u0011\u0007\u0005=W/\u0004\u0002\u0002R*\u0019\u00111\u001b\u0013\u0002\rq\u0012xn\u001c;?\u0013\r\t9.^\u0001\u0007!J,G-\u001a4\n\t\u0005m\u0017Q\u001c\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005]W\u000fC\u0004\u0002b6\u0001\r!a2\u0002\u0015Q\f7o[*uCR,7\u000fC\u0004\u0002f6\u0001\r!a2\u0002\u0013Q\f7o\u001b+za\u0016\u001c\bbBAu\u001b\u0001\u0007\u00111^\u0001\nM\u0016$8\r['pI\u0016\u0004B!!<\u0002t6\u0011\u0011q\u001e\u0006\u0005\u0003c\f\u0019%A\u0005fq\u0016\u001cW\u000f^5p]&!\u0011Q_Ax\u0005%1U\r^2i\u001b>$W\rC\u0004\u0002z6\u0001\r!!3\u0002\rQ\f7o[%e\u0011\u001d\ti0\u0004a\u0001\u0003\u007f\fab\u001c8msN+8mY3tg\u001a,H\u000eE\u0002u\u0005\u0003I1Aa\u0001v\u0005\u001d\u0011un\u001c7fC:Dq!!\u000b\u000e\u0001\u0004\tY#A\u0007hKR$\u0016m]6SKB|'\u000f\u001e\u000b\u0019\u0003/\u0013YA!\u0004\u0003\u0010\tE!1\u0003B\u000b\u0005/\u0011IBa\u0007\u0003\u001e\t}\u0001bBAS\u001d\u0001\u0007\u0011q\u0015\u0005\b\u0003gs\u0001\u0019AAT\u0011\u001d\t9H\u0004a\u0001\u0003\u007fBq!!/\u000f\u0001\u0004\tY\fC\u0004\u0002F:\u0001\r!a2\t\u000f\u0005\u0005h\u00021\u0001\u0002H\"9\u0011Q\u001d\bA\u0002\u0005\u001d\u0007bBAu\u001d\u0001\u0007\u00111\u001e\u0005\b\u0003st\u0001\u0019AAe\u0011\u001d\tiP\u0004a\u0001\u0003\u007fDq!!\u000b\u000f\u0001\u0004\tY#\u0001\ne_^tGn\\1e)\u0006\u001c8NU3q_J$H\u0003FAe\u0005K\u00119C!\u000b\u0003,\t5\"q\u0006B\u0019\u0005g\u0011)\u0004C\u0004\u0002&>\u0001\r!a*\t\u000f\u0005Mv\u00021\u0001\u0002(\"9\u0011\u0011X\bA\u0002\u0005m\u0006bBAc\u001f\u0001\u0007\u0011q\u0019\u0005\b\u0003C|\u0001\u0019AAd\u0011\u001d\t)o\u0004a\u0001\u0003\u000fDq!!?\u0010\u0001\u0004\tI\rC\u0004\u0002~>\u0001\r!a@\t\u000f\u0005%r\u00021\u0001\u0002,!ZqB!\u000f\u0003N\t=#1\u000bB+!\u0011\u0011YD!\u0013\u000e\u0005\tu\"\u0002\u0002B \u0005\u0003\n!\"\u00198o_R\fG/[8o\u0015\u0011\u0011\u0019E!\u0012\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u0004\u0005\u000fj\u0017aD:qe&twM\u001a:b[\u0016<xN]6\n\t\t-#Q\b\u0002\u000e)J\fgn]1di&|g.\u00197\u0002\u000bY\fG.^3\"\u0005\tE\u0013a\u0007:fa>\u0014H/\u001b8h)J\fgn]1di&|g.T1oC\u001e,'/\u0001\u0005sK\u0006$wJ\u001c7z3\u0005\t\u0001fC\b\u0003Z\t\r$Q\rB5\u0005W\u0002BAa\u0017\u0003`5\u0011!Q\f\u0006\u0003UjIAA!\u0019\u0003^\t9qk\u001c:lI&\u0014\u0018A\u00029sK\u001aL\u00070\t\u0002\u0003h\u0005AAm\\<oY>\fG-A\u0003dY\u0016\fg\u000e\n\u0002\u0003n%!!q\u000eB9\u0003\u0019\tEjV!Z'*!!1\u000fB;\u0003\u0015\u0019E.Z1o\u0015\u0011\u00119H!\u0018\u0002\u000f]{'o\u001b3je\u000692\u000f\u001e:fC6\u001cuN\u001c;s_2$\u0016m]6SKB|'\u000f\u001e\u000b\u0015\u0005{\u0012)Ia\"\u0003\n\n5%\u0011\u0013BJ\u0005+\u00139J!'\u0011\r\u0005U\u00131\fB@!\u0011\tYJ!!\n\t\t\r\u0015Q\u0014\u0002\u0016\u0007>tGO]8m)\u0006\u001c8NU3q_J$H*\u001b8f\u0011\u001d\t)\u000b\u0005a\u0001\u0003OCq!a-\u0011\u0001\u0004\t9\u000bC\u0004\u0003\fB\u0001\r!a2\u0002\rM$\u0018\r^3t\u0011\u001d\u0011y\t\u0005a\u0001\u0003\u0013\f\u0001\u0002^1tW:\u000bW.\u001a\u0005\b\u0003S\u0004\u0002\u0019AAv\u0011\u001d\t)\r\u0005a\u0001\u0003\u000fDq!!/\u0011\u0001\u0004\tY\fC\u0004\u0002xA\u0001\r!!\u001f\t\u000f\tm\u0005\u00031\u0001\u0003\u001e\u00069A/\u0019:hKR\u001c\bCBA\u0017\u0005?\u000bI-\u0003\u0003\u0003\"\u0006=\"aA*fi\u0006)r-\u001a;D_:$(o\u001c7UCN\\7OU3q_J$H\u0003\u0006B?\u0005O\u0013IKa+\u0003.\n=&\u0011\u0017BZ\u0005k\u00139\fC\u0004\u0002&F\u0001\r!a*\t\u000f\u0005M\u0016\u00031\u0001\u0002(\"9!1R\tA\u0002\u0005\u001d\u0007b\u0002BH#\u0001\u0007\u0011\u0011\u001a\u0005\b\u0003S\f\u0002\u0019AAv\u0011\u001d\t)-\u0005a\u0001\u0003\u000fDq!!/\u0012\u0001\u0004\tY\fC\u0004\u0002xE\u0001\r!a \t\u000f\tm\u0015\u00031\u0001\u0003\u001e\u0006QBm\\<oY>\fGmQ8oiJ|G\u000eV1tWN\u0014V\r]8siR\u0001\u0012\u0011\u001aB_\u0005\u007f\u0013\tMa1\u0003F\n\u001d'\u0011\u001a\u0005\b\u0003K\u0013\u0002\u0019AAT\u0011\u001d\t\u0019L\u0005a\u0001\u0003OCqAa#\u0013\u0001\u0004\t9\rC\u0004\u0003\u0010J\u0001\r!!3\t\u000f\u0005\u0015'\u00031\u0001\u0002H\"9\u0011\u0011\u0018\nA\u0002\u0005m\u0006b\u0002BN%\u0001\u0007!Q\u0014\u0015\f%\te\"Q\nB(\u0005'\u0012)\u0006K\u0006\u0013\u00053\u0012\u0019G!\u001a\u0003j\t-\u0014a\u00067jgR\fE\u000e\\\"jg>3G+\u001f9f\u000fJ|W\u000f]3e)\u0019\u0011\u0019Na<\u0004\u0006AA!Q\u001bBp\u0005G\fI-\u0004\u0002\u0003X*!!\u0011\u001cBn\u0003%IW.\\;uC\ndWMC\u0002\u0003^V\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011\tOa6\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0003f\n-XB\u0001Bt\u0015\u0011\u0011I/a\r\u0002\t1\fgnZ\u0005\u0005\u0005[\u00149OA\u0004J]R,w-\u001a:\t\u000f\tE8\u00031\u0001\u0003t\u000611-\u001b+za\u0016\u0004BA!>\u0004\u00025\u0011!q\u001f\u0006\u0005\u0005s\u0014Y0A\u0004sK\u001adWm\u0019;\u000b\u0007e\u0011iPC\u0002\u0003\u0000z\ta\u0001\u001d7vO&t\u0017\u0002BB\u0002\u0005o\u0014A\u0001V=qK\"91qA\nA\u0002\r%\u0011\u0001C4fi2\u000b'-\u001a7\u0011\u000fQ\fYia\u0003\u0002JB\u0019ai!\u0004\n\u0007\r=qIA\u0012D_:4\u0017nZ;sCRLwN\\%uK6$\u0015\r^1XSRD\u0017J\u001c;fe:\fG.\u00133\u0002\u001b1L7\u000f\u001e+za\u0016\u0004\u0016\r\u001e5t)!\tYc!\u0006\u0004\u001e\r}\u0001bBB\f)\u0001\u00071\u0011D\u0001\fCJ\u001c\u0007.\u001b<fI\u000eK7\u000f\u0005\u0005\u0002L\u000em!1]Ad\u0013\u0011\u0011\t/!8\t\u000f\r\u001dA\u00031\u0001\u0004\n!9!\u0011\u001f\u000bA\u0002\tM\u0018\u0001\u00057jgR,eN^5s_:lWM\u001c;t)\t\tY#\u0001\tmSN$\u0018\t\u001d9mS\u000e\fG/[8og\"\u001a\u0001a!\u000b\u0011\t\r-2qG\u0007\u0003\u0007[QAAa\u0010\u00040)!1\u0011GB\u001a\u0003\u001d1\u0017m\u0019;pefTAa!\u000e\u0003F\u0005)!-Z1og&!1\u0011HB\u0017\u0005%\tU\u000f^8xSJ,G\rK\u0002\u0001\u0007{\u0001Baa\u0010\u0004F5\u00111\u0011\t\u0006\u0005\u0007\u0007\u0012)%\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LAaa\u0012\u0004B\tQ1i\u001c8ue>dG.\u001a:")
public class ReportServiceImpl
extends AbstractSecuredResource
implements ReportService,
Logging {
    private final ReportGenerator reportGenerator;
    private final PaginationService paginationService;
    private final CiRepository ciRepository;
    private final TaskArchive taskArchive;
    private final DownloadResource downloadResource;
    @Context
    private HttpResponse response;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ReportServiceImpl reportServiceImpl = this;
        synchronized (reportServiceImpl) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private HttpResponse response() {
        return this.response;
    }

    private void response_$eq(HttpResponse x$1) {
        this.response = x$1;
    }

    public void setResponse(HttpResponse response) {
        this.response_$eq(response);
    }

    private void setCiFilters(ArchivedTaskSearchParameters searchParameters, java.util.List<ConfigurationItemId> configurationItemIds) {
        Tuple2<List<String>, List<String>> tuple2 = TaskFilterUtils$.MODULE$.parseCiFilters((List<ConfigurationItemId>)((List)Option$.MODULE$.apply(configurationItemIds).toList().flatten((Function1 & Serializable & scala.Serializable)l -> ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(l))));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        List applications = (List)tuple2._1();
        List environments = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)applications, (Object)environments);
        Tuple2 tuple23 = tuple22;
        List applications2 = (List)tuple23._1();
        List environments2 = (List)tuple23._2();
        applications2.foreach((Function1 & Serializable & scala.Serializable)x$1 -> searchParameters.forApplication(x$1));
        environments2.foreach((Function1 & Serializable & scala.Serializable)x$1 -> searchParameters.forEnvironment(x$1));
    }

    private <T> Stream<T> streamReport(Option<Paging> paging, Function1<Paging, ArchivedTaskSearchParameters> buildParams, Function1<ArchivedTaskSearchParameters, Stream<T>> stream) {
        Option limited = paging.map((Function1 & Serializable & scala.Serializable)input -> $this.paginationService.getLimitedPaging((Paging)input));
        ArchivedTaskSearchParameters searchParameters = (ArchivedTaskSearchParameters)buildParams.apply(limited.getOrElse((Function0 & Serializable & scala.Serializable)() -> new Paging()));
        limited.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            this.paginationService.addPagingHeaderIfNeeded((Paging)paging.get(), x$2, this.paginationService.toSetHeader(this.response()), () -> Predef$.MODULE$.int2Integer($this.taskArchive.countTotalResults(searchParameters$2)));
            return BoxedUnit.UNIT;
        });
        return (Stream)stream.apply((Object)searchParameters);
    }

    private Stream<DeploymentTaskReportLine> streamDeploymentTaskReport(Date begin, Date end, Option<Paging> paging, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, java.util.List<String> users, java.util.List<String> taskStates, java.util.List<String> taskTypes, FetchMode fetchMode, String taskId, boolean onlySuccessful, java.util.List<ConfigurationItemId> configurationItemIds) {
        return this.streamReport(paging, (Function1<Paging, ArchivedTaskSearchParameters>)(Function1 & Serializable & scala.Serializable)limited -> {
            ArchivedTaskSearchParameters params = $this.reportGenerator.buildFilteredTaskSearchParameters(begin, end, (Paging)limited, order, null, users, taskStates, taskTypes, fetchMode, taskId, ImplicitConversions$.MODULE$.seq$u0020AsJavaList((Seq)Nil$.MODULE$), ReportGenerator.DEPLOYMENT_ALLOWED_SORT_FIELDS, onlySuccessful);
            this.setCiFilters(params, configurationItemIds);
            return params;
        }, (Function1 & Serializable & scala.Serializable)searchParameters -> $this.reportGenerator.streamTaskReport((ArchivedTaskSearchParameters)searchParameters));
    }

    public Stream<DeploymentTaskReportLine> getTaskReport(Date begin, Date end, Paging paging, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, java.util.List<String> users, java.util.List<String> taskStates, java.util.List<String> taskTypes, FetchMode fetchMode, String taskId, boolean onlySuccessful, java.util.List<ConfigurationItemId> configurationItemIds) {
        return this.streamDeploymentTaskReport(begin, end, (Option<Paging>)Option$.MODULE$.apply((Object)paging), order, users, taskStates, taskTypes, fetchMode, taskId, onlySuccessful, configurationItemIds);
    }

    @Workdir(prefix="download", clean=Workdir.Clean.ALWAYS)
    @Transactional(value="reportingTransactionManager", readOnly=true)
    public String downloadTaskReport(Date begin, Date end, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, java.util.List<String> users, java.util.List<String> taskStates, java.util.List<String> taskTypes, String taskId, boolean onlySuccessful, java.util.List<ConfigurationItemId> configurationItemIds) {
        Stream<ReportLine> stream = this.streamDeploymentTaskReport(begin, end, (Option<Paging>)None$.MODULE$, order, users, taskStates, taskTypes, FetchMode.SUMMARY, taskId, onlySuccessful, configurationItemIds).map(x$1 -> DeploymentTaskReportLine.asReportLine((DeploymentTaskReportLine)x$1));
        String fileName = String.format("tasks-%s-%s.csv", ReportUtils.DATE_FORMAT.print((ReadableInstant)begin.asDateTime()), ReportUtils.DATE_FORMAT.print((ReadableInstant)end.asDateTime()));
        return ReportUtils.createDownloadToken(this.downloadResource, stream, fileName);
    }

    private Stream<ControlTaskReportLine> streamControlTaskReport(Date begin, Date end, java.util.List<String> states, String taskName, FetchMode fetchMode, java.util.List<String> users, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, Option<Paging> paging, Set<String> targets) {
        return this.streamReport(paging, (Function1<Paging, ArchivedTaskSearchParameters>)(Function1 & Serializable & scala.Serializable)limited -> {
            ArchivedTaskSearchParameters params = $this.reportGenerator.buildTaskSearchParameters((Paging)limited, order, EnumSet.of(TaskType.CONTROL), ReportGenerator.CONTROL_ALLOWED_SORT_FIELDS);
            params.withTargets(targets);
            params.withTaskStates(states);
            params.withTaskName(taskName);
            params.withFetchMode(fetchMode);
            params.inDateTimeRange($this.reportGenerator.safeDateTime(begin, null), $this.reportGenerator.safeDateTime(end, null));
            Object object = users != null && ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(users).nonEmpty() ? params.forUsers((Set)Sets.newHashSet((Iterable)users)) : BoxedUnit.UNIT;
            return params;
        }, (Function1 & Serializable & scala.Serializable)searchParameters -> $this.reportGenerator.streamControlTasksReport((ArchivedTaskSearchParameters)searchParameters));
    }

    public Stream<ControlTaskReportLine> getControlTasksReport(Date begin, Date end, java.util.List<String> states, String taskName, FetchMode fetchMode, java.util.List<String> users, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, Paging paging, Set<String> targets) {
        return this.streamControlTaskReport(begin, end, states, taskName, fetchMode, users, order, (Option<Paging>)Option$.MODULE$.apply((Object)paging), targets);
    }

    @Workdir(prefix="download", clean=Workdir.Clean.ALWAYS)
    @Transactional(value="reportingTransactionManager", readOnly=true)
    public String downloadControlTasksReport(Date begin, Date end, java.util.List<String> states, String taskName, java.util.List<String> users, java.util.List<com.xebialabs.deployit.engine.api.dto.Ordering> order, Set<String> targets) {
        Stream<ReportLine> report = this.streamControlTaskReport(begin, end, states, taskName, FetchMode.SUMMARY, users, order, (Option<Paging>)None$.MODULE$, targets).map(x$1 -> ControlTaskReportLine.asReportLine((ControlTaskReportLine)x$1));
        return ReportUtils.createDownloadToken(this.downloadResource, report, this.reportGenerator.buildControlTaskReportFileName(begin, end));
    }

    private Map<Integer, String> listAllCisOfTypeGrouped(Type ciType, Function1<ConfigurationItemDataWithInternalId, String> getLabel) {
        SearchParameters params = SearchParametersFactory.createSearchParams((Type)ciType, (long)0L, (long)-1L);
        PlatformPermissions.READ.getPermissionHandler().applyPermission(params);
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.ciRepository.listInternal(params)).asScala()).map((Function1 & Serializable & scala.Serializable)item -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)item.internalId()), getLabel.apply(item)), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private java.util.List<ConfigurationItemId> listTypePaths(Map<Integer, java.util.List<String>> archivedCis, Function1<ConfigurationItemDataWithInternalId, String> getLabel, Type ciType) {
        List list;
        this.checkPermission(PlatformPermissions.REPORT_VIEW);
        Map<Integer, String> cisInRepository = this.listAllCisOfTypeGrouped(ciType, getLabel);
        scala.collection.immutable.Set matchedIds = (scala.collection.immutable.Set)archivedCis.keySet().intersect((GenSet)cisInRepository.keySet());
        List onlyInArchive = ((TraversableOnce)archivedCis.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Integer id = (Integer)tuple2._1();
            java.util.List paths = (java.util.List)tuple2._2();
            Nil$ nil$ = matchedIds.contains((Object)id) ? (Seq)ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(paths).filter((Function1 & Serializable & scala.Serializable)path -> BoxesRunTime.boxToBoolean((boolean)ReportServiceImpl.$anonfun$listTypePaths$2(cisInRepository, id, path))) : Nil$.MODULE$;
            return nil$;
        }, Iterable$.MODULE$.canBuildFrom())).toList();
        List list2 = cisInRepository.values().toList();
        List inArchiveAndRepository = onlyInArchive.$colon$colon$colon(list2);
        if (this.hasPermission(PlatformPermissions.ADMIN)) {
            List list3 = inArchiveAndRepository;
            list = ((TraversableOnce)archivedCis.filterKeys((Function1 & Serializable & scala.Serializable)id -> BoxesRunTime.boxToBoolean((boolean)ReportServiceImpl.$anonfun$listTypePaths$3(cisInRepository, id))).values().flatten((Function1 & Serializable & scala.Serializable)l -> ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(l))).toList().$colon$colon$colon(list3);
        } else {
            list = inArchiveAndRepository;
        }
        List result = list;
        return ImplicitConversions$.MODULE$.seq$u0020AsJavaList((Seq)((List)((SeqLike)result.distinct()).sorted((Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$5 -> new ConfigurationItemId(x$5, ciType), List$.MODULE$.canBuildFrom()));
    }

    public java.util.List<ConfigurationItemId> listEnvironments() {
        return this.listTypePaths((Map<Integer, java.util.List<String>>)ImplicitConversions$.MODULE$.map$u0020AsScala(this.reportGenerator.getEnvironments()).toMap(Predef$.MODULE$.$conforms()), (Function1<ConfigurationItemDataWithInternalId, String>)(Function1 & Serializable & scala.Serializable)x$6 -> x$6.id(), Type.valueOf(Environment.class));
    }

    public java.util.List<ConfigurationItemId> listApplications() {
        return this.listTypePaths((Map<Integer, java.util.List<String>>)ImplicitConversions$.MODULE$.map$u0020AsScala(this.reportGenerator.getApplications()).toMap(Predef$.MODULE$.$conforms()), (Function1<ConfigurationItemDataWithInternalId, String>)(Function1 & Serializable & scala.Serializable)x$7 -> x$7.name(), Type.valueOf(Application.class));
    }

    public static final /* synthetic */ boolean $anonfun$listTypePaths$2(Map cisInRepository$1, Integer id$1, String path) {
        Object object = cisInRepository$1.apply((Object)id$1);
        String string = path;
        return object == null ? string != null : !object.equals(string);
    }

    public static final /* synthetic */ boolean $anonfun$listTypePaths$3(Map cisInRepository$1, Integer id) {
        return !cisInRepository$1.keySet().contains((Object)id);
    }

    public ReportServiceImpl(ReportGenerator reportGenerator, PaginationService paginationService, CiRepository ciRepository, TaskArchive taskArchive, DownloadResource downloadResource) {
        this.reportGenerator = reportGenerator;
        this.paginationService = paginationService;
        this.ciRepository = ciRepository;
        this.taskArchive = taskArchive;
        this.downloadResource = downloadResource;
        Logging.$init$((Logging)this);
    }
}

