/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.config;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.config.AccessManagerConfig;
import org.apache.jackrabbit.core.config.BeanConfig;
import org.apache.jackrabbit.core.config.ClusterConfig;
import org.apache.jackrabbit.core.config.ConfigurationException;
import org.apache.jackrabbit.core.config.ConfigurationParser;
import org.apache.jackrabbit.core.config.ISMLockingConfig;
import org.apache.jackrabbit.core.config.JournalConfig;
import org.apache.jackrabbit.core.config.LoginModuleConfig;
import org.apache.jackrabbit.core.config.PersistenceManagerConfig;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.jackrabbit.core.config.SearchConfig;
import org.apache.jackrabbit.core.config.SecurityConfig;
import org.apache.jackrabbit.core.config.SecurityManagerConfig;
import org.apache.jackrabbit.core.config.VersioningConfig;
import org.apache.jackrabbit.core.config.WorkspaceConfig;
import org.apache.jackrabbit.core.config.WorkspaceSecurityConfig;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.data.DataStoreFactory;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.FileSystemFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class RepositoryConfigurationParser
extends ConfigurationParser {
    public static final String REPOSITORY_HOME_VARIABLE = "rep.home";
    public static final String WORKSPACE_HOME_VARIABLE = "wsp.home";
    public static final String WORKSPACE_NAME_VARIABLE = "wsp.name";
    public static final String SECURITY_ELEMENT = "Security";
    public static final String SECURITY_MANAGER_ELEMENT = "SecurityManager";
    public static final String ACCESS_MANAGER_ELEMENT = "AccessManager";
    public static final String LOGIN_MODULE_ELEMENT = "LoginModule";
    private static final String WORKSPACE_ACCESS_ELEMENT = "WorkspaceAccessManager";
    public static final String WORKSPACES_ELEMENT = "Workspaces";
    public static final String WORKSPACE_ELEMENT = "Workspace";
    public static final String VERSIONING_ELEMENT = "Versioning";
    public static final String FILE_SYSTEM_ELEMENT = "FileSystem";
    public static final String CLUSTER_ELEMENT = "Cluster";
    public static final String JOURNAL_ELEMENT = "Journal";
    public static final String DATA_STORE_ELEMENT = "DataStore";
    public static final String PERSISTENCE_MANAGER_ELEMENT = "PersistenceManager";
    public static final String SEARCH_INDEX_ELEMENT = "SearchIndex";
    public static final String ISM_LOCKING_ELEMENT = "ISMLocking";
    public static final String APP_NAME_ATTRIBUTE = "appName";
    public static final String WSP_NAME_ATTRIBUTE = "workspaceName";
    public static final String ROOT_PATH_ATTRIBUTE = "rootPath";
    public static final String CONFIG_ROOT_PATH_ATTRIBUTE = "configRootPath";
    public static final String MAX_IDLE_TIME_ATTRIBUTE = "maxIdleTime";
    public static final String DEFAULT_WORKSPACE_ATTRIBUTE = "defaultWorkspace";
    public static final String ID_ATTRIBUTE = "id";
    public static final String SYNC_DELAY_ATTRIBUTE = "syncDelay";
    public static final String DEFAULT_QUERY_HANDLER = "org.apache.jackrabbit.core.query.lucene.SearchIndex";
    public static final String CLUSTERED_ATTRIBUTE = "clustered";
    public static final String DEFAULT_SYNC_DELAY = "5000";
    private static final String WSP_SECURITY_ELEMENT = "WorkspaceSecurity";
    private static final String AC_PROVIDER_ELEMENT = "AccessControlProvider";

    public RepositoryConfigurationParser(Properties variables) {
        super(variables);
    }

    public RepositoryConfig parseRepositoryConfig(InputSource xml) throws ConfigurationException {
        Element root = this.parseXML(xml, true);
        String home = this.getVariables().getProperty(REPOSITORY_HOME_VARIABLE);
        FileSystemFactory fsf = this.getFileSystemFactory(root, FILE_SYSTEM_ELEMENT);
        Element security = this.getElement(root, SECURITY_ELEMENT);
        SecurityConfig securityConfig = this.parseSecurityConfig(security);
        Element workspaces = this.getElement(root, WORKSPACES_ELEMENT);
        String workspaceDirectory = this.replaceVariables(this.getAttribute(workspaces, ROOT_PATH_ATTRIBUTE));
        String workspaceConfigDirectory = this.getAttribute(workspaces, CONFIG_ROOT_PATH_ATTRIBUTE, null);
        String defaultWorkspace = this.replaceVariables(this.getAttribute(workspaces, DEFAULT_WORKSPACE_ATTRIBUTE));
        int maxIdleTime = Integer.parseInt(this.getAttribute(workspaces, MAX_IDLE_TIME_ATTRIBUTE, "0"));
        Element template = this.getElement(root, WORKSPACE_ELEMENT);
        VersioningConfig vc = this.parseVersioningConfig(root);
        SearchConfig sc = this.parseSearchConfig(root);
        ClusterConfig cc = this.parseClusterConfig(root);
        DataStoreFactory dsf = this.getDataStoreFactory(root, home);
        return new RepositoryConfig(home, securityConfig, fsf, workspaceDirectory, workspaceConfigDirectory, defaultWorkspace, maxIdleTime, template, vc, sc, cc, dsf, this);
    }

    public SecurityConfig parseSecurityConfig(Element security) throws ConfigurationException {
        String appName = this.getAttribute(security, APP_NAME_ATTRIBUTE);
        SecurityManagerConfig smc = this.parseSecurityManagerConfig(security);
        AccessManagerConfig amc = this.parseAccessManagerConfig(security);
        LoginModuleConfig lmc = this.parseLoginModuleConfig(security);
        return new SecurityConfig(appName, smc, amc, lmc);
    }

    public SecurityManagerConfig parseSecurityManagerConfig(Element security) throws ConfigurationException {
        Element smElement = this.getElement(security, SECURITY_MANAGER_ELEMENT, false);
        if (smElement != null) {
            BeanConfig bc = this.parseBeanConfig(smElement);
            String wspAttr = this.getAttribute(smElement, WSP_NAME_ATTRIBUTE, null);
            BeanConfig wac = null;
            Element element = this.getElement(smElement, WORKSPACE_ACCESS_ELEMENT, false);
            if (element != null) {
                wac = this.parseBeanConfig(smElement, WORKSPACE_ACCESS_ELEMENT);
            }
            return new SecurityManagerConfig(bc, wspAttr, wac);
        }
        return null;
    }

    public AccessManagerConfig parseAccessManagerConfig(Element security) throws ConfigurationException {
        Element accessMgr = this.getElement(security, ACCESS_MANAGER_ELEMENT, false);
        if (accessMgr != null) {
            return new AccessManagerConfig(this.parseBeanConfig(accessMgr));
        }
        return null;
    }

    public LoginModuleConfig parseLoginModuleConfig(Element security) throws ConfigurationException {
        Element loginModule = this.getElement(security, LOGIN_MODULE_ELEMENT, false);
        if (loginModule != null) {
            return new LoginModuleConfig(this.parseBeanConfig(security, LOGIN_MODULE_ELEMENT));
        }
        return null;
    }

    public WorkspaceConfig parseWorkspaceConfig(InputSource xml) throws ConfigurationException {
        Element root = this.parseXML(xml);
        String home = this.getVariables().getProperty(WORKSPACE_HOME_VARIABLE);
        String name = this.getAttribute(root, "name", new File(home).getName());
        boolean clustered = Boolean.valueOf(this.getAttribute(root, CLUSTERED_ATTRIBUTE, "true"));
        Properties tmpVariables = (Properties)this.getVariables().clone();
        tmpVariables.put(WORKSPACE_NAME_VARIABLE, name);
        RepositoryConfigurationParser tmpParser = this.createSubParser(tmpVariables);
        FileSystemFactory fsf = tmpParser.getFileSystemFactory(root, FILE_SYSTEM_ELEMENT);
        PersistenceManagerConfig pmc = tmpParser.parsePersistenceManagerConfig(root);
        SearchConfig sc = tmpParser.parseSearchConfig(root);
        ISMLockingConfig ismLockingConfig = tmpParser.parseISMLockingConfig(root);
        WorkspaceSecurityConfig workspaceSecurityConfig = tmpParser.parseWorkspaceSecurityConfig(root);
        return new WorkspaceConfig(home, name, clustered, fsf, pmc, sc, ismLockingConfig, workspaceSecurityConfig);
    }

    protected SearchConfig parseSearchConfig(Element parent) throws ConfigurationException {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !SEARCH_INDEX_ELEMENT.equals(child.getNodeName())) continue;
            Element element = (Element)child;
            String className = this.getAttribute(element, "class", DEFAULT_QUERY_HANDLER);
            Properties parameters = this.parseParameters(element);
            FileSystemFactory fsf = null;
            if (this.getElement(element, FILE_SYSTEM_ELEMENT, false) != null) {
                fsf = this.getFileSystemFactory(element, FILE_SYSTEM_ELEMENT);
            }
            return new SearchConfig(className, parameters, fsf);
        }
        return null;
    }

    public WorkspaceSecurityConfig parseWorkspaceSecurityConfig(Element parent) throws ConfigurationException {
        Element provFact;
        BeanConfig factConf = null;
        Element element = this.getElement(parent, WSP_SECURITY_ELEMENT, false);
        if (element != null && (provFact = this.getElement(element, AC_PROVIDER_ELEMENT, false)) != null) {
            factConf = this.parseBeanConfig(element, AC_PROVIDER_ELEMENT);
            factConf.setValidate(false);
        }
        return new WorkspaceSecurityConfig(factConf);
    }

    protected ISMLockingConfig parseISMLockingConfig(Element parent) throws ConfigurationException {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !ISM_LOCKING_ELEMENT.equals(child.getNodeName())) continue;
            Element element = (Element)child;
            String className = this.getAttribute(element, "class");
            Properties parameters = this.parseParameters(element);
            return new ISMLockingConfig(className, parameters);
        }
        return null;
    }

    protected VersioningConfig parseVersioningConfig(Element parent) throws ConfigurationException {
        Element element = this.getElement(parent, VERSIONING_ELEMENT);
        String home = this.replaceVariables(this.getAttribute(element, ROOT_PATH_ATTRIBUTE));
        FileSystemFactory fsf = this.getFileSystemFactory(element, FILE_SYSTEM_ELEMENT);
        PersistenceManagerConfig pmc = this.parsePersistenceManagerConfig(element);
        ISMLockingConfig ismLockingConfig = this.parseISMLockingConfig(element);
        return new VersioningConfig(home, fsf, pmc, ismLockingConfig);
    }

    protected ClusterConfig parseClusterConfig(Element parent) throws ConfigurationException {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !CLUSTER_ELEMENT.equals(child.getNodeName())) continue;
            Element element = (Element)child;
            String id = null;
            String value = this.getAttribute(element, ID_ATTRIBUTE, null);
            if (value != null) {
                id = this.replaceVariables(value);
            }
            value = this.getAttribute(element, SYNC_DELAY_ATTRIBUTE, DEFAULT_SYNC_DELAY);
            long syncDelay = Long.parseLong(this.replaceVariables(value));
            JournalConfig jc = this.parseJournalConfig(element);
            return new ClusterConfig(id, syncDelay, jc);
        }
        return null;
    }

    protected JournalConfig parseJournalConfig(Element cluster) throws ConfigurationException {
        return new JournalConfig(this.parseBeanConfig(cluster, JOURNAL_ELEMENT));
    }

    protected DataStoreFactory getDataStoreFactory(final Element parent, final String directory) throws ConfigurationException {
        return new DataStoreFactory(){

            public DataStore getDataStore() throws RepositoryException {
                NodeList children = parent.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    Node child = children.item(i);
                    if (child.getNodeType() != 1 || !RepositoryConfigurationParser.DATA_STORE_ELEMENT.equals(child.getNodeName())) continue;
                    BeanConfig bc = RepositoryConfigurationParser.this.parseBeanConfig(parent, RepositoryConfigurationParser.DATA_STORE_ELEMENT);
                    DataStore store = (DataStore)bc.newInstance();
                    store.init(directory);
                    return store;
                }
                return null;
            }
        };
    }

    protected PersistenceManagerConfig parsePersistenceManagerConfig(Element parent) throws ConfigurationException {
        return new PersistenceManagerConfig(this.parseBeanConfig(parent, PERSISTENCE_MANAGER_ELEMENT));
    }

    protected RepositoryConfigurationParser createSubParser(Properties variables) {
        Properties props = new Properties(this.getVariables());
        props.putAll((Map<?, ?>)variables);
        return new RepositoryConfigurationParser(props);
    }

    protected FileSystemFactory getFileSystemFactory(Element parent, String name) throws ConfigurationException {
        final BeanConfig config = this.parseBeanConfig(parent, name);
        return new FileSystemFactory(){

            public FileSystem getFileSystem() throws RepositoryException {
                try {
                    FileSystem fs = (FileSystem)config.newInstance();
                    fs.init();
                    return fs;
                }
                catch (ClassCastException e) {
                    throw new RepositoryException("Invalid file system implementation class: " + config.getClassName(), (Throwable)e);
                }
                catch (FileSystemException e) {
                    throw new RepositoryException("File system initialization failure.", (Throwable)e);
                }
            }
        };
    }
}

