/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.principal;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.config.BeanConfig;
import org.apache.jackrabbit.core.security.principal.PrincipalProvider;
import org.apache.jackrabbit.core.security.principal.PrincipalProviderRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProviderRegistryImpl
implements PrincipalProviderRegistry {
    private static final Logger log = LoggerFactory.getLogger(ProviderRegistryImpl.class);
    private final PrincipalProvider defaultPrincipalProvider;
    private final Map<String, PrincipalProvider> providers = new LinkedHashMap<String, PrincipalProvider>();

    public ProviderRegistryImpl(PrincipalProvider defaultPrincipalProvider) {
        this.defaultPrincipalProvider = defaultPrincipalProvider;
        if (defaultPrincipalProvider != null) {
            this.providers.put(defaultPrincipalProvider.getClass().getName(), defaultPrincipalProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrincipalProvider registerProvider(Properties config) throws RepositoryException {
        PrincipalProvider provider = this.createProvider(config);
        if (provider != null) {
            Map<String, PrincipalProvider> map = this.providers;
            synchronized (map) {
                String providerName = (String)config.get("principal_provider.name");
                if (null == providerName || "".equals(providerName)) {
                    providerName = provider.getClass().getName();
                }
                this.providers.put(providerName, provider);
            }
        } else {
            log.debug("Could not register principal provider: principalProvider configuration entry missing.");
        }
        return provider;
    }

    @Override
    public PrincipalProvider getDefault() {
        return this.defaultPrincipalProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrincipalProvider getProvider(String className) {
        Map<String, PrincipalProvider> map = this.providers;
        synchronized (map) {
            return this.providers.get(className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrincipalProvider[] getProviders() {
        Map<String, PrincipalProvider> map = this.providers;
        synchronized (map) {
            Collection<PrincipalProvider> pps = this.providers.values();
            return pps.toArray(new PrincipalProvider[pps.size()]);
        }
    }

    private PrincipalProvider createProvider(Properties config) throws RepositoryException {
        String className = config.getProperty("principalProvider");
        if (className == null) {
            className = config.getProperty("principal_provider.class");
        }
        if (className == null) {
            return null;
        }
        try {
            Class<?> pc = Class.forName(className, true, BeanConfig.getDefaultClassLoader());
            PrincipalProvider pp = (PrincipalProvider)pc.newInstance();
            pp.init(config);
            return pp;
        }
        catch (ClassNotFoundException e) {
            throw new RepositoryException("Unable to create new principal provider.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new RepositoryException("Unable to create new principal provider.", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new RepositoryException("Unable to create new principal provider.", (Throwable)e);
        }
        catch (ClassCastException e) {
            throw new RepositoryException("Unable to create new principal provider.", (Throwable)e);
        }
    }
}

