/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.commons.cnd.CompactNodeTypeDefReader;
import org.apache.jackrabbit.commons.cnd.DefinitionBuilderFactory;
import org.apache.jackrabbit.commons.cnd.ParseException;
import org.apache.jackrabbit.core.nodetype.InvalidNodeTypeDefException;
import org.apache.jackrabbit.core.nodetype.xml.NodeTypeReader;
import org.apache.jackrabbit.core.nodetype.xml.NodeTypeWriter;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.commons.nodetype.QDefinitionBuilderFactory;

public class NodeTypeDefStore {
    private final Map<Name, QNodeTypeDefinition> ntDefs = new HashMap<Name, QNodeTypeDefinition>();

    public void load(InputStream in) throws IOException, InvalidNodeTypeDefException, RepositoryException {
        QNodeTypeDefinition[] types;
        for (QNodeTypeDefinition type : types = NodeTypeReader.read(in)) {
            this.add(type);
        }
    }

    public void loadCND(Reader in, String systemId) throws IOException, InvalidNodeTypeDefException {
        try {
            CompactNodeTypeDefReader r = new CompactNodeTypeDefReader(in, systemId, (DefinitionBuilderFactory)new QDefinitionBuilderFactory());
            for (QNodeTypeDefinition qdef : r.getNodeTypeDefinitions()) {
                this.add(qdef);
            }
        }
        catch (ParseException e) {
            throw new InvalidNodeTypeDefException("Unable to parse CND stream.", e);
        }
    }

    public void store(OutputStream out, NamespaceRegistry registry) throws IOException, RepositoryException {
        QNodeTypeDefinition[] types = this.ntDefs.values().toArray(new QNodeTypeDefinition[this.ntDefs.size()]);
        NodeTypeWriter.write(out, types, registry);
    }

    public void add(QNodeTypeDefinition ntd) {
        this.ntDefs.put(ntd.getName(), ntd);
    }

    public boolean remove(Name name) {
        return this.ntDefs.remove(name) != null;
    }

    public void removeAll() {
        this.ntDefs.clear();
    }

    public boolean contains(Name name) {
        return this.ntDefs.containsKey(name);
    }

    public QNodeTypeDefinition get(Name name) {
        return this.ntDefs.get(name);
    }

    public Collection<QNodeTypeDefinition> all() {
        return Collections.unmodifiableCollection(this.ntDefs.values());
    }
}

