/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.xebialabs.deployit.deployment.planner.CheckPointManagerListener;
import com.xebialabs.deployit.deployment.planner.MultiDeltaSpecification;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.tasker.IEngine;
import com.xebialabs.deployit.engine.tasker.Task;
import com.xebialabs.deployit.engine.tasker.TaskExecutionContext;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.service.deployment.DeploymentService;
import com.xebialabs.deployit.service.deployment.RollbackCompletedListener;
import com.xebialabs.deployit.task.TaskMetadata;
import com.xebialabs.deployit.task.TaskType;
import com.xebialabs.deployit.task.WorkdirCleanerTrigger;
import com.xebialabs.deployit.task.archive.TaskArchive;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@Component
@ScalaSignature(bytes="\u0006\u0001\u0005]c\u0001\u0002\u0007\u000e\u0001aA\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005a!AA\u0007\u0001B\u0001B\u0003%Q\u0007C\u0003>\u0001\u0011\u0005a\bC\u0003S\u0001\u0011\u00051\u000b\u0003\u0004d\u0001\u0011\u0005Q\u0002\u001a\u0005\u0006G\u0002!I!\u001b\u0005\b\u0003\u0017\u0001A\u0011BA\u0007\u0011\u001d\t\t\u0003\u0001C\u0005\u0003GA\u0001\"a\n\u0001\t\u0003i\u0011\u0011\u0006\u0005\u0007q\u0001!I!a\u0010\u0003\u001fI{G\u000e\u001c2bG.\u001cVM\u001d<jG\u0016T!AD\b\u0002\u0015\u0011,\u0007\u000f\\8z[\u0016tGO\u0003\u0002\u0011#\u000591/\u001a:wS\u000e,'B\u0001\n\u0014\u0003!!W\r\u001d7ps&$(B\u0001\u000b\u0016\u0003%AXMY5bY\u0006\u00147OC\u0001\u0017\u0003\r\u0019w.\\\u0002\u0001'\r\u0001\u0011d\b\t\u00035ui\u0011a\u0007\u0006\u00029\u0005)1oY1mC&\u0011ad\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0001*S\"A\u0011\u000b\u0005\t\u001a\u0013!B:mMRR'\"\u0001\u0013\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!AJ\u0011\u0003\u000f1{wmZ5oO\u00061QM\\4j]\u0016\u0004\"!K\u0017\u000e\u0003)R!a\u000b\u0017\u0002\rQ\f7o[3s\u0015\t9\u0013#\u0003\u0002/U\t9\u0011*\u00128hS:,\u0017!\u00053fa2|\u00170\\3oiN+'O^5dKB\u0011\u0011GM\u0007\u0002\u001b%\u00111'\u0004\u0002\u0012\t\u0016\u0004Hn\\=nK:$8+\u001a:wS\u000e,\u0017a\u0003;bg.\f%o\u00195jm\u0016\u0004\"AN\u001e\u000e\u0003]R!\u0001O\u001d\u0002\u000f\u0005\u00148\r[5wK*\u0011!(E\u0001\u0005i\u0006\u001c8.\u0003\u0002=o\tYA+Y:l\u0003J\u001c\u0007.\u001b<f\u0003\u0019a\u0014N\\5u}Q!q\bQ!C!\t\t\u0004\u0001C\u0003(\t\u0001\u0007\u0001\u0006C\u00030\t\u0001\u0007\u0001\u0007C\u00035\t\u0001\u0007Q\u0007\u000b\u0002\u0005\tB\u0011Q\tU\u0007\u0002\r*\u0011q\tS\u0001\u000bC:tw\u000e^1uS>t'BA%K\u0003\u001d1\u0017m\u0019;pefT!a\u0013'\u0002\u000b\t,\u0017M\\:\u000b\u00055s\u0015aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003=\u000b1a\u001c:h\u0013\t\tfIA\u0005BkR|w/\u001b:fI\u0006A!o\u001c7mE\u0006\u001c7\u000e\u0006\u0002U?B\u0011Q\u000b\u0018\b\u0003-j\u0003\"aV\u000e\u000e\u0003aS!!W\f\u0002\rq\u0012xn\u001c;?\u0013\tY6$\u0001\u0004Qe\u0016$WMZ\u0005\u0003;z\u0013aa\u0015;sS:<'BA.\u001c\u0011\u0015QT\u00011\u0001a!\tI\u0013-\u0003\u0002cU\t!A+Y:l\u0003m\u0019'/Z1uKJ{G\u000e\u001c2bG.\u001c\u0006/Z2jM&\u001c\u0017\r^5p]R\u0011Q\r\u001b\t\u0003S\u0019L!a\u001a\u0016\u0003#Q\u000b7o[*qK\u000eLg-[2bi&|g\u000eC\u0003;\r\u0001\u0007\u0001\r\u0006\u0003fU.$\b\"\u0002\u001e\b\u0001\u0004\u0001\u0007\"\u00027\b\u0001\u0004i\u0017\u0001\u00069beRL\u0017\r\\\"p[6LG\u000f\u0016:jO\u001e,'\u000f\u0005\u0002oe6\tqN\u0003\u0002qc\u00069\u0001\u000f\\1o]\u0016\u0014(B\u0001\b\u0012\u0013\t\u0019xNA\rDQ\u0016\u001c7\u000eU8j]Rl\u0015M\\1hKJd\u0015n\u001d;f]\u0016\u0014\b\"B;\b\u0001\u00041\u0018\u0001C<pe.$\u0015N]:\u0011\u0007]dxP\u0004\u0002yu:\u0011q+_\u0005\u00029%\u00111pG\u0001\ba\u0006\u001c7.Y4f\u0013\tihP\u0001\u0003MSN$(BA>\u001c!\u0011\t\t!a\u0002\u000e\u0005\u0005\r!bAA\u0003#\u0005Q!/\u001a9pg&$xN]=\n\t\u0005%\u00111\u0001\u0002\b/>\u00148\u000eR5s\u0003E9W\r^,pe.$\u0017N]\"mK\u0006tWM\u001d\u000b\u0005\u0003\u001f\t9\u0002\u0005\u0003\u0002\u0012\u0005MQ\"A\u001d\n\u0007\u0005U\u0011HA\u000bX_J\\G-\u001b:DY\u0016\fg.\u001a:Ue&<w-\u001a:\t\u000f\u0005e\u0001\u00021\u0001\u0002\u001c\u000591m\u001c8uKb$\bcA\u0015\u0002\u001e%\u0019\u0011q\u0004\u0016\u0003)Q\u000b7o[#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0003q9W\r^\"iK\u000e\\\u0007k\\5oi6\u000bg.Y4fe2K7\u000f^3oKJ$2!\\A\u0013\u0011\u001d\tI\"\u0003a\u0001\u00037\t!\u0002Z8S_2d'-Y2l)\u0019\tY#!\u000f\u0002<A!\u0011QFA\u001c\u001b\t\tyC\u0003\u0003\u00022\u0005M\u0012\u0001\u00027b]\u001eT!!!\u000e\u0002\t)\fg/Y\u0005\u0004;\u0006=\u0002\"\u0002\u001e\u000b\u0001\u0004\u0001\u0007BBA\u001f\u0015\u0001\u0007Q-A\u000bs_2d'-Y2l'B,7-\u001b4jG\u0006$\u0018n\u001c8\u0015\t\u0005\u0005\u0013q\t\t\u00045\u0005\r\u0013bAA#7\t!QK\\5u\u0011\u0015Q4\u00021\u0001aQ\r\u0001\u00111\n\t\u0005\u0003\u001b\n\u0019&\u0004\u0002\u0002P)\u0019\u0011\u0011\u000b'\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0002V\u0005=#!C\"p[B|g.\u001a8u\u0001")
public class RollbackService
implements Logging {
    private final IEngine engine;
    private final DeploymentService deploymentService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        RollbackService rollbackService = this;
        synchronized (rollbackService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public String rollback(Task task) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Going to rollback task ").append(task.getId()).toString());
        TaskSpecification rollbackSpecification = this.createRollbackSpecification(task);
        return this.doRollback(task, rollbackSpecification);
    }

    public TaskSpecification createRollbackSpecification(Task task) {
        TaskExecutionContext context = task.getContext();
        WorkdirCleanerTrigger workdirCleanerTrigger = this.getWorkdirCleaner(context);
        CheckPointManagerListener checkPointManagerListener = this.getCheckPointManagerListener(context);
        TaskSpecification rollbackSpecification = this.createRollbackSpecification(task, checkPointManagerListener, (List<WorkDir>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(workdirCleanerTrigger.getWorkDirs()).asScala()).toList());
        rollbackSpecification.getListeners().add(new RollbackCompletedListener(task.getId()));
        TaskMetadata.putMetadata((TaskSpecification)rollbackSpecification, (String)"taskType", (String)TaskType.ROLLBACK.name());
        TaskMetadata.putMetadata((TaskSpecification)rollbackSpecification, (String)"rollbackTask", (String)task.getId());
        return rollbackSpecification;
    }

    private TaskSpecification createRollbackSpecification(Task task, CheckPointManagerListener partialCommitTrigger, List<WorkDir> workDirs) {
        MultiDeltaSpecification rollbackSpec = partialCommitTrigger.checkpointManager().prepareRollback();
        return this.deploymentService.getTaskFullSpecification(rollbackSpec, task.getWorkDir(), (WorkDir[])workDirs.toArray(ClassTag$.MODULE$.apply(WorkDir.class)));
    }

    private WorkdirCleanerTrigger getWorkdirCleaner(TaskExecutionContext context) {
        String name = WorkdirCleanerTrigger.class.getName();
        return (WorkdirCleanerTrigger)context.getAttribute(name);
    }

    private CheckPointManagerListener getCheckPointManagerListener(TaskExecutionContext context) {
        String name = CheckPointManagerListener.class.getName();
        return (CheckPointManagerListener)context.getAttribute(name);
    }

    /*
     * WARNING - void declaration
     */
    public String doRollback(Task task, TaskSpecification rollbackSpecification) {
        void var3_3;
        String rollbackTaskId = this.engine.prepareRollbackAndRegister(task.getId(), rollbackSpecification);
        this.archive(task);
        return var3_3;
    }

    private void archive(Task task) {
        TaskExecutionState taskExecutionState = task.getState();
        TaskExecutionState taskExecutionState2 = TaskExecutionState.EXECUTED;
        if (!(taskExecutionState != null ? !taskExecutionState.equals(taskExecutionState2) : taskExecutionState2 != null)) {
            this.engine.archive(task.getId());
        } else if (((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TaskExecutionState[]{TaskExecutionState.STOPPED, TaskExecutionState.ABORTED, TaskExecutionState.FAILED}))).contains((Object)task.getState())) {
            this.engine.cancel(task.getId());
        } else {
            throw new IllegalStateException(new StringBuilder(67).append("Can only rollback a STOPPED, FAILED, ABORTED or EXECUTED task [").append(task.getId()).append(" (").append(task.getState()).append(")]").toString());
        }
    }

    @Autowired
    public RollbackService(IEngine engine, DeploymentService deploymentService, TaskArchive taskArchive) {
        this.engine = engine;
        this.deploymentService = deploymentService;
        Logging.$init$((Logging)this);
    }
}

