/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.base.Strings;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.repository.ConfigurationItemData;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.permission.DeployitPermissions;
import com.xebialabs.deployit.security.permission.PermissionHelper;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.task.TaskType;
import com.xebialabs.deployit.task.archive.TaskArchive;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class AbstractTaskRestrictedResource
extends AbstractSecuredResource {
    @Autowired
    protected TaskArchive taskArchive;
    @Autowired
    protected RepositoryService repositoryService;

    protected void checkAccessTo(Map<String, String> taskMetadata) {
        boolean isCloudTask;
        boolean isControlTask = TaskType.CONTROL.name().equals(taskMetadata.get("taskType"));
        boolean bl = isCloudTask = taskMetadata.get("cloudOperation") != null;
        if (isCloudTask) {
            this.doCloudTaskPermissionCheck(taskMetadata);
        } else if (isControlTask) {
            this.doControlTaskPermissionCheck(taskMetadata);
        } else {
            this.doDeploymentTaskPermissionCheck(taskMetadata);
        }
    }

    protected boolean hasTaskPermission(Map<String, String> taskMetadata) {
        boolean isCloudTask;
        boolean isControlTask = TaskType.CONTROL.name().equals(taskMetadata.get("taskType"));
        boolean bl = isCloudTask = taskMetadata.get("cloudOperation") != null;
        if (isCloudTask) {
            return this.hasCloudTaskPermission(taskMetadata);
        }
        if (isControlTask) {
            return this.hasTargetOrIsAdmin(taskMetadata) && this.hasControlTaskPermission(taskMetadata);
        }
        return this.hasDeploymentTaskPermission(taskMetadata, this.getApplicationId(taskMetadata));
    }

    private void doDeploymentTaskPermissionCheck(Map<String, String> taskMetadata) {
        String appId = this.getApplicationId(taskMetadata);
        if (appId == null) {
            throw new DeployitException("Unable to locate application for report");
        }
        if (!this.hasDeploymentTaskPermission(taskMetadata, appId)) {
            throw PermissionDeniedException.withMessage((String)"You need read permissions for both the environment and application to view the archived task.");
        }
    }

    private boolean hasDeploymentTaskPermission(Map<String, String> taskMetadata, String appId) {
        String envId = taskMetadata.get("environment_id");
        return appId != null && this.hasPermission(PlatformPermissions.READ, envId) && this.hasPermission(PlatformPermissions.READ, appId);
    }

    private String getApplicationId(Map<String, String> taskMetadata) {
        String appName = taskMetadata.get("application");
        List applications = this.repositoryService.list(new SearchParameters().setType(Type.valueOf(Application.class)).setName(appName));
        if (applications.size() != 1) {
            return null;
        }
        return ((ConfigurationItemData)applications.get(0)).getId();
    }

    private void doControlTaskPermissionCheck(Map<String, String> taskMetadata) {
        if (!this.hasTargetOrIsAdmin(taskMetadata)) {
            throw PermissionDeniedException.withMessage((String)"Control tasks that don't have their target CI archived can only be viewed by admin.");
        }
        if (!this.hasControlTaskPermission(taskMetadata)) {
            throw PermissionDeniedException.withMessage((String)"You need controltask#execute permission on an archived control task's target CI to view it.");
        }
    }

    private boolean hasTargetOrIsAdmin(Map<String, String> taskMetadata) {
        return !Strings.isNullOrEmpty((String)taskMetadata.get("controlTaskTargetCI")) || PermissionHelper.isCurrentUserAdmin();
    }

    private boolean hasControlTaskPermission(Map<String, String> taskMetadata) {
        return this.hasPermission(DeployitPermissions.CONTROLTASK_EXECUTE, taskMetadata.get("controlTaskTargetCI"));
    }

    private boolean hasCloudTaskPermission(Map<String, String> taskMetadata) {
        String cloudEnvId = taskMetadata.get("cloudEnvironmentId");
        String cloudTemplId = taskMetadata.get("cloudEnvironmentTemplateId");
        return this.hasPermission(PlatformPermissions.READ, cloudEnvId) && this.hasPermission(PlatformPermissions.READ, cloudTemplId);
    }

    private void doCloudTaskPermissionCheck(Map<String, String> taskMetadata) {
        if (!this.hasCloudTaskPermission(taskMetadata)) {
            throw PermissionDeniedException.withMessage((String)"You need read permissions for both the environment and the environment template to view the archived cloud task.");
        }
    }
}

