/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.discovery;

import java.net.MalformedURLException;
import java.net.URL;

public class ProviderConfiguration {
    private URL issuer;
    private URL authorizationEndpoint;
    private URL tokenEndpoint;
    private URL userInfoEndpoint;
    private URL jwkSetUri;

    public URL getIssuer() {
        return this.issuer;
    }

    public URL getAuthorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public URL getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public URL getUserInfoEndpoint() {
        return this.userInfoEndpoint;
    }

    public URL getJwkSetUri() {
        return this.jwkSetUri;
    }

    public static class Builder {
        private ProviderConfiguration providerConfiguration = new ProviderConfiguration();

        public void issuer(String isssuer) {
            this.providerConfiguration.issuer = this.toURL(isssuer);
        }

        public void authorizationEndpoint(String authorizationEndpoint) {
            this.providerConfiguration.authorizationEndpoint = this.toURL(authorizationEndpoint);
        }

        public void tokenEndpoint(String tokenEndpoint) {
            this.providerConfiguration.tokenEndpoint = this.toURL(tokenEndpoint);
        }

        public void userInfoEndpoint(String userInfoEndpoint) {
            this.providerConfiguration.userInfoEndpoint = this.toURL(userInfoEndpoint);
        }

        public void jwkSetUri(String jwkSetUri) {
            this.providerConfiguration.jwkSetUri = this.toURL(jwkSetUri);
        }

        public ProviderConfiguration build() {
            return this.providerConfiguration;
        }

        private URL toURL(String urlStr) {
            try {
                return new URL(urlStr);
            }
            catch (MalformedURLException ex) {
                throw new IllegalArgumentException("Unable to convert '" + urlStr + "' to URL: " + ex.getMessage(), ex);
            }
        }
    }
}

