/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.xebialabs.deployit.engine.spi.command.CopyCiCommand;
import com.xebialabs.deployit.engine.spi.command.CreateCiCommand;
import com.xebialabs.deployit.engine.spi.command.CreateCisCommand;
import com.xebialabs.deployit.engine.spi.command.DeleteCiCommand;
import com.xebialabs.deployit.engine.spi.command.DeleteCisCommand;
import com.xebialabs.deployit.engine.spi.command.MoveCiCommand;
import com.xebialabs.deployit.engine.spi.command.RenameCiCommand;
import com.xebialabs.deployit.engine.spi.command.UpdateCiCommand;
import com.xebialabs.deployit.engine.spi.command.UpdateCisCommand;
import com.xebialabs.deployit.engine.spi.command.util.Update;
import com.xebialabs.deployit.engine.spi.event.DeployitEventListener;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.CiRepositoryUtils;
import com.xebialabs.deployit.repository.ConfigurationItemData;
import com.xebialabs.deployit.repository.RepositoryServiceHolder;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.core.Directory;
import java.util.List;
import java.util.stream.Collectors;
import nl.javadude.t2bus.Subscribe;

@DeployitEventListener
public class RepositoryEventListener {
    public static final String DUPLICATE_NAME_SUFFIX = "Copy";

    @Subscribe
    public void receiveCreate(CreateCiCommand command) {
        CiRepositoryUtils.checkApplicationOnUniqueness(command.getCi());
        RepositoryServiceHolder.getRepositoryService().create(new ConfigurationItem[]{command.getCi()});
    }

    @Subscribe
    public void receiveCreate(CreateCisCommand command) {
        List listOfCis = command.getCis();
        ConfigurationItem[] cis = listOfCis.toArray(new ConfigurationItem[listOfCis.size()]);
        CiRepositoryUtils.checkApplicationOnUniqueness(cis);
        RepositoryServiceHolder.getRepositoryService().create(cis);
    }

    @Subscribe
    public void receiveUpdate(UpdateCiCommand command) {
        RepositoryServiceHolder.getRepositoryService().update(new ConfigurationItem[]{command.getUpdate().getNewCi()});
    }

    @Subscribe
    public void receiveUpdate(UpdateCisCommand command) {
        List updates = command.getUpdates();
        List cis = updates.stream().map(Update::getNewCi).collect(Collectors.toList());
        RepositoryServiceHolder.getRepositoryService().createOrUpdateCis(cis, command.getSCMTraceabilityData());
    }

    @Subscribe
    public void receiveDelete(DeleteCiCommand command) {
        RepositoryServiceHolder.getRepositoryService().delete(command.getCiId());
    }

    @Subscribe
    public void receiveDelete(DeleteCisCommand command) {
        RepositoryServiceHolder.getRepositoryService().delete(command.getCis().toArray(new String[command.getCis().size()]));
    }

    @Subscribe
    public void receiveMove(MoveCiCommand command) {
        RepositoryServiceHolder.getRepositoryService().move(command.getId(), command.getTargetId());
    }

    @Subscribe
    public void receiveCopy(CopyCiCommand command) {
        CiRepositoryUtils.checkApplicationOnUniquenessByName(this.getName(command.getTargetId()), command.getType());
        RepositoryServiceHolder.getRepositoryService().copy(command.getId(), command.getTargetId());
        this.ensureChildApplicationNamesAreUnique(command);
    }

    @Subscribe
    public void receiveRename(RenameCiCommand command) {
        CiRepositoryUtils.checkApplicationOnUniquenessByName(command.getTargetName(), command.getType());
        RepositoryServiceHolder.getRepositoryService().rename(command.getId(), command.getTargetName());
    }

    private void ensureChildApplicationNamesAreUnique(CopyCiCommand command) {
        if (!Type.valueOf(Directory.class).instanceOf(command.getType())) {
            return;
        }
        Type applicationType = Type.valueOf(Application.class);
        SearchParameters parameters = new SearchParameters().setType(applicationType).setAncestor(command.getTargetId());
        for (ConfigurationItemData childApplication : RepositoryServiceHolder.getRepositoryService().list(parameters)) {
            String duplicateName = CiRepositoryUtils.findUniqueName(applicationType, this.getName(childApplication.getId()), DUPLICATE_NAME_SUFFIX);
            RepositoryServiceHolder.getRepositoryService().rename(childApplication.getId(), duplicateName);
        }
    }

    private String getName(String id) {
        int indexOfLastSlash = id.lastIndexOf(47);
        if (indexOfLastSlash > -1) {
            return id.substring(indexOfLastSlash + 1);
        }
        return id;
    }
}

