/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.json;

import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.repository.RepositoryAdapterFactory;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReaderPostProcessor {
    private final RepositoryAdapterFactory factory;

    @Autowired
    public ReaderPostProcessor(RepositoryAdapterFactory factory) {
        this.factory = factory;
    }

    <T> T apply(Function<CiConverterContext, T> convertCallback, Boolean skipNotExistingCis) {
        CiConverterContext context = new CiConverterContext();
        T result = convertCallback.apply(context);
        Repository repository = this.factory.create();
        context.converters.forEach(ciConverter -> ciConverter.resolveReferences(repository, skipNotExistingCis));
        return result;
    }

    <T> T apply(Function<CiConverterContext, T> convertCallback) {
        return this.apply(convertCallback, false);
    }

    static class CiConverterContext {
        private final List<ConfigurationItemConverter> converters = new ArrayList<ConfigurationItemConverter>();

        CiConverterContext() {
        }

        public void register(ConfigurationItemConverter converter) {
            this.converters.add(converter);
        }
    }
}

