/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.FluentIterable;
import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.dto.ReportLine;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

public class ReportUtils {
    static final PeriodFormatter HH_MM_SS = new PeriodFormatterBuilder().minimumPrintedDigits(2).printZeroAlways().appendHours().appendSeparator(":").appendMinutes().appendSeparator(":").appendSeconds().toFormatter();
    private static final Joiner LINE_JOINER = Joiner.on((String)"\n");
    private static final Joiner FIELD_JOINER = Joiner.on((String)",");
    private static final Function<Object, String> QUOTE = input -> String.format("\"%s\"", input);

    private ReportUtils() {
    }

    static final String formatToHoursMinsSecs(long millis) {
        Period period = new Duration(millis).toPeriod();
        return HH_MM_SS.print((ReadablePeriod)period);
    }

    public static Stream<String> toCsv(Report report) {
        return ReportUtils.toCsv(report.getLines().stream());
    }

    public static Stream<String> toCsv(Stream<ReportLine> report) {
        return report.map(new HeadersFirstLine());
    }

    private static String line(Iterable<?> fields) {
        return FIELD_JOINER.join((Iterable)FluentIterable.from(fields).transform(QUOTE));
    }

    private static TreeMap<String, Object> sorted(ReportLine line) {
        return new TreeMap<String, Object>(line.getValues());
    }

    public static List<DateTime> getMonthsOfInterval(DateTime begin, DateTime end) {
        ArrayList<DateTime> result = new ArrayList<DateTime>();
        DateTime current = begin;
        while (current.isBefore((ReadableInstant)end) || current.isEqual((ReadableInstant)begin)) {
            result.add(current);
            current = current.plusMonths(1);
        }
        return result;
    }

    private static class HeadersFirstLine
    implements java.util.function.Function<ReportLine, String> {
        boolean first = true;

        private HeadersFirstLine() {
        }

        @Override
        public String apply(ReportLine reportLine) {
            TreeMap sorted = ReportUtils.sorted(reportLine);
            if (this.first) {
                this.first = false;
                return LINE_JOINER.join((Object)ReportUtils.line(sorted.keySet()), (Object)ReportUtils.line(sorted.values()), new Object[0]);
            }
            return ReportUtils.line(sorted.values());
        }
    }
}

