/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.tasker.satellite;

import com.xebialabs.deployit.engine.tasker.satellite.KryoCompressor;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001i2A!\u0002\u0004\u0001'!)a\u0004\u0001C\u0001?!A\u0011\u0005\u0001EC\u0002\u0013\u0005!\u0005C\u0003.\u0001\u0011\u0005a\u0006C\u00038\u0001\u0011\u0005\u0001H\u0001\tM5RZ%/_8D_6\u0014Xm]:pe*\u0011q\u0001C\u0001\ng\u0006$X\r\u001c7ji\u0016T!!\u0003\u0006\u0002\rQ\f7o[3s\u0015\tYA\"\u0001\u0004f]\u001eLg.\u001a\u0006\u0003\u001b9\t\u0001\u0002Z3qY>L\u0018\u000e\u001e\u0006\u0003\u001fA\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003E\t1aY8n\u0007\u0001\u00192\u0001\u0001\u000b\u001b!\t)\u0002$D\u0001\u0017\u0015\u00059\u0012!B:dC2\f\u0017BA\r\u0017\u0005\u0019\te.\u001f*fMB\u00111\u0004H\u0007\u0002\r%\u0011QD\u0002\u0002\u000f\u0017JLxnQ8naJ,7o]8s\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0005\u0005\u0002\u001c\u0001\u0005QAN\u001f\u001bgC\u000e$xN]=\u0016\u0003\r\u0002\"\u0001J\u0016\u000e\u0003\u0015R!AJ\u0014\u0002\u00071THG\u0003\u0002)S\u00059!\u000e]8v]RT(\"\u0001\u0016\u0002\u00079,G/\u0003\u0002-K\tQAJ\u0017\u001bGC\u000e$xN]=\u0002\u0011\r|W\u000e\u001d:fgN$\"aL\u001b\u0011\u0007U\u0001$'\u0003\u00022-\t)\u0011I\u001d:bsB\u0011QcM\u0005\u0003iY\u0011AAQ=uK\")ag\u0001a\u0001_\u0005I\u0011N\u001c9vi\n+hMZ\u0001\u000bI\u0016\u001cw.\u001c9sKN\u001cHCA\u0018:\u0011\u00151D\u00011\u00010\u0001")
public class LZ4KryoComressor
implements KryoCompressor {
    private LZ4Factory lz4factory;
    private volatile boolean bitmap$0;

    private LZ4Factory lz4factory$lzycompute() {
        LZ4KryoComressor lZ4KryoComressor = this;
        synchronized (lZ4KryoComressor) {
            if (!this.bitmap$0) {
                this.lz4factory = LZ4Factory.fastestInstance();
                this.bitmap$0 = true;
            }
        }
        return this.lz4factory;
    }

    public LZ4Factory lz4factory() {
        return !this.bitmap$0 ? this.lz4factory$lzycompute() : this.lz4factory;
    }

    @Override
    public byte[] compress(byte[] inputBuff) {
        int inputSize = inputBuff.length;
        LZ4Compressor lz4 = this.lz4factory().fastCompressor();
        int maxOutputSize = lz4.maxCompressedLength(inputSize);
        byte[] outputBuff = new byte[maxOutputSize + 4];
        int outputSize = lz4.compress(inputBuff, 0, inputSize, outputBuff, 4, maxOutputSize);
        outputBuff[0] = (byte)(inputSize & 0xFF);
        outputBuff[1] = (byte)(inputSize >> 8 & 0xFF);
        outputBuff[2] = (byte)(inputSize >> 16 & 0xFF);
        outputBuff[3] = (byte)(inputSize >> 24 & 0xFF);
        return (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(outputBuff)).take(outputSize + 4);
    }

    @Override
    public byte[] decompress(byte[] inputBuff) {
        int size = inputBuff[0] & 0xFF | (inputBuff[1] & 0xFF) << 8 | (inputBuff[2] & 0xFF) << 16 | (inputBuff[3] & 0xFF) << 24;
        LZ4FastDecompressor lz4 = this.lz4factory().fastDecompressor();
        byte[] outputBuff = new byte[size];
        lz4.decompress(inputBuff, 4, outputBuff, 0, size);
        return outputBuff;
    }
}

