/*
 * Decompiled with CFR 0.152.
 */
package kamon.jmx;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kamon.jmx.MetricMBeans;
import kamon.metric.instrument.InstrumentSnapshot;
import kamon.util.logger.LazyLogger;
import kamon.util.logger.LazyLogger$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;

public final class MBeanManager$ {
    public static MBeanManager$ MODULE$;
    private final MBeanServer mbs;
    private final TrieMap<String, MetricMBeans.AbstractMetricMBean<?>> registeredMBeans;
    private final LazyLogger log;

    static {
        new MBeanManager$();
    }

    private MBeanServer mbs() {
        return this.mbs;
    }

    private TrieMap<String, MetricMBeans.AbstractMetricMBean<?>> registeredMBeans() {
        return this.registeredMBeans;
    }

    private LazyLogger log() {
        return this.log;
    }

    public <M extends MetricMBeans.AbstractMetricMBean<T>, T extends InstrumentSnapshot> void createOrUpdateMBean(String group, String name, T snapshot, Function2<T, ObjectName, M> buildMetricMBean) {
        Some some;
        MetricMBeans.AbstractMetricMBean mbean;
        Option option = this.registeredMBeans().get((Object)name);
        if (option instanceof Some && (mbean = (MetricMBeans.AbstractMetricMBean)(some = (Some)option).value()) instanceof MetricMBeans.AbstractMetricMBean) {
            MetricMBeans.AbstractMetricMBean abstractMetricMBean = mbean;
            abstractMetricMBean.snapshot_$eq(snapshot);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            ObjectName objectName = new ObjectName(this.createMBeanName("kamon", group, name, this.createMBeanName$default$4()));
            MetricMBeans.AbstractMetricMBean mbean2 = (MetricMBeans.AbstractMetricMBean)buildMetricMBean.apply(snapshot, (Object)objectName);
            this.registeredMBeans().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)mbean2));
            this.mbs().registerMBean(mbean2, objectName);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new IllegalStateException("Illegal metric bean type");
        }
    }

    public void unregisterAllBeans() {
        ((IterableLike)this.registeredMBeans().values().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.objectName(), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)name -> {
            MBeanManager$.$anonfun$unregisterAllBeans$2(this, name);
            return BoxedUnit.UNIT;
        });
        this.registeredMBeans().clear();
    }

    private String createMBeanName(String group, String type, String name, Option<String> scope) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        StringBuilder nameBuilder = new StringBuilder();
        nameBuilder.append(group);
        nameBuilder.append(":type=");
        nameBuilder.append(type);
        if (scope.isDefined()) {
            nameBuilder.append(",scope=");
            boxedUnit2 = nameBuilder.append((String)scope.get());
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (name.length() > 0) {
            nameBuilder.append(",name=");
            boxedUnit = nameBuilder.append(name);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return nameBuilder.toString();
    }

    private Option<String> createMBeanName$default$4() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$unregisterAllBeans$2(MBeanManager$ $this, ObjectName name) {
        block4: {
            try {
                $this.mbs().unregisterMBean(name);
            }
            catch (InstanceNotFoundException e) {
                if ($this.log().isTraceEnabled()) {
                    $this.log().trace((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error unregistering ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})), (Function0 & Serializable & scala.Serializable)() -> e);
                }
            }
            catch (MBeanRegistrationException e) {
                if (!$this.log().isDebugEnabled()) break block4;
                $this.log().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error unregistering ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})), (Function0 & Serializable & scala.Serializable)() -> e);
            }
        }
    }

    private MBeanManager$() {
        MODULE$ = this;
        this.mbs = ManagementFactory.getPlatformMBeanServer();
        this.registeredMBeans = TrieMap$.MODULE$.empty();
        this.log = LazyLogger$.MODULE$.apply(this.getClass());
    }
}

