/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.signature;

import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.SSHRuntimeException;
import net.schmizz.sshj.common.SecurityUtils;
import net.schmizz.sshj.signature.Signature;

public abstract class AbstractSignature
implements Signature {
    protected final java.security.Signature signature;

    protected AbstractSignature(String algorithm) {
        try {
            this.signature = SecurityUtils.getSignature(algorithm);
        }
        catch (GeneralSecurityException e) {
            throw new SSHRuntimeException(e);
        }
    }

    protected AbstractSignature(java.security.Signature signatureEngine) {
        this.signature = signatureEngine;
    }

    @Override
    public void initVerify(PublicKey publicKey) {
        try {
            this.signature.initVerify(publicKey);
        }
        catch (InvalidKeyException e) {
            throw new SSHRuntimeException(e);
        }
    }

    @Override
    public void initSign(PrivateKey privateKey) {
        try {
            this.signature.initSign(privateKey);
        }
        catch (InvalidKeyException e) {
            throw new SSHRuntimeException(e);
        }
    }

    @Override
    public void update(byte[] foo) {
        this.update(foo, 0, foo.length);
    }

    @Override
    public void update(byte[] foo, int off, int len) {
        try {
            this.signature.update(foo, off, len);
        }
        catch (SignatureException e) {
            throw new SSHRuntimeException(e);
        }
    }

    @Override
    public byte[] sign() {
        try {
            return this.signature.sign();
        }
        catch (SignatureException e) {
            throw new SSHRuntimeException(e);
        }
    }

    protected byte[] extractSig(byte[] sig, String expectedKeyAlgorithm) {
        Buffer.PlainBuffer buffer = new Buffer.PlainBuffer(sig);
        try {
            String algo = buffer.readString();
            if (!expectedKeyAlgorithm.equals(algo)) {
                throw new SSHRuntimeException("Expected '" + expectedKeyAlgorithm + "' key algorithm, but got: " + algo);
            }
            return buffer.readBytes();
        }
        catch (Buffer.BufferException e) {
            throw new SSHRuntimeException(e);
        }
    }
}

