/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.wrapper;

import com.sun.jna.Platform;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.configuration2.Configuration;
import org.rzo.yajsw.app.WrapperMainServiceWin;
import org.rzo.yajsw.boot.WrapperLoader;
import org.rzo.yajsw.controller.AbstractController;
import org.rzo.yajsw.controller.jvm.JVMController;
import org.rzo.yajsw.os.JavaHome;
import org.rzo.yajsw.os.OperatingSystem;
import org.rzo.yajsw.util.Utils;
import org.rzo.yajsw.wrapper.AbstractWrappedProcess;
import org.rzo.yajsw.wrapper.AlphaNumericComparator;
import org.rzo.yajsw.wrapper.FileUtils;
import org.rzo.yajsw.wrapper.WrappedProcess;

public class WrappedJavaProcess
extends AbstractWrappedProcess {
    String _key;
    String _teeName;
    File _javaPidFile;
    boolean _initController = false;
    Runnable _serviceStartupListener = null;
    private static final Random RANDOM = new Random();
    private static final AtomicLong FILE_COUNTER = new AtomicLong(System.currentTimeMillis());

    @Override
    public void init() {
        super.init();
        this._key = "" + RANDOM.nextLong();
        this._localConfiguration.setProperty("wrapper.key", (Object)this._key);
        if (this._controller == null) {
            this._controller = new JVMController(this);
            this.configController();
        }
    }

    @Override
    protected boolean pipeStreams() {
        return super.pipeStreams() || this._teeName != null;
    }

    @Override
    protected void setState(int state) {
        super.setState(state);
        if (state == 0) {
            this.removeJavaPidFile();
        }
    }

    @Override
    void configProcess() {
        this._osProcess.setTmpPath(this._tmpPath);
        if (!super.pipeStreams()) {
            this._teeName = this._key + "$" + FILE_COUNTER.incrementAndGet();
            this._localConfiguration.setProperty("wrapper.teeName", (Object)this._teeName);
            this._osProcess.setTeeName(this._teeName);
            this._osProcess.setPipeStreams(false, false);
        } else {
            this._osProcess.setPipeStreams(true, true);
            this._osProcess.setTeeName(null);
            if (!this._haltAppOnWrapper) {
                this.getWrapperLogger().log(Level.WARNING, "WARNING: application streams are piped, but wrapper.control setting may cause zombie processes. Please set to TIGHT");
            }
        }
        JavaHome javaHome = OperatingSystem.instance().getJavaHome((Configuration)this._config);
        javaHome.setLogger(this.getInternalWrapperLogger(), this._debug);
        String java = javaHome.findJava(this._config.getString("wrapper.java.command"), this._config.getString("wrapper.java.customProcName"));
        if (java == null) {
            this.getWrapperLogger().log(Level.SEVERE, "ERROR: could not get java command");
        }
        List jvmOptions = this.jvmOptions();
        List wrapperOptions = this.wrapperOptions();
        String mainClass = this.getMainClass();
        ArrayList<String> command = new ArrayList<String>();
        command.add(java);
        command.addAll(jvmOptions);
        command.addAll(wrapperOptions);
        command.add(mainClass);
        String[] arrCmd = new String[command.size()];
        for (int i = 0; i < arrCmd.length; ++i) {
            arrCmd[i] = (String)command.get(i);
        }
        this._osProcess.setCommand(arrCmd);
        super.configProcess();
    }

    protected String getMainClass() {
        return this._config.getString("wrapper.java.mainclass", "org.rzo.yajsw.app.WrapperJVMMain");
    }

    private List wrapperOptions() {
        String preScript;
        ArrayList<String> result = new ArrayList<String>();
        JVMController controller = (JVMController)this._controller;
        result.add(Utils.getDOption("wrapper.port", "" + controller.getPort()));
        result.add(Utils.getDOption("wrapper.key", controller.getKey()));
        if (this._teeName != null) {
            result.add(Utils.getDOption("wrapper.teeName", this._teeName));
        }
        result.add(Utils.getDOption("wrapper.tmp.path", this._tmpPath));
        result.add(Utils.getDOption("jna_tmpdir", this._tmpPath));
        Iterator it = this._config.getSystemConfiguration().getKeys("wrapper");
        while (it.hasNext()) {
            String opt;
            String key = (String)it.next();
            if (("wrapper.service".equals(key) || "wrapper.console.visible".equals(key)) && this._config.getBoolean("wrapper.service", false)) continue;
            if ("wrapper.config".equals(key)) {
                result.add(this.checkValue(Utils.getDOption(key, this._config.getCachedPath())));
                continue;
            }
            if (this._config.getProperty(key) == null || result.contains(opt = Utils.getDOption(key, this._config.getProperty(key).toString()))) continue;
            result.add(this.checkValue(opt));
        }
        String gcPattern = this._config.getString("wrapper.java.monitor.gc", null);
        if (gcPattern != null && gcPattern.length() > 0) {
            result.add(Utils.getDOption("wrapper.java.monitor.gc", gcPattern));
        }
        if ((preScript = this._config.getString("wrapper.app.pre.script", null)) != null & !"".equals(preScript)) {
            try {
                File f = new File(preScript);
                if (!f.exists()) {
                    this.getWrapperLogger().warning("app.pre.script not found: " + preScript);
                } else {
                    preScript = this.checkValue(f.getCanonicalPath());
                    result.add(Utils.getDOption("wrapper.app.pre.script", preScript));
                }
            }
            catch (Exception ex) {
                this.getWrapperLogger().log(Level.SEVERE, "WrappedJavaProcess wrapperOptions", ex);
            }
        }
        return result;
    }

    private List jvmOptions() {
        String preMainScript;
        int port;
        String key;
        String cp;
        ArrayList<String> result = new ArrayList<String>();
        result.add("-classpath");
        StringBuffer sb = new StringBuffer();
        sb.append(WrapperLoader.getWrapperAppJar().trim());
        StringBuilder appCp = this.getAppClassPath(this._config.getString("wrapper.working.dir", "."), this._config.getKeys("wrapper.java.classpath"));
        if (appCp != null && appCp.length() > 0) {
            sb.append(PATHSEP);
            sb.append((CharSequence)appCp);
        }
        if ((cp = sb.toString()).contains(" ") && Platform.isWindows()) {
            cp = "\"" + cp + "\"";
        }
        result.add(this.checkValue(cp));
        boolean hasXrs = false;
        boolean hasXmx = false;
        boolean hasXms = false;
        Iterator it = this._config.getKeys("wrapper.java.additional");
        while (it.hasNext()) {
            key = (String)it.next();
            String value = this._config.getString(key);
            if (value == null) continue;
            result.add(this.checkQuotes(this.checkValue(value)));
            hasXrs |= value.contains("-Xrs");
            hasXmx |= value.contains("-Xmx");
            hasXms |= value.contains("-Xms");
        }
        sb = new StringBuffer();
        if (this._config.getKeys("wrapper.java.library.path").hasNext()) {
            it = this._config.getKeys("wrapper.java.library.path");
            while (it.hasNext()) {
                key = (String)it.next();
                if (this._config.getString(key) == null) continue;
                sb.append(this.checkQuotes(this.checkValue(this._config.getString(key))));
                if (!it.hasNext()) continue;
                sb.append(PATHSEP);
            }
            result.add(Utils.getDOption("java.library.path", sb.toString()));
        }
        if (this._config.getBoolean("wrapper.service", false) && !hasXrs && this._config.getBoolean("wrapper.ntservice.reduce_signals", true)) {
            result.add("-Xrs");
        }
        if (this._config.getBoolean("wrapper.service", false)) {
            result.add("-Dwrapper.service=true");
            result.add("-Dwrapper.console.visible=false");
        } else if (this._config.getBoolean("wrapper.console.visible", false)) {
            result.add("-Dwrapper.console.visible=true");
        }
        if (this._config.containsKey("wrapper.java.initmemory") || this._config.containsKey("wrapper.java.initmemory.relative") || this._config.containsKey("wrapper.java.maxmemory") || this._config.containsKey("wrapper.java.maxmemory.relative")) {
            long xmx = 0L;
            long xmxr = 0L;
            long xms = 0L;
            long xmsr = 0L;
            OperatingSystem.instance().systemInformation().setLogger(this.getWrapperLogger());
            long totalRAM = 0L;
            if (!hasXms) {
                try {
                    xms = this._config.getLong("wrapper.java.initmemory", 0L);
                    xmsr = this._config.getLong("wrapper.java.initmemory.relative", 0L);
                }
                catch (Exception ex) {
                    this.getWrapperLogger().info("error in wrapper.java.initmemory " + ex.getMessage());
                }
                if (xmsr > 0L) {
                    totalRAM = OperatingSystem.instance().systemInformation().totalRAM();
                }
                if (xmsr > 0L && totalRAM > 0L) {
                    xms = totalRAM * xmsr / 100L / 0x100000L;
                }
                if (xms > 0L) {
                    result.add("-Xms" + xms + "m");
                }
            }
            if (!hasXmx) {
                try {
                    xmx = this._config.getLong("wrapper.java.maxmemory", 0L);
                    xmxr = this._config.getLong("wrapper.java.maxmemory.relative", 0L);
                }
                catch (Exception ex) {
                    this.getWrapperLogger().info("error in wrapper.java.maxmemory " + ex.getMessage());
                }
                if (xmxr > 0L && totalRAM == 0L) {
                    totalRAM = OperatingSystem.instance().systemInformation().totalRAM();
                }
                if (xmxr > 0L && totalRAM > 0L) {
                    xmx = totalRAM * xmxr / 100L / 0x100000L;
                }
                if (xmx > 0L) {
                    if (xmx < xms) {
                        xmx = xms;
                    }
                    if (xmx < 3L) {
                        xmx = 3L;
                    }
                    result.add("-Xmx" + xmx + "m");
                }
            }
        }
        if ((port = this._config.getInt("wrapper.java.debug.port", -1)) != -1) {
            result.add("-Xdebug");
            result.add("-Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=" + port);
        }
        if ((preMainScript = this._config.getString("wrapper.app.pre_main.script", null)) != null && preMainScript.length() > 0) {
            result.add(Utils.getDOption("wrapper.app.pre_main.script", preMainScript));
        }
        if (this._config.getBoolean("wrapper.service", false) || this._config.getBoolean("wrapper.console.use_interpolated", true)) {
            for (Map.Entry<String, String> e : this._config.getEnvLookupSet().entrySet()) {
                String opt;
                if (e.getKey().contains("password") || (opt = Utils.getDOption(e.getKey(), e.getValue())) == null || result.contains(opt)) continue;
                result.add(opt);
            }
        }
        return result;
    }

    private String checkQuotes(String value) {
        if (value.contains("\"")) {
            value = value.replaceAll("\"", "");
        }
        if (value.contains(" ")) {
            value = "\"" + value + "\"";
        }
        return value;
    }

    private String checkValue(String value) {
        if ((value = value.trim()).endsWith("\\") && !value.endsWith("\\\\")) {
            value = value + "\\";
        }
        return value;
    }

    private StringBuilder getAppClassPath(String workingDir, Iterator keys) {
        workingDir = workingDir.replaceAll("\"", "");
        ArrayList configList = new ArrayList();
        Iterator it = keys;
        while (it.hasNext()) {
            configList.add(it.next());
        }
        Collections.sort(configList, new AlphaNumericComparator());
        ArrayList files = new ArrayList();
        String jar = this._config.getString("wrapper.java.app.jar", null);
        if (jar != null) {
            jar = jar.replaceAll("\"", "");
            Collection jars = FileUtils.getFiles(workingDir, jar);
            files.addAll(jars);
            files.addAll(this.classpathFromJar(jars, workingDir));
        }
        ListIterator it2 = configList.listIterator();
        while (it2.hasNext()) {
            String file = this._config.getString((String)it2.next());
            if ((file = file.replaceAll("\"", "")) == null) continue;
            files.addAll(FileUtils.getFiles(workingDir, file));
        }
        Path workingDirPath = new File(workingDir).toPath();
        StringBuilder sb = new StringBuilder();
        Iterator it3 = files.iterator();
        while (it3.hasNext()) {
            try {
                String fileLocation;
                File file = (File)it3.next();
                try {
                    fileLocation = workingDirPath.relativize(file.toPath()).toString();
                }
                catch (IllegalArgumentException e) {
                    fileLocation = file.getCanonicalPath();
                }
                sb.append(fileLocation);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (!it3.hasNext()) continue;
            sb.append(PATHSEP);
        }
        return sb;
    }

    private Collection classpathFromJar(Collection jars, String workingDir) {
        ArrayList result = new ArrayList();
        URL url = null;
        for (Object jar : jars) {
            Manifest manifest;
            try {
                url = ((File)jar).toURI().toURL();
            }
            catch (MalformedURLException e2) {
                e2.printStackTrace();
                continue;
            }
            try {
                manifest = new JarFile((File)jar).getManifest();
            }
            catch (IOException e1) {
                e1.printStackTrace();
                continue;
            }
            Attributes attr = manifest.getMainAttributes();
            String cl = attr.getValue("Class-Path");
            Object loader = null;
            if (cl == null) continue;
            String[] clArr = cl.split(" ");
            for (int i = 0; i < clArr.length; ++i) {
                String file = clArr[i];
                try {
                    Collection myFile = FileUtils.getFiles(workingDir, file);
                    result.addAll(myFile);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    @Override
    void configController() {
        long max;
        JVMController controller = (JVMController)this._controller;
        if (this._config.getBoolean("wrapper.java.monitor.gc.restart", false)) {
            max = this._config.getLong("wrapper.java.monitor.gc.threshold", -1L);
            controller.setMaxFullGCTimeRestart(max);
        }
        if (this._config.getBoolean("wrapper.java.monitor.heap.restart", false)) {
            max = this._config.getLong("wrapper.java.monitor.heap.threshold.percent", -1L);
            controller.setMaxHeapRestart(max);
        }
        controller.setLogger(this.getWrapperLogger());
        controller.setKey(this._config.getString("wrapper.key"));
        if (this._config.containsKey("wrapper.port")) {
            controller.setMinPort(this._config.getInt("wrapper.port"));
            controller.setMaxPort(this._config.getInt("wrapper.port"));
        } else {
            controller.setMinPort(this._config.getInt("wrapper.port.min", 15003));
            controller.setMaxPort(this._config.getInt("wrapper.port.max", 65535));
        }
        controller.setStartupTimeout(this._config.getInt("wrapper.startup.timeout", 30) * 1000);
        controller.setPingTimeout(this._config.getInt("wrapper.ping.timeout", 30) * 1000);
        if (!this._initController) {
            AbstractController.ControllerListener restartHandler = new AbstractController.ControllerListener(){

                @Override
                public void fire() {
                    if (WrappedJavaProcess.this._state == 6 || WrappedJavaProcess.this._state == 2 || WrappedJavaProcess.this._state == 5 || WrappedJavaProcess.this._state == 7) {
                        return;
                    }
                    if (WrappedJavaProcess.this.allowRestart() && WrappedJavaProcess.this.exitCodeRestart() && !WrappedJavaProcess.this.exitCodeShutdown() && !WrappedJavaProcess.this.exitCodeStop() || WrappedJavaProcess.this.allowRestart() && WrappedJavaProcess.this.exitSignalRestart() && !WrappedJavaProcess.this.exitSignalShutdown() && !WrappedJavaProcess.this.exitSignalStop()) {
                        WrappedJavaProcess.this.restartInternal();
                    } else {
                        if (WrappedJavaProcess.this._debug > 1) {
                            WrappedJavaProcess.this.getWrapperLogger().info("giving up after " + WrappedJavaProcess.this._restartCount + " retries");
                        }
                        if (WrappedJavaProcess.this._state != 8) {
                            WrappedJavaProcess.this.setState(9);
                        }
                        if (!WrappedJavaProcess.this._exiting) {
                            WrappedJavaProcess.this.stop();
                        }
                        WrappedJavaProcess.this.setState(0);
                        if (WrappedJavaProcess.this.exitCodeShutdown()) {
                            WrappedJavaProcess.this.stopWrapper();
                        }
                    }
                }
            };
            AbstractController.ControllerListener killedRestartHandler = new AbstractController.ControllerListener(){

                @Override
                public void fire() {
                    if (WrappedJavaProcess.this._state == 6 || WrappedJavaProcess.this._state == 2 || WrappedJavaProcess.this._state == 7) {
                        return;
                    }
                    if (WrappedJavaProcess.this.allowRestart() && WrappedJavaProcess.this.exitCodeRestart() && !WrappedJavaProcess.this.exitCodeShutdown() && !WrappedJavaProcess.this.exitCodeStop() || WrappedJavaProcess.this.allowRestart() && WrappedJavaProcess.this.exitSignalRestart() && !WrappedJavaProcess.this.exitSignalShutdown() && !WrappedJavaProcess.this.exitSignalStop()) {
                        WrappedJavaProcess.this.restartInternal();
                    } else {
                        if (WrappedJavaProcess.this._debug > 1) {
                            WrappedJavaProcess.this.getWrapperLogger().info("giving up after " + WrappedJavaProcess.this._restartCount + " retries");
                        }
                        if (WrappedJavaProcess.this._state != 8) {
                            WrappedJavaProcess.this.setState(9);
                        }
                        if (!WrappedJavaProcess.this._exiting) {
                            WrappedJavaProcess.this.stop();
                        }
                        WrappedJavaProcess.this.setState(0);
                        if (WrappedJavaProcess.this.exitCodeShutdown()) {
                            WrappedJavaProcess.this.stopWrapper();
                        }
                    }
                }
            };
            controller.addListener(4, restartHandler);
            controller.addListener(9, restartHandler);
            controller.addListener(7, restartHandler);
            controller.addListener(8, killedRestartHandler);
            if (!this._config.getBoolean("wrapper.ntservice.autoreport.startup", true) && this.getService() instanceof WrapperMainServiceWin) {
                this.setServiceStartupListener(new Runnable(){

                    @Override
                    public void run() {
                        ((WrapperMainServiceWin)WrappedJavaProcess.this.getService()).notifyStartup();
                    }
                });
            }
            controller.setServiceStartupListener(this._serviceStartupListener);
            controller.init();
            this._initController = true;
        }
    }

    @Override
    void postStart() {
        this.saveJavaPidFile();
    }

    public static void main(String[] args) {
        WrappedProcess[] w = new WrappedProcess[20];
        for (int i = 0; i < w.length; ++i) {
            w[i] = new WrappedJavaProcess();
            w[i].getLocalConfiguration().setProperty("wrapper.config", (Object)"conf/wrapper.helloworld.conf");
            w[i].getLocalConfiguration().setProperty("wrapper.debug", (Object)"true");
            w[i].setUseSystemProperties(false);
            w[i].init();
        }
        boolean done = false;
        while (!done) {
            for (int i = 0; i < w.length; ++i) {
                System.out.println("starting " + i);
                w[i].start();
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
            }
            for (int i = 0; i < w.length; ++i) {
                System.out.println("stopping " + i);
                w[i].stop();
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
            }
        }
    }

    void saveJavaPidFile() {
        String file = this._config.getString("wrapper.java.pidfile");
        if (file != null) {
            try {
                this._javaPidFile = new File(file);
                if (!this._javaPidFile.exists()) {
                    this._javaPidFile.createNewFile();
                }
                FileWriter out = new FileWriter(this._javaPidFile, false);
                out.write("" + this.getAppPid());
                out.flush();
                out.close();
                if (this._debug > 2) {
                    this.getWrapperLogger().info("created jva.pid file " + this._javaPidFile.getAbsolutePath());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void removeJavaPidFile() {
        if (this._javaPidFile != null) {
            try {
                this._javaPidFile.delete();
                if (this._debug > 2) {
                    this.getWrapperLogger().info("removed java.pid file " + this._javaPidFile.getAbsolutePath());
                }
                this._javaPidFile = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean reconnect(int pid) {
        if (this._state != 0) {
            this.getWrapperLogger().log(Level.INFO, "process not in IDLE state: " + this.getStringState() + ", reconnect failed");
            return false;
        }
        this._osProcess = OperatingSystem.instance().processManagerInstance().getProcess(pid);
        if (this._osProcess == null) {
            this.getWrapperLogger().log(Level.INFO, "osProcess with PID " + pid + "can not be found, reconnect failed");
            return false;
        }
        String cmd = this._osProcess.getCommand();
        if (cmd == null) {
            this.getWrapperLogger().log(Level.INFO, "commandline for process with PID " + pid + " is missing, reconnect failed");
            return false;
        }
        String key = this.getPropertyFromCommandLine("wrapper.key=[^ \"]*", cmd);
        if (key == null) {
            this.getWrapperLogger().log(Level.INFO, "commandline of process with pid=" + pid + " does not contain warpper.key property: " + cmd + ", reconnect failed");
            return false;
        }
        String port = this.getPropertyFromCommandLine("wrapper.port=[^ \"]*", cmd);
        if (port == null) {
            this.getWrapperLogger().log(Level.INFO, "commandline of process with pid=" + pid + " does not contain warpper.port property: " + cmd + ", reconnect failed");
            return false;
        }
        String configFile = this.getPropertyFromCommandLine("wrapper.config=[^ \"]*", cmd);
        String teeName = this.getPropertyFromCommandLine("wrapper.teeName=[^ \"]*", cmd);
        String tmpPath = this.getPropertyFromCommandLine("wrapper.tmpPath=[^ \"]*", cmd);
        if (tmpPath == null) {
            tmpPath = this.getPropertyFromCommandLine("wrapper.tmp.path=[^ \"]*", cmd);
        }
        this._localConfiguration.setProperty("wrapper.key", (Object)key);
        this._localConfiguration.setProperty("wrapper.port", (Object)port);
        if (teeName != null) {
            this._localConfiguration.setProperty("wrapper.teeName", (Object)teeName);
        }
        this._localConfiguration.setProperty("wrapper.tmpPath", (Object)tmpPath);
        if (configFile != null && !this._localConfiguration.containsKey("wrapper.config")) {
            this._localConfiguration.setProperty("wrapper.config", (Object)configFile);
        }
        this.setReconnecting(true);
        super.init();
        this._osProcess.setTeeName(teeName);
        this._osProcess.setTmpPath(tmpPath);
        this._osProcess.reconnectStreams();
        if (this._controller == null) {
            this._controller = new JVMController(this);
        }
        JVMController controller = (JVMController)this._controller;
        this.configController();
        this._firstRestartTime = System.currentTimeMillis();
        controller.start();
        controller.processStarted();
        this.setState(4);
        boolean result = controller.waitFor(this._config.getInt("wrapper.ping.timeout", 30) * 1000);
        if (result) {
            for (int i = 0; i < 5 && this._osProcess.getInputStream() == null; ++i) {
                try {
                    Thread.sleep(200L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    Thread.currentThread().interrupt();
                }
            }
            Map triggerActions = this.getTriggerActions();
            Map regexTriggerActions = this.getRegexTriggerActions();
            Map missingTriggerActions = this.getMissingTriggerActions();
            Map missingRegexTriggerActions = this.getMissingRegexTriggerActions();
            this._gobler_in = new AbstractWrappedProcess.Gobler(this._osProcess.getInputStream(), this.getAppLogger(), triggerActions, regexTriggerActions, missingTriggerActions, missingRegexTriggerActions, "OUTPUT " + this._osProcess.getPid(), this._osProcess.getPid());
            this._gobler_err = new AbstractWrappedProcess.Gobler(this._osProcess.getErrorStream(), this.getAppLogger(), triggerActions, regexTriggerActions, missingTriggerActions, missingRegexTriggerActions, "ERROR " + this._osProcess.getPid(), this._osProcess.getPid());
            executor.execute(this._gobler_err);
            executor.execute(this._gobler_in);
            this.setState(4);
            this.saveJavaPidFile();
            this.saveLockFile();
        } else {
            this.getWrapperLogger().log(Level.INFO, "error reconnecting to pid=" + pid);
        }
        return result;
    }

    private String getPropertyFromCommandLine(String pattern, String cmd) {
        String result = null;
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(cmd);
        if (m.find()) {
            result = m.group();
        }
        if (result != null && result.length() > 0) {
            return result.substring(result.indexOf("=") + 1).replaceAll("'", "");
        }
        return null;
    }

    public String getTeeName() {
        return this._teeName;
    }

    public void requestThreadDump() {
        if (this._controller != null) {
            JVMController controller = (JVMController)this._controller;
            controller.requestThreadDump();
        }
    }

    public void requestGc() {
        if (this._controller != null) {
            JVMController controller = (JVMController)this._controller;
            controller.requestGc();
        }
    }

    public void requestDumpHeap(String fileName) {
        if (this._controller != null) {
            JVMController controller = (JVMController)this._controller;
            controller.requestDumpHeap(fileName);
        }
    }

    @Override
    void stopController(int timeout, String reason) {
        JVMController controller = (JVMController)this._controller;
        controller.stop(6, reason);
        String shutdownScript = this._config.getString("wrapper.app.shutdown.script", null);
        if (shutdownScript != null && !"".equals(shutdownScript)) {
            this.getWrapperLogger().log(Level.FINEST, "waiting for shutdownScript to terminate process");
            this._osProcess.waitFor(timeout);
        }
    }

    @Override
    public String getType() {
        return "Java-" + super.getType();
    }

    public void setServiceStartupListener(Runnable serviceStartupListener) {
        this._serviceStartupListener = serviceStartupListener;
    }

    @Override
    protected void reloadConfiguration() {
        super.reloadConfiguration();
    }

    public float getHeapPercent() {
        if (this._controller == null) {
            return -1.0f;
        }
        return ((JVMController)this._controller).getHeap();
    }

    public long getMinorGCTime() {
        if (this._controller == null) {
            return -1L;
        }
        return ((JVMController)this._controller).getMinGC();
    }

    public long getFullGCTime() {
        if (this._controller == null) {
            return -1L;
        }
        return ((JVMController)this._controller).getFullGC();
    }

    public long getHeapInBytes() {
        if (this._controller == null) {
            return -1L;
        }
        return ((JVMController)this._controller).getHeapInBytes();
    }
}

