/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.controller.jvm;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.DelimiterBasedFrameDecoder;
import io.netty.handler.codec.Delimiters;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.rzo.yajsw.controller.Message;
import org.rzo.yajsw.controller.jvm.ControllerHandler;
import org.rzo.yajsw.controller.jvm.JVMController;
import org.rzo.yajsw.controller.jvm.MessageDecoder;
import org.rzo.yajsw.controller.jvm.MessageEncoder;
import org.rzo.yajsw.nettyutils.ChannelGroupFilter;
import org.rzo.yajsw.nettyutils.Condition;
import org.rzo.yajsw.nettyutils.ConditionFilter;
import org.rzo.yajsw.nettyutils.LoggingFilter;
import org.rzo.yajsw.nettyutils.WhitelistFilter;

class ControllerPipelineFactory
extends ChannelInitializer<SocketChannel> {
    JVMController _controller;
    boolean _debug = false;

    ControllerPipelineFactory(JVMController controller) {
        this._controller = controller;
    }

    public void setDebug(boolean debug) {
        this._debug = debug;
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        if (this._debug) {
            pipeline.addLast("logging1", (ChannelHandler)new LoggingFilter(this._controller.getLog(), "controller"));
        }
        pipeline.addLast("checkWaiting", (ChannelHandler)new ConditionFilter(new Condition(){

            @Override
            public boolean isOk(ChannelHandlerContext ctx, Object msg) {
                boolean result = true;
                int currentState = ControllerPipelineFactory.this._controller.getState();
                if (currentState == 3) {
                    ControllerPipelineFactory.this._controller.getLog().info("app already logged on -> rejecting new connection");
                    result = false;
                } else if (currentState == 8) {
                    if (ControllerPipelineFactory.this._debug) {
                        ControllerPipelineFactory.this._controller.getLog().info("app not running -> rejecting new connection");
                    }
                    result = false;
                }
                return result;
            }
        }));
        WhitelistFilter firewall = new WhitelistFilter();
        try {
            firewall.allowAll(InetAddress.getAllByName("127.0.0.1"));
        }
        catch (UnknownHostException e) {
            this._controller.getLog().warning("error getting 127.0.0.1 by name: " + e.getMessage());
        }
        try {
            firewall.allow(InetAddress.getLocalHost());
        }
        catch (UnknownHostException e) {
            this._controller.getLog().warning("error getting localhost by name: " + e.getMessage());
        }
        pipeline.addLast("firewall", (ChannelHandler)firewall);
        pipeline.addLast("framer", (ChannelHandler)new DelimiterBasedFrameDecoder(8192, true, Delimiters.nulDelimiter()));
        pipeline.addLast("messageEncoder", (ChannelHandler)new MessageEncoder());
        pipeline.addLast("messageDecoder", (ChannelHandler)new MessageDecoder());
        if (this._debug) {
            pipeline.addLast("logging", (ChannelHandler)new LoggingFilter(this._controller.getLog(), "controller"));
            this._controller.getLog().info("jvm controller: netty logger set");
        }
        pipeline.addLast("removeConnected", (ChannelHandler)new ChannelGroupFilter(new Condition(){

            @Override
            public boolean isOk(ChannelHandlerContext ctx, Object msg) {
                boolean result = false;
                if (msg instanceof Message) {
                    Message m = (Message)msg;
                    result = m.getCode() == 116;
                }
                return result;
            }
        }));
        pipeline.addLast("handler", (ChannelHandler)new ControllerHandler(this._controller));
    }
}

